/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca;

import com.google.common.annotations.VisibleForTesting;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.AppContext;
import org.opensearch.performanceanalyzer.ClientServers;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerApp;
import org.opensearch.performanceanalyzer.PerformanceAnalyzerThreads;
import org.opensearch.performanceanalyzer.config.PluginSettings;
import org.opensearch.performanceanalyzer.core.Util;
import org.opensearch.performanceanalyzer.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.net.GRPCConnectionManager;
import org.opensearch.performanceanalyzer.net.NetClient;
import org.opensearch.performanceanalyzer.net.NetServer;
import org.opensearch.performanceanalyzer.rca.RcaControllerHelper;
import org.opensearch.performanceanalyzer.rca.exceptions.MalformedConfig;
import org.opensearch.performanceanalyzer.rca.framework.core.ConnectedComponent;
import org.opensearch.performanceanalyzer.rca.framework.core.Queryable;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;
import org.opensearch.performanceanalyzer.rca.framework.core.Stats;
import org.opensearch.performanceanalyzer.rca.framework.core.ThresholdMain;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ExceptionsAndErrors;
import org.opensearch.performanceanalyzer.rca.framework.metrics.RcaRuntimeMetrics;
import org.opensearch.performanceanalyzer.rca.framework.metrics.ReaderMetrics;
import org.opensearch.performanceanalyzer.rca.framework.util.InstanceDetails;
import org.opensearch.performanceanalyzer.rca.framework.util.RcaConsts;
import org.opensearch.performanceanalyzer.rca.framework.util.RcaUtil;
import org.opensearch.performanceanalyzer.rca.net.NodeStateManager;
import org.opensearch.performanceanalyzer.rca.net.ReceivedFlowUnitStore;
import org.opensearch.performanceanalyzer.rca.net.SubscriptionManager;
import org.opensearch.performanceanalyzer.rca.net.WireHopper;
import org.opensearch.performanceanalyzer.rca.net.handler.PublishRequestHandler;
import org.opensearch.performanceanalyzer.rca.net.handler.SubscribeServerHandler;
import org.opensearch.performanceanalyzer.rca.persistence.NetPersistor;
import org.opensearch.performanceanalyzer.rca.persistence.Persistable;
import org.opensearch.performanceanalyzer.rca.persistence.PersistenceFactory;
import org.opensearch.performanceanalyzer.rca.scheduler.RCAScheduler;
import org.opensearch.performanceanalyzer.rca.scheduler.RcaSchedulerState;
import org.opensearch.performanceanalyzer.rest.QueryActionRequestHandler;
import org.opensearch.performanceanalyzer.rest.QueryRcaRequestHandler;
import org.opensearch.performanceanalyzer.threads.ThreadProvider;

public class RcaController {
    private static final Logger LOG = LogManager.getLogger(RcaController.class);
    public static final String RCA_ENABLED_CONF_FILE = "rca_enabled.conf";
    private final ScheduledExecutorService netOpsExecutorService;
    private final boolean useHttps;
    private boolean rcaEnabledDefaultValue = false;
    private final int WAIT_FOR_SCHED_START_SECS = 10;
    private volatile boolean rcaEnabled = false;
    private volatile long lastModifiedTimeInMillisInMemory = 0L;
    protected volatile AllMetrics.NodeRole currentRole = AllMetrics.NodeRole.UNKNOWN;
    private volatile List<ConnectedComponent> connectedComponents;
    private final ThreadProvider threadProvider;
    private RCAScheduler rcaScheduler;
    private NetPersistor netPersistor;
    private NetClient rcaNetClient;
    private NetServer rcaNetServer;
    private NodeStateManager nodeStateManager;
    private HttpServer httpServer;
    private QueryRcaRequestHandler queryRcaRequestHandler;
    private QueryActionRequestHandler queryActionRequestHandler;
    private SubscriptionManager subscriptionManager;
    private volatile RcaConf rcaConf;
    private final String RCA_ENABLED_CONF_LOCATION;
    private final long rcaStateCheckIntervalMillis;
    private final long roleCheckPeriodicity;
    private volatile boolean deliberateInterrupt;
    private AtomicReference<ExecutorService> networkThreadPoolReference = new AtomicReference();
    private ReceivedFlowUnitStore receivedFlowUnitStore;
    private final AppContext appContext;
    protected volatile Queryable dbProvider = null;
    private volatile Persistable persistenceProvider;

    public RcaController(ThreadProvider threadProvider, ScheduledExecutorService netOpsExecutorService, GRPCConnectionManager grpcConnectionManager, ClientServers clientServers, String rca_enabled_conf_location, long rcaStateCheckIntervalMillis, long nodeRoleCheckPeriodicityMillis, AppContext appContext, Queryable dbProvider) {
        this.threadProvider = threadProvider;
        this.appContext = appContext;
        this.netOpsExecutorService = netOpsExecutorService;
        this.rcaNetClient = clientServers.getNetClient();
        this.rcaNetServer = clientServers.getNetServer();
        this.httpServer = clientServers.getHttpServer();
        this.RCA_ENABLED_CONF_LOCATION = rca_enabled_conf_location;
        this.netPersistor = new NetPersistor();
        this.useHttps = PluginSettings.instance().getHttpsEnabled();
        this.subscriptionManager = new SubscriptionManager(grpcConnectionManager);
        this.nodeStateManager = new NodeStateManager(this.appContext);
        this.queryRcaRequestHandler = new QueryRcaRequestHandler(this.appContext);
        this.queryActionRequestHandler = new QueryActionRequestHandler(this.appContext);
        this.rcaScheduler = null;
        this.rcaStateCheckIntervalMillis = rcaStateCheckIntervalMillis;
        this.roleCheckPeriodicity = nodeRoleCheckPeriodicityMillis;
        this.deliberateInterrupt = false;
        this.connectedComponents = null;
        this.dbProvider = dbProvider;
        this.persistenceProvider = null;
    }

    @VisibleForTesting
    public RcaController() {
        this.netOpsExecutorService = null;
        this.useHttps = false;
        this.threadProvider = null;
        this.RCA_ENABLED_CONF_LOCATION = "";
        this.rcaStateCheckIntervalMillis = 0L;
        this.roleCheckPeriodicity = 0L;
        this.appContext = null;
        this.persistenceProvider = null;
    }

    protected List<ConnectedComponent> getRcaGraphComponents(RcaConf rcaConf) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return RcaUtil.getAnalysisGraphComponents(rcaConf);
    }

    private void start() {
        try {
            Objects.requireNonNull(this.subscriptionManager);
            Objects.requireNonNull(this.rcaConf);
            if (this.dbProvider == null) {
                return;
            }
            this.subscriptionManager.setCurrentLocus(this.rcaConf.getTagMap().get("locus"));
            this.connectedComponents = this.getRcaGraphComponents(this.rcaConf);
            this.readAndUpdateMutedComponentsDuringStart();
            ThresholdMain thresholdMain = new ThresholdMain(RcaConsts.THRESHOLDS_PATH, this.rcaConf);
            this.persistenceProvider = PersistenceFactory.create(this.rcaConf);
            this.networkThreadPoolReference.set(RcaControllerHelper.buildNetworkThreadPool(this.rcaConf.getNetworkQueueLength()));
            this.addRcaRequestHandler();
            this.queryRcaRequestHandler.setPersistable(this.persistenceProvider);
            this.addActionsRequestHandler();
            this.queryActionRequestHandler.setPersistable(this.persistenceProvider);
            this.receivedFlowUnitStore = new ReceivedFlowUnitStore(this.rcaConf.getPerVertexBufferLength());
            WireHopper net = new WireHopper(this.nodeStateManager, this.rcaNetClient, this.subscriptionManager, this.networkThreadPoolReference, this.receivedFlowUnitStore, this.appContext);
            AppContext copyAppContext = new AppContext(this.appContext);
            this.rcaScheduler = new RCAScheduler(this.connectedComponents, this.dbProvider, this.rcaConf, thresholdMain, this.persistenceProvider, net, copyAppContext);
            this.rcaNetServer.setSendDataHandler(new PublishRequestHandler(this.nodeStateManager, this.receivedFlowUnitStore, this.networkThreadPoolReference));
            this.rcaNetServer.setSubscribeHandler(new SubscribeServerHandler(this.subscriptionManager, this.networkThreadPoolReference));
            Thread rcaSchedulerThread = this.threadProvider.createThreadForRunnable(() -> this.rcaScheduler.start(), PerformanceAnalyzerThreads.RCA_SCHEDULER, copyAppContext.getMyInstanceDetails().getInstanceId().toString());
            CountDownLatch schedulerStartLatch = new CountDownLatch(1);
            this.rcaScheduler.setSchedulerTrackingLatch(schedulerStartLatch);
            rcaSchedulerThread.start();
            if (!schedulerStartLatch.await(10L, TimeUnit.SECONDS)) {
                LOG.error("Failed to start RcaScheduler.");
                throw new IllegalStateException("Failed to start RcaScheduler within 10 seconds.");
            }
            if (this.rcaScheduler.getState() != RcaSchedulerState.STATE_STARTED) {
                LOG.error("RCA scheduler didn't start within {} seconds", (Object)10);
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | SQLException | MalformedConfig e) {
            LOG.error("Couldn't build connected components or persistable..", (Throwable)e);
        }
        catch (Exception ex) {
            LOG.error("Couldn't start RcaController", (Throwable)ex);
        }
    }

    public void stop() {
        this.rcaScheduler.shutdown();
        this.rcaNetClient.stop();
        this.rcaNetServer.stop();
        this.receivedFlowUnitStore.drainAll();
        this.networkThreadPoolReference.get().shutdown();
        try {
            this.networkThreadPoolReference.get().awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            LOG.warn("Awaiting termination interrupted. {}", (Object)e.getCause(), (Object)e);
            this.networkThreadPoolReference.get().shutdownNow();
            Thread.currentThread().interrupt();
        }
        this.removeRcaRequestHandler();
        Stats.getInstance().reset();
    }

    private void restart() {
        this.stop();
        this.start();
        PerformanceAnalyzerApp.READER_METRICS_AGGREGATOR.updateStat(ReaderMetrics.RCA_SCHEDULER_RESTART, "", 1);
    }

    protected RcaConf getRcaConfForMyRole(AllMetrics.NodeRole role) {
        return RcaControllerHelper.pickRcaConfForRole(role);
    }

    public void run() {
        long tick = 0L;
        long nodeRoleCheckInTicks = this.roleCheckPeriodicity / this.rcaStateCheckIntervalMillis;
        while (true) {
            block7: {
                try {
                    long startTime = System.currentTimeMillis();
                    this.readRcaEnabledFromConf();
                    if (this.rcaEnabled && tick % nodeRoleCheckInTicks == 0L) {
                        tick = 0L;
                        InstanceDetails nodeDetails = this.appContext.getMyInstanceDetails();
                        if (nodeDetails.getRole() != AllMetrics.NodeRole.UNKNOWN) {
                            this.currentRole = nodeDetails.getRole();
                        }
                    }
                    if (this.rcaEnabled) {
                        this.rcaConf = this.getRcaConfForMyRole(this.currentRole);
                        LOG.debug("Updating Analysis Graph with Muted RCAs");
                        this.readAndUpdateMutedComponents();
                    }
                    this.updateRcaState();
                    long duration = System.currentTimeMillis() - startTime;
                    if (duration >= this.rcaStateCheckIntervalMillis) break block7;
                    Thread.sleep(this.rcaStateCheckIntervalMillis - duration);
                }
                catch (InterruptedException ie) {
                    PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat(ExceptionsAndErrors.RCA_FRAMEWORK_CRASH, "", 1);
                    if (this.deliberateInterrupt) {
                        LOG.info("RcaController thread interrupted..");
                        break;
                    }
                    LOG.error("RCA controller thread was interrupted.", (Throwable)ie);
                    break;
                }
            }
            ++tick;
        }
        LOG.error("RcaController exits..");
    }

    private void readRcaEnabledFromConf() {
        Path filePath = Paths.get(this.RCA_ENABLED_CONF_LOCATION, RCA_ENABLED_CONF_FILE);
        Util.invokePrivileged(() -> {
            try (Scanner sc = new Scanner(filePath);){
                String nextLine = sc.nextLine();
                boolean oldVal = this.rcaEnabled;
                boolean newVal = Boolean.parseBoolean(nextLine);
                if (oldVal != newVal) {
                    this.rcaEnabled = newVal;
                    LOG.info("RCA enabled changed from {} to {}", (Object)oldVal, (Object)newVal);
                }
            }
            catch (IOException e) {
                LOG.error("Error reading file {}", (Object)filePath.toString(), (Object)e);
                this.rcaEnabled = this.rcaEnabledDefaultValue;
            }
        });
    }

    private void readAndUpdateMutedComponentsDuringStart() {
        if (this.lastModifiedTimeInMillisInMemory == 0L) {
            this.updateMutedComponents();
        }
    }

    private boolean updateMutedComponents() {
        try {
            Set<String> allNodes = ConnectedComponent.getNodesForAllComponents(this.connectedComponents);
            if (allNodes.isEmpty()) {
                LOG.info("Analysis graph not initialized/has been reset; returning.");
                return false;
            }
            HashSet<String> actionsForMute = new HashSet<String>(this.rcaConf.getMutedActionList());
            HashSet<String> graphNodesForMute = new HashSet<String>();
            graphNodesForMute.addAll(this.rcaConf.getMutedRcaList());
            graphNodesForMute.addAll(this.rcaConf.getMutedDeciderList());
            LOG.info("Graph nodes provided for muting : {}", graphNodesForMute);
            LOG.info("Actions provided for muting: {}", actionsForMute);
            graphNodesForMute.retainAll(allNodes);
            if (!(!graphNodesForMute.isEmpty() || this.rcaConf.getMutedRcaList().isEmpty() && this.rcaConf.getMutedDeciderList().isEmpty())) {
                if (this.lastModifiedTimeInMillisInMemory == 0L) {
                    LOG.error("Removing Incorrect RCA(s): {} provided before RCA Scheduler start. Valid RCAs: {}.", this.rcaConf.getMutedRcaList(), allNodes);
                } else {
                    LOG.error("Incorrect RCA(s): {}, cannot be muted. Valid RCAs: {}, Muted RCAs: {}", this.rcaConf.getMutedRcaList(), allNodes, Stats.getInstance().getMutedGraphNodes());
                    return false;
                }
            }
            LOG.info("Updating the muted graph nodes to : {}", graphNodesForMute);
            Stats.getInstance().updateMutedGraphNodes(graphNodesForMute);
            this.appContext.updateMutedActions(actionsForMute);
            if (this.rcaScheduler != null) {
                this.rcaScheduler.updateAppContextWithMutedActions(actionsForMute);
            }
        }
        catch (Exception e) {
            PerformanceAnalyzerApp.ERRORS_AND_EXCEPTIONS_AGGREGATOR.updateStat(ExceptionsAndErrors.MUTE_ERROR, "", 1);
            LOG.error("Couldn't read/update the muted RCAs", (Throwable)e);
            return false;
        }
        return true;
    }

    private void readAndUpdateMutedComponents() {
        long lastModifiedTimeInMillisOnDisk = this.rcaConf.getLastModifiedTime();
        if (lastModifiedTimeInMillisOnDisk > this.lastModifiedTimeInMillisInMemory && this.updateMutedComponents()) {
            this.lastModifiedTimeInMillisInMemory = lastModifiedTimeInMillisOnDisk;
        }
    }

    private void updateRcaState() {
        if (this.rcaScheduler != null && this.rcaScheduler.getState() == RcaSchedulerState.STATE_STARTED) {
            if (!this.rcaEnabled) {
                this.stop();
                PerformanceAnalyzerApp.RCA_RUNTIME_METRICS_AGGREGATOR.updateStat(RcaRuntimeMetrics.RCA_STOPPED_BY_OPERATOR, "", 1);
            } else if (this.rcaScheduler.getRole() != this.currentRole) {
                this.restart();
                PerformanceAnalyzerApp.RCA_RUNTIME_METRICS_AGGREGATOR.updateStat(RcaRuntimeMetrics.RCA_RESTARTED_BY_OPERATOR, "", 1);
            }
        } else if (this.rcaEnabled && AllMetrics.NodeRole.UNKNOWN != this.currentRole && (this.rcaScheduler == null || this.rcaScheduler.getState() != RcaSchedulerState.STATE_STOPPED_DUE_TO_EXCEPTION)) {
            this.start();
        }
    }

    private void removeRcaRequestHandler() {
        try {
            this.httpServer.removeContext("/_plugins/_performanceanalyzer/rca");
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Http(s) context for path: {} was not found to remove.", (Object)"/_plugins/_performanceanalyzer/rca");
        }
        try {
            this.httpServer.removeContext("/_plugins/_performanceanalyzer/rca");
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Http(s) context for path: {} was not found to remove.", (Object)"/_plugins/_performanceanalyzer/rca");
        }
    }

    public static String getCatMasterUrl() {
        return "http://localhost:9200/_cat/master?h=ip";
    }

    public static String getRcaEnabledConfFile() {
        return RCA_ENABLED_CONF_FILE;
    }

    public boolean isRcaEnabled() {
        return this.rcaEnabled;
    }

    public AllMetrics.NodeRole getCurrentRole() {
        return this.currentRole;
    }

    @VisibleForTesting
    public AppContext getAppContext() {
        return this.appContext;
    }

    public RCAScheduler getRcaScheduler() {
        return this.rcaScheduler;
    }

    private void addRcaRequestHandler() {
        this.httpServer.createContext("/_plugins/_performanceanalyzer/rca", this.queryRcaRequestHandler);
        this.httpServer.createContext("/_plugins/_performanceanalyzer/rca", this.queryRcaRequestHandler);
    }

    private void addActionsRequestHandler() {
        this.httpServer.createContext("/_plugins/_performanceanalyzer/actions", this.queryActionRequestHandler);
        this.httpServer.createContext("/_plugins/_performanceanalyzer/actions", this.queryActionRequestHandler);
    }

    public void setDeliberateInterrupt() {
        this.deliberateInterrupt = true;
    }

    public RcaConf getRcaConf() {
        return this.rcaConf;
    }

    @VisibleForTesting
    public void setDbProvider(Queryable dbProvider) throws InterruptedException {
        this.dbProvider = dbProvider;
    }

    @VisibleForTesting
    public List<ConnectedComponent> getConnectedComponents() {
        return this.connectedComponents;
    }

    @VisibleForTesting
    public Persistable getPersistenceProvider() {
        return this.persistenceProvider;
    }
}

