/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.breaker;

import org.opensearch.ml.common.breaker.ThresholdCircuitBreaker;
import org.opensearch.monitor.jvm.JvmService;

public class MemoryCircuitBreaker
extends ThresholdCircuitBreaker<Short> {
    public static final short DEFAULT_JVM_HEAP_USAGE_THRESHOLD = 85;
    private final JvmService jvmService;

    public MemoryCircuitBreaker(JvmService jvmService) {
        super((short)85);
        this.jvmService = jvmService;
    }

    public MemoryCircuitBreaker(short threshold, JvmService jvmService) {
        super(threshold);
        this.jvmService = jvmService;
    }

    @Override
    public boolean isOpen() {
        return this.jvmService.stats().getMem().getHeapUsedPercent() > (Short)this.getThreshold();
    }
}

