/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import java.io.IOException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class SearchModelTransportAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    private ModelDao modelDao = ModelDao.OpenSearchKNNModelDao.getInstance();

    @Inject
    public SearchModelTransportAction(TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/knn_search_model_action", transportService, actionFilters, SearchRequest::new);
    }

    protected void doExecute(Task task, SearchRequest request, ActionListener<SearchResponse> listener) {
        try {
            this.modelDao.search(request, listener);
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }
}

