/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.indexmanagement.indexstatemanagement.util.RestHandlerUtilsKt;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptService;
import org.opensearch.script.ScriptType;
import org.opensearch.script.TemplateScript;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0004J\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/indexmanagement/rollup/util/RollupFieldValueExpressionResolver;", "", "()V", "scriptService", "Lorg/opensearch/script/ScriptService;", "validTopContextFields", "", "", "registerScriptService", "", "resolve", "rollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "fieldValue", "opensearch-index-management"})
public final class RollupFieldValueExpressionResolver {
    @NotNull
    public static final RollupFieldValueExpressionResolver INSTANCE = new RollupFieldValueExpressionResolver();
    @NotNull
    private static final Set<String> validTopContextFields = SetsKt.setOf((Object)"source_index");
    private static ScriptService scriptService;

    private RollupFieldValueExpressionResolver() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String resolve(@NotNull Rollup rollup2, @NotNull String fieldValue) {
        void $this$filterKeys$iv;
        Intrinsics.checkNotNullParameter((Object)rollup2, (String)"rollup");
        Intrinsics.checkNotNullParameter((Object)fieldValue, (String)"fieldValue");
        Script script = new Script(ScriptType.INLINE, "mustache", fieldValue, MapsKt.emptyMap());
        Object object = XContentFactory.jsonBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jsonBuilder()");
        object = OpenSearchExtensionsKt.toMap(rollup2.toXContent((XContentBuilder)object, (ToXContent.Params)RestHandlerUtilsKt.getXCONTENT_WITHOUT_TYPE()));
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String key = (String)entry$iv.getKey();
            boolean bl = false;
            if (!validTopContextFields.contains(key)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map contextMap = result$iv;
        ScriptService scriptService = RollupFieldValueExpressionResolver.scriptService;
        if (scriptService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scriptService");
            scriptService = null;
        }
        TemplateScript.Factory factory = (TemplateScript.Factory)scriptService.compile(script, TemplateScript.CONTEXT);
        Map map = script.getParams();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"script.params");
        String compiledValue = factory.newInstance(MapsKt.plus((Map)map, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"ctx", (Object)contextMap)))).execute();
        Intrinsics.checkNotNullExpressionValue((Object)compiledValue, (String)"compiledValue");
        return StringsKt.isBlank((CharSequence)compiledValue) ? fieldValue : compiledValue;
    }

    public final void registerScriptService(@NotNull ScriptService scriptService) {
        Intrinsics.checkNotNullParameter((Object)scriptService, (String)"scriptService");
        RollupFieldValueExpressionResolver.scriptService = scriptService;
    }
}

