"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.LOGIN_PAGE_URI = exports.ERROR_MISSING_ROLE_PATH = exports.CUSTOM_ERROR_PAGE_URI = exports.CONFIGURATION_API_PREFIX = exports.AuthType = exports.APP_ID_LOGIN = exports.APP_ID_CUSTOMERROR = exports.API_PREFIX = exports.API_ENDPOINT_AUTHINFO = exports.API_AUTH_LOGOUT = exports.API_AUTH_LOGIN = void 0;
exports.isValidResourceName = isValidResourceName;

/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */
const PLUGIN_ID = 'opensearchDashboardsSecurity';
exports.PLUGIN_ID = PLUGIN_ID;
const PLUGIN_NAME = 'security-dashboards-plugin';
exports.PLUGIN_NAME = PLUGIN_NAME;
const APP_ID_LOGIN = 'login';
exports.APP_ID_LOGIN = APP_ID_LOGIN;
const APP_ID_CUSTOMERROR = 'customerror';
exports.APP_ID_CUSTOMERROR = APP_ID_CUSTOMERROR;
const API_PREFIX = '/api/v1';
exports.API_PREFIX = API_PREFIX;
const CONFIGURATION_API_PREFIX = 'configuration';
exports.CONFIGURATION_API_PREFIX = CONFIGURATION_API_PREFIX;
const API_ENDPOINT_AUTHINFO = API_PREFIX + '/auth/authinfo';
exports.API_ENDPOINT_AUTHINFO = API_ENDPOINT_AUTHINFO;
const LOGIN_PAGE_URI = '/app/' + APP_ID_LOGIN;
exports.LOGIN_PAGE_URI = LOGIN_PAGE_URI;
const CUSTOM_ERROR_PAGE_URI = '/app/' + APP_ID_CUSTOMERROR;
exports.CUSTOM_ERROR_PAGE_URI = CUSTOM_ERROR_PAGE_URI;
const API_AUTH_LOGIN = '/auth/login';
exports.API_AUTH_LOGIN = API_AUTH_LOGIN;
const API_AUTH_LOGOUT = '/auth/logout';
exports.API_AUTH_LOGOUT = API_AUTH_LOGOUT;
const ERROR_MISSING_ROLE_PATH = '/missing-role';
exports.ERROR_MISSING_ROLE_PATH = ERROR_MISSING_ROLE_PATH;
let AuthType;
/**
 * A valid resource name should not containing percent sign (%) as they raise url injection issue.
 * And also should not be empty.
 * @param resourceName resource name to be validated
 */

exports.AuthType = AuthType;

(function (AuthType) {
  AuthType["BASIC"] = "basicauth";
  AuthType["OPEN_ID"] = "openid";
  AuthType["JWT"] = "jwt";
  AuthType["SAML"] = "saml";
  AuthType["PROXY"] = "proxy";
})(AuthType || (exports.AuthType = AuthType = {}));

function isValidResourceName(resourceName) {
  // see: https://javascript.info/regexp-unicode
  const exp = new RegExp('[\\p{C}%]', 'u');
  return !exp.test(resourceName) && resourceName.length > 0;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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