"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupRoutes = setupRoutes;

var _ppl = require("./ppl");

var _ppl_facet = _interopRequireDefault(require("../services/facets/ppl_facet"));

var _dsl = require("./dsl");

var _dsl_facet = _interopRequireDefault(require("../services/facets/dsl_facet"));

var _saved_objects = _interopRequireDefault(require("../services/facets/saved_objects"));

var _panels_router = require("./custom_panels/panels_router");

var _visualizations_router = require("./custom_panels/visualizations_router");

var _trace_analytics_dsl_router = require("./trace_analytics_dsl_router");

var _paraRouter = require("./notebooks/paraRouter");

var _noteRouter = require("./notebooks/noteRouter");

var _vizRouter = require("./notebooks/vizRouter");

var _queryService = _interopRequireDefault(require("../services/queryService"));

var _sqlRouter = require("./notebooks/sqlRouter");

var _event_analytics_router = require("./event_analytics/event_analytics_router");

var _app_analytics_router = require("./application_analytics/app_analytics_router");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupRoutes({
  router,
  client
}) {
  (0, _panels_router.PanelsRouter)(router);
  (0, _visualizations_router.VisualizationsRouter)(router);
  (0, _ppl.registerPplRoute)({
    router,
    facet: new _ppl_facet.default(client)
  });
  (0, _dsl.registerDslRoute)({
    router,
    facet: new _dsl_facet.default(client)
  });
  (0, _event_analytics_router.registerEventAnalyticsRouter)({
    router,
    savedObjectFacet: new _saved_objects.default(client)
  });
  (0, _app_analytics_router.registerAppAnalyticsRouter)(router); // TODO remove trace analytics route when DSL route for autocomplete is added

  (0, _trace_analytics_dsl_router.registerTraceAnalyticsDslRouter)(router); // notebooks routes

  (0, _paraRouter.registerParaRoute)(router);
  (0, _noteRouter.registerNoteRoute)(router);
  (0, _vizRouter.registerVizRoute)(router);
  const queryService = new _queryService.default(client);
  (0, _sqlRouter.registerSqlRoute)(router, queryService);
}

;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImluZGV4LnRzIl0sIm5hbWVzIjpbInNldHVwUm91dGVzIiwicm91dGVyIiwiY2xpZW50IiwiZmFjZXQiLCJQUExGYWNldCIsIkRTTEZhY2V0Iiwic2F2ZWRPYmplY3RGYWNldCIsIlNhdmVkT2JqZWN0RmFjZXQiLCJxdWVyeVNlcnZpY2UiLCJRdWVyeVNlcnZpY2UiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFNQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7QUFDQTs7OztBQXBCQTtBQUNBO0FBQ0E7QUFDQTtBQW9CTyxTQUFTQSxXQUFULENBQXFCO0FBQUVDLEVBQUFBLE1BQUY7QUFBVUMsRUFBQUE7QUFBVixDQUFyQixFQUE0RjtBQUNqRyxtQ0FBYUQsTUFBYjtBQUNBLG1EQUFxQkEsTUFBckI7QUFDQSw2QkFBaUI7QUFBRUEsSUFBQUEsTUFBRjtBQUFVRSxJQUFBQSxLQUFLLEVBQUUsSUFBSUMsa0JBQUosQ0FBYUYsTUFBYjtBQUFqQixHQUFqQjtBQUNBLDZCQUFpQjtBQUFFRCxJQUFBQSxNQUFGO0FBQVVFLElBQUFBLEtBQUssRUFBRSxJQUFJRSxrQkFBSixDQUFhSCxNQUFiO0FBQWpCLEdBQWpCO0FBQ0EsNERBQTZCO0FBQUVELElBQUFBLE1BQUY7QUFBVUssSUFBQUEsZ0JBQWdCLEVBQUUsSUFBSUMsc0JBQUosQ0FBcUJMLE1BQXJCO0FBQTVCLEdBQTdCO0FBQ0Esd0RBQTJCRCxNQUEzQixFQU5pRyxDQVFqRzs7QUFDQSxtRUFBZ0NBLE1BQWhDLEVBVGlHLENBV2pHOztBQUNBLHFDQUFrQkEsTUFBbEI7QUFDQSxxQ0FBa0JBLE1BQWxCO0FBQ0EsbUNBQWlCQSxNQUFqQjtBQUNBLFFBQU1PLFlBQVksR0FBRyxJQUFJQyxxQkFBSixDQUFpQlAsTUFBakIsQ0FBckI7QUFDQSxtQ0FBaUJELE1BQWpCLEVBQXlCTyxZQUF6QjtBQUNEOztBQUFBIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBJUm91dGVyLCBJTGVnYWN5Q2x1c3RlckNsaWVudCB9IGZyb20gJy4uLy4uLy4uLy4uL3NyYy9jb3JlL3NlcnZlcic7XG5pbXBvcnQgeyByZWdpc3RlclBwbFJvdXRlIH0gZnJvbSAnLi9wcGwnO1xuaW1wb3J0IFBQTEZhY2V0IGZyb20gJy4uL3NlcnZpY2VzL2ZhY2V0cy9wcGxfZmFjZXQnO1xuaW1wb3J0IHsgcmVnaXN0ZXJEc2xSb3V0ZSB9IGZyb20gJy4vZHNsJztcbmltcG9ydCBEU0xGYWNldCBmcm9tICcuLi9zZXJ2aWNlcy9mYWNldHMvZHNsX2ZhY2V0JztcbmltcG9ydCBTYXZlZE9iamVjdEZhY2V0IGZyb20gJy4uL3NlcnZpY2VzL2ZhY2V0cy9zYXZlZF9vYmplY3RzJztcbmltcG9ydCB7IFBhbmVsc1JvdXRlciB9IGZyb20gJy4vY3VzdG9tX3BhbmVscy9wYW5lbHNfcm91dGVyJztcbmltcG9ydCB7IFZpc3VhbGl6YXRpb25zUm91dGVyIH0gZnJvbSAnLi9jdXN0b21fcGFuZWxzL3Zpc3VhbGl6YXRpb25zX3JvdXRlcic7XG5pbXBvcnQgeyByZWdpc3RlclRyYWNlQW5hbHl0aWNzRHNsUm91dGVyIH0gZnJvbSAnLi90cmFjZV9hbmFseXRpY3NfZHNsX3JvdXRlcic7XG5pbXBvcnQgeyByZWdpc3RlclBhcmFSb3V0ZSB9IGZyb20gJy4vbm90ZWJvb2tzL3BhcmFSb3V0ZXInO1xuaW1wb3J0IHsgcmVnaXN0ZXJOb3RlUm91dGUgfSBmcm9tICcuL25vdGVib29rcy9ub3RlUm91dGVyJztcbmltcG9ydCB7IHJlZ2lzdGVyVml6Um91dGUgfSBmcm9tICcuL25vdGVib29rcy92aXpSb3V0ZXInO1xuaW1wb3J0IFF1ZXJ5U2VydmljZSBmcm9tICcuLi9zZXJ2aWNlcy9xdWVyeVNlcnZpY2UnO1xuaW1wb3J0IHsgcmVnaXN0ZXJTcWxSb3V0ZSB9IGZyb20gJy4vbm90ZWJvb2tzL3NxbFJvdXRlcic7XG5pbXBvcnQgeyByZWdpc3RlckV2ZW50QW5hbHl0aWNzUm91dGVyIH0gZnJvbSAnLi9ldmVudF9hbmFseXRpY3MvZXZlbnRfYW5hbHl0aWNzX3JvdXRlcic7XG5pbXBvcnQgeyByZWdpc3RlckFwcEFuYWx5dGljc1JvdXRlciB9IGZyb20gJy4vYXBwbGljYXRpb25fYW5hbHl0aWNzL2FwcF9hbmFseXRpY3Nfcm91dGVyJztcblxuXG5leHBvcnQgZnVuY3Rpb24gc2V0dXBSb3V0ZXMoeyByb3V0ZXIsIGNsaWVudCB9OiB7IHJvdXRlcjogSVJvdXRlcjsgY2xpZW50OiBJTGVnYWN5Q2x1c3RlckNsaWVudCB9KSB7XG4gIFBhbmVsc1JvdXRlcihyb3V0ZXIpO1xuICBWaXN1YWxpemF0aW9uc1JvdXRlcihyb3V0ZXIpO1xuICByZWdpc3RlclBwbFJvdXRlKHsgcm91dGVyLCBmYWNldDogbmV3IFBQTEZhY2V0KGNsaWVudCkgfSk7XG4gIHJlZ2lzdGVyRHNsUm91dGUoeyByb3V0ZXIsIGZhY2V0OiBuZXcgRFNMRmFjZXQoY2xpZW50KX0pO1xuICByZWdpc3RlckV2ZW50QW5hbHl0aWNzUm91dGVyKHsgcm91dGVyLCBzYXZlZE9iamVjdEZhY2V0OiBuZXcgU2F2ZWRPYmplY3RGYWNldChjbGllbnQpIH0pO1xuICByZWdpc3RlckFwcEFuYWx5dGljc1JvdXRlcihyb3V0ZXIpO1xuICBcbiAgLy8gVE9ETyByZW1vdmUgdHJhY2UgYW5hbHl0aWNzIHJvdXRlIHdoZW4gRFNMIHJvdXRlIGZvciBhdXRvY29tcGxldGUgaXMgYWRkZWRcbiAgcmVnaXN0ZXJUcmFjZUFuYWx5dGljc0RzbFJvdXRlcihyb3V0ZXIpO1xuXG4gIC8vIG5vdGVib29rcyByb3V0ZXNcbiAgcmVnaXN0ZXJQYXJhUm91dGUocm91dGVyKTtcbiAgcmVnaXN0ZXJOb3RlUm91dGUocm91dGVyKTtcbiAgcmVnaXN0ZXJWaXpSb3V0ZShyb3V0ZXIpO1xuICBjb25zdCBxdWVyeVNlcnZpY2UgPSBuZXcgUXVlcnlTZXJ2aWNlKGNsaWVudCk7XG4gIHJlZ2lzdGVyU3FsUm91dGUocm91dGVyLCBxdWVyeVNlcnZpY2UpO1xufTtcbiJdfQ==