function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import PropTypes from "prop-types";
import { timeUnits, timeUnitsPlural } from '../time_units';
import { OuiI18n } from '../../../i18n';
import { OuiFlexGroup, OuiFlexItem } from '../../../flex';
import { OuiTitle } from '../../../title';
import { OuiSpacer } from '../../../spacer';
import { OuiSelect, OuiFieldNumber } from '../../../form';
import { OuiButton } from '../../../button';
import { htmlIdGenerator } from '../../../../services';
import { OuiScreenReaderOnly } from '../../../accessibility';
import { keysOf } from '../../../common';
var refreshUnitsOptions = keysOf(timeUnits).filter(function (timeUnit) {
  return timeUnit === 'h' || timeUnit === 'm' || timeUnit === 's';
}).map(function (timeUnit) {
  return {
    value: timeUnit,
    text: timeUnitsPlural[timeUnit]
  };
});
var MILLISECONDS_IN_SECOND = 1000;
var MILLISECONDS_IN_MINUTE = MILLISECONDS_IN_SECOND * 60;
var MILLISECONDS_IN_HOUR = MILLISECONDS_IN_MINUTE * 60;

function fromMilliseconds(milliseconds) {
  var round = function round(value) {
    return parseFloat(value.toFixed(2));
  };

  if (milliseconds > MILLISECONDS_IN_HOUR) {
    return {
      units: 'h',
      value: round(milliseconds / MILLISECONDS_IN_HOUR)
    };
  }

  if (milliseconds > MILLISECONDS_IN_MINUTE) {
    return {
      units: 'm',
      value: round(milliseconds / MILLISECONDS_IN_MINUTE)
    };
  }

  return {
    units: 's',
    value: round(milliseconds / MILLISECONDS_IN_SECOND)
  };
}

function toMilliseconds(units, value) {
  switch (units) {
    case 'h':
      return Math.round(value * MILLISECONDS_IN_HOUR);

    case 'm':
      return Math.round(value * MILLISECONDS_IN_MINUTE);

    case 's':
    default:
      return Math.round(value * MILLISECONDS_IN_SECOND);
  }
}

export var OuiRefreshInterval = /*#__PURE__*/function (_Component) {
  _inherits(OuiRefreshInterval, _Component);

  var _super = _createSuper(OuiRefreshInterval);

  function OuiRefreshInterval() {
    var _this;

    _classCallCheck(this, OuiRefreshInterval);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", fromMilliseconds(_this.props.refreshInterval));

    _defineProperty(_assertThisInitialized(_this), "generateId", htmlIdGenerator());

    _defineProperty(_assertThisInitialized(_this), "onValueChange", function (event) {
      var sanitizedValue = parseFloat(event.target.value);

      _this.setState({
        value: isNaN(sanitizedValue) ? '' : sanitizedValue
      }, _this.applyRefreshInterval);
    });

    _defineProperty(_assertThisInitialized(_this), "onUnitsChange", function (event) {
      _this.setState({
        units: event.target.value
      }, _this.applyRefreshInterval);
    });

    _defineProperty(_assertThisInitialized(_this), "startRefresh", function () {
      var applyRefreshInterval = _this.props.applyRefreshInterval;
      var _this$state = _this.state,
          value = _this$state.value,
          units = _this$state.units;

      if (value !== '' && value > 0 && applyRefreshInterval !== undefined) {
        applyRefreshInterval({
          refreshInterval: toMilliseconds(units, value),
          isPaused: false
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleKeyDown", function (_ref) {
      var key = _ref.key;

      if (key === 'Enter') {
        _this.startRefresh();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "applyRefreshInterval", function () {
      var _this$props = _this.props,
          applyRefreshInterval = _this$props.applyRefreshInterval,
          isPaused = _this$props.isPaused;
      var _this$state2 = _this.state,
          units = _this$state2.units,
          value = _this$state2.value;

      if (value === '') {
        return;
      }

      if (!applyRefreshInterval) {
        return;
      }

      var refreshInterval = toMilliseconds(units, value);
      applyRefreshInterval({
        refreshInterval: refreshInterval,
        isPaused: refreshInterval <= 0 ? true : isPaused
      });
    });

    _defineProperty(_assertThisInitialized(_this), "toggleRefresh", function () {
      var _this$props2 = _this.props,
          applyRefreshInterval = _this$props2.applyRefreshInterval,
          isPaused = _this$props2.isPaused;
      var _this$state3 = _this.state,
          units = _this$state3.units,
          value = _this$state3.value;

      if (!applyRefreshInterval || value === '') {
        return;
      }

      applyRefreshInterval({
        refreshInterval: toMilliseconds(units, value),
        isPaused: !isPaused
      });
    });

    return _this;
  }

  _createClass(OuiRefreshInterval, [{
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          applyRefreshInterval = _this$props3.applyRefreshInterval,
          isPaused = _this$props3.isPaused;
      var _this$state4 = this.state,
          value = _this$state4.value,
          units = _this$state4.units;
      var legendId = this.generateId();
      var refreshSelectionId = this.generateId();

      if (!applyRefreshInterval) {
        return null;
      }

      var options = refreshUnitsOptions.find(function (_ref2) {
        var value = _ref2.value;
        return value === units;
      });
      var optionText = options ? options.text : '';
      return /*#__PURE__*/React.createElement("fieldset", null, /*#__PURE__*/React.createElement(OuiTitle, {
        size: "xxxs"
      }, /*#__PURE__*/React.createElement("legend", {
        id: legendId
      }, /*#__PURE__*/React.createElement(OuiI18n, {
        token: "ouiRefreshInterval.legend",
        default: "Refresh every"
      }))), /*#__PURE__*/React.createElement(OuiSpacer, {
        size: "s"
      }), /*#__PURE__*/React.createElement(OuiFlexGroup, {
        gutterSize: "s",
        responsive: false
      }, /*#__PURE__*/React.createElement(OuiFlexItem, null, /*#__PURE__*/React.createElement(OuiFieldNumber, {
        compressed: true,
        value: value,
        onChange: this.onValueChange,
        onKeyDown: this.handleKeyDown,
        "aria-label": "Refresh interval value",
        "aria-describedby": "".concat(refreshSelectionId, " ").concat(legendId),
        "data-test-subj": "superDatePickerRefreshIntervalInput"
      })), /*#__PURE__*/React.createElement(OuiFlexItem, null, /*#__PURE__*/React.createElement(OuiSelect, {
        compressed: true,
        "aria-label": "Refresh interval units",
        "aria-describedby": "".concat(refreshSelectionId, " ").concat(legendId),
        value: units,
        options: refreshUnitsOptions,
        onChange: this.onUnitsChange,
        onKeyDown: this.handleKeyDown,
        "data-test-subj": "superDatePickerRefreshIntervalUnitsSelect"
      })), /*#__PURE__*/React.createElement(OuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(OuiButton, {
        className: "ouiRefreshInterval__startButton",
        iconType: isPaused ? 'play' : 'stop',
        size: "s",
        onClick: this.toggleRefresh,
        disabled: value === '' || value <= 0,
        "data-test-subj": "superDatePickerToggleRefreshButton",
        "aria-describedby": refreshSelectionId
      }, isPaused ? /*#__PURE__*/React.createElement(OuiI18n, {
        token: "ouiRefreshInterval.start",
        default: "Start"
      }) : /*#__PURE__*/React.createElement(OuiI18n, {
        token: "ouiRefreshInterval.stop",
        default: "Stop"
      })))), /*#__PURE__*/React.createElement(OuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("p", {
        id: refreshSelectionId
      }, /*#__PURE__*/React.createElement(OuiI18n, {
        token: "ouiRefreshInterval.fullDescription",
        default: "Refresh interval currently set to {optionValue} {optionText}.",
        values: {
          optionValue: value,
          optionText: optionText
        }
      }))));
    }
  }]);

  return OuiRefreshInterval;
}(Component);
/* OUI -> EUI Aliases: Build-Time */

OuiRefreshInterval.propTypes = {
  applyRefreshInterval: PropTypes.func,
  isPaused: PropTypes.bool.isRequired,
  refreshInterval: PropTypes.number.isRequired
};

/* OUI -> EUI Aliases: Build-Time */
export { EuiRefreshInterval } from '../../../../eui_components/date_picker/super_date_picker/quick_select_popover/refresh_interval';