/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.stats;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opensearch.ad.model.Mergeable;
import org.opensearch.ad.transport.ADStatsNodesResponse;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;

public class ADStatsResponse
implements ToXContentObject,
Mergeable {
    private ADStatsNodesResponse adStatsNodesResponse;
    private Map<String, Object> clusterStats;

    public Map<String, Object> getClusterStats() {
        return this.clusterStats;
    }

    public void setClusterStats(Map<String, Object> clusterStats) {
        this.clusterStats = clusterStats;
    }

    public ADStatsNodesResponse getADStatsNodesResponse() {
        return this.adStatsNodesResponse;
    }

    public void setADStatsNodesResponse(ADStatsNodesResponse adStatsNodesResponse) {
        this.adStatsNodesResponse = adStatsNodesResponse;
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public ADStatsResponse() {
    }

    public ADStatsResponse(StreamInput in) throws IOException {
        this.adStatsNodesResponse = new ADStatsNodesResponse(in);
        this.clusterStats = in.readMap();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.adStatsNodesResponse.writeTo(out);
        out.writeMap(this.clusterStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        for (Map.Entry<String, Object> clusterStat : this.clusterStats.entrySet()) {
            builder.field(clusterStat.getKey(), clusterStat.getValue());
        }
        this.adStatsNodesResponse.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
        return xContentBuilder.endObject();
    }

    @Override
    public void merge(Mergeable other) {
        if (this == other || other == null || this.getClass() != other.getClass()) {
            return;
        }
        ADStatsResponse otherResponse = (ADStatsResponse)other;
        if (otherResponse.adStatsNodesResponse != null) {
            this.adStatsNodesResponse = otherResponse.adStatsNodesResponse;
        }
        if (otherResponse.clusterStats != null) {
            this.clusterStats = otherResponse.clusterStats;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ADStatsResponse other = (ADStatsResponse)obj;
        return new EqualsBuilder().append((Object)this.adStatsNodesResponse, (Object)other.adStatsNodesResponse).append(this.clusterStats, other.clusterStats).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.adStatsNodesResponse).append(this.clusterStats).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("adStatsNodesResponse", (Object)this.adStatsNodesResponse).append("clusterStats", this.clusterStats).toString();
    }
}

