/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.analysis;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ko.KoreanTokenizer;
import org.apache.lucene.analysis.ko.dict.UserDictionary;
import org.opensearch.OpenSearchException;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenizerFactory;
import org.opensearch.index.analysis.Analysis;

public class NoriTokenizerFactory
extends AbstractTokenizerFactory {
    private static final String USER_DICT_PATH_OPTION = "user_dictionary";
    private static final String USER_DICT_RULES_OPTION = "user_dictionary_rules";
    private final UserDictionary userDictionary;
    private final KoreanTokenizer.DecompoundMode decompoundMode;
    private final boolean discardPunctuation;

    public NoriTokenizerFactory(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, settings, name);
        this.decompoundMode = NoriTokenizerFactory.getMode(settings);
        this.userDictionary = NoriTokenizerFactory.getUserDictionary(env, settings);
        this.discardPunctuation = settings.getAsBoolean("discard_punctuation", Boolean.valueOf(true));
    }

    public static UserDictionary getUserDictionary(Environment env, Settings settings) {
        UserDictionary userDictionary;
        if (settings.get(USER_DICT_PATH_OPTION) != null && settings.get(USER_DICT_RULES_OPTION) != null) {
            throw new IllegalArgumentException("It is not allowed to use [user_dictionary] in conjunction with [user_dictionary_rules]");
        }
        List ruleList = Analysis.getWordList((Environment)env, (Settings)settings, (String)USER_DICT_PATH_OPTION, (String)USER_DICT_RULES_OPTION, (boolean)true);
        StringBuilder sb = new StringBuilder();
        if (ruleList == null || ruleList.isEmpty()) {
            return null;
        }
        for (String line : ruleList) {
            sb.append(line).append(System.lineSeparator());
        }
        StringReader rulesReader = new StringReader(sb.toString());
        try {
            userDictionary = UserDictionary.open((Reader)rulesReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)rulesReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OpenSearchException("failed to load nori user dictionary", (Throwable)e, new Object[0]);
            }
        }
        ((Reader)rulesReader).close();
        return userDictionary;
    }

    public static KoreanTokenizer.DecompoundMode getMode(Settings settings) {
        KoreanTokenizer.DecompoundMode mode = KoreanTokenizer.DEFAULT_DECOMPOUND;
        String modeSetting = settings.get("decompound_mode", null);
        if (modeSetting != null) {
            mode = KoreanTokenizer.DecompoundMode.valueOf((String)modeSetting.toUpperCase(Locale.ENGLISH));
        }
        return mode;
    }

    public Tokenizer create() {
        return new KoreanTokenizer(KoreanTokenizer.DEFAULT_TOKEN_ATTRIBUTE_FACTORY, this.userDictionary, this.decompoundMode, false, this.discardPunctuation);
    }
}

