/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java.java14;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import com.google.googlejavaformat.Op;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.java.JavaInputAstVisitor;
import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.YieldTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Name;

public class Java14InputAstVisitor
extends JavaInputAstVisitor {
    public Java14InputAstVisitor(OpsBuilder builder, int indentMultiplier) {
        super(builder, indentMultiplier);
    }

    @Override
    public Void visitBindingPattern(BindingPatternTree node, Void unused) {
        this.sync(node);
        try {
            VariableTree variableTree = (VariableTree)BindingPatternTree.class.getMethod("getVariable", new Class[0]).invoke((Object)node, new Object[0]);
            this.visitBindingPattern(variableTree.getType(), variableTree.getName());
        }
        catch (ReflectiveOperationException e1) {
            try {
                Tree type = (Tree)BindingPatternTree.class.getMethod("getType", new Class[0]).invoke((Object)node, new Object[0]);
                Name name = (Name)BindingPatternTree.class.getMethod("getName", new Class[0]).invoke((Object)node, new Object[0]);
                this.visitBindingPattern(type, name);
            }
            catch (ReflectiveOperationException e2) {
                e2.addSuppressed(e1);
                throw new LinkageError(e2.getMessage(), e2);
            }
        }
        return null;
    }

    private void visitBindingPattern(Tree type, Name name) {
        this.scan(type, null);
        this.builder.breakOp(" ");
        this.visit(name);
    }

    @Override
    public Void visitYield(YieldTree node, Void aVoid) {
        this.sync(node);
        this.token("yield");
        this.builder.space();
        this.scan((Tree)node.getValue(), null);
        this.token(";");
        return null;
    }

    @Override
    public Void visitSwitchExpression(SwitchExpressionTree node, Void aVoid) {
        this.sync(node);
        this.visitSwitch(node.getExpression(), node.getCases());
        return null;
    }

    @Override
    public Void visitClass(ClassTree tree, Void unused) {
        switch (tree.getKind()) {
            case ANNOTATION_TYPE: {
                this.visitAnnotationType(tree);
                break;
            }
            case CLASS: 
            case INTERFACE: {
                this.visitClassDeclaration(tree);
                break;
            }
            case ENUM: {
                this.visitEnumDeclaration(tree);
                break;
            }
            case RECORD: {
                this.visitRecordDeclaration(tree);
                break;
            }
            default: {
                throw new AssertionError((Object)tree.getKind());
            }
        }
        return null;
    }

    public void visitRecordDeclaration(ClassTree node) {
        this.sync(node);
        List<Op> breaks = this.visitModifiers(node.getModifiers(), JavaInputAstVisitor.Direction.VERTICAL, Optional.empty());
        Verify.verify((node.getExtendsClause() == null ? 1 : 0) != 0);
        boolean hasSuperInterfaceTypes = !node.getImplementsClause().isEmpty();
        this.builder.addAll(breaks);
        this.token("record");
        this.builder.space();
        this.visit(node.getSimpleName());
        if (!node.getTypeParameters().isEmpty()) {
            this.token("<");
        }
        this.builder.open(this.plusFour);
        if (!node.getTypeParameters().isEmpty()) {
            this.typeParametersRest(node.getTypeParameters(), hasSuperInterfaceTypes ? this.plusFour : ZERO);
        }
        ImmutableList parameters = Java14InputAstVisitor.compactRecordConstructor(node).map(m -> ImmutableList.copyOf((Collection)m.getParameters())).orElseGet(() -> Java14InputAstVisitor.recordVariables(node));
        this.token("(");
        if (!parameters.isEmpty()) {
            this.builder.breakToFill("");
        }
        this.visitFormals(Optional.empty(), (List<? extends VariableTree>)parameters);
        this.token(")");
        if (hasSuperInterfaceTypes) {
            this.builder.breakToFill(" ");
            this.builder.open(node.getImplementsClause().size() > 1 ? this.plusFour : ZERO);
            this.token("implements");
            this.builder.space();
            boolean first = true;
            for (Tree tree : node.getImplementsClause()) {
                if (!first) {
                    this.token(",");
                    this.builder.breakOp(" ");
                }
                this.scan(tree, null);
                first = false;
            }
            this.builder.close();
        }
        this.builder.close();
        if (node.getMembers() == null) {
            this.token(";");
        } else {
            List members = (List)node.getMembers().stream().filter(t -> (TreeInfo.flags((JCTree)t) & 0x1000000L) == 0L).collect(ImmutableList.toImmutableList());
            this.addBodyDeclarations(members, JavaInputAstVisitor.BracesOrNot.YES, JavaInputAstVisitor.FirstDeclarationsOrNot.YES);
        }
        this.dropEmptyDeclarations();
    }

    private static Optional<JCTree.JCMethodDecl> compactRecordConstructor(ClassTree node) {
        return (Optional)node.getMembers().stream().filter(JCTree.JCMethodDecl.class::isInstance).map(JCTree.JCMethodDecl.class::cast).filter(m -> (m.mods.flags & 0x8000000000000L) == 0x8000000000000L).collect(MoreCollectors.toOptional());
    }

    private static ImmutableList<JCTree.JCVariableDecl> recordVariables(ClassTree node) {
        return (ImmutableList)node.getMembers().stream().filter(JCTree.JCVariableDecl.class::isInstance).map(JCTree.JCVariableDecl.class::cast).filter(m -> (m.mods.flags & 0x2000000000000000L) == 0x2000000000000000L).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getExpression(), null);
        this.builder.breakOp(" ");
        this.builder.open(ZERO);
        this.token("instanceof");
        this.builder.breakOp(" ");
        if (node.getPattern() != null) {
            this.scan((Tree)node.getPattern(), null);
        } else {
            this.scan(node.getType(), null);
        }
        this.builder.close();
        this.builder.close();
        return null;
    }

    @Override
    public Void visitCase(CaseTree node, Void unused) {
        this.sync(node);
        this.markForPartialFormat();
        this.builder.forcedBreak();
        if (node.getExpressions().isEmpty()) {
            this.token("default", this.plusTwo);
        } else {
            this.token("case", this.plusTwo);
            this.builder.space();
            boolean first = true;
            for (ExpressionTree expressionTree : node.getExpressions()) {
                if (!first) {
                    this.token(",");
                    this.builder.space();
                }
                this.scan((Tree)expressionTree, null);
                first = false;
            }
        }
        switch (node.getCaseKind()) {
            case STATEMENT: {
                this.token(":");
                this.builder.open(this.plusTwo);
                this.visitStatements(node.getStatements());
                this.builder.close();
                break;
            }
            case RULE: {
                this.builder.space();
                this.token("-");
                this.token(">");
                this.builder.space();
                this.scan(node.getBody(), null);
                this.builder.guessToken(";");
                break;
            }
            default: {
                throw new AssertionError((Object)node.getCaseKind());
            }
        }
        return null;
    }
}

