/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.opensearch.common.Strings;
import org.opensearch.common.settings.Settings;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AbstractTokenFilterFactory;

public class SnowballTokenFilterFactory
extends AbstractTokenFilterFactory {
    private String language;

    SnowballTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.language = Strings.capitalize((String)settings.get("language", settings.get("name", "English")));
    }

    public TokenStream create(TokenStream tokenStream) {
        return new SnowballFilter(tokenStream, this.language);
    }
}

