/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.internal;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.suggest.document.CompletionTerms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.opensearch.common.lucene.index.SequentialStoredFieldsLeafReader;

class ExitableDirectoryReader
extends FilterDirectoryReader {
    ExitableDirectoryReader(DirectoryReader in, final QueryCancellation queryCancellation) throws IOException {
        super(in, new FilterDirectoryReader.SubReaderWrapper(){

            public LeafReader wrap(LeafReader reader) {
                return new ExitableLeafReader(reader, queryCancellation);
            }
        });
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) {
        throw new UnsupportedOperationException("doWrapDirectoryReader() should never be invoked");
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    private static class ExitableIntersectVisitor
    implements PointValues.IntersectVisitor {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 8191;
        private PointValues.IntersectVisitor in;
        private final QueryCancellation queryCancellation;
        private int calls;

        private ExitableIntersectVisitor(QueryCancellation queryCancellation) {
            this.queryCancellation = queryCancellation;
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        private void setVisitor(PointValues.IntersectVisitor in) {
            this.in = in;
        }

        public void visit(int docID) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID);
        }

        public void visit(int docID, byte[] packedValue) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID, packedValue);
        }

        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            this.queryCancellation.checkCancelled();
            return this.in.compare(minPackedValue, maxPackedValue);
        }

        public void grow(int count) {
            this.queryCancellation.checkCancelled();
            this.in.grow(count);
        }
    }

    static class ExitablePointValues
    extends PointValues {
        private final PointValues in;
        private final QueryCancellation queryCancellation;

        private ExitablePointValues(PointValues in, QueryCancellation queryCancellation) {
            this.in = in;
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        public PointValues.PointTree getPointTree() throws IOException {
            return new ExitablePointTree(this.in, this.in.getPointTree(), this.queryCancellation);
        }

        public byte[] getMinPackedValue() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getMinPackedValue();
        }

        public byte[] getMaxPackedValue() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getMaxPackedValue();
        }

        public int getNumDimensions() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getNumDimensions();
        }

        public int getNumIndexDimensions() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getNumIndexDimensions();
        }

        public int getBytesPerDimension() throws IOException {
            this.queryCancellation.checkCancelled();
            return this.in.getBytesPerDimension();
        }

        public long size() {
            this.queryCancellation.checkCancelled();
            return this.in.size();
        }

        public int getDocCount() {
            this.queryCancellation.checkCancelled();
            return this.in.getDocCount();
        }
    }

    private static class ExitablePointTree
    implements PointValues.PointTree {
        private final PointValues values;
        private final PointValues.PointTree pointTree;
        private final ExitableIntersectVisitor exitableIntersectVisitor;
        private final QueryCancellation queryCancellation;
        private int calls;

        private ExitablePointTree(PointValues values, PointValues.PointTree pointTree, QueryCancellation queryCancellation) {
            this.values = values;
            this.pointTree = pointTree;
            this.exitableIntersectVisitor = new ExitableIntersectVisitor(queryCancellation);
            this.queryCancellation = queryCancellation;
        }

        public PointValues.PointTree clone() {
            this.queryCancellation.checkCancelled();
            return new ExitablePointTree(this.values, this.pointTree.clone(), this.queryCancellation);
        }

        public boolean moveToChild() throws IOException {
            this.checkAndThrowWithSampling();
            return this.pointTree.moveToChild();
        }

        public boolean moveToSibling() throws IOException {
            this.checkAndThrowWithSampling();
            return this.pointTree.moveToSibling();
        }

        public boolean moveToParent() throws IOException {
            this.checkAndThrowWithSampling();
            return this.pointTree.moveToParent();
        }

        public byte[] getMinPackedValue() {
            this.checkAndThrowWithSampling();
            return this.pointTree.getMinPackedValue();
        }

        public byte[] getMaxPackedValue() {
            this.checkAndThrowWithSampling();
            return this.pointTree.getMaxPackedValue();
        }

        public long size() {
            this.queryCancellation.checkCancelled();
            return this.pointTree.size();
        }

        public void visitDocIDs(PointValues.IntersectVisitor visitor) throws IOException {
            this.queryCancellation.checkCancelled();
            this.pointTree.visitDocIDs(visitor);
        }

        public void visitDocValues(PointValues.IntersectVisitor visitor) throws IOException {
            this.queryCancellation.checkCancelled();
            this.exitableIntersectVisitor.setVisitor(visitor);
            this.pointTree.visitDocValues((PointValues.IntersectVisitor)this.exitableIntersectVisitor);
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0x1FFF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }
    }

    private static class ExitableTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 15;
        private int calls;
        private final QueryCancellation queryCancellation;

        private ExitableTermsEnum(TermsEnum termsEnum, QueryCancellation queryCancellation) {
            super(termsEnum);
            this.queryCancellation = queryCancellation;
            this.queryCancellation.checkCancelled();
        }

        private void checkAndThrowWithSampling() {
            if ((this.calls++ & 0xF) == 0) {
                this.queryCancellation.checkCancelled();
            }
        }

        public BytesRef next() throws IOException {
            this.checkAndThrowWithSampling();
            return this.in.next();
        }
    }

    static class ExitableTerms
    extends FilterLeafReader.FilterTerms {
        private final QueryCancellation queryCancellation;

        private ExitableTerms(Terms terms, QueryCancellation queryCancellation) {
            super(terms);
            this.queryCancellation = queryCancellation;
        }

        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new ExitableTermsEnum(this.in.intersect(compiled, startTerm), this.queryCancellation);
        }

        public TermsEnum iterator() throws IOException {
            return new ExitableTermsEnum(this.in.iterator(), this.queryCancellation);
        }
    }

    static class ExitableLeafReader
    extends SequentialStoredFieldsLeafReader {
        private final QueryCancellation queryCancellation;

        private ExitableLeafReader(LeafReader leafReader, QueryCancellation queryCancellation) {
            super(leafReader);
            this.queryCancellation = queryCancellation;
        }

        public PointValues getPointValues(String field) throws IOException {
            PointValues pointValues = this.in.getPointValues(field);
            if (pointValues == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() ? new ExitablePointValues(pointValues, this.queryCancellation) : pointValues;
        }

        public Terms terms(String field) throws IOException {
            Terms terms = this.in.terms(field);
            if (terms == null) {
                return null;
            }
            return this.queryCancellation.isEnabled() && !(terms instanceof CompletionTerms) ? new ExitableTerms(terms, this.queryCancellation) : terms;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }

        @Override
        protected StoredFieldsReader doGetSequentialStoredFieldsReader(StoredFieldsReader reader) {
            return reader;
        }
    }

    static interface QueryCancellation {
        public boolean isEnabled();

        public void checkCancelled();
    }
}

