/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.misc.store.HardlinkCopyDirectoryWrapper;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.StepListener;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.common.UUIDs;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.index.engine.EngineException;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardClosedException;
import org.opensearch.index.shard.IndexShardNotStartedException;
import org.opensearch.index.shard.IndexShardRecoveryException;
import org.opensearch.index.shard.IndexShardState;
import org.opensearch.index.shard.LocalShardSnapshot;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.shard.ShardSplittingQuery;
import org.opensearch.index.snapshots.IndexShardRestoreFailedException;
import org.opensearch.index.store.Store;
import org.opensearch.index.translog.Translog;
import org.opensearch.indices.recovery.RecoveryState;
import org.opensearch.indices.replication.common.ReplicationLuceneIndex;
import org.opensearch.repositories.IndexId;
import org.opensearch.repositories.Repository;

final class StoreRecovery {
    private final Logger logger;
    private final ShardId shardId;

    StoreRecovery(ShardId shardId, Logger logger) {
        this.logger = logger;
        this.shardId = shardId;
    }

    void recoverFromStore(IndexShard indexShard, ActionListener<Boolean> listener) {
        if (this.canRecover(indexShard)) {
            RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
            assert (recoveryType == RecoverySource.Type.EMPTY_STORE || recoveryType == RecoverySource.Type.EXISTING_STORE) : "expected store recovery type but was: " + recoveryType;
            ActionListener.completeWith(this.recoveryListener(indexShard, listener), () -> {
                this.logger.debug("starting recovery from store ...");
                this.internalRecoverFromStore(indexShard);
                return true;
            });
        } else {
            listener.onResponse(false);
        }
    }

    void recoverFromRemoteStore(IndexShard indexShard, ActionListener<Boolean> listener) {
        if (this.canRecover(indexShard)) {
            RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
            assert (recoveryType == RecoverySource.Type.REMOTE_STORE) : "expected remote store recovery type but was: " + recoveryType;
            ActionListener.completeWith(this.recoveryListener(indexShard, listener), () -> {
                this.logger.debug("starting recovery from remote store ...");
                this.recoverFromRemoteStore(indexShard);
                return true;
            });
        } else {
            listener.onResponse(false);
        }
    }

    void recoverFromLocalShards(Consumer<MappingMetadata> mappingUpdateConsumer, IndexShard indexShard, List<LocalShardSnapshot> shards, ActionListener<Boolean> listener) {
        if (this.canRecover(indexShard)) {
            RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
            assert (recoveryType == RecoverySource.Type.LOCAL_SHARDS) : "expected local shards recovery type: " + recoveryType;
            if (shards.isEmpty()) {
                throw new IllegalArgumentException("shards must not be empty");
            }
            Set indices = shards.stream().map(s -> s.getIndex()).collect(Collectors.toSet());
            if (indices.size() > 1) {
                throw new IllegalArgumentException("can't add shards from more than one index");
            }
            IndexMetadata sourceMetadata = shards.get(0).getIndexMetadata();
            if (sourceMetadata.mapping() != null) {
                mappingUpdateConsumer.accept(sourceMetadata.mapping());
            }
            indexShard.mapperService().merge(sourceMetadata, MapperService.MergeReason.MAPPING_RECOVERY);
            Sort indexSort = indexShard.getIndexSort();
            boolean hasNested = indexShard.mapperService().hasNested();
            boolean isSplit = sourceMetadata.getNumberOfShards() < indexShard.indexSettings().getNumberOfShards();
            ActionListener.completeWith(this.recoveryListener(indexShard, listener), () -> {
                this.logger.debug("starting recovery from local shards {}", (Object)shards);
                try {
                    Directory directory = indexShard.store().directory();
                    Directory[] sources = (Directory[])shards.stream().map(LocalShardSnapshot::getSnapshotDirectory).toArray(Directory[]::new);
                    long maxSeqNo = shards.stream().mapToLong(LocalShardSnapshot::maxSeqNo).max().getAsLong();
                    long maxUnsafeAutoIdTimestamp = shards.stream().mapToLong(LocalShardSnapshot::maxUnsafeAutoIdTimestamp).max().getAsLong();
                    this.addIndices(indexShard.recoveryState().getIndex(), directory, indexSort, sources, maxSeqNo, maxUnsafeAutoIdTimestamp, indexShard.indexSettings().getIndexMetadata(), indexShard.shardId().id(), isSplit, hasNested);
                    this.internalRecoverFromStore(indexShard);
                    indexShard.getEngine().forceMerge(false, -1, false, false, false, UUIDs.randomBase64UUID());
                    return true;
                }
                catch (IOException ex) {
                    throw new IndexShardRecoveryException(indexShard.shardId(), "failed to recover from local shards", ex);
                }
            });
        } else {
            listener.onResponse(false);
        }
    }

    void addIndices(ReplicationLuceneIndex indexRecoveryStats, Directory target, Sort indexSort, Directory[] sources, long maxSeqNo, long maxUnsafeAutoIdTimestamp, IndexMetadata indexMetadata, int shardId, boolean split, boolean hasNested) throws IOException {
        assert (sources.length > 0);
        int luceneIndexCreatedVersionMajor = Lucene.readSegmentInfos(sources[0]).getIndexCreatedVersionMajor();
        HardlinkCopyDirectoryWrapper hardLinkOrCopyTarget = new HardlinkCopyDirectoryWrapper(target);
        IndexWriterConfig iwc = new IndexWriterConfig(null).setSoftDeletesField("__soft_deletes").setCommitOnClose(false).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(IndexWriterConfig.OpenMode.CREATE).setIndexCreatedVersionMajor(luceneIndexCreatedVersionMajor);
        if (indexSort != null) {
            iwc.setIndexSort(indexSort);
        }
        try (IndexWriter writer = new IndexWriter((Directory)new StatsDirectoryWrapper((Directory)hardLinkOrCopyTarget, indexRecoveryStats), iwc);){
            writer.addIndexes(sources);
            indexRecoveryStats.setFileDetailsComplete();
            if (split) {
                writer.deleteDocuments(new Query[]{new ShardSplittingQuery(indexMetadata, shardId, hasNested)});
            }
            writer.setLiveCommitData(() -> {
                HashMap<String, String> liveCommitData = new HashMap<String, String>(3);
                liveCommitData.put("max_seq_no", Long.toString(maxSeqNo));
                liveCommitData.put("local_checkpoint", Long.toString(maxSeqNo));
                liveCommitData.put("max_unsafe_auto_id_timestamp", Long.toString(maxUnsafeAutoIdTimestamp));
                return liveCommitData.entrySet().iterator();
            });
            writer.commit();
        }
    }

    void recoverFromRepository(IndexShard indexShard, Repository repository, ActionListener<Boolean> listener) {
        try {
            if (this.canRecover(indexShard)) {
                RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
                assert (recoveryType == RecoverySource.Type.SNAPSHOT) : "expected snapshot recovery type: " + recoveryType;
                RecoverySource.SnapshotRecoverySource recoverySource = (RecoverySource.SnapshotRecoverySource)indexShard.recoveryState().getRecoverySource();
                this.restore(indexShard, repository, recoverySource, this.recoveryListener(indexShard, listener));
            } else {
                listener.onResponse(false);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private boolean canRecover(IndexShard indexShard) {
        if (indexShard.state() == IndexShardState.CLOSED) {
            return false;
        }
        if (!indexShard.routingEntry().primary()) {
            throw new IndexShardRecoveryException(this.shardId, "Trying to recover when the shard is in backup state", null);
        }
        return true;
    }

    private ActionListener<Boolean> recoveryListener(IndexShard indexShard, ActionListener<Boolean> listener) {
        return ActionListener.wrap(res -> {
            if (res.booleanValue()) {
                IndexShardState shardState = indexShard.state();
                RecoveryState recoveryState = indexShard.recoveryState();
                assert (shardState != IndexShardState.CREATED && shardState != IndexShardState.RECOVERING) : "recovery process of " + this.shardId + " didn't get to post_recovery. shardState [" + shardState + "]";
                if (this.logger.isTraceEnabled()) {
                    ReplicationLuceneIndex index = recoveryState.getIndex();
                    StringBuilder sb = new StringBuilder();
                    sb.append("    index    : files           [").append(index.totalFileCount()).append("] with total_size [").append(new ByteSizeValue(index.totalBytes())).append("], took[").append(TimeValue.timeValueMillis((long)index.time())).append("]\n");
                    sb.append("             : recovered_files [").append(index.recoveredFileCount()).append("] with total_size [").append(new ByteSizeValue(index.recoveredBytes())).append("]\n");
                    sb.append("             : reusing_files   [").append(index.reusedFileCount()).append("] with total_size [").append(new ByteSizeValue(index.reusedBytes())).append("]\n");
                    sb.append("    verify_index    : took [").append(TimeValue.timeValueMillis((long)recoveryState.getVerifyIndex().time())).append("], check_index [").append(TimeValue.timeValueMillis((long)recoveryState.getVerifyIndex().checkIndexTime())).append("]\n");
                    sb.append("    translog : number_of_operations [").append(recoveryState.getTranslog().recoveredOperations()).append("], took [").append(TimeValue.timeValueMillis((long)recoveryState.getTranslog().time())).append("]");
                    this.logger.trace("recovery completed from [shard_store], took [{}]\n{}", (Object)TimeValue.timeValueMillis((long)recoveryState.getTimer().time()), (Object)sb);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("recovery completed from [shard_store], took [{}]", (Object)TimeValue.timeValueMillis((long)recoveryState.getTimer().time()));
                }
            }
            listener.onResponse((Boolean)res);
        }, ex -> {
            if (ex instanceof IndexShardRecoveryException) {
                if (indexShard.state() == IndexShardState.CLOSED) {
                    listener.onResponse(false);
                    return;
                }
                if (ex.getCause() instanceof IndexShardClosedException || ex.getCause() instanceof IndexShardNotStartedException) {
                    listener.onResponse(false);
                    return;
                }
                listener.onFailure((Exception)ex);
            } else if (ex instanceof IndexShardClosedException || ex instanceof IndexShardNotStartedException) {
                listener.onResponse(false);
            } else if (indexShard.state() == IndexShardState.CLOSED) {
                listener.onResponse(false);
            } else {
                listener.onFailure(new IndexShardRecoveryException(this.shardId, "failed recovery", (Throwable)ex));
            }
        });
    }

    private void recoverFromRemoteStore(IndexShard indexShard) throws IndexShardRecoveryException {
        Store remoteStore = indexShard.remoteStore();
        if (remoteStore == null) {
            throw new IndexShardRecoveryException(indexShard.shardId(), "Remote store is not enabled for this index", new IllegalArgumentException());
        }
        indexShard.preRecovery();
        indexShard.prepareForIndexRecovery();
        assert (remoteStore.directory() instanceof FilterDirectory) : "Store.directory is not an instance of FilterDirectory";
        FilterDirectory remoteStoreDirectory = (FilterDirectory)remoteStore.directory();
        assert (remoteStoreDirectory.getDelegate() instanceof FilterDirectory) : "Store.directory is not enclosing an instance of FilterDirectory";
        FilterDirectory byteSizeCachingStoreDirectory = (FilterDirectory)remoteStoreDirectory.getDelegate();
        Directory remoteDirectory = byteSizeCachingStoreDirectory.getDelegate();
        Store store = indexShard.store();
        Directory storeDirectory = store.directory();
        store.incRef();
        remoteStore.incRef();
        try {
            for (String file : storeDirectory.listAll()) {
                storeDirectory.deleteFile(file);
            }
            for (String file : remoteDirectory.listAll()) {
                storeDirectory.copyFrom(remoteDirectory, file, file, IOContext.DEFAULT);
            }
            this.bootstrap(indexShard, store);
            assert (indexShard.shardRouting.primary()) : "only primary shards can recover from store";
            indexShard.recoveryState().getIndex().setFileDetailsComplete();
            indexShard.openEngineAndRecoverFromTranslog();
            indexShard.getEngine().fillSeqNoGaps(indexShard.getPendingPrimaryTerm());
            indexShard.finalizeRecovery();
            indexShard.postRecovery("post recovery from remote_store");
        }
        catch (IOException e) {
            throw new IndexShardRecoveryException(indexShard.shardId, "Exception while recovering from remote store", e);
        }
        finally {
            store.decRef();
            remoteStore.decRef();
        }
    }

    private void internalRecoverFromStore(IndexShard indexShard) throws IndexShardRecoveryException {
        indexShard.preRecovery();
        RecoveryState recoveryState = indexShard.recoveryState();
        boolean indexShouldExists = recoveryState.getRecoverySource().getType() != RecoverySource.Type.EMPTY_STORE;
        indexShard.prepareForIndexRecovery();
        SegmentInfos si = null;
        Store store = indexShard.store();
        store.incRef();
        try {
            try {
                block21: {
                    store.failIfCorrupted();
                    try {
                        si = store.readLastCommittedSegmentsInfo();
                    }
                    catch (Exception e) {
                        Object files = "_unknown_";
                        try {
                            files = Arrays.toString(store.directory().listAll());
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            files = (String)files + " (failure=" + ExceptionsHelper.detailedMessage(inner) + ")";
                        }
                        if (!indexShouldExists) break block21;
                        throw new IndexShardRecoveryException(this.shardId, "shard allocated for local recovery (post api), should exist, but doesn't, current files: " + (String)files, e);
                    }
                }
                if (si != null && !indexShouldExists) {
                    this.logger.trace("cleaning existing shard, shouldn't exists");
                    Lucene.cleanLuceneIndex(store.directory());
                    si = null;
                }
            }
            catch (Exception e) {
                throw new IndexShardRecoveryException(this.shardId, "failed to fetch index version after copying it over", e);
            }
            if (recoveryState.getRecoverySource().getType() == RecoverySource.Type.LOCAL_SHARDS) {
                assert (indexShouldExists);
                this.bootstrap(indexShard, store);
                StoreRecovery.writeEmptyRetentionLeasesFile(indexShard);
            } else if (indexShouldExists) {
                if (recoveryState.getRecoverySource().shouldBootstrapNewHistoryUUID()) {
                    store.bootstrapNewHistory();
                    StoreRecovery.writeEmptyRetentionLeasesFile(indexShard);
                }
                ReplicationLuceneIndex index = recoveryState.getIndex();
                try {
                    if (si != null) {
                        this.addRecoveredFileDetails(si, store, index);
                    }
                }
                catch (IOException e) {
                    this.logger.debug("failed to list file details", (Throwable)e);
                }
                index.setFileDetailsComplete();
            } else {
                store.createEmpty(indexShard.indexSettings().getIndexVersionCreated().luceneVersion);
                String translogUUID = Translog.createEmptyTranslog(indexShard.shardPath().resolveTranslog(), -1L, this.shardId, indexShard.getPendingPrimaryTerm());
                store.associateIndexWithNewTranslog(translogUUID);
                StoreRecovery.writeEmptyRetentionLeasesFile(indexShard);
                indexShard.recoveryState().getIndex().setFileDetailsComplete();
            }
            indexShard.openEngineAndRecoverFromTranslog();
            indexShard.getEngine().fillSeqNoGaps(indexShard.getPendingPrimaryTerm());
            indexShard.finalizeRecovery();
            indexShard.postRecovery("post recovery from shard_store");
        }
        catch (IOException | EngineException e) {
            throw new IndexShardRecoveryException(this.shardId, "failed to recover from gateway", e);
        }
        finally {
            store.decRef();
        }
    }

    private static void writeEmptyRetentionLeasesFile(IndexShard indexShard) throws IOException {
        assert (indexShard.getRetentionLeases().leases().isEmpty()) : indexShard.getRetentionLeases();
        indexShard.persistRetentionLeases();
        assert (indexShard.loadRetentionLeases().leases().isEmpty());
    }

    private void addRecoveredFileDetails(SegmentInfos si, Store store, ReplicationLuceneIndex index) throws IOException {
        Directory directory = store.directory();
        for (String name : Lucene.files(si)) {
            long length = directory.fileLength(name);
            index.addFileDetail(name, length, true);
        }
    }

    private void restore(IndexShard indexShard, Repository repository, RecoverySource.SnapshotRecoverySource restoreSource, ActionListener<Boolean> listener) {
        this.logger.debug("restoring from {} ...", (Object)indexShard.recoveryState().getRecoverySource());
        indexShard.preRecovery();
        RecoveryState.Translog translogState = indexShard.recoveryState().getTranslog();
        if (restoreSource == null) {
            listener.onFailure(new IndexShardRestoreFailedException(this.shardId, "empty restore source"));
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] restoring shard [{}]", (Object)restoreSource.snapshot(), (Object)this.shardId);
        }
        ActionListener restoreListener = ActionListener.wrap(v -> {
            Store store = indexShard.store();
            this.bootstrap(indexShard, store);
            assert (indexShard.shardRouting.primary()) : "only primary shards can recover from store";
            StoreRecovery.writeEmptyRetentionLeasesFile(indexShard);
            indexShard.openEngineAndRecoverFromTranslog();
            indexShard.getEngine().fillSeqNoGaps(indexShard.getPendingPrimaryTerm());
            indexShard.finalizeRecovery();
            indexShard.postRecovery("restore done");
            listener.onResponse(true);
        }, e -> listener.onFailure(new IndexShardRestoreFailedException(this.shardId, "restore failed", (Throwable)e)));
        try {
            translogState.totalOperations(0);
            translogState.totalOperationsOnStart(0);
            indexShard.prepareForIndexRecovery();
            IndexId indexId = restoreSource.index();
            ShardId snapshotShardId = this.shardId.getIndexName().equals(indexId.getName()) ? this.shardId : new ShardId(indexId.getName(), "_na_", this.shardId.id());
            StepListener<IndexId> indexIdListener = new StepListener<IndexId>();
            if (indexId.getId().equals("_na_")) {
                repository.getRepositoryData(ActionListener.map(indexIdListener, repositoryData -> repositoryData.resolveIndexId(indexId.getName())));
            } else {
                indexIdListener.onResponse(indexId);
            }
            assert (indexShard.getEngineOrNull() == null);
            indexIdListener.whenComplete(idx -> repository.restoreShard(indexShard.store(), restoreSource.snapshot().getSnapshotId(), (IndexId)idx, snapshotShardId, indexShard.recoveryState(), restoreListener), restoreListener::onFailure);
        }
        catch (Exception e2) {
            restoreListener.onFailure(e2);
        }
    }

    private void bootstrap(IndexShard indexShard, Store store) throws IOException {
        store.bootstrapNewHistory();
        SegmentInfos segmentInfos = store.readLastCommittedSegmentsInfo();
        long localCheckpoint = Long.parseLong((String)segmentInfos.userData.get("local_checkpoint"));
        String translogUUID = Translog.createEmptyTranslog(indexShard.shardPath().resolveTranslog(), localCheckpoint, this.shardId, indexShard.getPendingPrimaryTerm());
        store.associateIndexWithNewTranslog(translogUUID);
    }

    static final class StatsDirectoryWrapper
    extends FilterDirectory {
        private final ReplicationLuceneIndex index;

        StatsDirectoryWrapper(Directory in, ReplicationLuceneIndex indexRecoveryStats) {
            super(in);
            this.index = indexRecoveryStats;
        }

        public void copyFrom(Directory from, String src, final String dest, IOContext context) throws IOException {
            final long l = from.fileLength(src);
            final AtomicBoolean copies = new AtomicBoolean(false);
            this.in.copyFrom((Directory)new FilterDirectory(from){

                public IndexInput openInput(String name, IOContext context) throws IOException {
                    index.addFileDetail(dest, l, false);
                    copies.set(true);
                    final IndexInput input = this.in.openInput(name, context);
                    return new IndexInput("StatsDirectoryWrapper(" + input.toString() + ")"){

                        public void close() throws IOException {
                            input.close();
                        }

                        public long getFilePointer() {
                            throw new UnsupportedOperationException("only straight copies are supported");
                        }

                        public void seek(long pos) throws IOException {
                            throw new UnsupportedOperationException("seeks are not supported");
                        }

                        public long length() {
                            return input.length();
                        }

                        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
                            throw new UnsupportedOperationException("slices are not supported");
                        }

                        public byte readByte() throws IOException {
                            throw new UnsupportedOperationException("use a buffer if you wanna perform well");
                        }

                        public void readBytes(byte[] b, int offset, int len) throws IOException {
                            input.readBytes(b, offset, len);
                            index.addRecoveredBytesToFile(dest, len);
                        }
                    };
                }
            }, src, dest, context);
            if (!copies.get()) {
                this.index.addFileDetail(dest, l, true);
            } else {
                assert (this.index.getFileDetails(dest) != null) : "File [" + dest + "] has no file details";
                assert (this.index.getFileDetails(dest).recovered() == l) : this.index.getFileDetails(dest).toString();
            }
        }

        public Set<String> getPendingDeletions() throws IOException {
            return this.in.getPendingDeletions();
        }
    }
}

