/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.lucene.search.Query;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.ParseField;
import org.opensearch.common.ParsingException;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.index.query.support.QueryParsers;
import org.opensearch.index.search.MatchQuery;
import org.opensearch.index.search.MultiMatchQuery;
import org.opensearch.index.search.QueryParserHelper;

public class MultiMatchQueryBuilder
extends AbstractQueryBuilder<MultiMatchQueryBuilder> {
    private static final String CUTOFF_FREQUENCY_DEPRECATION_MSG = "you can omit this option, the [multi_match] query can skip block of documents efficiently if the total number of hits is not tracked";
    public static final String NAME = "multi_match";
    public static final Type DEFAULT_TYPE = Type.BEST_FIELDS;
    public static final Operator DEFAULT_OPERATOR = Operator.OR;
    public static final int DEFAULT_PHRASE_SLOP = 0;
    public static final int DEFAULT_PREFIX_LENGTH = 0;
    public static final int DEFAULT_MAX_EXPANSIONS = 50;
    public static final MatchQuery.ZeroTermsQuery DEFAULT_ZERO_TERMS_QUERY = MatchQuery.DEFAULT_ZERO_TERMS_QUERY;
    public static final boolean DEFAULT_FUZZY_TRANSPOSITIONS = true;
    private static final ParseField SLOP_FIELD = new ParseField("slop", new String[0]);
    private static final ParseField ZERO_TERMS_QUERY_FIELD = new ParseField("zero_terms_query", new String[0]);
    private static final ParseField LENIENT_FIELD = new ParseField("lenient", new String[0]);
    private static final ParseField CUTOFF_FREQUENCY_FIELD = new ParseField("cutoff_frequency", new String[0]).withAllDeprecated("you can omit this option, the [multi_match] query can skip block of documents efficiently if the total number of hits is not tracked");
    private static final ParseField TIE_BREAKER_FIELD = new ParseField("tie_breaker", new String[0]);
    private static final ParseField FUZZY_REWRITE_FIELD = new ParseField("fuzzy_rewrite", new String[0]);
    private static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match", new String[0]);
    private static final ParseField OPERATOR_FIELD = new ParseField("operator", new String[0]);
    private static final ParseField MAX_EXPANSIONS_FIELD = new ParseField("max_expansions", new String[0]);
    private static final ParseField PREFIX_LENGTH_FIELD = new ParseField("prefix_length", new String[0]);
    private static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private static final ParseField GENERATE_SYNONYMS_PHRASE_QUERY = new ParseField("auto_generate_synonyms_phrase_query", new String[0]);
    private static final ParseField FUZZY_TRANSPOSITIONS_FIELD = new ParseField("fuzzy_transpositions", new String[0]);
    private final Object value;
    private final Map<String, Float> fieldsBoosts;
    private Type type = DEFAULT_TYPE;
    private Operator operator = DEFAULT_OPERATOR;
    private String analyzer;
    private int slop = 0;
    private Fuzziness fuzziness;
    private int prefixLength = 0;
    private int maxExpansions = 50;
    private String minimumShouldMatch;
    private String fuzzyRewrite = null;
    private Float tieBreaker;
    private Boolean lenient;
    private Float cutoffFrequency = null;
    private MatchQuery.ZeroTermsQuery zeroTermsQuery = DEFAULT_ZERO_TERMS_QUERY;
    private boolean autoGenerateSynonymsPhraseQuery = true;
    private boolean fuzzyTranspositions = true;

    public Type getType() {
        return this.type;
    }

    public MultiMatchQueryBuilder(Object value, String ... fields) {
        if (value == null) {
            throw new IllegalArgumentException("[multi_match] requires query value");
        }
        if (fields == null) {
            throw new IllegalArgumentException("[multi_match] requires fields at initialization time");
        }
        this.value = value;
        this.fieldsBoosts = new TreeMap<String, Float>();
        for (String field : fields) {
            this.field(field);
        }
    }

    public MultiMatchQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.value = in.readGenericValue();
        int size = in.readVInt();
        this.fieldsBoosts = new TreeMap<String, Float>();
        for (int i = 0; i < size; ++i) {
            String field = in.readString();
            float boost = in.readFloat();
            this.checkNegativeBoost(boost);
            this.fieldsBoosts.put(field, Float.valueOf(boost));
        }
        this.type = Type.readFromStream(in);
        this.operator = Operator.readFromStream(in);
        this.analyzer = in.readOptionalString();
        this.slop = in.readVInt();
        this.fuzziness = in.readOptionalWriteable(Fuzziness::new);
        this.prefixLength = in.readVInt();
        this.maxExpansions = in.readVInt();
        this.minimumShouldMatch = in.readOptionalString();
        this.fuzzyRewrite = in.readOptionalString();
        if (in.getVersion().before(LegacyESVersion.V_7_0_0)) {
            in.readOptionalBoolean();
        }
        this.tieBreaker = in.readOptionalFloat();
        this.lenient = in.readOptionalBoolean();
        this.cutoffFrequency = in.readOptionalFloat();
        this.zeroTermsQuery = MatchQuery.ZeroTermsQuery.readFromStream(in);
        this.autoGenerateSynonymsPhraseQuery = in.readBoolean();
        this.fuzzyTranspositions = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeGenericValue(this.value);
        out.writeVInt(this.fieldsBoosts.size());
        for (Map.Entry<String, Float> fieldsEntry : this.fieldsBoosts.entrySet()) {
            out.writeString(fieldsEntry.getKey());
            out.writeFloat(fieldsEntry.getValue().floatValue());
        }
        this.type.writeTo(out);
        this.operator.writeTo(out);
        out.writeOptionalString(this.analyzer);
        out.writeVInt(this.slop);
        out.writeOptionalWriteable(this.fuzziness);
        out.writeVInt(this.prefixLength);
        out.writeVInt(this.maxExpansions);
        out.writeOptionalString(this.minimumShouldMatch);
        out.writeOptionalString(this.fuzzyRewrite);
        if (out.getVersion().before(LegacyESVersion.V_7_0_0)) {
            out.writeOptionalBoolean(null);
        }
        out.writeOptionalFloat(this.tieBreaker);
        out.writeOptionalBoolean(this.lenient);
        out.writeOptionalFloat(this.cutoffFrequency);
        this.zeroTermsQuery.writeTo(out);
        out.writeBoolean(this.autoGenerateSynonymsPhraseQuery);
        out.writeBoolean(this.fuzzyTranspositions);
    }

    public Object value() {
        return this.value;
    }

    public MultiMatchQueryBuilder field(String field) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("supplied field is null or empty.");
        }
        this.fieldsBoosts.put(field, Float.valueOf(1.0f));
        return this;
    }

    public MultiMatchQueryBuilder field(String field, float boost) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("supplied field is null or empty.");
        }
        this.checkNegativeBoost(boost);
        this.fieldsBoosts.put(field, Float.valueOf(boost));
        return this;
    }

    public MultiMatchQueryBuilder fields(Map<String, Float> fields) {
        for (float fieldBoost : fields.values()) {
            this.checkNegativeBoost(fieldBoost);
        }
        this.fieldsBoosts.putAll(fields);
        return this;
    }

    public Map<String, Float> fields() {
        return this.fieldsBoosts;
    }

    public MultiMatchQueryBuilder type(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("[multi_match] requires type to be non-null");
        }
        this.type = type;
        return this;
    }

    public MultiMatchQueryBuilder type(Object type) {
        if (type == null) {
            throw new IllegalArgumentException("[multi_match] requires type to be non-null");
        }
        this.type = Type.parse(type.toString().toLowerCase(Locale.ROOT), LoggingDeprecationHandler.INSTANCE);
        return this;
    }

    public Type type() {
        return this.type;
    }

    public MultiMatchQueryBuilder operator(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException("[multi_match] requires operator to be non-null");
        }
        this.operator = operator;
        return this;
    }

    public Operator operator() {
        return this.operator;
    }

    public MultiMatchQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public MultiMatchQueryBuilder slop(int slop) {
        if (slop < 0) {
            throw new IllegalArgumentException("No negative slop allowed.");
        }
        this.slop = slop;
        return this;
    }

    public int slop() {
        return this.slop;
    }

    public MultiMatchQueryBuilder fuzziness(Object fuzziness) {
        if (fuzziness != null) {
            this.fuzziness = Fuzziness.build(fuzziness);
        }
        return this;
    }

    public Fuzziness fuzziness() {
        return this.fuzziness;
    }

    public MultiMatchQueryBuilder prefixLength(int prefixLength) {
        if (prefixLength < 0) {
            throw new IllegalArgumentException("No negative prefix length allowed.");
        }
        this.prefixLength = prefixLength;
        return this;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public MultiMatchQueryBuilder maxExpansions(int maxExpansions) {
        if (maxExpansions <= 0) {
            throw new IllegalArgumentException("Max expansions must be strictly great than zero.");
        }
        this.maxExpansions = maxExpansions;
        return this;
    }

    public int maxExpansions() {
        return this.maxExpansions;
    }

    public MultiMatchQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public MultiMatchQueryBuilder fuzzyRewrite(String fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
        return this;
    }

    public String fuzzyRewrite() {
        return this.fuzzyRewrite;
    }

    public MultiMatchQueryBuilder tieBreaker(float tieBreaker) {
        this.tieBreaker = Float.valueOf(tieBreaker);
        return this;
    }

    public MultiMatchQueryBuilder tieBreaker(Float tieBreaker) {
        this.tieBreaker = tieBreaker;
        return this;
    }

    public Float tieBreaker() {
        return this.tieBreaker;
    }

    public MultiMatchQueryBuilder lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public boolean lenient() {
        return this.lenient == null ? false : this.lenient;
    }

    @Deprecated
    public MultiMatchQueryBuilder cutoffFrequency(float cutoff) {
        this.cutoffFrequency = Float.valueOf(cutoff);
        return this;
    }

    @Deprecated
    public MultiMatchQueryBuilder cutoffFrequency(Float cutoff) {
        this.cutoffFrequency = cutoff;
        return this;
    }

    public Float cutoffFrequency() {
        return this.cutoffFrequency;
    }

    public MultiMatchQueryBuilder zeroTermsQuery(MatchQuery.ZeroTermsQuery zeroTermsQuery) {
        if (zeroTermsQuery == null) {
            throw new IllegalArgumentException("[multi_match] requires zero terms query to be non-null");
        }
        this.zeroTermsQuery = zeroTermsQuery;
        return this;
    }

    public MatchQuery.ZeroTermsQuery zeroTermsQuery() {
        return this.zeroTermsQuery;
    }

    public MultiMatchQueryBuilder autoGenerateSynonymsPhraseQuery(boolean enable) {
        this.autoGenerateSynonymsPhraseQuery = enable;
        return this;
    }

    public boolean autoGenerateSynonymsPhraseQuery() {
        return this.autoGenerateSynonymsPhraseQuery;
    }

    public boolean fuzzyTranspositions() {
        return this.fuzzyTranspositions;
    }

    public MultiMatchQueryBuilder fuzzyTranspositions(boolean fuzzyTranspositions) {
        this.fuzzyTranspositions = fuzzyTranspositions;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.value);
        builder.startArray(FIELDS_FIELD.getPreferredName());
        for (Map.Entry<String, Float> fieldEntry : this.fieldsBoosts.entrySet()) {
            builder.value(fieldEntry.getKey() + "^" + fieldEntry.getValue());
        }
        builder.endArray();
        builder.field(TYPE_FIELD.getPreferredName(), this.type.toString().toLowerCase(Locale.ENGLISH));
        builder.field(OPERATOR_FIELD.getPreferredName(), this.operator.toString());
        if (this.analyzer != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        builder.field(SLOP_FIELD.getPreferredName(), this.slop);
        if (this.fuzziness != null) {
            this.fuzziness.toXContent(builder, params);
        }
        builder.field(PREFIX_LENGTH_FIELD.getPreferredName(), this.prefixLength);
        builder.field(MAX_EXPANSIONS_FIELD.getPreferredName(), this.maxExpansions);
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch);
        }
        if (this.fuzzyRewrite != null) {
            builder.field(FUZZY_REWRITE_FIELD.getPreferredName(), this.fuzzyRewrite);
        }
        if (this.tieBreaker != null) {
            builder.field(TIE_BREAKER_FIELD.getPreferredName(), this.tieBreaker);
        }
        if (this.lenient != null) {
            builder.field(LENIENT_FIELD.getPreferredName(), this.lenient);
        }
        if (this.cutoffFrequency != null) {
            builder.field(CUTOFF_FREQUENCY_FIELD.getPreferredName(), this.cutoffFrequency);
        }
        builder.field(ZERO_TERMS_QUERY_FIELD.getPreferredName(), this.zeroTermsQuery.toString());
        builder.field(GENERATE_SYNONYMS_PHRASE_QUERY.getPreferredName(), this.autoGenerateSynonymsPhraseQuery);
        builder.field(FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), this.fuzzyTranspositions);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static MultiMatchQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        Object value = null;
        HashMap<String, Float> fieldsBoosts = new HashMap<String, Float>();
        Type type = DEFAULT_TYPE;
        String analyzer = null;
        int slop = 0;
        Fuzziness fuzziness = null;
        int prefixLength = 0;
        int maxExpansions = 50;
        Operator operator = DEFAULT_OPERATOR;
        String minimumShouldMatch = null;
        String fuzzyRewrite = null;
        Object useDisMax = null;
        Float tieBreaker = null;
        Float cutoffFrequency = null;
        Boolean lenient = null;
        MatchQuery.ZeroTermsQuery zeroTermsQuery = DEFAULT_ZERO_TERMS_QUERY;
        boolean autoGenerateSynonymsPhraseQuery = true;
        boolean fuzzyTranspositions = true;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (FIELDS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        MultiMatchQueryBuilder.parseFieldAndBoost(parser, fieldsBoosts);
                    }
                    continue;
                }
                if (token.isValue()) {
                    MultiMatchQueryBuilder.parseFieldAndBoost(parser, fieldsBoosts);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[multi_match] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    value = parser.objectText();
                    continue;
                }
                if (TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    type = Type.parse(parser.text(), parser.getDeprecationHandler());
                    continue;
                }
                if (ANALYZER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    analyzer = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                if (SLOP_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    slop = parser.intValue();
                    continue;
                }
                if (Fuzziness.FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fuzziness = Fuzziness.parse(parser);
                    continue;
                }
                if (PREFIX_LENGTH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    prefixLength = parser.intValue();
                    continue;
                }
                if (MAX_EXPANSIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    maxExpansions = parser.intValue();
                    continue;
                }
                if (OPERATOR_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    operator = Operator.fromString(parser.text());
                    continue;
                }
                if (MINIMUM_SHOULD_MATCH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    minimumShouldMatch = parser.textOrNull();
                    continue;
                }
                if (FUZZY_REWRITE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fuzzyRewrite = parser.textOrNull();
                    continue;
                }
                if (TIE_BREAKER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    tieBreaker = Float.valueOf(parser.floatValue());
                    continue;
                }
                if (CUTOFF_FREQUENCY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    cutoffFrequency = Float.valueOf(parser.floatValue());
                    continue;
                }
                if (LENIENT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    lenient = parser.booleanValue();
                    continue;
                }
                if (ZERO_TERMS_QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    String zeroTermsValue = parser.text();
                    if ("none".equalsIgnoreCase(zeroTermsValue)) {
                        zeroTermsQuery = MatchQuery.ZeroTermsQuery.NONE;
                        continue;
                    }
                    if ("all".equalsIgnoreCase(zeroTermsValue)) {
                        zeroTermsQuery = MatchQuery.ZeroTermsQuery.ALL;
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "Unsupported zero_terms_query value [" + zeroTermsValue + "]", new Object[0]);
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                if (GENERATE_SYNONYMS_PHRASE_QUERY.match(currentFieldName, parser.getDeprecationHandler())) {
                    autoGenerateSynonymsPhraseQuery = parser.booleanValue();
                    continue;
                }
                if (FUZZY_TRANSPOSITIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fuzzyTranspositions = parser.booleanValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[multi_match] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[multi_match] unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (value == null) {
            throw new ParsingException(parser.getTokenLocation(), "No text specified for multi_match query", new Object[0]);
        }
        if (fuzziness != null && (type == Type.CROSS_FIELDS || type == Type.PHRASE || type == Type.PHRASE_PREFIX)) {
            throw new ParsingException(parser.getTokenLocation(), "Fuzziness not allowed for type [" + type.parseField.getPreferredName() + "]", new Object[0]);
        }
        if (slop != 0 && type == Type.BOOL_PREFIX) {
            throw new ParsingException(parser.getTokenLocation(), "[" + SLOP_FIELD.getPreferredName() + "] not allowed for type [" + type.parseField.getPreferredName() + "]", new Object[0]);
        }
        if (cutoffFrequency != null && type == Type.BOOL_PREFIX) {
            throw new ParsingException(parser.getTokenLocation(), "[" + CUTOFF_FREQUENCY_FIELD.getPreferredName() + "] not allowed for type [" + type.parseField.getPreferredName() + "]", new Object[0]);
        }
        MultiMatchQueryBuilder builder = ((MultiMatchQueryBuilder)((MultiMatchQueryBuilder)new MultiMatchQueryBuilder(value, new String[0]).fields(fieldsBoosts).type(type).analyzer(analyzer).cutoffFrequency(cutoffFrequency).fuzziness(fuzziness).fuzzyRewrite(fuzzyRewrite).maxExpansions(maxExpansions).minimumShouldMatch(minimumShouldMatch).operator(operator).prefixLength(prefixLength).slop(slop).tieBreaker(tieBreaker).zeroTermsQuery(zeroTermsQuery).autoGenerateSynonymsPhraseQuery(autoGenerateSynonymsPhraseQuery).boost(boost)).queryName(queryName)).fuzzyTranspositions(fuzzyTranspositions);
        if (lenient != null) {
            builder.lenient(lenient);
        }
        return builder;
    }

    private static void parseFieldAndBoost(XContentParser parser, Map<String, Float> fieldsBoosts) throws IOException {
        String fField = null;
        Float fBoost = Float.valueOf(1.0f);
        char[] fieldText = parser.textCharacters();
        int end = parser.textOffset() + parser.textLength();
        for (int i = parser.textOffset(); i < end; ++i) {
            if (fieldText[i] != '^') continue;
            int relativeLocation = i - parser.textOffset();
            fField = new String(fieldText, parser.textOffset(), relativeLocation);
            fBoost = Float.valueOf(Float.parseFloat(new String(fieldText, i + 1, parser.textLength() - relativeLocation - 1)));
            break;
        }
        if (fField == null) {
            fField = parser.text();
        }
        fieldsBoosts.put(fField, fBoost);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        boolean isAllField;
        Map<String, Float> newFieldsBoosts;
        MultiMatchQuery multiMatchQuery = new MultiMatchQuery(context);
        if (this.analyzer != null) {
            if (context.getIndexAnalyzers().get(this.analyzer) == null) {
                throw new QueryShardException(context, "[multi_match] analyzer [" + this.analyzer + "] not found", new Object[0]);
            }
            multiMatchQuery.setAnalyzer(this.analyzer);
        }
        multiMatchQuery.setPhraseSlop(this.slop);
        if (this.fuzziness != null) {
            multiMatchQuery.setFuzziness(this.fuzziness);
        }
        multiMatchQuery.setFuzzyPrefixLength(this.prefixLength);
        multiMatchQuery.setMaxExpansions(this.maxExpansions);
        multiMatchQuery.setOccur(this.operator.toBooleanClauseOccur());
        if (this.fuzzyRewrite != null) {
            multiMatchQuery.setFuzzyRewriteMethod(QueryParsers.parseRewriteMethod(this.fuzzyRewrite, null, LoggingDeprecationHandler.INSTANCE));
        }
        if (this.tieBreaker != null) {
            multiMatchQuery.setTieBreaker(this.tieBreaker.floatValue());
        }
        if (this.cutoffFrequency != null) {
            multiMatchQuery.setCommonTermsCutoff(this.cutoffFrequency);
        }
        if (this.lenient != null) {
            multiMatchQuery.setLenient(this.lenient);
        }
        multiMatchQuery.setZeroTermsQuery(this.zeroTermsQuery);
        multiMatchQuery.setAutoGenerateSynonymsPhraseQuery(this.autoGenerateSynonymsPhraseQuery);
        multiMatchQuery.setTranspositions(this.fuzzyTranspositions);
        if (this.fieldsBoosts.isEmpty()) {
            List<String> defaultFields = context.defaultFields();
            newFieldsBoosts = QueryParserHelper.resolveMappingFields(context, QueryParserHelper.parseFieldsAndWeights(defaultFields));
            isAllField = QueryParserHelper.hasAllFieldsWildcard(defaultFields);
        } else {
            newFieldsBoosts = QueryParserHelper.resolveMappingFields(context, this.fieldsBoosts);
            isAllField = QueryParserHelper.hasAllFieldsWildcard(this.fieldsBoosts.keySet());
        }
        if (isAllField && this.lenient == null) {
            multiMatchQuery.setLenient(true);
        }
        return multiMatchQuery.parse(this.type, newFieldsBoosts, this.value, this.minimumShouldMatch);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.value, this.fieldsBoosts, this.type, this.operator, this.analyzer, this.slop, this.fuzziness, this.prefixLength, this.maxExpansions, this.minimumShouldMatch, this.fuzzyRewrite, this.tieBreaker, this.lenient, this.cutoffFrequency, this.zeroTermsQuery, this.autoGenerateSynonymsPhraseQuery, this.fuzzyTranspositions);
    }

    @Override
    protected boolean doEquals(MultiMatchQueryBuilder other) {
        return Objects.equals(this.value, other.value) && Objects.equals(this.fieldsBoosts, other.fieldsBoosts) && Objects.equals(this.type, other.type) && Objects.equals(this.operator, other.operator) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.slop, other.slop) && Objects.equals(this.fuzziness, other.fuzziness) && Objects.equals(this.prefixLength, other.prefixLength) && Objects.equals(this.maxExpansions, other.maxExpansions) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.fuzzyRewrite, other.fuzzyRewrite) && Objects.equals(this.tieBreaker, other.tieBreaker) && Objects.equals(this.lenient, other.lenient) && Objects.equals(this.cutoffFrequency, other.cutoffFrequency) && Objects.equals(this.zeroTermsQuery, other.zeroTermsQuery) && Objects.equals(this.autoGenerateSynonymsPhraseQuery, other.autoGenerateSynonymsPhraseQuery) && Objects.equals(this.fuzzyTranspositions, other.fuzzyTranspositions);
    }

    public static enum Type implements Writeable
    {
        BEST_FIELDS(MatchQuery.Type.BOOLEAN, 0.0f, new ParseField("best_fields", new String[]{"boolean"})),
        MOST_FIELDS(MatchQuery.Type.BOOLEAN, 1.0f, new ParseField("most_fields", new String[0])),
        CROSS_FIELDS(MatchQuery.Type.BOOLEAN, 0.0f, new ParseField("cross_fields", new String[0])),
        PHRASE(MatchQuery.Type.PHRASE, 0.0f, new ParseField("phrase", new String[0])),
        PHRASE_PREFIX(MatchQuery.Type.PHRASE_PREFIX, 0.0f, new ParseField("phrase_prefix", new String[0])),
        BOOL_PREFIX(MatchQuery.Type.BOOLEAN_PREFIX, 1.0f, new ParseField("bool_prefix", new String[0]));

        private MatchQuery.Type matchQueryType;
        private final float tieBreaker;
        private final ParseField parseField;

        private Type(MatchQuery.Type matchQueryType, float tieBreaker, ParseField parseField) {
            this.matchQueryType = matchQueryType;
            this.tieBreaker = tieBreaker;
            this.parseField = parseField;
        }

        public float tieBreaker() {
            return this.tieBreaker;
        }

        public MatchQuery.Type matchQueryType() {
            return this.matchQueryType;
        }

        public ParseField parseField() {
            return this.parseField;
        }

        public static Type parse(String value, DeprecationHandler deprecationHandler) {
            Type[] values = Type.values();
            Type type = null;
            for (Type t : values) {
                if (!t.parseField().match(value, deprecationHandler)) continue;
                type = t;
                break;
            }
            if (type == null) {
                throw new OpenSearchParseException("failed to parse [{}] query type [{}]. unknown type.", MultiMatchQueryBuilder.NAME, value);
            }
            return type;
        }

        public static Type readFromStream(StreamInput in) throws IOException {
            return Type.values()[in.readVInt()];
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal());
        }
    }
}

