/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.configuration;

import java.io.IOException;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.cluster.configuration.ClearVotingConfigExclusionsRequest;
import org.opensearch.action.admin.cluster.configuration.ClearVotingConfigExclusionsResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateObserver;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.coordination.CoordinationMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Priority;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportClearVotingConfigExclusionsAction
extends TransportClusterManagerNodeAction<ClearVotingConfigExclusionsRequest, ClearVotingConfigExclusionsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportClearVotingConfigExclusionsAction.class);

    @Inject
    public TransportClearVotingConfigExclusionsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/voting_config/clear_exclusions", transportService, clusterService, threadPool, actionFilters, ClearVotingConfigExclusionsRequest::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClearVotingConfigExclusionsResponse read(StreamInput in) throws IOException {
        return new ClearVotingConfigExclusionsResponse(in);
    }

    @Override
    protected void clusterManagerOperation(final ClearVotingConfigExclusionsRequest request, final ClusterState initialState, final ActionListener<ClearVotingConfigExclusionsResponse> listener) throws Exception {
        final long startTimeMillis = this.threadPool.relativeTimeInMillis();
        Predicate<ClusterState> allExclusionsRemoved = newState -> {
            for (CoordinationMetadata.VotingConfigExclusion tombstone : initialState.getVotingConfigExclusions()) {
                if (!newState.nodes().nodeExists(tombstone.getNodeId())) continue;
                return false;
            }
            return true;
        };
        if (request.getWaitForRemoval() && !allExclusionsRemoved.test(initialState)) {
            ClusterStateObserver clusterStateObserver = new ClusterStateObserver(initialState, this.clusterService, request.getTimeout(), logger, this.threadPool.getThreadContext());
            clusterStateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                @Override
                public void onNewClusterState(ClusterState state) {
                    TransportClearVotingConfigExclusionsAction.this.submitClearVotingConfigExclusionsTask(request, startTimeMillis, listener);
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new OpenSearchException("cluster service closed while waiting for removal of nodes " + initialState.getVotingConfigExclusions(), new Object[0]));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    listener.onFailure(new OpenSearchTimeoutException("timed out waiting for removal of nodes; if nodes should not be removed, set waitForRemoval to false. " + initialState.getVotingConfigExclusions(), new Object[0]));
                }
            }, allExclusionsRemoved);
        } else {
            this.submitClearVotingConfigExclusionsTask(request, startTimeMillis, listener);
        }
    }

    private void submitClearVotingConfigExclusionsTask(final ClearVotingConfigExclusionsRequest request, final long startTimeMillis, final ActionListener<ClearVotingConfigExclusionsResponse> listener) {
        this.clusterService.submitStateUpdateTask("clear-voting-config-exclusions", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public ClusterState execute(ClusterState currentState) {
                CoordinationMetadata newCoordinationMetadata = CoordinationMetadata.builder(currentState.coordinationMetadata()).clearVotingConfigExclusions().build();
                Metadata newMetadata = Metadata.builder(currentState.metadata()).coordinationMetadata(newCoordinationMetadata).build();
                return ClusterState.builder(currentState).metadata(newMetadata).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public TimeValue timeout() {
                return TimeValue.timeValueMillis((long)(request.getTimeout().millis() + startTimeMillis - TransportClearVotingConfigExclusionsAction.this.threadPool.relativeTimeInMillis()));
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new ClearVotingConfigExclusionsResponse());
            }
        });
    }

    @Override
    protected ClusterBlockException checkBlock(ClearVotingConfigExclusionsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

