/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.MergePolicy;

public class OneMergeHelper {
    private OneMergeHelper() {
    }

    public static String getSegmentName(MergePolicy.OneMerge merge) {
        return merge.info != null ? merge.info.info.name : "_na_";
    }

    public static double getMbPerSec(Thread thread, MergePolicy.OneMerge merge) {
        if (thread instanceof ConcurrentMergeScheduler.MergeThread) {
            return ((ConcurrentMergeScheduler.MergeThread)thread).rateLimiter.getMBPerSec();
        }
        assert (false) : "this is not merge thread";
        return Double.POSITIVE_INFINITY;
    }

    public static long getTotalBytesWritten(Thread thread, MergePolicy.OneMerge merge) throws IOException {
        if (thread instanceof ConcurrentMergeScheduler.MergeThread) {
            return ((ConcurrentMergeScheduler.MergeThread)thread).rateLimiter.getTotalBytesWritten();
        }
        assert (false) : "this is not merge thread";
        return merge.totalBytesSize();
    }
}

