/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javafx.animation.PauseTransition;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.util.Duration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import jiconfont.icons.font_awesome.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.FilmResolution;
import mediathek.daten.ListePset;
import mediathek.daten.abo.DatenAbo;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.daten.blacklist.ListeBlacklist;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.gui.TabPaneIndex;
import mediathek.gui.actions.ShowBlacklistDialogAction;
import mediathek.gui.actions.ShowFilmInformationAction;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.gui.dialog.DialogAboNoSet;
import mediathek.gui.dialog.DialogAddDownload;
import mediathek.gui.dialog.DialogAddMoreDownload;
import mediathek.gui.dialog.DialogEditAbo;
import mediathek.gui.filmInformation.InfoDialog;
import mediathek.gui.messages.AboListChangedEvent;
import mediathek.gui.messages.BaseEvent;
import mediathek.gui.messages.BlacklistChangedEvent;
import mediathek.gui.messages.ButtonStartEvent;
import mediathek.gui.messages.ButtonsPanelVisibilityChangedEvent;
import mediathek.gui.messages.DownloadListChangedEvent;
import mediathek.gui.messages.StartEvent;
import mediathek.gui.messages.TableModelChangeEvent;
import mediathek.gui.messages.UpdateStatusBarLeftDisplayEvent;
import mediathek.gui.messages.history.DownloadHistoryChangedEvent;
import mediathek.gui.tabs.AGuiTabPanel;
import mediathek.gui.tabs.tab_film.GuiFilmeModelHelper;
import mediathek.gui.tabs.tab_film.JDownloadHelper;
import mediathek.gui.tabs.tab_film.OnlineSearchProviders;
import mediathek.javafx.bookmark.BookmarkWindowController;
import mediathek.javafx.buttonsPanel.ButtonsPanelController;
import mediathek.javafx.descriptionPanel.DescriptionPanelController;
import mediathek.javafx.filmtab.FilmTabInfoPane;
import mediathek.javafx.filterpanel.FilmActionPanel;
import mediathek.javafx.tool.JavaFxUtils;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MessageBus;
import mediathek.tool.NoSelectionErrorDialog;
import mediathek.tool.cellrenderer.CellRendererFilme;
import mediathek.tool.datum.DatumFilm;
import mediathek.tool.listener.BeobTableHeader;
import mediathek.tool.models.TModelFilm;
import mediathek.tool.table.MVFilmTable;
import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.listener.Handler;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.VerticalLayout;
import org.jetbrains.annotations.NotNull;

public class GuiFilme
extends AGuiTabPanel {
    public static final String NAME = "Filme";
    private static final String ACTION_MAP_KEY_PLAY_FILM = "film_abspielen";
    private static final String ACTION_MAP_KEY_SAVE_FILM = "download_film";
    private static final String ACTION_MAP_KEY_BOOKMARK_FILM = "bookmark_film";
    private static final String ACTION_MAP_KEY_COPY_NORMAL_URL = "copy_url";
    private static final String ACTION_MAP_KEY_COPY_HD_URL = "copy_url_hd";
    private static final String ACTION_MAP_KEY_COPY_KLEIN_URL = "copy_url_klein";
    private static final String ACTION_MAP_KEY_MARK_SEEN = "seen";
    private static final String ACTION_MAP_KEY_MARK_UNSEEN = "unseen";
    private static final int[] HIDDEN_COLUMNS = new int[]{4, 5, 6};
    private static final Logger logger = LogManager.getLogger(GuiFilme.class);
    private static final int[] BUTTON_COLUMNS = new int[]{4, 5, 6};
    public static boolean[] VISIBLE_COLUMNS = new boolean[17];
    public final PlayFilmAction playAction = new PlayFilmAction();
    public final SaveFilmAction saveFilmAction = new SaveFilmAction();
    public final BookmarkFilmAction bookmarkFilmAction = new BookmarkFilmAction();
    public final BookmarkManageListAction bookmarkManageListAction = new BookmarkManageListAction();
    private final AGuiTabPanel.MarkFilmAsSeenAction markFilmAsSeenAction = new AGuiTabPanel.MarkFilmAsSeenAction();
    private final AGuiTabPanel.MarkFilmAsUnseenAction markFilmAsUnseenAction = new AGuiTabPanel.MarkFilmAsUnseenAction();
    private final JScrollPane filmListScrollPane = new JScrollPane();
    private final JPanel extensionArea = new JPanel();
    private final JCheckBoxMenuItem cbkShowDescription = new JCheckBoxMenuItem("Beschreibung anzeigen");
    private final JFXPanel fxDescriptionPanel = new JFXPanel();
    private final JFXPanel fxPsetButtonsPanel = new JFXPanel();
    private final SeenHistoryController historyController = new SeenHistoryController();
    public FilmActionPanel filmActionPanel;
    private Optional<BookmarkWindowController> bookmarkWindowController = Optional.empty();
    private JFXPanel fxFilmActionPanel;
    private boolean stopBeob;
    private FilmTabInfoPane filmInfoLabel;
    private JCheckBoxMenuItem cbShowButtons;
    private ButtonsPanelController psetController;
    private MVFilmTable tabelle;
    protected PauseTransition reloadTableDataTransition = new PauseTransition(Duration.millis(250.0));
    private ListenableFuture<TableModel> modelFuture;

    public GuiFilme(Daten aDaten, MediathekGui mediathekGui) {
        this.daten = aDaten;
        this.mediathekGui = mediathekGui;
        this.setLayout(new BorderLayout());
        this.createFilmListArea();
        this.createExtensionArea();
        this.createFilmActionPanel();
        this.extensionArea.add(this.fxDescriptionPanel);
        this.extensionArea.add(this.fxPsetButtonsPanel);
        this.setupFilmListTable();
        this.installTabInfoStatusBarControl();
        this.setupFilmSelectionPropertyListener(mediathekGui);
        this.setupDescriptionPanel();
        this.setupPsetButtonsPanel();
        this.setupFilmActionPanel();
        this.start_init();
        MessageBus.getMessageBus().subscribe(this);
        this.setupActionListeners();
    }

    @Override
    public void tabelleSpeichern() {
        if (this.tabelle != null) {
            this.tabelle.writeTableConfigurationData();
        }
    }

    private void setupFilmListTable() {
        this.tabelle = new MVFilmTable();
        this.filmListScrollPane.setViewportView(this.tabelle);
    }

    private void createFilmActionPanel() {
        this.fxFilmActionPanel = new JFXPanel();
        this.add((Component)this.fxFilmActionPanel, "North");
    }

    private void setupFilmSelectionPropertyListener(final MediathekGui mediathekGui) {
        this.tabelle.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                int sel = this.tabelle.getSelectedRowCount();
                Platform.runLater(() -> mediathekGui.getSelectedItemsProperty().setValue(sel));
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                int sel = GuiFilme.this.tabelle.getSelectedRowCount();
                Platform.runLater(() -> mediathekGui.getSelectedItemsProperty().setValue(sel));
                GuiFilme.this.onComponentShown();
            }
        });
    }

    @Override
    protected void installTabInfoStatusBarControl() {
        final ObservableList<Node> leftItems = this.mediathekGui.getStatusBarController().getStatusBar().getLeftItems();
        Platform.runLater(() -> {
            this.filmInfoLabel = new FilmTabInfoPane(this.daten, this);
            if (this.isVisible()) {
                leftItems.add(this.filmInfoLabel);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                Platform.runLater(() -> {
                    GuiFilme.this.filmInfoLabel.setVisible(true);
                    leftItems.add(GuiFilme.this.filmInfoLabel);
                });
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Platform.runLater(() -> {
                    GuiFilme.this.filmInfoLabel.setVisible(false);
                    leftItems.remove(GuiFilme.this.filmInfoLabel);
                });
            }
        });
    }

    private void createFilmListArea() {
        this.add((Component)this.filmListScrollPane, "Center");
    }

    private void createExtensionArea() {
        this.extensionArea.setLayout(new VerticalLayout());
        this.add((Component)this.extensionArea, "South");
    }

    @Handler
    private void handleButtonsPanelVisibilityChanged(ButtonsPanelVisibilityChangedEvent evt) {
        SwingUtilities.invokeLater(() -> this.cbShowButtons.setSelected(evt.visible));
        SwingUtilities.invokeLater(() -> this.fxPsetButtonsPanel.setVisible(evt.visible));
    }

    public void installViewMenuEntry(JMenu jMenuAnsicht) {
        this.cbShowButtons = new JCheckBoxMenuItem("Buttons anzeigen");
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.cbShowButtons.setAccelerator(KeyStroke.getKeyStroke(122, 0));
        }
        this.cbShowButtons.setSelected(ApplicationConfiguration.getConfiguration().getBoolean("application.buttons_panel.visible", false));
        this.cbShowButtons.addActionListener(e -> MessageBus.getMessageBus().publishAsync(new ButtonsPanelVisibilityChangedEvent(this.cbShowButtons.isSelected())));
        jMenuAnsicht.add((Component)this.cbShowButtons, 0);
    }

    @Override
    public void installMenuEntries(JMenu menu) {
        JMenuItem miPlayFilm = new JMenuItem("Film abspielen");
        if (SystemUtils.IS_OS_MAC_OSX) {
            miPlayFilm.setAccelerator(KeyStroke.getKeyStroke(117, 256));
        } else {
            miPlayFilm.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        }
        miPlayFilm.setIcon(IconFontSwing.buildIcon(FontAwesome.PLAY, 16.0f));
        miPlayFilm.addActionListener(this.playAction);
        JMenuItem miRecordFilm = new JMenuItem("Film aufzeichnen");
        if (SystemUtils.IS_OS_MAC_OSX) {
            miRecordFilm.setAccelerator(KeyStroke.getKeyStroke(118, 256));
        } else {
            miRecordFilm.setAccelerator(KeyStroke.getKeyStroke(68, 128));
        }
        miRecordFilm.setIcon(IconFontSwing.buildIcon(FontAwesome.DOWNLOAD, 16.0f));
        miRecordFilm.addActionListener(this.saveFilmAction);
        JMenuItem miBookmarkFilm = new JMenuItem("Film merken");
        if (SystemUtils.IS_OS_MAC_OSX) {
            miBookmarkFilm.setAccelerator(KeyStroke.getKeyStroke(119, 256));
        } else {
            miBookmarkFilm.setAccelerator(KeyStroke.getKeyStroke(66, 128));
        }
        miBookmarkFilm.setIcon(IconFontSwing.buildIcon(FontAwesome.BOOKMARK_O, 16.0f));
        miBookmarkFilm.addActionListener(this.bookmarkFilmAction);
        JMenuItem miOpenBlacklist = new JMenuItem("Blacklist \u00f6ffnen");
        if (SystemUtils.IS_OS_MAC_OSX) {
            miOpenBlacklist.setAccelerator(KeyStroke.getKeyStroke(120, 256));
        } else {
            miOpenBlacklist.setAccelerator(KeyStroke.getKeyStroke(66, 128));
        }
        miOpenBlacklist.setAction(new ShowBlacklistDialogAction(this.mediathekGui, this.daten));
        if (!SystemUtils.IS_OS_MAC_OSX) {
            this.cbkShowDescription.setAccelerator(KeyStroke.getKeyStroke(121, 0));
        }
        JMenuItem miMarkFilmAsSeen = new JMenuItem("Filme als gesehen markieren");
        miMarkFilmAsSeen.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        miMarkFilmAsSeen.addActionListener(this.markFilmAsSeenAction);
        JMenuItem miMarkFilmAsUnseen = new JMenuItem("Filme als ungesehen markieren");
        miMarkFilmAsUnseen.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        miMarkFilmAsUnseen.addActionListener(this.markFilmAsUnseenAction);
        menu.add(miPlayFilm);
        menu.add(miRecordFilm);
        menu.add(miBookmarkFilm);
        menu.addSeparator();
        menu.add(miMarkFilmAsSeen);
        menu.add(miMarkFilmAsUnseen);
        menu.addSeparator();
        menu.add(miOpenBlacklist);
        menu.addSeparator();
        menu.add(this.cbkShowDescription);
    }

    private void setupFilmActionPanel() {
        this.filmActionPanel = new FilmActionPanel(this.reloadTableDataTransition);
        JavaFxUtils.invokeInFxThreadAndWait(() -> this.fxFilmActionPanel.setScene(this.filmActionPanel.getFilmActionPanelScene()));
    }

    private void setupPsetButtonsPanel() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            try {
                this.psetController = ButtonsPanelController.install(this.fxPsetButtonsPanel, this);
                this.psetController.setOnCloseRequest(e -> {
                    MessageBus.getMessageBus().publishAsync(new ButtonsPanelVisibilityChangedEvent(false));
                    e.consume();
                });
                this.psetController.setupButtonLayout();
            }
            catch (Exception ex) {
                logger.error("setupPsetButtonsPanel", (Throwable)ex);
            }
        });
        final Configuration config = ApplicationConfiguration.getConfiguration();
        SwingUtilities.invokeLater(() -> this.fxPsetButtonsPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                config.setProperty("application.buttons_panel.visible", true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                config.setProperty("application.buttons_panel.visible", false);
            }
        }));
        boolean visible = config.getBoolean("application.buttons_panel.visible", false);
        this.fxPsetButtonsPanel.setVisible(visible);
    }

    private void setupDescriptionPanel() {
        JavaFxUtils.invokeInFxThreadAndWait(() -> {
            try {
                DescriptionPanelController descriptionPanelController = DescriptionPanelController.install(this.fxDescriptionPanel);
                SwingUtilities.invokeLater(() -> this.tabelle.getSelectionModel().addListSelectionListener(e -> {
                    Optional<DatenFilm> optFilm = this.getCurrentlySelectedFilm();
                    Platform.runLater(() -> descriptionPanelController.showFilmDescription(optFilm));
                }));
            }
            catch (Exception ex) {
                logger.error("setupDescriptionPanel", (Throwable)ex);
            }
        });
    }

    private void showDescriptionPanel() {
        this.fxDescriptionPanel.setVisible(ApplicationConfiguration.getConfiguration().getBoolean("film.show_description", true));
    }

    private void onComponentShown() {
        this.mediathekGui.tabPaneIndexProperty().setValue(TabPaneIndex.FILME);
        this.updateFilmData();
        this.setInfoStatusbar();
    }

    public int getTableRowCount() {
        if (this.tabelle != null) {
            return this.tabelle.getModel().getRowCount();
        }
        return 0;
    }

    private void setupKeyMapping() {
        InputMap focusedWindowMap = this.tabelle.getInputMap();
        focusedWindowMap.put(KeyStroke.getKeyStroke(80, 0), ACTION_MAP_KEY_PLAY_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(10, 0), ACTION_MAP_KEY_PLAY_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(68, 0), ACTION_MAP_KEY_SAVE_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(66, 0), ACTION_MAP_KEY_BOOKMARK_FILM);
        focusedWindowMap.put(KeyStroke.getKeyStroke(72, 0), ACTION_MAP_KEY_COPY_HD_URL);
        focusedWindowMap.put(KeyStroke.getKeyStroke(78, 0), ACTION_MAP_KEY_COPY_NORMAL_URL);
        focusedWindowMap.put(KeyStroke.getKeyStroke(75, 0), ACTION_MAP_KEY_COPY_KLEIN_URL);
        focusedWindowMap.put(KeyStroke.getKeyStroke(71, 0), ACTION_MAP_KEY_MARK_SEEN);
        focusedWindowMap.put(KeyStroke.getKeyStroke(85, 0), ACTION_MAP_KEY_MARK_UNSEEN);
        ActionMap actionMap = this.tabelle.getActionMap();
        actionMap.put(ACTION_MAP_KEY_PLAY_FILM, this.playAction);
        actionMap.put(ACTION_MAP_KEY_SAVE_FILM, this.saveFilmAction);
        actionMap.put(ACTION_MAP_KEY_BOOKMARK_FILM, this.bookmarkFilmAction);
        actionMap.put(ACTION_MAP_KEY_COPY_NORMAL_URL, new CopyUrlToClipboardAction(FilmResolution.Enum.NORMAL));
        actionMap.put(ACTION_MAP_KEY_COPY_HD_URL, new CopyUrlToClipboardAction(FilmResolution.Enum.HIGH_QUALITY));
        actionMap.put(ACTION_MAP_KEY_COPY_KLEIN_URL, new CopyUrlToClipboardAction(FilmResolution.Enum.LOW));
        actionMap.put(ACTION_MAP_KEY_MARK_SEEN, this.markFilmAsSeenAction);
        actionMap.put(ACTION_MAP_KEY_MARK_UNSEEN, this.markFilmAsUnseenAction);
    }

    private void setupCellRenderer() {
        CellRendererFilme cellRenderer = new CellRendererFilme();
        this.tabelle.setDefaultRenderer(Object.class, cellRenderer);
        this.tabelle.setDefaultRenderer(DatumFilm.class, cellRenderer);
        this.tabelle.setDefaultRenderer(Integer.class, cellRenderer);
    }

    private void start_init() {
        this.showDescriptionPanel();
        this.daten.getFilmeLaden().addAdListener(new ListenerFilmeLaden(){

            @Override
            public void fertig(ListenerFilmeLadenEvent event) {
                Platform.runLater(() -> GuiFilme.this.filmActionPanel.updateThemaBox());
            }
        });
        this.setupKeyMapping();
        this.tabelle.setModel(new TModelFilm());
        this.tabelle.addMouseListener(new TableContextMenuHandler());
        this.tabelle.getSelectionModel().addListSelectionListener(event -> {
            ListSelectionModel m3 = (ListSelectionModel)event.getSource();
            if (!(m3.isSelectionEmpty() || m3.getValueIsAdjusting() || this.stopBeob)) {
                this.updateFilmData();
            }
        });
        this.setupCellRenderer();
        this.tabelle.setLineBreak(MVConfig.getBool(MVConfig.Configs.SYSTEM_TAB_FILME_LINEBREAK));
        this.setupHeaderPopupMenu();
        this.tabelle.readColumnConfigurationData();
        if (this.tabelle.getRowCount() > 0) {
            this.tabelle.setRowSelectionInterval(0, 0);
        }
    }

    private void setupHeaderPopupMenu() {
        BeobTableHeader headerListener = new BeobTableHeader(this.tabelle, VISIBLE_COLUMNS, HIDDEN_COLUMNS, BUTTON_COLUMNS, true, MVConfig.Configs.SYSTEM_TAB_FILME_LINEBREAK);
        headerListener.setFontSizeChangeCapable(SystemUtils.IS_OS_LINUX);
        this.tabelle.getTableHeader().addMouseListener(headerListener);
    }

    @Handler
    private void handleDownloadHistoryChangedEvent(DownloadHistoryChangedEvent e) {
        SwingUtilities.invokeLater(() -> {
            if (this.filmActionPanel.showUnseenOnly.getValue().booleanValue()) {
                Platform.runLater(() -> this.reloadTableDataTransition.playFromStart());
            } else {
                this.tabelle.fireTableDataChanged(true);
            }
        });
    }

    @Handler
    private void handleButtonStart(ButtonStartEvent e) {
        SwingUtilities.invokeLater(() -> {
            this.tabelle.fireTableDataChanged(true);
            this.setInfoStatusbar();
        });
    }

    @Handler
    private void handleAboListChanged(AboListChangedEvent e) {
        Platform.runLater(() -> this.reloadTableDataTransition.playFromStart());
    }

    @Handler
    private void handleBlacklistChangedEvent(BlacklistChangedEvent e) {
        Platform.runLater(() -> this.reloadTableDataTransition.playFromStart());
    }

    @Handler
    private void handleStartEvent(StartEvent msg) {
        SwingUtilities.invokeLater(this::setInfoStatusbar);
    }

    private synchronized void saveFilm(DatenPset pSet) {
        if (Daten.listePset.getListeSpeichern().isEmpty()) {
            new DialogAboNoSet(this.mediathekGui).setVisible(true);
            return;
        }
        List<DatenFilm> liste = this.getSelFilme();
        boolean standard = false;
        String pfad = "";
        boolean info = false;
        boolean subtitle = false;
        if (liste.size() > 1) {
            if (pSet == null) {
                pSet = (DatenPset)Daten.listePset.getListeSpeichern().get(0);
            }
            DialogAddMoreDownload damd = new DialogAddMoreDownload(this.mediathekGui, pSet);
            damd.setVisible(true);
            standard = damd.addAll;
            pfad = damd.getPath();
            info = damd.info;
            subtitle = damd.subtitle;
            if (damd.cancel) {
                return;
            }
        }
        for (DatenFilm datenFilm : liste) {
            int ret;
            DatenDownload datenDownload = this.daten.getListeDownloads().getDownloadUrlFilm(datenFilm.getUrlNormalQuality());
            if (datenDownload != null && (ret = JOptionPane.showConfirmDialog(this.mediathekGui, "Download f\u00fcr den Film existiert bereits.\nNochmal anlegen?", "Anlegen?", 0)) != 0) continue;
            if (standard) {
                if (pSet == null) {
                    pSet = (DatenPset)Daten.listePset.getListeSpeichern().get(0);
                }
                datenDownload = new DatenDownload(pSet, datenFilm, 2, null, "", pfad, "");
                datenDownload.arr[35] = Boolean.toString(info);
                datenDownload.arr[37] = Boolean.toString(subtitle);
                this.daten.getListeDownloads().addMitNummer(datenDownload);
                MessageBus.getMessageBus().publishAsync(new DownloadListChangedEvent());
                if (!Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN))) continue;
                datenDownload.startDownload();
                continue;
            }
            this.saveFilm(datenFilm, pSet);
        }
    }

    private void saveFilm(DatenFilm datenFilm, DatenPset pSet) {
        if (Daten.listePset.getListeSpeichern().isEmpty()) {
            MVMessageDialog.showMessageDialog(this, "Ohne Programm-Sets k\u00f6nnen keine Downloads gestartet werden.", "MediathekView", 0);
        } else {
            Optional<FilmResolution.Enum> res = this.filmActionPanel.showOnlyHd.getValue() != false ? Optional.of(FilmResolution.Enum.HIGH_QUALITY) : Optional.empty();
            DialogAddDownload dialog = new DialogAddDownload((Frame)this.mediathekGui, datenFilm, pSet, res);
            dialog.setVisible(true);
        }
    }

    private synchronized void bookmarkFilm() {
        List<DatenFilm> movies = this.getSelFilme();
        long size = movies.size();
        if (size > 250L) {
            JavaFxUtils.invokeInFxThreadAndWait(() -> {
                ButtonType yes = new ButtonType("Ja", ButtonBar.ButtonData.YES);
                ButtonType no = new ButtonType("Nein", ButtonBar.ButtonData.NO);
                Alert alert = new Alert(Alert.AlertType.WARNING, String.format("M\u00f6chten Sie wirklich %d Eintr\u00e4ge bearbeiten?%nDas Programm k\u00f6nnte w\u00e4hrend der Operation nicht reagieren.", size), yes, no);
                alert.setTitle("Merkliste");
                alert.showAndWait().filter(r -> r == yes).ifPresent(response -> SwingUtilities.invokeLater(() -> {
                    this.daten.getListeBookmarkList().checkAndBookmarkMovies(movies);
                    this.repaint();
                }));
            });
        } else {
            this.daten.getListeBookmarkList().checkAndBookmarkMovies(movies);
            this.repaint();
        }
    }

    public void showBookmarkWindow() {
        if (this.bookmarkWindowController.isEmpty()) {
            this.bookmarkWindowController = Optional.of(new BookmarkWindowController());
            this.bookmarkWindowController.get().setPartner(this);
        }
        this.bookmarkWindowController.get().show();
    }

    public void playerStarten(DatenPset pSet) {
        if (this.tabelle.getSelectedRow() == -1) {
            NoSelectionErrorDialog.show();
        } else if (pSet.istSpeichern()) {
            this.saveFilm(pSet);
        } else {
            String aufloesung = this.filmActionPanel.showOnlyHd.getValue() != false ? FilmResolution.Enum.HIGH_QUALITY.toString() : "";
            Optional<DatenFilm> filmSelection = this.getCurrentlySelectedFilm();
            filmSelection.ifPresent(film -> this.daten.getStarterClass().urlMitProgrammStarten(pSet, (DatenFilm)film, aufloesung));
        }
    }

    public void saveSettings() {
        this.bookmarkWindowController.ifPresent(BookmarkWindowController::saveSettings);
    }

    private Optional<DatenFilm> getFilm(int zeileTabelle) {
        if (zeileTabelle >= 0 && zeileTabelle < this.tabelle.getRowCount()) {
            return Optional.of((DatenFilm)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(zeileTabelle), 16));
        }
        return Optional.empty();
    }

    @Override
    protected Optional<DatenFilm> getCurrentlySelectedFilm() {
        int selectedTableRow = this.tabelle.getSelectedRow();
        if (selectedTableRow != -1) {
            int modelIndex = this.tabelle.convertRowIndexToModel(selectedTableRow);
            return Optional.of((DatenFilm)this.tabelle.getModel().getValueAt(modelIndex, 16));
        }
        return Optional.empty();
    }

    @Override
    protected List<DatenFilm> getSelFilme() {
        ArrayList<DatenFilm> arrayFilme = new ArrayList<DatenFilm>();
        int[] rows = this.tabelle.getSelectedRows();
        if (rows.length > 0) {
            for (int row : rows) {
                DatenFilm datenFilm = (DatenFilm)this.tabelle.getModel().getValueAt(this.tabelle.convertRowIndexToModel(row), 16);
                arrayFilme.add(datenFilm);
            }
        } else {
            NoSelectionErrorDialog.show();
        }
        return arrayFilme;
    }

    private void updateFilmData() {
        InfoDialog infoDialog = this.mediathekGui.getFilmInfoDialog();
        if (infoDialog != null) {
            Optional<DatenFilm> filmSelection = this.getCurrentlySelectedFilm();
            filmSelection.ifPresent(this.mediathekGui.getFilmInfoDialog()::updateCurrentFilm);
        }
    }

    private void setInfoStatusbar() {
        MessageBus.getMessageBus().publishAsync(new UpdateStatusBarLeftDisplayEvent());
    }

    private void setupActionListeners() {
        Platform.runLater(() -> {
            this.reloadTableDataTransition.setOnFinished(e -> {
                try {
                    SwingUtilities.invokeAndWait(this::loadTable);
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    ex.printStackTrace();
                    logger.error("Table reload failed", (Throwable)ex);
                }
            });
            ChangeListener<Boolean> reloadTableListener = (ob, ov, nv) -> this.reloadTableDataTransition.playFromStart();
            ChangeListener<Boolean> reloadTableListener2 = (ob, ov, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.reloadTableDataTransition.playFromStart();
                }
            };
            this.filmActionPanel.showOnlyHd.addListener(reloadTableListener);
            this.filmActionPanel.showSubtitlesOnly.addListener(reloadTableListener);
            this.filmActionPanel.showNewOnly.addListener(reloadTableListener);
            this.filmActionPanel.showBookMarkedOnly.addListener(reloadTableListener);
            this.filmActionPanel.showUnseenOnly.addListener(reloadTableListener);
            this.filmActionPanel.dontShowAbos.addListener(reloadTableListener);
            this.filmActionPanel.dontShowTrailers.addListener(reloadTableListener);
            this.filmActionPanel.dontShowSignLanguage.addListener(reloadTableListener);
            this.filmActionPanel.dontShowAudioVersions.addListener(reloadTableListener);
            this.filmActionPanel.showLivestreamsOnly.addListener(reloadTableListener);
            this.filmActionPanel.filmLengthSlider.lowValueChangingProperty().addListener(reloadTableListener2);
            this.filmActionPanel.filmLengthSlider.highValueChangingProperty().addListener(reloadTableListener2);
            this.filmActionPanel.searchThroughDescription.addListener((os, o, n) -> {
                if (!this.filmActionPanel.roSearchStringProperty.getReadOnlyProperty().isEmpty().get()) {
                    this.reloadTableDataTransition.playFromStart();
                }
            });
            this.setupZeitraumListener();
            this.filmActionPanel.themaBox.setOnAction(evt -> {
                if (!this.filmActionPanel.themaBox.getItems().isEmpty()) {
                    this.reloadTableDataTransition.playFromStart();
                }
            });
        });
        this.setupShowFilmDescriptionMenuItem();
    }

    private void setupShowFilmDescriptionMenuItem() {
        this.cbkShowDescription.setSelected(ApplicationConfiguration.getConfiguration().getBoolean("film.show_description", true));
        this.cbkShowDescription.addActionListener(l -> this.fxDescriptionPanel.setVisible(this.cbkShowDescription.isSelected()));
        this.cbkShowDescription.addItemListener(e -> ApplicationConfiguration.getConfiguration().setProperty("film.show_description", this.cbkShowDescription.isSelected()));
        this.fxDescriptionPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                GuiFilme.this.cbkShowDescription.setSelected(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                GuiFilme.this.cbkShowDescription.setSelected(false);
            }
        });
    }

    private void setupZeitraumListener() {
        PauseTransition trans = new PauseTransition(Duration.millis(250.0));
        trans.setOnFinished(evt -> {
            this.filmActionPanel.getViewSettingsPane().senderCheckList.getCheckModel().clearChecks();
            try {
                SwingUtilities.invokeAndWait(() -> this.daten.getListeBlacklist().filterListe());
            }
            catch (InterruptedException | InvocationTargetException e) {
                e.printStackTrace();
                logger.error("Failed to filter list", (Throwable)e);
            }
            this.reloadTableDataTransition.playFromStart();
        });
        this.filmActionPanel.zeitraumProperty.addListener((observable2, oldValue, newValue) -> trans.playFromStart());
    }

    private void loadTable() {
        if (this.modelFuture != null && !this.modelFuture.isDone()) {
            return;
        }
        final MBassador<BaseEvent> messageBus = MessageBus.getMessageBus();
        messageBus.publishAsync(new TableModelChangeEvent(true));
        this.stopBeob = true;
        this.tabelle.getSpalten();
        this.tabelle.setEnabled(false);
        ListeningExecutorService decoratedPool = this.daten.getDecoratedPool();
        this.modelFuture = decoratedPool.submit(() -> {
            GuiFilmeModelHelper helper = new GuiFilmeModelHelper(this.filmActionPanel, this.historyController);
            return helper.getFilteredTableModel();
        });
        Futures.addCallback(this.modelFuture, new FutureCallback<TableModel>(){

            @Override
            public void onSuccess(TableModel model) {
                SwingUtilities.invokeLater(() -> {
                    GuiFilme.this.tabelle.setModel(model);
                    GuiFilme.this.tabelle.setEnabled(true);
                    GuiFilme.this.setInfoStatusbar();
                    GuiFilme.this.tabelle.setSpalten();
                    GuiFilme.this.updateFilmData();
                    GuiFilme.this.stopBeob = false;
                    GuiFilme.this.tabelle.scrollToSelection();
                    messageBus.publishAsync(new TableModelChangeEvent(false));
                });
            }

            @Override
            public void onFailure(@NotNull Throwable thrown) {
                logger.error("Model filtering failed!", thrown);
                SwingUtilities.invokeLater(() -> {
                    GuiFilme.this.tabelle.setEnabled(true);
                    GuiFilme.this.setInfoStatusbar();
                    GuiFilme.this.tabelle.setSpalten();
                    GuiFilme.this.updateFilmData();
                    GuiFilme.this.stopBeob = false;
                    messageBus.publishAsync(new TableModelChangeEvent(false));
                });
            }
        }, decoratedPool);
    }

    public class PlayFilmAction
    extends AbstractAction {
        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            DatenPset pset = Daten.listePset.getPsetAbspielen();
            if (pset != null) {
                GuiFilme.this.playerStarten(pset);
            } else {
                MVMessageDialog.showMessageDialog(GuiFilme.this.mediathekGui, "Im Men\u00fc unter \"Datei->Einstellungen->Set bearbeiten\" ein Programm zum Abspielen festlegen.", "kein Videoplayer!", 1);
            }
        }
    }

    public class SaveFilmAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.saveFilm(null);
        }
    }

    public class BookmarkFilmAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            GuiFilme.this.bookmarkFilm();
        }
    }

    public class BookmarkManageListAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent ae) {
            GuiFilme.this.showBookmarkWindow();
        }
    }

    private class CopyUrlToClipboardAction
    extends AbstractAction {
        private final FilmResolution.Enum resolution;

        CopyUrlToClipboardAction(FilmResolution.Enum resolution) {
            this.resolution = resolution;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Optional<DatenFilm> filmSelection = GuiFilme.this.getCurrentlySelectedFilm();
            filmSelection.ifPresent(film -> GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung(this.resolution)));
        }
    }

    class TableContextMenuHandler
    extends MouseAdapter {
        private final BeobPrint beobPrint = new BeobPrint();
        private final BeobAbo beobAbo = new BeobAbo(false);
        private final BeobAbo beobAboMitTitel = new BeobAbo(true);
        private final BeobBlacklist beobBlacklistSender = new BeobBlacklist(true, false);
        private final BeobBlacklist beobBlacklistSenderThema = new BeobBlacklist(true, true);
        private final BeobBlacklist beobBlacklistThema = new BeobBlacklist(false, true);
        private final JMenuItem miPlay = this.createPlayItem();
        private final JMenuItem miSave = this.createSaveFilmItem();
        private final JMenuItem miBookmark = this.createBookmarkFilmItem();
        private final ShowFilmInformationAction showFilmInformationAction = new ShowFilmInformationAction(false);
        private final ActionListener unseenActionListener = new BeobHistory(false);
        private final ActionListener seenActionListener = new BeobHistory(true);
        private final JDownloadHelper jDownloadHelper = new JDownloadHelper();
        private Point p;
        private JMenuItem miPrintTable;

        TableContextMenuHandler() {
            this.createStaticMenuEntries();
        }

        private void createStaticMenuEntries() {
            this.miPrintTable = new JMenuItem("Tabelle drucken");
            this.miPrintTable.addActionListener(this.beobPrint);
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            if (arg0.getButton() == 1) {
                InfoDialog infoDialog;
                if (arg0.getClickCount() == 1) {
                    this.p = arg0.getPoint();
                    int row = GuiFilme.this.tabelle.rowAtPoint(this.p);
                    int column = GuiFilme.this.tabelle.columnAtPoint(this.p);
                    if (row >= 0) {
                        this.buttonTable(row, column);
                    }
                } else if (arg0.getClickCount() > 1 && (infoDialog = GuiFilme.this.mediathekGui.getFilmInfoDialog()) != null && !infoDialog.isVisible()) {
                    infoDialog.showInfo();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void buttonTable(int row, int column) {
            if (row != -1) {
                switch (GuiFilme.this.tabelle.convertColumnIndexToModel(column)) {
                    case 4: {
                        Optional<DatenFilm> filmSelection = GuiFilme.this.getCurrentlySelectedFilm();
                        filmSelection.ifPresent(datenFilm -> {
                            boolean stop = false;
                            DatenDownload datenDownload = GuiFilme.this.daten.getListeDownloadsButton().getDownloadUrlFilm(datenFilm.getUrlNormalQuality());
                            if (datenDownload != null && datenDownload.start != null && datenDownload.start.status == 2) {
                                stop = true;
                                GuiFilme.this.daten.getListeDownloadsButton().delDownloadButton(datenFilm.getUrlNormalQuality());
                            }
                            if (!stop) {
                                GuiFilme.this.playAction.actionPerformed(null);
                            }
                        });
                        break;
                    }
                    case 5: {
                        GuiFilme.this.saveFilm(null);
                        break;
                    }
                    case 6: {
                        GuiFilme.this.getCurrentlySelectedFilm().ifPresent(film -> {
                            if (!film.isLivestream()) {
                                GuiFilme.this.bookmarkFilm();
                            }
                        });
                    }
                }
            }
        }

        private JMenuItem createPlayItem() {
            JMenuItem item = new JMenuItem("Film abspielen");
            item.setIcon(IconFontSwing.buildIcon(FontAwesome.PLAY, 16.0f));
            item.addActionListener(GuiFilme.this.playAction);
            return item;
        }

        private JMenuItem createSaveFilmItem() {
            JMenuItem item = new JMenuItem("Film aufzeichnen");
            item.setIcon(IconFontSwing.buildIcon(FontAwesome.DOWNLOAD, 16.0f));
            item.addActionListener(GuiFilme.this.saveFilmAction);
            return item;
        }

        private JMenuItem createBookmarkFilmItem() {
            JMenuItem item = new JMenuItem("Film merken");
            item.setIcon(IconFontSwing.buildIcon(FontAwesome.BOOKMARK_O, 16.0f));
            item.addActionListener(GuiFilme.this.bookmarkFilmAction);
            return item;
        }

        private void showMenu(MouseEvent evt) {
            this.p = evt.getPoint();
            int nr = GuiFilme.this.tabelle.rowAtPoint(this.p);
            if (nr >= 0) {
                GuiFilme.this.tabelle.setRowSelectionInterval(nr, nr);
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(this.miPlay);
            jPopupMenu.add(this.miSave);
            jPopupMenu.add(this.miBookmark);
            jPopupMenu.addSeparator();
            JMenu submenueAbo = new JMenu("Abo");
            jPopupMenu.add(submenueAbo);
            JMenuItem itemAboLoeschen = new JMenuItem("Abo L\u00f6schen");
            JMenuItem itemAbo = new JMenuItem("Abo mit Sender und Thema anlegen");
            JMenuItem itemAboMitTitel = new JMenuItem("Abo mit Sender und Thema und Titel anlegen");
            JMenuItem itemChangeAboFilter = new JMenuItem("Abo \u00e4ndern");
            Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
            res.ifPresent(film -> {
                if (GuiFilme.this.daten.getListeAbo().getAboFuerFilm_schnell((DatenFilm)film, false) != null) {
                    itemAbo.setEnabled(false);
                    itemAboMitTitel.setEnabled(false);
                    itemAboLoeschen.addActionListener(this.beobAbo);
                    itemChangeAboFilter.addActionListener(new BeobChangeAbo());
                } else {
                    itemAboLoeschen.setEnabled(false);
                    itemChangeAboFilter.setEnabled(false);
                    itemAbo.addActionListener(this.beobAbo);
                    itemAboMitTitel.addActionListener(this.beobAboMitTitel);
                }
                if (film.isLivestream()) {
                    jPopupMenu.remove(this.miBookmark);
                } else {
                    this.miBookmark.setText(film.isBookmarked() ? "Film aus Merkliste entfernen" : "Film merken");
                }
            });
            submenueAbo.add(itemAboLoeschen);
            submenueAbo.add(itemChangeAboFilter);
            submenueAbo.add(itemAbo);
            submenueAbo.add(itemAboMitTitel);
            JMenu submenue = new JMenu("Film mit Set starten");
            jPopupMenu.add(submenue);
            ListePset liste = Daten.listePset.getListeButton();
            for (DatenPset pset : liste) {
                if (pset.getListeProg().isEmpty() && pset.arr[0].isEmpty()) continue;
                Color col = pset.getFarbe();
                JMenuItem item = new JMenuItem(pset.arr[0]);
                if (pset.getListeProg().isEmpty()) {
                    if (col != null) {
                        item.setForeground(col);
                    }
                } else {
                    item.addActionListener(l -> GuiFilme.this.playerStarten(pset));
                    if (col != null) {
                        item.setBackground(col);
                    }
                }
                submenue.add(item);
            }
            JMenu submenueBlack = new JMenu("Blacklist");
            jPopupMenu.add(submenueBlack);
            JMenuItem itemBlackSender = new JMenuItem("Sender in die Blacklist einf\u00fcgen");
            itemBlackSender.addActionListener(this.beobBlacklistSender);
            JMenuItem itemBlackThema = new JMenuItem("Thema in die Blacklist einf\u00fcgen");
            itemBlackThema.addActionListener(this.beobBlacklistThema);
            JMenuItem itemBlackSenderThema = new JMenuItem("Sender und Thema in die Blacklist einf\u00fcgen");
            itemBlackSenderThema.addActionListener(this.beobBlacklistSenderThema);
            submenueBlack.add(itemBlackSender);
            submenueBlack.add(itemBlackThema);
            submenueBlack.add(itemBlackSenderThema);
            res.ifPresent(film -> {
                this.jDownloadHelper.installContextMenu((DatenFilm)film, jPopupMenu);
                jPopupMenu.addSeparator();
                this.setupCopytoClipboardContextMenu((DatenFilm)film, jPopupMenu);
                jPopupMenu.addSeparator();
                this.setupSearchEntries(jPopupMenu, (DatenFilm)film);
            });
            jPopupMenu.add(this.miPrintTable);
            jPopupMenu.add(this.showFilmInformationAction);
            res.ifPresent(film -> this.setupHistoryContextActions(jPopupMenu, (DatenFilm)film));
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private void setupHistoryContextActions(@NotNull JPopupMenu popupMenu, @NotNull DatenFilm film) {
            if (!film.isLivestream()) {
                try (SeenHistoryController history = new SeenHistoryController();){
                    JMenuItem miHistory;
                    if (history.hasBeenSeen(film)) {
                        miHistory = new JMenuItem("Film als ungesehen markieren");
                        miHistory.addActionListener(this.unseenActionListener);
                    } else {
                        miHistory = new JMenuItem("Film als gesehen markieren");
                        miHistory.addActionListener(this.seenActionListener);
                    }
                    popupMenu.add(miHistory);
                }
            }
        }

        private void setupCopytoClipboardContextMenu(@NotNull DatenFilm film, @NotNull JPopupMenu popupMenu) {
            JMenu mCopyToClipboard = new JMenu("In Zwischenablage kopieren");
            JMenuItem miCopyClipboardTitle = new JMenuItem("Titel");
            miCopyClipboardTitle.addActionListener(e -> GuiFunktionen.copyToClipboard(film.getTitle()));
            mCopyToClipboard.add(miCopyClipboardTitle);
            JMenuItem miCopyClipboardThema = new JMenuItem("Thema");
            miCopyClipboardThema.addActionListener(e -> GuiFunktionen.copyToClipboard(film.getThema()));
            mCopyToClipboard.add(miCopyClipboardThema);
            JMenuItem miCopyTitleThemaToClipboard = new JMenuItem("Thema - Titel");
            miCopyTitleThemaToClipboard.addActionListener(e -> {
                String text = film.getThema() + " - " + film.getTitle();
                GuiFunktionen.copyToClipboard(text);
            });
            mCopyToClipboard.add(miCopyTitleThemaToClipboard);
            this.setupFilmUrlCopyToClipboardEntries(mCopyToClipboard, film);
            popupMenu.add(mCopyToClipboard);
        }

        private void setupFilmUrlCopyToClipboardEntries(@NotNull JMenu parentMenu, @NotNull DatenFilm film) {
            JMenuItem item;
            parentMenu.addSeparator();
            String uNormal = film.getUrlFuerAufloesung(FilmResolution.Enum.NORMAL);
            String uHd = film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY);
            String uLow = film.getUrlFuerAufloesung(FilmResolution.Enum.LOW);
            if (uHd.equals(uNormal)) {
                uHd = "";
            }
            if (uLow.equals(uNormal)) {
                uLow = "";
            }
            if (!uNormal.isEmpty()) {
                ActionListener copyNormalUrlListener = e -> GuiFunktionen.copyToClipboard(uNormal);
                if (!uHd.isEmpty() || !uLow.isEmpty()) {
                    JMenu submenueURL = new JMenu("Film-URL");
                    if (!uHd.isEmpty()) {
                        item = new JMenuItem("h\u00f6chste/hohe Qualit\u00e4t");
                        item.addActionListener(e -> GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY)));
                        submenueURL.add(item);
                    }
                    item = new JMenuItem("mittlere Qualit\u00e4t");
                    item.addActionListener(copyNormalUrlListener);
                    submenueURL.add(item);
                    if (!uLow.isEmpty()) {
                        item = new JMenuItem("niedrige Qualit\u00e4t");
                        item.addActionListener(e -> GuiFunktionen.copyToClipboard(film.getUrlFuerAufloesung(FilmResolution.Enum.LOW)));
                        submenueURL.add(item);
                    }
                    parentMenu.add(submenueURL);
                } else {
                    item = new JMenuItem("Verf\u00fcgbare URL");
                    item.addActionListener(copyNormalUrlListener);
                    parentMenu.add(item);
                }
            }
            if (!film.getUrlSubtitle().isEmpty()) {
                item = new JMenuItem("Untertitel-URL");
                item.addActionListener(e -> GuiFunktionen.copyToClipboard(film.getUrlSubtitle()));
                parentMenu.add(item);
            }
        }

        private void setupSearchEntries(@NotNull JPopupMenu popupMenu, @NotNull DatenFilm film) {
            JMenu mOnlineSearch = new JMenu("Online-Suche nach");
            JMenu mThema = new JMenu("Thema");
            JMenu mTitel = new JMenu("Titel");
            EnumSet<OnlineSearchProviders> set = EnumSet.allOf(OnlineSearchProviders.class);
            for (OnlineSearchProviders item : set) {
                JMenuItem miThema = new JMenuItem(item.toString());
                miThema.addActionListener(l -> {
                    String url = item.getQueryUrl() + URLEncoder.encode(film.getThema(), StandardCharsets.UTF_8);
                    try {
                        UrlHyperlinkAction.openURL(MediathekGui.ui(), url);
                    }
                    catch (URISyntaxException ex) {
                        logger.error("Failed to launch online search for url {}", (Object)url);
                    }
                });
                mThema.add(miThema);
                JMenuItem miTitel = new JMenuItem(item.toString());
                miTitel.addActionListener(l -> {
                    String url = item.getQueryUrl() + URLEncoder.encode(film.getTitle(), StandardCharsets.UTF_8);
                    try {
                        UrlHyperlinkAction.openURL(MediathekGui.ui(), url);
                    }
                    catch (URISyntaxException ex) {
                        logger.error("Failed to launch online search for url {}", (Object)url);
                    }
                });
                mTitel.add(miTitel);
            }
            mOnlineSearch.add(mThema);
            mOnlineSearch.add(mTitel);
            popupMenu.add(mOnlineSearch);
            popupMenu.addSeparator();
        }

        private class BeobPrint
        implements ActionListener {
            private BeobPrint() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GuiFilme.this.tabelle.print();
                }
                catch (PrinterException ex) {
                    logger.error(ex);
                }
            }
        }

        private class BeobAbo
        implements ActionListener {
            private final boolean mitTitel;

            BeobAbo(boolean mmitTitel) {
                this.mitTitel = mmitTitel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Daten.listePset.getListeAbo().isEmpty()) {
                    new DialogAboNoSet(GuiFilme.this.mediathekGui).setVisible(true);
                } else {
                    int nr = GuiFilme.this.tabelle.rowAtPoint(TableContextMenuHandler.this.p);
                    if (nr >= 0) {
                        GuiFilme.this.stopBeob = true;
                        Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
                        res.ifPresent(film -> {
                            DatenAbo datenAbo = GuiFilme.this.daten.getListeAbo().getAboFuerFilm_schnell((DatenFilm)film, false);
                            if (datenAbo != null) {
                                GuiFilme.this.daten.getListeAbo().aboLoeschen(datenAbo);
                            } else if (this.mitTitel) {
                                GuiFilme.this.daten.getListeAbo().addAbo(film.getThema(), film.getSender(), film.getThema(), film.getTitle());
                            } else {
                                GuiFilme.this.daten.getListeAbo().addAbo(film.getThema(), film.getSender(), film.getThema(), "");
                            }
                        });
                        GuiFilme.this.stopBeob = false;
                    }
                }
            }
        }

        private final class BeobBlacklist
        implements ActionListener {
            private final boolean sender;
            private final boolean thema;

            BeobBlacklist(boolean sender, boolean thema) {
                this.sender = sender;
                this.thema = thema;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(TableContextMenuHandler.this.p);
                if (nr >= 0) {
                    Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
                    res.ifPresent(film -> {
                        String thema = film.getThema();
                        String sender = film.getSender();
                        MVConfig.add(MVConfig.Configs.SYSTEM_BLACKLIST_ON, Boolean.TRUE.toString());
                        ListeBlacklist listeBlacklist = GuiFilme.this.daten.getListeBlacklist();
                        if (!this.sender) {
                            listeBlacklist.add(new BlacklistRule("", thema, "", ""));
                        } else if (!this.thema) {
                            listeBlacklist.add(new BlacklistRule(sender, "", "", ""));
                        } else {
                            listeBlacklist.add(new BlacklistRule(sender, thema, "", ""));
                        }
                    });
                }
            }
        }

        private class BeobHistory
        implements ActionListener {
            private final boolean seen;

            BeobHistory(boolean seen) {
                this.seen = seen;
            }

            private void updateHistory(DatenFilm film) {
                try (SeenHistoryController history = new SeenHistoryController();){
                    if (this.seen) {
                        history.markSeen(film);
                    } else {
                        history.markUnseen(film);
                    }
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int nr = GuiFilme.this.tabelle.rowAtPoint(TableContextMenuHandler.this.p);
                if (nr != -1) {
                    Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
                    res.ifPresent(this::updateHistory);
                }
            }
        }

        private class BeobChangeAbo
        implements ActionListener {
            private BeobChangeAbo() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Daten.listePset.getListeAbo().isEmpty()) {
                    new DialogAboNoSet(GuiFilme.this.mediathekGui).setVisible(true);
                } else {
                    int nr = GuiFilme.this.tabelle.rowAtPoint(TableContextMenuHandler.this.p);
                    if (nr >= 0) {
                        GuiFilme.this.stopBeob = true;
                        Optional<DatenFilm> res = GuiFilme.this.getFilm(nr);
                        res.ifPresent(film -> {
                            DatenAbo datenAbo = GuiFilme.this.daten.getListeAbo().getAboFuerFilm_schnell((DatenFilm)film, false);
                            if (datenAbo != null) {
                                DialogEditAbo dialog = new DialogEditAbo(GuiFilme.this.mediathekGui, datenAbo, false);
                                dialog.setVisible(true);
                                if (dialog.successful()) {
                                    GuiFilme.this.daten.getListeAbo().aenderungMelden();
                                }
                            }
                        });
                        GuiFilme.this.stopBeob = false;
                    }
                }
            }
        }
    }
}

