/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolbox;

import java.time.Duration;
import java.time.Period;
import java.util.regex.Pattern;

public class Constants {
    public static final double EPSILON = 1.0E-6;
    public static final Pattern INT_PATTERN = Pattern.compile("[0-9]+");
    public static final Pattern FLOAT_PATTERN = Pattern.compile("[-+]?[0-9]*\\.?[0-9]+");
    public static final Pattern HEX_PATTERN = Pattern.compile("#?([A-Fa-f0-9]{8}|[A-Fa-f0-9]{6})");
    public static final Pattern POSITIVE_INTEGER_PATTERN = Pattern.compile("\\d+");
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long SECONDS_PER_HOUR = 3600L;
    public static final long SECONDS_PER_DAY = 86400L;
    public static final long SECONDS_PER_MONTH = 2592000L;
    public static final Duration TIME_PERIOD_24_HOURS = Duration.ofHours(24L);
    public static final Duration TIME_PERIOD_3_DAYS = Duration.ofDays(3L);
    public static final Duration TIME_PERIOD_5_DAYS = Duration.ofDays(5L);
    public static final Duration TIME_PERIOD_7_DAYS = Duration.ofDays(7L);
    public static final Duration TIME_PERIOD_1_MONTH = Duration.ofSeconds((long)Period.ofMonths(1).getDays() * 86400L);
    public static final Duration TIME_PERIOD_3_MONTH = Duration.ofSeconds((long)Period.ofMonths(3).getDays() * 86400L);
    public static final Duration TIME_PERIOD_6_MONTH = Duration.ofSeconds((long)Period.ofMonths(6).getDays() * 86400L);
    public static final Duration TIME_PERIOD_12_MONTH = Duration.ofSeconds((long)Period.ofYears(1).getDays() * 86400L);
    public static final String SQUARE_BRACKET_OPEN = "[";
    public static final String SQUARE_BRACKET_CLOSE = "]";
    public static final String CURLY_BRACKET_OPEN = "{";
    public static final String CURLY_BRACKET_CLOSE = "}";
    public static final String INDENTED_QUOTES = "  \"";
    public static final String QUOTES = "\"";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String SLASH = "/";
    public static final String NEW_LINE = "\n";
    public static final String COMMA_NEW_LINE = ",\n";
    public static final String INDENT = "  ";
    public static final String PERCENTAGE = "%";
    public static final String DEGREE = "\u00b0";

    private Constants() {
    }
}

