/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import eu.hansolo.tilesfx.tools.Helper;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;

public class RotationEffect
extends Region {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 10.0;
    private static final double MINIMUM_HEIGHT = 10.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double width;
    private double height;
    private double offsetX;
    private double offsetY;
    private Canvas canvas;
    private GraphicsContext ctx;
    private double angle = 0.0;
    private long lastTimerCall = System.nanoTime();
    private AnimationTimer timer = new AnimationTimer(){

        @Override
        public void handle(long now) {
            if (now > RotationEffect.this.lastTimerCall + 20000000L) {
                RotationEffect.this.redraw();
                RotationEffect.this.lastTimerCall = now;
            }
        }
    };
    private boolean isRunning = false;
    private Color _color;
    private ObjectProperty<Color> color;
    private double _alpha;
    private DoubleProperty alpha;
    private double centerX;
    private double centerY;
    private RadialGradient gradient;

    public RotationEffect() {
        this(Color.WHITE, 0.1, 0.5, 0.5);
    }

    public RotationEffect(Color color, double alpha, double centerX, double centerY) {
        this._color = color;
        this._alpha = alpha;
        this.gradient = new RadialGradient(0.0, 0.0, 0.5, 0.5, 250.0, true, CycleMethod.NO_CYCLE, new Stop(0.0, this.getColorWithOpacity(this.getAlpha())), new Stop(1.0, Color.TRANSPARENT));
        this.centerX = centerX;
        this.centerY = centerY;
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0 || Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0) {
            if (this.getPrefWidth() > 0.0 && this.getPrefHeight() > 0.0) {
                this.setPrefSize(this.getPrefWidth(), this.getPrefHeight());
            } else {
                this.setPrefSize(250.0, 250.0);
            }
        }
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.getChildren().setAll((Node[])new Node[]{this.canvas});
    }

    private void registerListeners() {
        this.widthProperty().addListener(o -> this.resize());
        this.heightProperty().addListener(o -> this.resize());
    }

    @Override
    protected double computeMinWidth(double HEIGHT) {
        return 10.0;
    }

    @Override
    protected double computeMinHeight(double WIDTH) {
        return 10.0;
    }

    @Override
    protected double computePrefWidth(double HEIGHT) {
        return super.computePrefWidth(HEIGHT);
    }

    @Override
    protected double computePrefHeight(double WIDTH) {
        return super.computePrefHeight(WIDTH);
    }

    @Override
    protected double computeMaxWidth(double HEIGHT) {
        return 1024.0;
    }

    @Override
    protected double computeMaxHeight(double WIDTH) {
        return 1024.0;
    }

    public void start() {
        this.timer.start();
        this.isRunning = true;
    }

    public void stop() {
        this.timer.stop();
        this.isRunning = false;
    }

    public Color getColor() {
        return null == this.color ? this._color : (Color)this.color.get();
    }

    public void setColor(Color color) {
        if (null == this.color) {
            this._color = color;
            this.updateGradient();
            this.redraw();
        } else {
            this.color.set(color);
        }
    }

    public ObjectProperty<Color> colorProperty() {
        if (null == this.color) {
            this.color = new ObjectPropertyBase(this._color){

                @Override
                protected void invalidated() {
                    RotationEffect.this.updateGradient();
                    RotationEffect.this.redraw();
                }

                @Override
                public Object getBean() {
                    return RotationEffect.this;
                }

                @Override
                public String getName() {
                    return "color";
                }
            };
            this._color = null;
        }
        return this.color;
    }

    public double getAlpha() {
        return null == this.alpha ? this._alpha : this.alpha.get();
    }

    public void setAlpha(double alpha) {
        if (null == this.alpha) {
            this._alpha = Helper.clamp(0.0, 1.0, alpha);
            this.updateGradient();
            this.redraw();
        } else {
            this.alpha.set(Helper.clamp(0.0, 1.0, alpha));
        }
    }

    public DoubleProperty alphaProperty() {
        if (null == this.alpha) {
            this.alpha = new DoublePropertyBase(this._alpha){

                @Override
                protected void invalidated() {
                    this.set(Helper.clamp(0.0, 1.0, this.get()));
                    RotationEffect.this.updateGradient();
                    RotationEffect.this.redraw();
                }

                @Override
                public Object getBean() {
                    return RotationEffect.this;
                }

                @Override
                public String getName() {
                    return "alpha";
                }
            };
        }
        return this.alpha;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public void setCenterX(double centerX) {
        this.centerX = Helper.clamp(0.0, 1.0, centerX);
        this.updateGradient();
        this.redraw();
    }

    public double getCenterY() {
        return this.centerY;
    }

    public void setCenterY(double centerY) {
        this.centerY = Helper.clamp(0.0, 1.0, centerY);
        this.updateGradient();
        this.redraw();
    }

    private Color getColorWithOpacity(double alpha) {
        return Color.color(this.getColor().getRed(), this.getColor().getBlue(), this.getColor().getBlue(), alpha);
    }

    private void updateGradient() {
        this.gradient = new RadialGradient(0.0, 0.0, this.offsetX + this.width * this.centerX, this.offsetY + this.height * this.centerY, 1024.0, false, CycleMethod.NO_CYCLE, new Stop(0.0, this.getColorWithOpacity(this.getAlpha())), new Stop(1.0, Color.TRANSPARENT));
    }

    private void resize() {
        this.width = this.getWidth() - this.getInsets().getLeft() - this.getInsets().getRight();
        this.height = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        if (this.width > 0.0 && this.height > 0.0) {
            boolean wasRunning = this.isRunning;
            this.stop();
            this.offsetX = (this.getWidth() - this.width) * 0.5;
            this.offsetY = (this.getHeight() - this.height) * 0.5;
            this.updateGradient();
            this.canvas.setWidth(this.width);
            this.canvas.setHeight(this.height);
            if (wasRunning) {
                this.start();
            } else {
                this.redraw();
            }
        }
    }

    private void redraw() {
        this.ctx.clearRect(0.0, 0.0, this.width, this.height);
        boolean toggle = true;
        double x = -this.width - this.width * 0.5 + this.width * this.getCenterX();
        double y = -this.height - this.height * 0.5 + this.height * this.getCenterY();
        double w = 3.0 * this.width;
        double h2 = 3.0 * this.height;
        for (int i = 0; i < 360; i += 15) {
            this.ctx.setFill(toggle ? this.gradient : Color.TRANSPARENT);
            this.ctx.fillArc(x, y, w, h2, -((double)i + this.angle), 15.0, ArcType.ROUND);
            toggle ^= true;
        }
        this.angle += 2.0;
        if (this.angle > 360.0) {
            this.angle = 0.0;
        }
    }
}

