/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Section;
import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.toolboxfx.GradientLookup;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Line;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class BarGaugeTileSkin
extends TileSkin {
    private static final double START_ANGLE = 90.0;
    private static final double ANGLE_RANGE = 180.0;
    private Text titleText;
    private Text valueText;
    private Text upperUnitText;
    private Line fractionLine;
    private Text unitText;
    private VBox unitFlow;
    private HBox valueUnitFlow;
    private Text text;
    private GradientLookup gradientLookup;
    private boolean colorGradientEnabled;
    private int noOfGradientStops;
    private Text minValueText;
    private Text maxValueText;
    private Arc barBackground;
    private Arc bar;
    private Line threshold;
    private Text thresholdText;
    private Line lowerThreshold;
    private Text lowerThresholdText;

    public BarGaugeTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        if (this.tile.isAutoScale()) {
            this.tile.calcAutoScale();
        }
        this.gradientLookup = new GradientLookup(this.tile.getGradientStops());
        this.noOfGradientStops = this.tile.getGradientStops().size();
        this.sectionsVisible = this.tile.getSectionsVisible();
        this.colorGradientEnabled = this.tile.isStrokeWithGradient();
        this.titleText = new Text(this.tile.getTitle());
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, this.tile.getValue()));
        this.valueText.setFill(this.tile.getValueColor());
        Helper.enableNode(this.valueText, this.tile.isValueVisible());
        this.upperUnitText = new Text("");
        this.upperUnitText.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.upperUnitText, !this.tile.getUnit().isEmpty());
        this.fractionLine = new Line();
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.unitText, !this.tile.getUnit().isEmpty());
        this.unitFlow = new VBox(this.upperUnitText, this.unitText);
        this.unitFlow.setAlignment(Pos.CENTER_RIGHT);
        this.valueUnitFlow = new HBox(this.valueText, this.unitFlow);
        this.valueUnitFlow.setAlignment(Pos.CENTER);
        this.valueUnitFlow.setMouseTransparent(true);
        this.text = new Text(this.tile.getText());
        this.text.setTextOrigin(VPos.TOP);
        this.text.setFill(this.tile.getTextColor());
        this.barBackground = new Arc(125.0, 125.0, 100.0, 100.0, 0.0, 180.0);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke(this.tile.getBarBackgroundColor());
        this.barBackground.setStrokeWidth(31.25);
        this.barBackground.setStrokeLineCap(StrokeLineCap.BUTT);
        this.barBackground.setFill(null);
        this.bar = new Arc(125.0, 125.0, 100.0, 100.0, 270.0, 0.0);
        this.bar.setType(ArcType.OPEN);
        this.bar.setStroke(this.tile.getBarColor());
        this.bar.setStrokeWidth(31.25);
        this.bar.setStrokeLineCap(StrokeLineCap.BUTT);
        this.bar.setFill(null);
        this.lowerThreshold = new Line();
        this.lowerThreshold.setStroke(this.tile.getLowerThresholdColor());
        this.lowerThreshold.setStrokeLineCap(StrokeLineCap.BUTT);
        Helper.enableNode(this.lowerThreshold, this.tile.isLowerThresholdVisible());
        this.lowerThresholdText = new Text(String.format(this.locale, this.formatString, this.tile.getLowerThreshold()));
        Helper.enableNode(this.lowerThresholdText, this.tile.isLowerThresholdVisible());
        this.threshold = new Line();
        this.threshold.setStroke(this.tile.getThresholdColor());
        this.threshold.setStrokeLineCap(StrokeLineCap.BUTT);
        Helper.enableNode(this.threshold, this.tile.isThresholdVisible());
        this.thresholdText = new Text(String.format(this.locale, this.formatString, this.tile.getThreshold()));
        Helper.enableNode(this.thresholdText, this.tile.isThresholdVisible());
        this.minValueText = new Text();
        this.maxValueText = new Text();
        this.getPane().getChildren().addAll((Node[])new Node[]{this.barBackground, this.bar, this.lowerThreshold, this.lowerThresholdText, this.threshold, this.thresholdText, this.minValueText, this.maxValueText, this.titleText, this.valueUnitFlow, this.fractionLine, this.text});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
            Helper.enableNode(this.valueText, this.tile.isValueVisible());
            Helper.enableNode(this.unitFlow, !this.tile.getUnit().isEmpty());
            Helper.enableNode(this.lowerThreshold, this.tile.isLowerThresholdVisible());
            Helper.enableNode(this.lowerThresholdText, this.tile.isLowerThresholdVisible());
            Helper.enableNode(this.threshold, this.tile.isThresholdVisible());
            Helper.enableNode(this.thresholdText, this.tile.isThresholdVisible());
            this.sectionsVisible = this.tile.getSectionsVisible();
            this.redraw();
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        if (this.tile.getShortenNumbers()) {
            this.valueText.setText(Helper.shortenNumber((long)VALUE));
        } else if (this.tile.getCustomDecimalFormatEnabled()) {
            this.valueText.setText(this.decimalFormat.format(VALUE));
        } else {
            this.valueText.setText(String.format(this.locale, this.formatString, VALUE));
        }
        this.resizeDynamicText();
        this.setBar(VALUE);
    }

    private void setBar(double VALUE) {
        double barLength = 0.0;
        double barStart = 0.0;
        double step = this.tile.getAngleStep();
        double clampedValue = Helper.clamp(this.minValue, this.maxValue, VALUE);
        if (this.tile.isStartFromZero()) {
            if ((VALUE > this.minValue || this.minValue < 0.0) && (VALUE < this.maxValue || this.maxValue > 0.0)) {
                if (this.maxValue < 0.0) {
                    barStart = -360.0;
                    barLength = (this.maxValue - clampedValue) * step;
                } else if (this.minValue > 0.0) {
                    barStart = -180.0;
                    barLength = (this.minValue - clampedValue) * step;
                } else {
                    barStart = -180.0 + this.minValue * step;
                    barLength = -clampedValue * step;
                }
            }
        } else {
            barStart = -180.0;
            barLength = (this.minValue - clampedValue) * step;
        }
        this.bar.setStartAngle(barStart);
        this.bar.setLength(barLength);
        this.setBarColor(VALUE);
    }

    private void setBarColor(double VALUE) {
        if (!this.sectionsVisible && !this.colorGradientEnabled) {
            this.bar.setStroke(this.tile.getBarColor());
        } else if (this.colorGradientEnabled && this.noOfGradientStops > 1) {
            this.bar.setStroke(this.gradientLookup.getColorAt((VALUE - this.minValue) / this.range));
        } else {
            this.bar.setStroke(this.tile.getBarColor());
            for (Section section : this.sections) {
                if (!section.contains(VALUE)) continue;
                this.bar.setStroke(section.getColor());
                break;
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        maxWidth = this.width - (this.width - this.size * 0.275);
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.upperUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.upperUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.upperUnitText, maxWidth, fontSize);
        }
        fontSize = this.upperUnitText.getText().isEmpty() ? this.size * 0.12 : this.size * 0.1;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        maxWidth = this.size * 0.15;
        fontSize = this.size * 0.07;
        this.minValueText.setFont(Fonts.latoRegular(fontSize));
        this.minValueText.setText(String.format(this.locale, this.tickLabelFormatString, this.minValue));
        if (this.minValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.minValueText, maxWidth, fontSize);
        }
        this.minValueText.setX(this.width * 0.5 - this.size * 0.2);
        this.minValueText.setY(this.height * 0.85);
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        this.maxValueText.setText(String.format(this.locale, this.tickLabelFormatString, this.maxValue));
        if (this.maxValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueText, maxWidth, fontSize);
        }
        this.maxValueText.setX(this.width * 0.5 + this.size * 0.2 - this.maxValueText.getLayoutBounds().getWidth());
        this.maxValueText.setY(this.height * 0.85);
        maxWidth = this.width - this.size * 0.25;
        fontSize = this.size * 0.06;
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.1);
    }

    @Override
    protected void resize() {
        super.resize();
        this.handleCurrentValue(this.tile.getValue());
        this.resizeStaticText();
        this.resizeDynamicText();
        double centerX = this.width * 0.5;
        double centerY = this.height * 0.85;
        this.valueUnitFlow.setPrefWidth(this.width - this.size * 0.1);
        this.valueUnitFlow.relocate(this.size * 0.05, this.contentBounds.getY());
        this.valueUnitFlow.setMaxHeight(this.valueText.getFont().getSize());
        this.fractionLine.setStartX(this.width - 0.17 * this.size);
        this.fractionLine.setStartY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setEndX(this.width - 0.05 * this.size);
        this.fractionLine.setEndY(this.tile.getTitle().isEmpty() ? this.size * 0.2 : this.size * 0.3);
        this.fractionLine.setStroke(this.tile.getUnitColor());
        this.fractionLine.setStrokeWidth(this.size * 0.005);
        this.unitFlow.setTranslateY(-this.size * 0.005);
        this.barBackground.setCenterX(centerX);
        this.barBackground.setCenterY(centerY);
        this.barBackground.setRadiusX(this.size * 0.325);
        this.barBackground.setRadiusY(this.size * 0.325);
        this.barBackground.setStrokeWidth(this.size * 0.15);
        this.bar.setCenterX(centerX);
        this.bar.setCenterY(centerY);
        this.bar.setRadiusX(this.size * 0.325);
        this.bar.setRadiusY(this.size * 0.325);
        this.bar.setStrokeWidth(this.size * 0.15);
        this.lowerThreshold.setStrokeWidth(Helper.clamp(1.0, 2.0, 0.00675676 * this.size));
        double lowerThresholdInnerRadius = 0.25 * this.size;
        double lowerThresholdOuterRadius = 0.4 * this.size;
        double lowerThresholdAngle = Helper.clamp(90.0, 270.0, (this.tile.getThreshold() - this.minValue) * this.angleStep + 90.0);
        this.lowerThreshold.setStartX(centerX + lowerThresholdInnerRadius * Math.sin(-Math.toRadians(lowerThresholdAngle)));
        this.lowerThreshold.setStartY(centerY + lowerThresholdInnerRadius * Math.cos(-Math.toRadians(lowerThresholdAngle)));
        this.lowerThreshold.setEndX(centerX + lowerThresholdOuterRadius * Math.sin(-Math.toRadians(lowerThresholdAngle)));
        this.lowerThreshold.setEndY(centerY + lowerThresholdOuterRadius * Math.cos(-Math.toRadians(lowerThresholdAngle)));
        double lowerThresholdTextRadius = 0.43 * this.size;
        this.lowerThresholdText.setText(String.format(this.locale, this.tickLabelFormatString, this.tile.getThreshold()));
        this.lowerThresholdText.setFont(Fonts.latoRegular(this.size * 0.047));
        this.lowerThresholdText.setRotate(lowerThresholdAngle + 180.0);
        this.lowerThresholdText.relocate(centerX - this.lowerThresholdText.getLayoutBounds().getWidth() * 0.5 + lowerThresholdTextRadius * Math.sin(-Math.toRadians(lowerThresholdAngle)), centerY - this.lowerThresholdText.getLayoutBounds().getWidth() * 0.5 + lowerThresholdTextRadius * Math.cos(-Math.toRadians(lowerThresholdAngle)));
        this.threshold.setStrokeWidth(Helper.clamp(1.0, 2.0, 0.00675676 * this.size));
        double thresholdInnerRadius = 0.25 * this.size;
        double thresholdOuterRadius = 0.4 * this.size;
        double thresholdAngle = Helper.clamp(90.0, 270.0, (this.tile.getThreshold() - this.minValue) * this.angleStep + 90.0);
        this.threshold.setStartX(centerX + thresholdInnerRadius * Math.sin(-Math.toRadians(thresholdAngle)));
        this.threshold.setStartY(centerY + thresholdInnerRadius * Math.cos(-Math.toRadians(thresholdAngle)));
        this.threshold.setEndX(centerX + thresholdOuterRadius * Math.sin(-Math.toRadians(thresholdAngle)));
        this.threshold.setEndY(centerY + thresholdOuterRadius * Math.cos(-Math.toRadians(thresholdAngle)));
        double thresholdTextRadius = 0.43 * this.size;
        this.thresholdText.setText(String.format(this.locale, this.tickLabelFormatString, this.tile.getThreshold()));
        this.thresholdText.setFont(Fonts.latoRegular(this.size * 0.047));
        this.thresholdText.setRotate(thresholdAngle + 180.0);
        this.thresholdText.relocate(centerX - this.thresholdText.getLayoutBounds().getWidth() * 0.5 + thresholdTextRadius * Math.sin(-Math.toRadians(thresholdAngle)), centerY - this.thresholdText.getLayoutBounds().getWidth() * 0.5 + thresholdTextRadius * Math.cos(-Math.toRadians(thresholdAngle)));
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.gradientLookup.setStops(this.tile.getGradientStops());
        this.colorGradientEnabled = this.tile.isStrokeWithGradient();
        this.barBackground.setStroke(this.tile.getBarBackgroundColor());
        this.setBar(this.tile.getCurrentValue());
        this.lowerThreshold.setStroke(this.tile.getLowerThresholdColor());
        this.threshold.setStroke(this.tile.getThresholdColor());
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        if (this.tile.getUnit().contains("/")) {
            String[] units = this.tile.getUnit().split("/");
            this.upperUnitText.setText(units[0]);
            this.unitText.setText(units[1]);
            Helper.enableNode(this.fractionLine, true);
        } else {
            this.upperUnitText.setText(" ");
            this.unitText.setText(this.tile.getUnit());
            Helper.enableNode(this.fractionLine, false);
        }
        if (!this.tile.getDescription().isEmpty()) {
            this.text.setText(this.tile.getDescription());
        }
        this.text.setText(this.tile.getText());
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.valueText.setFill(this.tile.getValueColor());
        this.upperUnitText.setFill(this.tile.getUnitColor());
        this.fractionLine.setStroke(this.tile.getUnitColor());
        this.unitText.setFill(this.tile.getUnitColor());
        this.text.setFill(this.tile.getTextColor());
        this.minValueText.setFill(this.tile.getTextColor());
        this.maxValueText.setFill(this.tile.getTextColor());
        this.lowerThresholdText.setFill(this.tile.getValueColor());
        this.thresholdText.setFill(this.tile.getValueColor());
    }
}

