/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.fx.countries.tools;

import eu.hansolo.fx.countries.tools.CLocation;
import eu.hansolo.fx.countries.tools.Connection;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;

public class ConnectionBuilder<B extends ConnectionBuilder<B>> {
    private final HashMap<String, Property> properties = new HashMap();
    private final CLocation sourceLocation;
    private final CLocation targetLocation;

    protected ConnectionBuilder(CLocation sourceLocation, CLocation targetLocation) {
        if (null == sourceLocation) {
            throw new IllegalArgumentException("sourceLocation cannot be null");
        }
        if (null == targetLocation) {
            throw new IllegalArgumentException("targetLocation cannot be null");
        }
        this.sourceLocation = sourceLocation;
        this.targetLocation = targetLocation;
    }

    public static final ConnectionBuilder create(CLocation sourceLocation, CLocation targetLocation) {
        return new ConnectionBuilder(sourceLocation, targetLocation);
    }

    public final B name(String name) {
        this.properties.put("name", new SimpleStringProperty(name));
        return (B)this;
    }

    public final B value(double value) {
        this.properties.put("value", new SimpleDoubleProperty(value));
        return (B)this;
    }

    public final B stroke(Color stroke) {
        this.properties.put("stroke", new SimpleObjectProperty<Color>(stroke));
        return (B)this;
    }

    public final B sourceColor(Color sourceColor) {
        this.properties.put("sourceColor", new SimpleObjectProperty<Color>(sourceColor));
        return (B)this;
    }

    public final B targetColor(Color targetColor) {
        this.properties.put("targetColor", new SimpleObjectProperty<Color>(targetColor));
        return (B)this;
    }

    public final B gradientFill(boolean gradientFill) {
        this.properties.put("gradientFill", new SimpleBooleanProperty(gradientFill));
        return (B)this;
    }

    public final B selectedStroke(Color selectedStroke) {
        this.properties.put("selectedStroke", new SimpleObjectProperty<Color>(selectedStroke));
        return (B)this;
    }

    public final B lineWidth(double lineWidth) {
        this.properties.put("lineWidth", new SimpleDoubleProperty(lineWidth));
        return (B)this;
    }

    public final B arrowsVisible(boolean arrowsVisible) {
        this.properties.put("arrowsVisible", new SimpleBooleanProperty(arrowsVisible));
        return (B)this;
    }

    public final B tooltipText(String tooltipText) {
        this.properties.put("tooltipText", new SimpleStringProperty(tooltipText));
        return (B)this;
    }

    public final Connection build() {
        Connection connection = new Connection(this.sourceLocation, this.targetLocation);
        this.properties.forEach((key, property) -> {
            if ("name".equals(key)) {
                connection.setName((String)((StringProperty)this.properties.get(key)).get());
            } else if ("value".equals(key)) {
                connection.setValue(((DoubleProperty)this.properties.get(key)).get());
            } else if ("stroke".equals(key)) {
                connection.setStroke((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("sourceColor".equals(key)) {
                connection.setSourceColor((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("targetColor".equals(key)) {
                connection.setTargetColor((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("gradientFill".equals(key)) {
                connection.setGradientFill(((BooleanProperty)this.properties.get(key)).get());
            } else if ("selectedStroke".equals(key)) {
                connection.setSelectedStroke((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("lineWidth".equals(key)) {
                connection.setLineWidth(((DoubleProperty)this.properties.get(key)).get());
            } else if ("arrowsVisible".equals(key)) {
                connection.setArrowsVisible(((BooleanProperty)this.properties.get(key)).get());
            } else if ("tooltipText".equals(key)) {
                connection.setTooltipText((String)((StringProperty)this.properties.get(key)).get());
            }
        });
        return connection;
    }
}

