# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Testing(Object):
    r"""
    Testing - a unified VTK regression testing framework
    
    Superclass: Object
    
    This is a VTK regression testing framework. Looks like this:
    
    
     Testing* t = Testing::New();
    
    
     Two options for setting arguments
    
    
     Option 1:
     for ( cc = 1; cc < argc; cc ++ )
       {
       t->add_argument(argv[cc]);
       }
    
    
     Option 2:
     t->add_argument("-D");
     t->add_argument(my_data_dir);
     t->add_argument("-V");
     t->add_argument(my_valid_image);
    
    
     ...
    
    
     Two options of doing testing:
    
    
     Option 1:
     t->set_render_window(renWin);
     int res = t->regression_test(threshold);
    
    
     Option 2:
     int res = t->regression_test(test_image, threshold);
    
    
     ...
    
    
     if (res == Testing::PASSED)
       {
       Test passed
       }
     else
       {
       Test failed
       }
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTesting, obj, update, **traits)
    
    front_buffer = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _front_buffer_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFrontBuffer,
                        self.front_buffer_)

    border_offset = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Number of pixels added as borders to avoid problems with window
        decorations added by some window managers.
        """
    )

    def _border_offset_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBorderOffset,
                        self.border_offset)

    data_root = traits.String('/build/VTKData', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _data_root_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDataRoot,
                        self.data_root)

    def _get_render_window(self):
        return wrap_vtk(self._vtk_obj.GetRenderWindow())
    def _set_render_window(self, arg):
        old_val = self._get_render_window()
        self._wrap_call(self._vtk_obj.SetRenderWindow,
                        deref_vtk(arg))
        self.trait_property_changed('render_window', old_val, arg)
    render_window = traits.Property(_get_render_window, _set_render_window, desc=\
        r"""
        
        """
    )

    temp_directory = traits.String('/build/mayavi/Testing/Temporary', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _temp_directory_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTempDirectory,
                        self.temp_directory)

    valid_image_file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Set/Get the name of the valid image file
        """
    )

    def _valid_image_file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetValidImageFileName,
                        self.valid_image_file_name)

    verbose = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set verbosity level. A level of 0 is quiet.
        """
    )

    def _verbose_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVerbose,
                        self.verbose)

    def get_argument(self, *args):
        """
        get_argument(self, arg:str) -> str
        C++: char *get_argument(const char *arg)
        Search for a specific argument by name and return its value
        (assumed to be the next on the command tail). Up to caller to
        delete the returned string.
        """
        ret = self._wrap_call(self._vtk_obj.GetArgument, *args)
        return ret

    def _get_image_difference(self):
        return self._vtk_obj.GetImageDifference()
    image_difference = traits.Property(_get_image_difference, desc=\
        r"""
        Get the image difference.
        """
    )

    def add_argument(self, *args):
        """
        add_argument(self, argv:str) -> None
        C++: void add_argument(const char *argv)
        Pass the command line arguments into this class to be processed.
        Many of the Get methods such as get_valid_image and get_baseline_root
        rely on the arguments to be passed in prior to retrieving these
        values. Just call add_argument for each argument that was passed
        into the command line
        """
        ret = self._wrap_call(self._vtk_obj.AddArgument, *args)
        return ret

    def clean_arguments(self):
        """
        clean_arguments(self) -> None
        C++: void clean_arguments()
        This method delete all arguments in Testing, this way you can
        reuse it in a loop where you would have multiple testing.
        """
        ret = self._vtk_obj.CleanArguments()
        return ret
        

    def compare_average_of_l2_norm(self, *args):
        """
        compare_average_of_l2_norm(self, dsA:DataSet, dsB:DataSet,
            tol:float) -> int
        C++: int compare_average_of_l2_norm(DataSet *dsA, DataSet *dsB,
            double tol)
        compare_average_of_l2_norm(self, daA:DataArray, daB:DataArray,
            tol:float) -> int
        C++: int compare_average_of_l2_norm(DataArray *daA,
            DataArray *daB, double tol)
        Compute the average L2 norm between all point data data arrays of
        types float and double present in the data sets "dsA" and "dsB"
        (this includes instances of Points) Compare the result of each
        L2 comutation to "tol".
        """
        my_args = deref_array(args, [('vtkDataSet', 'vtkDataSet', 'float'), ('vtkDataArray', 'vtkDataArray', 'float')])
        ret = self._wrap_call(self._vtk_obj.CompareAverageOfL2Norm, *my_args)
        return ret

    def is_flag_specified(self, *args):
        """
        is_flag_specified(self, flag:str) -> int
        C++: int is_flag_specified(const char *flag)
        Is some arbitrary user flag ("-X", "-Z" etc) specified
        """
        ret = self._wrap_call(self._vtk_obj.IsFlagSpecified, *args)
        return ret

    def is_interactive_mode_specified(self):
        """
        is_interactive_mode_specified(self) -> int
        C++: int is_interactive_mode_specified()
        Is the interactive mode specified?
        """
        ret = self._vtk_obj.IsInteractiveModeSpecified()
        return ret
        

    def is_valid_image_specified(self):
        """
        is_valid_image_specified(self) -> int
        C++: int is_valid_image_specified()
        Is a valid image specified on the command line areguments?
        """
        ret = self._vtk_obj.IsValidImageSpecified()
        return ret
        

    def regression_test(self, *args):
        """
        regression_test(self, thresh:float) -> int
        C++: virtual int regression_test(double thresh)
        regression_test(self, pngFileName:str, thresh:float) -> int
        C++: virtual int regression_test(const std::string &pngFileName,
            double thresh)
        regression_test(self, imageSource:Algorithm, thresh:float)
            -> int
        C++: virtual int regression_test(Algorithm *imageSource,
            double thresh)
        Perform the test and return the result. Delegates to
        regression_test_and_capture_output, sending the output to cout.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RegressionTest, *my_args)
        return ret

    _updateable_traits_ = \
    (('front_buffer', 'GetFrontBuffer'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('border_offset', 'GetBorderOffset'), ('data_root', 'GetDataRoot'),
    ('temp_directory', 'GetTempDirectory'), ('valid_image_file_name',
    'GetValidImageFileName'), ('verbose', 'GetVerbose'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'front_buffer', 'global_warning_display', 'border_offset',
    'data_root', 'temp_directory', 'valid_image_file_name', 'verbose'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Testing, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Testing properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['front_buffer'], [], ['border_offset', 'data_root',
            'temp_directory', 'valid_image_file_name', 'verbose']),
            title='Edit Testing properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Testing properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

