# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.directed_graph_algorithm import DirectedGraphAlgorithm


class ReebGraphToJoinSplitTreeFilter(DirectedGraphAlgorithm):
    r"""
    ReebGraphToJoinSplitTreeFilter - converts a given Reeb graph
    either to a join tree or a split tree (respectively the connectivity
    of the sub- and sur- level sets).
    
    Superclass: DirectedGraphAlgorithm
    
    Note: if you want to use simplification filters, do so on the input
    Reeb graph first.
    
    Reference: "Computing contpour trees in all dimensions". H. Carr, J.
    Snoeyink, U. Axen. SODA 2000, pp. 918-926.
    
    The filter takes as an input the underlying mesh (port 0, a
    PolyData for 2D meshes or a UnstructuredGrid for 3D meshes)
    with an attached scalar field (identified by field_id, with
    setfield_id()) and an input Reeb graph computed on that mesh (port 1).
    The outputs is ReebGraph object describing either a join or split
    tree.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkReebGraphToJoinSplitTreeFilter, obj, update, **traits)
    
    field_id = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set the scalar field Id Default value: 0;
        """
    )

    def _field_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFieldId,
                        self.field_id)

    is_split_tree = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Specify if you want to get a join or a split tree. Default value:
        false (join tree)
        """
    )

    def _is_split_tree_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIsSplitTree,
                        self.is_split_tree)

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('field_id',
    'GetFieldId'), ('is_split_tree', 'GetIsSplitTree'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'field_id', 'is_split_tree', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ReebGraphToJoinSplitTreeFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ReebGraphToJoinSplitTreeFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['field_id', 'is_split_tree']),
            title='Edit ReebGraphToJoinSplitTreeFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ReebGraphToJoinSplitTreeFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

