# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.archiver import Archiver


class PartitionedArchiver(Archiver):
    r"""
    PartitionedArchiver - Writes an archive to several buffers
    
    Superclass: Archiver
    
    PartitionedArchiver is a specialized archiver for writing datasets
    into several memory buffers with zip compression. Each insertion into
    the archiver is assigned to its own buffer.
    
    @sa
    Archiver
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPartitionedArchiver, obj, update, **traits)
    
    def get_buffer(self, *args):
        """
        get_buffer(self, relativePath:str) -> str
        C++: const char *get_buffer(const char *relativePath)
        Access the buffer.
        """
        ret = self._wrap_call(self._vtk_obj.GetBuffer, *args)
        return ret

    def get_buffer_address(self, *args):
        """
        get_buffer_address(self, relativePath:str) -> Pointer
        C++: const void *get_buffer_address(const char *relativePath)
        Access the address of the buffer.
        """
        ret = self._wrap_call(self._vtk_obj.GetBufferAddress, *args)
        return ret

    def get_buffer_name(self, *args):
        """
        get_buffer_name(self, i:int) -> str
        C++: const char *get_buffer_name(std::size_t i)
        Get the name of buffer i.
        """
        ret = self._wrap_call(self._vtk_obj.GetBufferName, *args)
        return ret

    def get_buffer_size(self, *args):
        """
        get_buffer_size(self, relativePath:str) -> int
        C++: std::size_t get_buffer_size(const char *relativePath)
        Get the buffer used size.
        """
        ret = self._wrap_call(self._vtk_obj.GetBufferSize, *args)
        return ret

    def _get_number_of_buffers(self):
        return self._vtk_obj.GetNumberOfBuffers()
    number_of_buffers = traits.Property(_get_number_of_buffers, desc=\
        r"""
        Get the number of buffers in the archive.
        """
    )

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('archive_name', 'GetArchiveName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'archive_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PartitionedArchiver, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PartitionedArchiver properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['archive_name']),
            title='Edit PartitionedArchiver properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PartitionedArchiver properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

