# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class ParallelTimer(Object):
    r"""
    ParallelTimer -  Provides distributed log functionality.
    
    Superclass: Object
    
    When the file is
     written each process data is collected by rank 0 who
     writes the data to a single file in rank order.
    
    
     The log works as an event stack. event_start pushes the
     event identifier and its start time onto the stack. event_end
     pops the most recent event time and identifier computes the
     elapsed time and adds an entry to the log recording the
     event, it's start and end times, and its elapsed time.
     end_event_synch includes a barrier before the measurement.
    
    
     The log class implements the singleton pattern so that it
     may be shared across class boundaries. If the log instance
     doesn't exist then one is created. It will be automatically
     destroyed at exit by the signleton destructor. It can be
     destroyed explicitly by calling delete_global_instance.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkParallelTimer, obj, update, **traits)
    
    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    global_level = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the global log level. Applications can set this to the
        desired level so that all pipeline objects will log data.
        """
    )

    def _global_level_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGlobalLevel,
                        self.global_level)

    write_on_close = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        If enabled and used as a singleton the log will write it's
        contents to disk during program termination.
        """
    )

    def _write_on_close_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWriteOnClose,
                        self.write_on_close)

    writer_rank = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set the rank who writes.
        """
    )

    def _writer_rank_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWriterRank,
                        self.writer_rank)

    def _get_global_instance(self):
        return wrap_vtk(self._vtk_obj.GetGlobalInstance())
    global_instance = traits.Property(_get_global_instance, desc=\
        r"""
        The log class implements the singleton pattern so that it may be
        shared across class boundaries. If the log instance doesn't exist
        then one is created. It will be automatically destroyed at exit
        by the signleton destructor. It can be destroyed explicitly by
        calling delete_global_instance.
        """
    )

    def clear(self):
        """
        clear(self) -> None
        C++: void clear()
        Clear the log.
        """
        ret = self._vtk_obj.Clear()
        return ret
        

    def delete_global_instance(self):
        """
        delete_global_instance() -> None
        C++: static void delete_global_instance()
        Explicitly delete the singleton.
        """
        ret = self._vtk_obj.DeleteGlobalInstance()
        return ret
        

    def end_event(self, *args):
        """
        end_event(self, event:str) -> None
        C++: void end_event(const char *event)
        end_event(self, rank:int, event:str) -> None
        C++: void end_event(int rank, const char *event)"""
        ret = self._wrap_call(self._vtk_obj.EndEvent, *args)
        return ret

    def end_event_synch(self, *args):
        """
        end_event_synch(self, event:str) -> None
        C++: void end_event_synch(const char *event)
        end_event_synch(self, rank:int, event:str) -> None
        C++: void end_event_synch(int rank, const char *event)"""
        ret = self._wrap_call(self._vtk_obj.EndEventSynch, *args)
        return ret

    def start_event(self, *args):
        """
        start_event(self, event:str) -> None
        C++: void start_event(const char *event)
        start_event(self, rank:int, event:str) -> None
        C++: void start_event(int rank, const char *event)
        The log works as an event stack. event_start pushes the event
        identifier and its start time onto the stack. event_end pops the
        most recent event time and identifier computes the elapsed time
        and adds an entry to the log recording the event, it's start and
        end times, and its elapsed time. end_event_synch includes a barrier
        before the measurement.
        """
        ret = self._wrap_call(self._vtk_obj.StartEvent, *args)
        return ret

    def update(self):
        """
        update(self) -> None
        C++: void update()
        When an object is finished writing data to the log object it must
        call Update to send the data to the writer rank. This ensures
        that all data is transferred to the root before MPI_Finalize is
        called while allowing the write to occur after Mpi_finalize.
        Note: This is a collective call.
        """
        ret = self._vtk_obj.Update()
        return ret
        

    def write(self):
        """
        write(self) -> int
        C++: int write()
        Write the log contents to a file.
        """
        ret = self._vtk_obj.Write()
        return ret
        

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('file_name', 'GetFileName'),
    ('global_level', 'GetGlobalLevel'), ('write_on_close',
    'GetWriteOnClose'), ('writer_rank', 'GetWriterRank'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'file_name', 'global_level',
    'write_on_close', 'writer_rank'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ParallelTimer, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ParallelTimer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['file_name', 'global_level', 'write_on_close',
            'writer_rank']),
            title='Edit ParallelTimer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ParallelTimer properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

