# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.renderer_node import RendererNode


class OSPRayRendererNode(RendererNode):
    r"""
    OSPRayRendererNode - links Renderers to OSPRay
    
    Superclass: RendererNode
    
    Translates Renderer state into OSPRay rendering calls
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOSPRayRendererNode, obj, update, **traits)
    
    def get_ambient_samples(self, *args):
        """
        get_ambient_samples(renderer:Renderer) -> int
        C++: static int get_ambient_samples(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetAmbientSamples, *my_args)
        return ret

    def set_ambient_samples(self, *args):
        """
        set_ambient_samples(__a:int, renderer:Renderer) -> None
        C++: static void set_ambient_samples(int, Renderer *renderer)
        Convenience method to set/get AMBIENT_SAMPLES on a Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetAmbientSamples, *my_args)
        return ret

    def get_background_mode(self, *args):
        """
        get_background_mode(renderer:Renderer) -> BackgroundMode
        C++: static BackgroundMode get_background_mode(
            Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetBackgroundMode, *my_args)
        return ret

    def set_background_mode(self, *args):
        """
        set_background_mode(__a:BackgroundMode, renderer:Renderer)
            -> None
        C++: static void set_background_mode(BackgroundMode,
            Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetBackgroundMode, *my_args)
        return ret

    def get_composite_on_gl(self, *args):
        """
        get_composite_on_gl(renderer:Renderer) -> int
        C++: static int get_composite_on_gl(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetCompositeOnGL, *my_args)
        return ret

    def set_composite_on_gl(self, *args):
        """
        set_composite_on_gl(__a:int, renderer:Renderer) -> None
        C++: static void set_composite_on_gl(int, Renderer *renderer)
        Convenience method to set/get COMPOSITE_ON_GL on a Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetCompositeOnGL, *my_args)
        return ret

    def get_denoiser_threshold(self, *args):
        """
        get_denoiser_threshold(renderer:Renderer) -> int
        C++: static int get_denoiser_threshold(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetDenoiserThreshold, *my_args)
        return ret

    def set_denoiser_threshold(self, *args):
        """
        set_denoiser_threshold(__a:int, renderer:Renderer) -> None
        C++: static void set_denoiser_threshold(int, Renderer *renderer)
        Convenience method to set/get DENOISER_THRESHOLD on a
        Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetDenoiserThreshold, *my_args)
        return ret

    def get_east_pole(self, *args):
        """
        get_east_pole(renderer:Renderer) -> Pointer
        C++: static double *get_east_pole(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetEastPole, *my_args)
        return ret

    def set_east_pole(self, *args):
        """
        set_east_pole(__a:[float, ...], renderer:Renderer) -> None
        C++: static void set_east_pole(double *, Renderer *renderer)
        Convenience method to set/get EAST_POLE on a Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetEastPole, *my_args)
        return ret

    def get_enable_denoiser(self, *args):
        """
        get_enable_denoiser(renderer:Renderer) -> int
        C++: static int get_enable_denoiser(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetEnableDenoiser, *my_args)
        return ret

    def set_enable_denoiser(self, *args):
        """
        set_enable_denoiser(__a:int, renderer:Renderer) -> None
        C++: static void set_enable_denoiser(int, Renderer *renderer)
        Convenience method to set/get ENABLE_DENOISER on a Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetEnableDenoiser, *my_args)
        return ret

    def get_material_library(self, *args):
        """
        get_material_library(renderer:Renderer)
            -> OSPRayMaterialLibrary
        C++: static OSPRayMaterialLibrary *get_material_library(
            Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetMaterialLibrary, *my_args)
        return wrap_vtk(ret)

    def set_material_library(self, *args):
        """
        set_material_library(__a:OSPRayMaterialLibrary,
            renderer:Renderer) -> None
        C++: static void set_material_library(OSPRayMaterialLibrary *,
            Renderer *renderer)
        Convenience method to set/get Material library on a renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetMaterialLibrary, *my_args)
        return ret

    def get_max_contribution(self, *args):
        """
        get_max_contribution(renderer:Renderer) -> float
        C++: static double get_max_contribution(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetMaxContribution, *my_args)
        return ret

    def set_max_contribution(self, *args):
        """
        set_max_contribution(__a:float, renderer:Renderer) -> None
        C++: static void set_max_contribution(double, Renderer *renderer)
        Convenience method to set/get MAX_CONTRIBUTION on a Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetMaxContribution, *my_args)
        return ret

    def get_max_depth(self, *args):
        """
        get_max_depth(renderer:Renderer) -> int
        C++: static int get_max_depth(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetMaxDepth, *my_args)
        return ret

    def set_max_depth(self, *args):
        """
        set_max_depth(__a:int, renderer:Renderer) -> None
        C++: static void set_max_depth(int, Renderer *renderer)
        Convenience method to set/get MAX_DEPTH on a Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetMaxDepth, *my_args)
        return ret

    def get_max_frames(self, *args):
        """
        get_max_frames(renderer:Renderer) -> int
        C++: static int get_max_frames(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetMaxFrames, *my_args)
        return ret

    def set_max_frames(self, *args):
        """
        set_max_frames(__a:int, renderer:Renderer) -> None
        C++: static void set_max_frames(int, Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetMaxFrames, *my_args)
        return ret

    def get_min_contribution(self, *args):
        """
        get_min_contribution(renderer:Renderer) -> float
        C++: static double get_min_contribution(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetMinContribution, *my_args)
        return ret

    def set_min_contribution(self, *args):
        """
        set_min_contribution(__a:float, renderer:Renderer) -> None
        C++: static void set_min_contribution(double, Renderer *renderer)
        Convenience method to set/get MIN_CONTRIBUTION on a Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetMinContribution, *my_args)
        return ret

    def get_north_pole(self, *args):
        """
        get_north_pole(renderer:Renderer) -> Pointer
        C++: static double *get_north_pole(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetNorthPole, *my_args)
        return ret

    def set_north_pole(self, *args):
        """
        set_north_pole(__a:[float, ...], renderer:Renderer) -> None
        C++: static void set_north_pole(double *, Renderer *renderer)
        Convenience method to set/get NORTH_POLE on a Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetNorthPole, *my_args)
        return ret

    def get_renderer_type(self, *args):
        """
        get_renderer_type(renderer:Renderer) -> str
        C++: static std::string get_renderer_type(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetRendererType, *my_args)
        return ret

    def set_renderer_type(self, *args):
        """
        set_renderer_type(name:str, renderer:Renderer) -> None
        C++: static void set_renderer_type(std::string name,
            Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetRendererType, *my_args)
        return ret

    def get_roulette_depth(self, *args):
        """
        get_roulette_depth(renderer:Renderer) -> int
        C++: static int get_roulette_depth(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetRouletteDepth, *my_args)
        return ret

    def set_roulette_depth(self, *args):
        """
        set_roulette_depth(__a:int, renderer:Renderer) -> None
        C++: static void set_roulette_depth(int, Renderer *renderer)
        Convenience method to set/get ROULETTE_DEPTH on a Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetRouletteDepth, *my_args)
        return ret

    def get_samples_per_pixel(self, *args):
        """
        get_samples_per_pixel(renderer:Renderer) -> int
        C++: static int get_samples_per_pixel(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetSamplesPerPixel, *my_args)
        return ret

    def set_samples_per_pixel(self, *args):
        """
        set_samples_per_pixel(__a:int, renderer:Renderer) -> None
        C++: static void set_samples_per_pixel(int, Renderer *renderer)
        Convenience method to set/get SAMPLES_PER_PIXEL on a Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSamplesPerPixel, *my_args)
        return ret

    def get_time_cache_size(self, *args):
        """
        get_time_cache_size(renderer:Renderer) -> int
        C++: static int get_time_cache_size(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetTimeCacheSize, *my_args)
        return ret

    def set_time_cache_size(self, *args):
        """
        set_time_cache_size(__a:int, renderer:Renderer) -> None
        C++: static void set_time_cache_size(int, Renderer *renderer)
        Convenience method to set/get TIME_CACHE_SIZE on a Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetTimeCacheSize, *my_args)
        return ret

    def get_variance_threshold(self, *args):
        """
        get_variance_threshold(renderer:Renderer) -> float
        C++: static double get_variance_threshold(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetVarianceThreshold, *my_args)
        return ret

    def set_variance_threshold(self, *args):
        """
        set_variance_threshold(__a:float, renderer:Renderer) -> None
        C++: static void set_variance_threshold(double,
            Renderer *renderer)
        Convenience method to set/get VARIANCE_THRESHOLD on a
        Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetVarianceThreshold, *my_args)
        return ret

    def get_view_time(self, *args):
        """
        get_view_time(renderer:Renderer) -> float
        C++: static double get_view_time(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetViewTime, *my_args)
        return ret

    def set_view_time(self, *args):
        """
        set_view_time(__a:float, renderer:Renderer) -> None
        C++: static void set_view_time(double, Renderer *renderer)
        Convenience method to set/get VIEW_TIME on a Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetViewTime, *my_args)
        return ret

    def get_volume_anisotropy(self, *args):
        """
        get_volume_anisotropy(renderer:Renderer) -> float
        C++: static double get_volume_anisotropy(Renderer *renderer)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetVolumeAnisotropy, *my_args)
        return ret

    def set_volume_anisotropy(self, *args):
        """
        set_volume_anisotropy(__a:float, renderer:Renderer) -> None
        C++: static void set_volume_anisotropy(double,
            Renderer *renderer)
        Convenience method to set/get VOLUME_ANISOTROPY on a Renderer.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetVolumeAnisotropy, *my_args)
        return ret

    def _get_buffer(self):
        return self._vtk_obj.GetBuffer()
    buffer = traits.Property(_get_buffer, desc=\
        r"""
        Get the last rendered color_buffer
        """
    )

    def _get_color_buffer_texture_gl(self):
        return self._vtk_obj.GetColorBufferTextureGL()
    color_buffer_texture_gl = traits.Property(_get_color_buffer_texture_gl, desc=\
        r"""
        
        """
    )

    def _get_depth_buffer_texture_gl(self):
        return self._vtk_obj.GetDepthBufferTextureGL()
    depth_buffer_texture_gl = traits.Property(_get_depth_buffer_texture_gl, desc=\
        r"""
        
        """
    )

    def _get_renderer(self):
        return wrap_vtk(self._vtk_obj.GetRenderer())
    renderer = traits.Property(_get_renderer, desc=\
        r"""
        
        """
    )

    def get_renderer_node(self, *args):
        """
        get_renderer_node(__a:ViewNode) -> OSPRayRendererNode
        C++: static OSPRayRendererNode *get_renderer_node(ViewNode *)
        Convenience method to get and downcast renderable.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetRendererNode, *my_args)
        return wrap_vtk(ret)

    def _get_z_buffer(self):
        return self._vtk_obj.GetZBuffer()
    z_buffer = traits.Property(_get_z_buffer, desc=\
        r"""
        Get the last rendered ZBuffer
        """
    )

    def AMBIENT_SAMPLES(self):
        """
        ambient__samples() -> InformationIntegerKey
        C++: static InformationIntegerKey *ambient__samples()
        When present on renderer, controls the number of ambient
        occlusion samples shot per hit. default is 4
        """
        ret = wrap_vtk(self._vtk_obj.AMBIENT_SAMPLES())
        return ret
        

    def BACKGROUND_MODE(self):
        """
        background__mode() -> InformationIntegerKey
        C++: static InformationIntegerKey *background__mode()
        Control use of the path tracer backplate and environmental
        background. 0 means neither is shown, 1 means only backplate is
        shown, 2 (the default) means only environment is shown, 3 means
        that both are enabled and therefore backblate shows on screen but
        actors acquire color from the environment.
        """
        ret = wrap_vtk(self._vtk_obj.BACKGROUND_MODE())
        return ret
        

    def COMPOSITE_ON_GL(self):
        """
        composite__on__gl() -> InformationIntegerKey
        C++: static InformationIntegerKey *composite__on__gl()
        used to make the renderer add ospray's content onto GL rendered
        content on the window
        """
        ret = wrap_vtk(self._vtk_obj.COMPOSITE_ON_GL())
        return ret
        

    def DENOISER_THRESHOLD(self):
        """
        denoiser__threshold() -> InformationIntegerKey
        C++: static InformationIntegerKey *denoiser__threshold()
        Accumulation threshold when above which denoising kicks in.
        """
        ret = wrap_vtk(self._vtk_obj.DENOISER_THRESHOLD())
        return ret
        

    def EAST_POLE(self):
        """
        east__pole() -> InformationDoubleVectorKey
        C++: static InformationDoubleVectorKey *east__pole()
        World space direction of east pole for texture background.
        """
        ret = wrap_vtk(self._vtk_obj.EAST_POLE())
        return ret
        

    def ENABLE_DENOISER(self):
        """
        enable__denoiser() -> InformationIntegerKey
        C++: static InformationIntegerKey *enable__denoiser()
        Enable denoising (if supported).
        """
        ret = wrap_vtk(self._vtk_obj.ENABLE_DENOISER())
        return ret
        

    def MATERIAL_LIBRARY(self):
        """
        material__library() -> InformationObjectBaseKey
        C++: static InformationObjectBaseKey *material__library()
        Material Library attached to the renderer.
        """
        ret = wrap_vtk(self._vtk_obj.MATERIAL_LIBRARY())
        return ret
        

    def MAX_CONTRIBUTION(self):
        """
        max__contribution() -> InformationDoubleKey
        C++: static InformationDoubleKey *max__contribution()
        When present on renderer, samples are clamped to this value
        before they are accumulated into the framebuffer default is 2.0
        """
        ret = wrap_vtk(self._vtk_obj.MAX_CONTRIBUTION())
        return ret
        

    def MAX_DEPTH(self):
        """
        max__depth() -> InformationIntegerKey
        C++: static InformationIntegerKey *max__depth()
        When present on renderer, controls the maximum ray recursion
        depth default is 20
        """
        ret = wrap_vtk(self._vtk_obj.MAX_DEPTH())
        return ret
        

    def MAX_FRAMES(self):
        """
        max__frames() -> InformationIntegerKey
        C++: static InformationIntegerKey *max__frames()
        When present on renderer, controls the number of ospray render
        calls for each refresh. default is 1
        """
        ret = wrap_vtk(self._vtk_obj.MAX_FRAMES())
        return ret
        

    def MIN_CONTRIBUTION(self):
        """
        min__contribution() -> InformationDoubleKey
        C++: static InformationDoubleKey *min__contribution()
        When present on renderer, sample contributions below this value
        will be neglected to speedup rendering default is 0.01
        """
        ret = wrap_vtk(self._vtk_obj.MIN_CONTRIBUTION())
        return ret
        

    def NORTH_POLE(self):
        """
        north__pole() -> InformationDoubleVectorKey
        C++: static InformationDoubleVectorKey *north__pole()
        World space direction of north pole for gradient and texture
        background.
        """
        ret = wrap_vtk(self._vtk_obj.NORTH_POLE())
        return ret
        

    def RENDERER_TYPE(self):
        """
        renderer__type() -> InformationStringKey
        C++: static InformationStringKey *renderer__type()
        Set the OSPRay renderer type to use (e.g. scivis vs. pathtracer)
        default is scivis
        """
        ret = wrap_vtk(self._vtk_obj.RENDERER_TYPE())
        return ret
        

    def ROULETTE_DEPTH(self):
        """
        roulette__depth() -> InformationIntegerKey
        C++: static InformationIntegerKey *roulette__depth()
        When present on renderer, controls the ray recursion depth at
        which to start Russian roulette termination default is 5
        """
        ret = wrap_vtk(self._vtk_obj.ROULETTE_DEPTH())
        return ret
        

    def SAMPLES_PER_PIXEL(self):
        """
        samples__per__pixel() -> InformationIntegerKey
        C++: static InformationIntegerKey *samples__per__pixel()
        When present on renderer, controls the number of primary rays
        shot per pixel default is 1
        """
        ret = wrap_vtk(self._vtk_obj.SAMPLES_PER_PIXEL())
        return ret
        

    def TIME_CACHE_SIZE(self):
        """
        time__cache__size() -> InformationIntegerKey
        C++: static InformationIntegerKey *time__cache__size()
        Temporal cache size.
        """
        ret = wrap_vtk(self._vtk_obj.TIME_CACHE_SIZE())
        return ret
        

    def VARIANCE_THRESHOLD(self):
        """
        variance__threshold() -> InformationDoubleKey
        C++: static InformationDoubleKey *variance__threshold()
        When present on renderer, controls the threshold for adaptive
        accumulation default is 0.3
        """
        ret = wrap_vtk(self._vtk_obj.VARIANCE_THRESHOLD())
        return ret
        

    def VIEW_TIME(self):
        """
        view__time() -> InformationDoubleKey
        C++: static InformationDoubleKey *view__time()
        Requested time to show in a renderer and to lookup in a temporal
        cache.
        """
        ret = wrap_vtk(self._vtk_obj.VIEW_TIME())
        return ret
        

    def VOLUME_ANISOTROPY(self):
        """
        volume__anisotropy() -> InformationDoubleKey
        C++: static InformationDoubleKey *volume__anisotropy()
        When present on renderer, affects path traced rendering phase
        function.
        
        valid values are between -1.0 and 1.0. The default is 0.0.
        """
        ret = wrap_vtk(self._vtk_obj.VOLUME_ANISOTROPY())
        return ret
        

    def write_layer(self, *args):
        """
        write_layer(self, buffer:[int, ...], zbuffer:[float, ...],
            buffx:int, buffy:int, layer:int) -> None
        C++: virtual void write_layer(unsigned char *buffer,
            float *zbuffer, int buffx, int buffy, int layer)
        Put my results into the correct place in the provided pixel
        buffer.
        """
        ret = self._wrap_call(self._vtk_obj.WriteLayer, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('scale', 'GetScale'), ('size',
    'GetSize'), ('viewport', 'GetViewport'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'scale', 'size', 'viewport'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OSPRayRendererNode, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OSPRayRendererNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['scale', 'size', 'viewport']),
            title='Edit OSPRayRendererNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OSPRayRendererNode properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

