# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class ObjectIdMap(Object):
    r"""
    ObjectIdMap - class used to assign Id to any VTK object and be
    able to retrieve it base on its id.
    
    Superclass: Object
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkObjectIdMap, obj, update, **traits)
    
    def get_active_object(self, *args):
        """
        get_active_object(self, objectType:str) -> Object
        C++: Object *get_active_object(const char *objectType)
        Retrieve a previously stored object based on a name
        """
        ret = self._wrap_call(self._vtk_obj.GetActiveObject, *args)
        return wrap_vtk(ret)

    def set_active_object(self, *args):
        """
        set_active_object(self, objectType:str, obj:Object) -> int
        C++: TypeUInt32 set_active_object(const char *objectType,
            Object *obj)
        Assign an active key (string) to an existing object. This is
        usually used to provide another type of access to specific
        Object that we want to retrieve easily using a string. Return
        the global Id of the given registered object
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetActiveObject, *my_args)
        return ret

    def get_global_id(self, *args):
        """
        get_global_id(self, obj:Object) -> int
        C++: TypeUInt32 get_global_id(Object *obj)
        Retrieve a unique identifier for the given object or generate a
        new one if its global id was never requested.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetGlobalId, *my_args)
        return ret

    def get_vtk_object(self, *args):
        """
        get_vtk_object(self, globalId:int) -> Object
        C++: Object *get_vtk_object(TypeUInt32 globalId)
        Retrieve a Object based on its global id. If not found return
        nullptr
        """
        ret = self._wrap_call(self._vtk_obj.GetVTKObject, *args)
        return wrap_vtk(ret)

    def free_object(self, *args):
        """
        free_object(self, obj:Object) -> bool
        C++: bool free_object(Object *obj)
        Given an object, remove any internal reference count due to
        internal Id/Object mapping. Returns true if the item existed in
        the map and was deleted.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.FreeObject, *my_args)
        return ret

    def free_object_by_id(self, *args):
        """
        free_object_by_id(self, id:int) -> bool
        C++: bool free_object_by_id(TypeUInt32 id)
        Given an id, remove any internal reference count due to internal
        Id/Object mapping. Returns true if the id existed in the map and
        was deleted.
        """
        ret = self._wrap_call(self._vtk_obj.FreeObjectById, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ObjectIdMap, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ObjectIdMap properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit ObjectIdMap properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ObjectIdMap properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

