# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class Information(Object):
    r"""
    Information - Store Algorithm input/output information.
    
    Superclass: Object
    
    Information represents information and/or data for one input or
    one output of a Algorithm.  It maps from keys to values of several
    data types.  Instances of this class are collected in
    InformationVector instances and passed to
    Algorithm::ProcessRequest calls.  The information and data
    referenced by the instance on a particular input or output define the
    request made to the Algorithm instance.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkInformation, obj, update, **traits)
    
    def _get_request(self):
        return wrap_vtk(self._vtk_obj.GetRequest())
    def _set_request(self, arg):
        old_val = self._get_request()
        self._wrap_call(self._vtk_obj.SetRequest,
                        deref_vtk(arg))
        self.trait_property_changed('request', old_val, arg)
    request = traits.Property(_get_request, _set_request, desc=\
        r"""
        
        """
    )

    def get_key(self, *args):
        """
        get_key(key:InformationDataObjectKey) -> InformationKey
        C++: static InformationKey *get_key(
            InformationDataObjectKey *key)
        get_key(key:InformationDoubleKey) -> InformationKey
        C++: static InformationKey *get_key(
            InformationDoubleKey *key)
        get_key(key:InformationDoubleVectorKey) -> InformationKey
        C++: static InformationKey *get_key(
            InformationDoubleVectorKey *key)
        get_key(key:InformationInformationKey) -> InformationKey
        C++: static InformationKey *get_key(
            InformationInformationKey *key)
        get_key(key:InformationInformationVectorKey)
            -> InformationKey
        C++: static InformationKey *get_key(
            InformationInformationVectorKey *key)
        get_key(key:InformationIntegerKey) -> InformationKey
        C++: static InformationKey *get_key(
            InformationIntegerKey *key)
        get_key(key:InformationIntegerVectorKey) -> InformationKey
        C++: static InformationKey *get_key(
            InformationIntegerVectorKey *key)
        get_key(key:InformationRequestKey) -> InformationKey
        C++: static InformationKey *get_key(
            InformationRequestKey *key)
        get_key(key:InformationStringKey) -> InformationKey
        C++: static InformationKey *get_key(
            InformationStringKey *key)
        get_key(key:InformationStringVectorKey) -> InformationKey
        C++: static InformationKey *get_key(
            InformationStringVectorKey *key)
        get_key(key:InformationKey) -> InformationKey
        C++: static InformationKey *get_key(InformationKey *key)
        get_key(key:InformationUnsignedLongKey) -> InformationKey
        C++: static InformationKey *get_key(
            InformationUnsignedLongKey *key)
        get_key(key:InformationVariantKey) -> InformationKey
        C++: static InformationKey *get_key(
            InformationVariantKey *key)
        get_key(key:InformationVariantVectorKey) -> InformationKey
        C++: static InformationKey *get_key(
            InformationVariantVectorKey *key)
        Upcast the given key instance.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetKey, *my_args)
        return wrap_vtk(ret)

    def _get_number_of_keys(self):
        return self._vtk_obj.GetNumberOfKeys()
    number_of_keys = traits.Property(_get_number_of_keys, desc=\
        r"""
        Return the number of keys in this information object (as would be
        returned by iterating over the keys).
        """
    )

    def append(self, *args):
        """
        append(self, from_:Information, deep:int=0) -> None
        C++: void append(Information *from, int deep=0)
        append(self, key:InformationIntegerVectorKey, value:int)
            -> None
        C++: void append(InformationIntegerVectorKey *key, int value)
        append(self, key:InformationStringVectorKey, value:str) -> None
        C++: void append(InformationStringVectorKey *key,
            const std::string &value)
        append(self, key:InformationDoubleVectorKey, value:float)
            -> None
        C++: void append(InformationDoubleVectorKey *key, double value)
        append(self, key:InformationVariantVectorKey, value:Variant)
             -> None
        C++: void append(InformationVariantVectorKey *key,
            const Variant &value)
        append(self, key:InformationKeyVectorKey,
            value:InformationKey) -> None
        C++: void append(InformationKeyVectorKey *key,
            InformationKey *value)
        append(self, key:InformationKeyVectorKey,
            value:InformationDataObjectKey) -> None
        C++: void append(InformationKeyVectorKey *key,
            InformationDataObjectKey *value)
        append(self, key:InformationKeyVectorKey,
            value:InformationDoubleKey) -> None
        C++: void append(InformationKeyVectorKey *key,
            InformationDoubleKey *value)
        append(self, key:InformationKeyVectorKey,
            value:InformationDoubleVectorKey) -> None
        C++: void append(InformationKeyVectorKey *key,
            InformationDoubleVectorKey *value)
        append(self, key:InformationKeyVectorKey,
            value:InformationInformationKey) -> None
        C++: void append(InformationKeyVectorKey *key,
            InformationInformationKey *value)
        append(self, key:InformationKeyVectorKey,
            value:InformationInformationVectorKey) -> None
        C++: void append(InformationKeyVectorKey *key,
            InformationInformationVectorKey *value)
        append(self, key:InformationKeyVectorKey,
            value:InformationIntegerKey) -> None
        C++: void append(InformationKeyVectorKey *key,
            InformationIntegerKey *value)
        Append all information ...
         [Truncated]
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Append, *my_args)
        return ret

    def append_unique(self, *args):
        """
        append_unique(self, key:InformationKeyVectorKey,
            value:InformationKey) -> None
        C++: void append_unique(InformationKeyVectorKey *key,
            InformationKey *value)
        append_unique(self, key:InformationKeyVectorKey,
            value:InformationDataObjectKey) -> None
        C++: void append_unique(InformationKeyVectorKey *key,
            InformationDataObjectKey *value)
        append_unique(self, key:InformationKeyVectorKey,
            value:InformationDoubleKey) -> None
        C++: void append_unique(InformationKeyVectorKey *key,
            InformationDoubleKey *value)
        append_unique(self, key:InformationKeyVectorKey,
            value:InformationDoubleVectorKey) -> None
        C++: void append_unique(InformationKeyVectorKey *key,
            InformationDoubleVectorKey *value)
        append_unique(self, key:InformationKeyVectorKey,
            value:InformationInformationKey) -> None
        C++: void append_unique(InformationKeyVectorKey *key,
            InformationInformationKey *value)
        append_unique(self, key:InformationKeyVectorKey,
            value:InformationInformationVectorKey) -> None
        C++: void append_unique(InformationKeyVectorKey *key,
            InformationInformationVectorKey *value)
        append_unique(self, key:InformationKeyVectorKey,
            value:InformationIntegerKey) -> None
        C++: void append_unique(InformationKeyVectorKey *key,
            InformationIntegerKey *value)
        append_unique(self, key:InformationKeyVectorKey,
            value:InformationIntegerVectorKey) -> None
        C++: void append_unique(InformationKeyVectorKey *key,
            InformationIntegerVectorKey *value)
        append_unique(self, key:InformationKeyVectorKey,
            value:InformationStringKey) -> None
        C++: void append_unique(InformationKeyVectorKey *key,
            InformationStringKey *value)
        append_unique(self, key:InformationKeyVectorKey,
            value:InformationStringVectorKey) -> None
        C++: void append_unique(InformationKeyVectorKey *key,
            InformationStringVectorKey *value)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AppendUnique, *my_args)
        return ret

    def clear(self):
        """
        clear(self) -> None
        C++: void clear()
        Clear all information entries.
        """
        ret = self._vtk_obj.Clear()
        return ret
        

    def copy(self, *args):
        """
        copy(self, from_:Information, deep:int=0) -> None
        C++: void copy(Information *from, int deep=0)
        Copy all information entries from the given Information
        instance.  Any previously existing entries are removed.  If
        deep==1, a deep copy of the information structure is performed
        (new instances of any contained Information and
        InformationVector objects are created).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Copy, *my_args)
        return ret

    def copy_entries(self, *args):
        """
        copy_entries(self, from_:Information,
            key:InformationKeyVectorKey, deep:int=0) -> None
        C++: void copy_entries(Information *from,
            InformationKeyVectorKey *key, int deep=0)
        Use the given key to lookup a list of other keys in the given
        information object.  The key/value pairs associated with these
        other keys will be copied.  If deep==1, a deep copy of the
        information structure is performed.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyEntries, *my_args)
        return ret

    def copy_entry(self, *args):
        """
        copy_entry(self, from_:Information, key:InformationKey,
            deep:int=0) -> None
        C++: void copy_entry(Information *from, InformationKey *key,
            int deep=0)
        copy_entry(self, from_:Information,
            key:InformationDataObjectKey, deep:int=0) -> None
        C++: void copy_entry(Information *from,
            InformationDataObjectKey *key, int deep=0)
        copy_entry(self, from_:Information,
            key:InformationDoubleVectorKey, deep:int=0) -> None
        C++: void copy_entry(Information *from,
            InformationDoubleVectorKey *key, int deep=0)
        copy_entry(self, from_:Information,
            key:InformationVariantKey, deep:int=0) -> None
        C++: void copy_entry(Information *from,
            InformationVariantKey *key, int deep=0)
        copy_entry(self, from_:Information,
            key:InformationVariantVectorKey, deep:int=0) -> None
        C++: void copy_entry(Information *from,
            InformationVariantVectorKey *key, int deep=0)
        copy_entry(self, from_:Information,
            key:InformationInformationKey, deep:int=0) -> None
        C++: void copy_entry(Information *from,
            InformationInformationKey *key, int deep=0)
        copy_entry(self, from_:Information,
            key:InformationInformationVectorKey, deep:int=0) -> None
        C++: void copy_entry(Information *from,
            InformationInformationVectorKey *key, int deep=0)
        copy_entry(self, from_:Information,
            key:InformationIntegerKey, deep:int=0) -> None
        C++: void copy_entry(Information *from,
            InformationIntegerKey *key, int deep=0)
        copy_entry(self, from_:Information,
            key:InformationIntegerVectorKey, deep:int=0) -> None
        C++: void copy_entry(Information *from,
            InformationIntegerVectorKey *key, int deep=0)
        copy_entry(self, from_:Information,
            key:InformationObjectBaseVectorKey, deep:int=0) -> None
        C++: void copy_entry(Information *from,
            InformationObjectBaseVectorKey *key, int deep=0)
        Copy the key/value pair associated with the given key in the
        given information object.  If deep=1, ...
         [Truncated]
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyEntry, *my_args)
        return ret

    def get(self, *args):
        """
        get(self, key:InformationIntegerKey) -> int
        C++: int get(InformationIntegerKey *key)
        get(self, key:InformationIdTypeKey) -> int
        C++: IdType get(InformationIdTypeKey *key)
        get(self, key:InformationDoubleKey) -> float
        C++: double get(InformationDoubleKey *key)
        get(self, key:InformationVariantKey) -> Variant
        C++: const Variant &get(InformationVariantKey *key)
        get(self, key:InformationIntegerVectorKey) -> (int, ...)
        C++: int *get(InformationIntegerVectorKey *key)
        get(self, key:InformationIntegerVectorKey, idx:int) -> int
        C++: int get(InformationIntegerVectorKey *key, int idx)
        get(self, key:InformationIntegerVectorKey, value:[int, ...])
            -> None
        C++: void get(InformationIntegerVectorKey *key, int *value)
        get(self, key:InformationStringVectorKey, idx:int=0) -> str
        C++: const char *get(InformationStringVectorKey *key,
            int idx=0)
        get(self, key:InformationIntegerPointerKey) -> Pointer
        C++: int *get(InformationIntegerPointerKey *key)
        get(self, key:InformationIntegerPointerKey, value:[int, ...])
            -> None
        C++: void get(InformationIntegerPointerKey *key, int *value)
        get(self, key:InformationUnsignedLongKey) -> int
        C++: unsigned long get(InformationUnsignedLongKey *key)
        get(self, key:InformationDoubleVectorKey) -> (float, ...)
        C++: double *get(InformationDoubleVectorKey *key)
        get(self, key:InformationDoubleVectorKey, idx:int) -> float
        C++: double get(InformationDoubleVectorKey *key, int idx)
        get(self, key:InformationDoubleVectorKey, value:[float, ...])
            -> None
        C++: void get(InformationDoubleVectorKey *key, double *value)
        get(self, key:InformationVariantVectorKey, idx:int)
            -> Variant
        C++: const Variant &get(InformationVariantVectorKey *key,
            int idx)
        get(self, key:InformationKeyVectorKey, idx:int)
            -> InformationKey
        C++: InformationKey *get(InformationKeyVectorKey *key,
            int idx)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Get, *my_args)
        return wrap_vtk(ret)

    def has(self, *args):
        """
        has(self, key:InformationKey) -> int
        C++: int has(InformationKey *key)
        has(self, key:InformationRequestKey) -> int
        C++: int has(InformationRequestKey *key)
        has(self, key:InformationIntegerKey) -> int
        C++: int has(InformationIntegerKey *key)
        has(self, key:InformationIdTypeKey) -> int
        C++: int has(InformationIdTypeKey *key)
        has(self, key:InformationDoubleKey) -> int
        C++: int has(InformationDoubleKey *key)
        has(self, key:InformationVariantKey) -> int
        C++: int has(InformationVariantKey *key)
        has(self, key:InformationIntegerVectorKey) -> int
        C++: int has(InformationIntegerVectorKey *key)
        has(self, key:InformationStringVectorKey) -> int
        C++: int has(InformationStringVectorKey *key)
        has(self, key:InformationIntegerPointerKey) -> int
        C++: int has(InformationIntegerPointerKey *key)
        has(self, key:InformationUnsignedLongKey) -> int
        C++: int has(InformationUnsignedLongKey *key)
        has(self, key:InformationDoubleVectorKey) -> int
        C++: int has(InformationDoubleVectorKey *key)
        has(self, key:InformationVariantVectorKey) -> int
        C++: int has(InformationVariantVectorKey *key)
        has(self, key:InformationKeyVectorKey) -> int
        C++: int has(InformationKeyVectorKey *key)
        has(self, key:InformationStringKey) -> int
        C++: int has(InformationStringKey *key)
        has(self, key:InformationInformationKey) -> int
        C++: int has(InformationInformationKey *key)
        has(self, key:InformationInformationVectorKey) -> int
        C++: int has(InformationInformationVectorKey *key)
        has(self, key:InformationObjectBaseKey) -> int
        C++: int has(InformationObjectBaseKey *key)
        has(self, key:InformationObjectBaseVectorKey) -> int
        C++: int has(InformationObjectBaseVectorKey *key)
        has(self, key:InformationDataObjectKey) -> int
        C++: int has(InformationDataObjectKey *key)
        Check whether the given key appears in this information object.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Has, *my_args)
        return ret

    def length(self, *args):
        """
        length(self, key:InformationIntegerVectorKey) -> int
        C++: int length(InformationIntegerVectorKey *key)
        length(self, key:InformationStringVectorKey) -> int
        C++: int length(InformationStringVectorKey *key)
        length(self, key:InformationIntegerPointerKey) -> int
        C++: int length(InformationIntegerPointerKey *key)
        length(self, key:InformationDoubleVectorKey) -> int
        C++: int length(InformationDoubleVectorKey *key)
        length(self, key:InformationVariantVectorKey) -> int
        C++: int length(InformationVariantVectorKey *key)
        length(self, key:InformationKeyVectorKey) -> int
        C++: int length(InformationKeyVectorKey *key)
        length(self, key:InformationObjectBaseVectorKey) -> int
        C++: int length(InformationObjectBaseVectorKey *key)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Length, *my_args)
        return ret

    def remove(self, *args):
        """
        remove(self, key:InformationKey) -> None
        C++: void remove(InformationKey *key)
        remove(self, key:InformationRequestKey) -> None
        C++: void remove(InformationRequestKey *key)
        remove(self, key:InformationIntegerKey) -> None
        C++: void remove(InformationIntegerKey *key)
        remove(self, key:InformationIdTypeKey) -> None
        C++: void remove(InformationIdTypeKey *key)
        remove(self, key:InformationDoubleKey) -> None
        C++: void remove(InformationDoubleKey *key)
        remove(self, key:InformationVariantKey) -> None
        C++: void remove(InformationVariantKey *key)
        remove(self, key:InformationIntegerVectorKey) -> None
        C++: void remove(InformationIntegerVectorKey *key)
        remove(self, key:InformationStringVectorKey) -> None
        C++: void remove(InformationStringVectorKey *key)
        remove(self, key:InformationIntegerPointerKey) -> None
        C++: void remove(InformationIntegerPointerKey *key)
        remove(self, key:InformationUnsignedLongKey) -> None
        C++: void remove(InformationUnsignedLongKey *key)
        remove(self, key:InformationDoubleVectorKey) -> None
        C++: void remove(InformationDoubleVectorKey *key)
        remove(self, key:InformationVariantVectorKey) -> None
        C++: void remove(InformationVariantVectorKey *key)
        remove(self, key:InformationKeyVectorKey,
            value:InformationKey) -> None
        C++: void remove(InformationKeyVectorKey *key,
            InformationKey *value)
        remove(self, key:InformationKeyVectorKey) -> None
        C++: void remove(InformationKeyVectorKey *key)
        remove(self, key:InformationStringKey) -> None
        C++: void remove(InformationStringKey *key)
        remove(self, key:InformationInformationKey) -> None
        C++: void remove(InformationInformationKey *key)
        remove(self, key:InformationInformationVectorKey) -> None
        C++: void remove(InformationInformationVectorKey *key)
        remove(self, key:InformationObjectBaseKey) -> None
        C++: void remove(InformationObjectBaseKey *key)
        Remove the given key and its data from this informat ...
         [Truncated]
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Remove, *my_args)
        return ret

    def set(self, *args):
        """
        set(self, key:InformationRequestKey) -> None
        C++: void set(InformationRequestKey *key)
        set(self, key:InformationIntegerKey, value:int) -> None
        C++: void set(InformationIntegerKey *key, int value)
        set(self, key:InformationIdTypeKey, value:int) -> None
        C++: void set(InformationIdTypeKey *key, IdType value)
        set(self, key:InformationDoubleKey, value:float) -> None
        C++: void set(InformationDoubleKey *key, double value)
        set(self, key:InformationVariantKey, value:Variant) -> None
        C++: void set(InformationVariantKey *key,
            const Variant &value)
        set(self, key:InformationIntegerVectorKey, value:(int, ...),
            length:int) -> None
        C++: void set(InformationIntegerVectorKey *key,
            const int *value, int length)
        set(self, key:InformationIntegerVectorKey, value1:int,
            value2:int, value3:int) -> None
        C++: void set(InformationIntegerVectorKey *key, int value1,
            int value2, int value3)
        set(self, key:InformationIntegerVectorKey, value1:int,
            value2:int, value3:int, value4:int, value5:int, value6:int)
            -> None
        C++: void set(InformationIntegerVectorKey *key, int value1,
            int value2, int value3, int value4, int value5, int value6)
        set(self, key:InformationStringVectorKey, value:str, idx:int=0)
             -> None
        C++: void set(InformationStringVectorKey *key,
            const std::string &value, int idx=0)
        set(self, key:InformationIntegerPointerKey, value:[int, ...],
            length:int) -> None
        C++: void set(InformationIntegerPointerKey *key, int *value,
            int length)
        set(self, key:InformationUnsignedLongKey, value:int) -> None
        C++: void set(InformationUnsignedLongKey *key,
            unsigned long value)
        set(self, key:InformationDoubleVectorKey, value:(float, ...),
            length:int) -> None
        C++: void set(InformationDoubleVectorKey *key,
            const double *value, int length)
        Get/Set a request-valued entry.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Set, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Information, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Information properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit Information properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Information properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

