# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class H5PartReader(PolyDataAlgorithm):
    r"""
    H5PartReader - Read h5_part particle files
    
    Superclass: PolyDataAlgorithm
    
    H5PartReader reads compatible with h5_part : documented here
    http://amas.web.psi.ch/docs/h5_part-doc/h5part.html
    
    ote Thanks to John Bidiscombe of CSCS - Swiss National Supercomputing
    Centre for creating and contributing the original implementation of
    this class.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkH5PartReader, obj, update, **traits)
    
    combine_vector_components = tvtk_base.true_bool_trait(desc=\
        r"""
        When this option is set, scalar fields with names which form a
        pattern of the form scalar_0, scalar_1, scalar_2 will be combined
        into a single vector field with N components
        """
    )

    def _combine_vector_components_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCombineVectorComponents,
                        self.combine_vector_components_)

    generate_vertex_cells = tvtk_base.false_bool_trait(desc=\
        r"""
        When set (default no), the reader will generate a vertex cell for
        each point/particle read. When using the points directly this is
        unnecessary and time can be saved by omitting cell generation
        PointSpriteMapper does not require them. When using para_view,
        cell generation is recommended, without them many filter
        operations are unavailable
        """
    )

    def _generate_vertex_cells_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateVertexCells,
                        self.generate_vertex_cells_)

    mask_out_of_time_range_output = tvtk_base.false_bool_trait(desc=\
        r"""
        Normally, a request for data at time t=x, where x is either
        before the start of time for the data, or after the end, will
        result in the first or last timestep of data to be retrieved
        (time is clamped to max/min values). Forsome
        applications/animations, it may be desirable to not display data
        for invalid times. When mask_out_of_time_range_output is set to ON,
        the reader will return an empty dataset for out of range
        requests. This helps avoid corruption of animations.
        """
    )

    def _mask_out_of_time_range_output_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaskOutOfTimeRangeOutput,
                        self.mask_out_of_time_range_output_)

    def get_coordinate_array_status(self, *args):
        """
        get_coordinate_array_status(self, name:str) -> int
        C++: int get_coordinate_array_status(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetCoordinateArrayStatus, *args)
        return ret

    def set_coordinate_array_status(self, *args):
        """
        set_coordinate_array_status(self, name:str, status:int) -> None
        C++: void set_coordinate_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetCoordinateArrayStatus, *args)
        return ret

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Specify file name.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    def get_point_array_status(self, *args):
        """
        get_point_array_status(self, name:str) -> int
        C++: int get_point_array_status(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetPointArrayStatus, *args)
        return ret

    def set_point_array_status(self, *args):
        """
        set_point_array_status(self, name:str, status:int) -> None
        C++: void set_point_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetPointArrayStatus, *args)
        return ret

    def get_point_array_status_array_status(self, *args):
        """
        get_point_array_status_array_status(self, name:str) -> int
        C++: int get_point_array_status_array_status(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetPointArrayStatusArrayStatus, *args)
        return ret

    def set_point_array_status_array_status(self, *args):
        """
        set_point_array_status_array_status(self, name:str, status:int) -> None
        C++: void set_point_array_status_array_status(const char *name,
            int status)"""
        ret = self._wrap_call(self._vtk_obj.SetPointArrayStatusArrayStatus, *args)
        return ret

    xarray = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _xarray_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetXarray,
                        self.xarray)

    yarray = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _yarray_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetYarray,
                        self.yarray)

    zarray = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _zarray_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetZarray,
                        self.zarray)

    def get_coordinate_array_name(self, *args):
        """
        get_coordinate_array_name(self, index:int) -> str
        C++: const char *get_coordinate_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetCoordinateArrayName, *args)
        return ret

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_coordinate_arrays(self):
        return self._vtk_obj.GetNumberOfCoordinateArrays()
    number_of_coordinate_arrays = traits.Property(_get_number_of_coordinate_arrays, desc=\
        r"""
        
        """
    )

    def _get_number_of_point_array_status_arrays(self):
        return self._vtk_obj.GetNumberOfPointArrayStatusArrays()
    number_of_point_array_status_arrays = traits.Property(_get_number_of_point_array_status_arrays, desc=\
        r"""
        
        """
    )

    def _get_number_of_point_arrays(self):
        return self._vtk_obj.GetNumberOfPointArrays()
    number_of_point_arrays = traits.Property(_get_number_of_point_arrays, desc=\
        r"""
        An h5_part file may contain multiple arrays a GUI (eg Paraview)
        can provide a mechanism for selecting which data arrays are to be
        read from the file. The point_array variables and members can be
        used to query the names and number of arrays available and set
        the status (on/off) for each array, thereby controlling which
        should be read from the file. Paraview queries these point arrays
        after the (update) information part of the pipeline has been
        updated, and before the (update) data part is updated.
        """
    )

    def get_point_array_name(self, *args):
        """
        get_point_array_name(self, index:int) -> str
        C++: const char *get_point_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetPointArrayName, *args)
        return ret

    def get_point_array_status_array_name(self, *args):
        """
        get_point_array_status_array_name(self, index:int) -> str
        C++: const char *get_point_array_status_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetPointArrayStatusArrayName, *args)
        return ret

    def disable(self, *args):
        """
        disable(self, name:str) -> None
        C++: void disable(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.Disable, *args)
        return ret

    def disable_all(self):
        """
        disable_all(self) -> None
        C++: void disable_all()"""
        ret = self._vtk_obj.DisableAll()
        return ret
        

    def enable(self, *args):
        """
        enable(self, name:str) -> None
        C++: void enable(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.Enable, *args)
        return ret

    def enable_all(self):
        """
        enable_all(self) -> None
        C++: void enable_all()"""
        ret = self._vtk_obj.EnableAll()
        return ret
        

    _updateable_traits_ = \
    (('combine_vector_components', 'GetCombineVectorComponents'),
    ('generate_vertex_cells', 'GetGenerateVertexCells'),
    ('mask_out_of_time_range_output', 'GetMaskOutOfTimeRangeOutput'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('xarray', 'GetXarray'), ('yarray', 'GetYarray'),
    ('zarray', 'GetZarray'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'combine_vector_components', 'debug',
    'generate_vertex_cells', 'global_warning_display',
    'mask_out_of_time_range_output', 'release_data_flag', 'file_name',
    'progress_text', 'xarray', 'yarray', 'zarray'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(H5PartReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit H5PartReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['combine_vector_components', 'generate_vertex_cells',
            'mask_out_of_time_range_output'], [], ['file_name', 'xarray',
            'yarray', 'zarray']),
            title='Edit H5PartReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit H5PartReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

