# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.image_reader2 import ImageReader2


class GDALRasterReader(ImageReader2):
    r"""
    GDALRasterReader - Read raster file formats using GDAL.
    
    Superclass: ImageReader2
    
    GDALRasterReader is a source object that reads raster files and
    uses GDAL as the underlying library for the task. GDAL library is
    required for this reader. The output of the reader is a
    UniformGrid (vtkimage_data with blanking) with cell data. The
    reader currently supports only north up images. Flips along X or Y
    direction are also supported. Arbitrary affine geotransforms or GCPs
    are not supported. See GDAL Data Model for more information
    https://www.gdal.org/gdal_datamodel.html
    
    @sa
    UniformGrid, ImageData
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGDALRasterReader, obj, update, **traits)
    
    collate_bands = tvtk_base.true_bool_trait(desc=\
        r"""
        Get/Set if bands are collated in one scalar array. Currently we
        collate RGB, RGBA, gray alpha and palette. The default is true.
        """
    )

    def _collate_bands_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCollateBands,
                        self.collate_bands_)

    def get_cell_array_status(self, *args):
        """
        get_cell_array_status(self, name:str) -> int
        C++: int get_cell_array_status(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetCellArrayStatus, *args)
        return ret

    def set_cell_array_status(self, *args):
        """
        set_cell_array_status(self, name:str, status:int) -> None
        C++: void set_cell_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetCellArrayStatus, *args)
        return ret

    target_dimensions = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(-1, -1), cols=2, desc=\
        r"""
        Set desired width and height of the image
        """
    )

    def _target_dimensions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTargetDimensions,
                        self.target_dimensions)

    def get_cell_array_name(self, *args):
        """
        get_cell_array_name(self, index:int) -> str
        C++: const char *get_cell_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetCellArrayName, *args)
        return ret

    def get_domain_meta_data(self, *args):
        """
        get_domain_meta_data(self, domain:str) -> (str, ...)
        C++: std::vector<std::string> get_domain_meta_data(
            const std::string &domain)
        Return domain metadata
        """
        ret = self._wrap_call(self._vtk_obj.GetDomainMetaData, *args)
        return ret

    def _get_driver_long_name(self):
        return self._vtk_obj.GetDriverLongName()
    driver_long_name = traits.Property(_get_driver_long_name, desc=\
        r"""
        
        """
    )

    def _get_driver_short_name(self):
        return self._vtk_obj.GetDriverShortName()
    driver_short_name = traits.Property(_get_driver_short_name, desc=\
        r"""
        Return driver name which was used to read the current data
        """
    )

    def _get_geo_corner_points(self):
        return self._vtk_obj.GetGeoCornerPoints()
    geo_corner_points = traits.Property(_get_geo_corner_points, desc=\
        r"""
        Return geo-referenced corner points (Upper left, lower left,
        lower right, upper right)
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        Get a data object for one of the input port connections.  The use
        of this method is strongly discouraged, but some filters that
        were written a long time ago still use this method.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def get_invalid_value(self, *args):
        """
        get_invalid_value(self, bandIndex:int=0, hasNoData:[int, ...]=...)
            -> float
        C++: double get_invalid_value(size_t bandIndex=0,
            int *hasNoData=nullptr)
        Return the invalid value for a pixel (for blanking purposes) in a
        specified raster band. Note bandIndex is a 0 based index while
        GDAL bands are 1 based indexes. hasno_data indicates if there is a
        no_data value associated with this band.
        """
        ret = self._wrap_call(self._vtk_obj.GetInvalidValue, *args)
        return ret

    def _get_meta_data(self):
        return self._vtk_obj.GetMetaData()
    meta_data = traits.Property(_get_meta_data, desc=\
        r"""
        Return metadata as reported by GDAL
        """
    )

    def _get_number_of_cell_arrays(self):
        return self._vtk_obj.GetNumberOfCellArrays()
    number_of_cell_arrays = traits.Property(_get_number_of_cell_arrays, desc=\
        r"""
        The following methods allow selective reading of bands. By
        default, ALL bands are read.
        """
    )

    def _get_number_of_cells(self):
        return self._vtk_obj.GetNumberOfCells()
    number_of_cells = traits.Property(_get_number_of_cells, desc=\
        r"""
        Return the number of cells that are not set to GDAL NODATA
        """
    )

    def _get_projection_string(self):
        return self._vtk_obj.GetProjectionString()
    projection_string = traits.Property(_get_projection_string, desc=\
        r"""
        Return proj4 spatial reference
        """
    )

    def _get_projection_wkt(self):
        return self._vtk_obj.GetProjectionWKT()
    projection_wkt = traits.Property(_get_projection_wkt, desc=\
        r"""
        Returns WKT spatial reference.
        """
    )

    def _get_raster_dimensions(self):
        return self._vtk_obj.GetRasterDimensions()
    raster_dimensions = traits.Property(_get_raster_dimensions, desc=\
        r"""
        Get raster width and height in number of pixels (cells)
        """
    )

    def disable_all_cell_arrays(self):
        """
        disable_all_cell_arrays(self) -> None
        C++: void disable_all_cell_arrays()"""
        ret = self._vtk_obj.DisableAllCellArrays()
        return ret
        

    def enable_all_cell_arrays(self):
        """
        enable_all_cell_arrays(self) -> None
        C++: void enable_all_cell_arrays()"""
        ret = self._vtk_obj.EnableAllCellArrays()
        return ret
        

    _updateable_traits_ = \
    (('collate_bands', 'GetCollateBands'), ('file_lower_left',
    'GetFileLowerLeft'), ('swap_bytes', 'GetSwapBytes'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('data_byte_order', 'GetDataByteOrder'),
    ('target_dimensions', 'GetTargetDimensions'), ('data_direction',
    'GetDataDirection'), ('data_extent', 'GetDataExtent'), ('data_origin',
    'GetDataOrigin'), ('data_spacing', 'GetDataSpacing'),
    ('file_dimensionality', 'GetFileDimensionality'), ('file_name',
    'GetFileName'), ('file_name_slice_offset', 'GetFileNameSliceOffset'),
    ('file_name_slice_spacing', 'GetFileNameSliceSpacing'),
    ('file_pattern', 'GetFilePattern'), ('file_prefix', 'GetFilePrefix'),
    ('header_size', 'GetHeaderSize'), ('memory_buffer_length',
    'GetMemoryBufferLength'), ('number_of_scalar_components',
    'GetNumberOfScalarComponents'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'collate_bands', 'debug', 'file_lower_left',
    'global_warning_display', 'release_data_flag', 'swap_bytes',
    'data_byte_order', 'data_direction', 'data_extent', 'data_origin',
    'data_spacing', 'file_dimensionality', 'file_name',
    'file_name_slice_offset', 'file_name_slice_spacing', 'file_pattern',
    'file_prefix', 'header_size', 'memory_buffer_length',
    'number_of_scalar_components', 'progress_text', 'target_dimensions'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GDALRasterReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GDALRasterReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['collate_bands', 'file_lower_left', 'swap_bytes'],
            ['data_byte_order'], ['data_direction', 'data_extent', 'data_origin',
            'data_spacing', 'file_dimensionality', 'file_name',
            'file_name_slice_offset', 'file_name_slice_spacing', 'file_pattern',
            'file_prefix', 'header_size', 'memory_buffer_length',
            'number_of_scalar_components', 'target_dimensions']),
            title='Edit GDALRasterReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GDALRasterReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

