# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_spline_representation import AbstractSplineRepresentation


class CameraPathRepresentation(AbstractSplineRepresentation):
    r"""
    CameraPathRepresentation - representation for a camera path.
    
    Superclass: AbstractSplineRepresentation
    
    CameraPathRepresentation is a WidgetRepresentation for a camera
    path. This 3D widget defines a camera path that can be interactively
    manipulated in a scene. The camera path has camera handles, that can
    be added and deleted, plus they can be picked on the path itself to
    be translated in the scene. This representation is used with
    CameraPathWidget.
    @sa
    CameraPathWidget
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCameraPathRepresentation, obj, update, **traits)
    
    number_of_handles = traits.Int(5, enter_set=True, auto_set=False, desc=\
        r"""
        Adjust the number of camera handles while keeping the same path.
        """
    )

    def _number_of_handles_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfHandles,
                        self.number_of_handles)

    def _get_parametric_spline(self):
        return wrap_vtk(self._vtk_obj.GetParametricSpline())
    def _set_parametric_spline(self, arg):
        old_val = self._get_parametric_spline()
        self._wrap_call(self._vtk_obj.SetParametricSpline,
                        deref_vtk(arg))
        self.trait_property_changed('parametric_spline', old_val, arg)
    parametric_spline = traits.Property(_get_parametric_spline, _set_parametric_spline, desc=\
        r"""
        Set the parametric spline object. Can be redefined in the child
        classes for further updates when a spline is set. The default
        value is nullptr.
        """
    )

    def add_camera_at(self, *args):
        """
        add_camera_at(self, camera:Camera, index:int) -> None
        C++: void add_camera_at(Camera *camera, int index)
        Add a camera to the path.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddCameraAt, *my_args)
        return ret

    def delete_camera_at(self, *args):
        """
        delete_camera_at(self, index:int) -> None
        C++: void delete_camera_at(int index)
        Remove a camera from the path.
        """
        ret = self._wrap_call(self._vtk_obj.DeleteCameraAt, *args)
        return ret

    _updateable_traits_ = \
    (('closed', 'GetClosed'), ('directional_line', 'GetDirectionalLine'),
    ('directional', 'GetDirectional'), ('project_to_plane',
    'GetProjectToPlane'), ('need_to_render', 'GetNeedToRender'),
    ('picking_managed', 'GetPickingManaged'), ('dragable', 'GetDragable'),
    ('pickable', 'GetPickable'), ('use_bounds', 'GetUseBounds'),
    ('visibility', 'GetVisibility'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('projection_normal', 'GetProjectionNormal'), ('number_of_handles',
    'GetNumberOfHandles'), ('resolution', 'GetResolution'),
    ('current_handle_index', 'GetCurrentHandleIndex'),
    ('interaction_state', 'GetInteractionState'), ('projection_position',
    'GetProjectionPosition'), ('translation_axis', 'GetTranslationAxis'),
    ('handle_size', 'GetHandleSize'), ('place_factor', 'GetPlaceFactor'),
    ('estimated_render_time', 'GetEstimatedRenderTime'),
    ('render_time_multiplier', 'GetRenderTimeMultiplier'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['closed', 'debug', 'directional', 'directional_line', 'dragable',
    'global_warning_display', 'need_to_render', 'pickable',
    'picking_managed', 'project_to_plane', 'use_bounds', 'visibility',
    'projection_normal', 'current_handle_index', 'estimated_render_time',
    'handle_size', 'interaction_state', 'number_of_handles',
    'place_factor', 'projection_position', 'render_time_multiplier',
    'resolution', 'translation_axis'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CameraPathRepresentation, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CameraPathRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['closed', 'directional', 'directional_line', 'need_to_render',
            'picking_managed', 'project_to_plane', 'use_bounds', 'visibility'],
            ['projection_normal'], ['current_handle_index',
            'estimated_render_time', 'handle_size', 'interaction_state',
            'number_of_handles', 'place_factor', 'projection_position',
            'render_time_multiplier', 'resolution', 'translation_axis']),
            title='Edit CameraPathRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CameraPathRepresentation properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

