# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.graph_algorithm import GraphAlgorithm


class BoostBreadthFirstSearch(GraphAlgorithm):
    r"""
    BoostBreadthFirstSearch - Boost breadth_first_search on a Graph
    
    Superclass: GraphAlgorithm
    
    This vtk class uses the Boost breadth_first_search generic algorithm
    to perform a breadth first search from a given a 'source' vertex on
    the input graph (a Graph).
    
    @sa
    Graph BoostGraphAdapter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBoostBreadthFirstSearch, obj, update, **traits)
    
    origin_from_selection = tvtk_base.false_bool_trait(desc=\
        r"""
        Use the Selection from input port 1 as the origin vertex. The
        selection should be a IDS selection with field type POINTS. The
        first ID in the selection will be used for the origin vertex.
        Default is off (origin is specified by set_origin_vertex(...)).
        """
    )

    def _origin_from_selection_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOriginFromSelection,
                        self.origin_from_selection_)

    output_selection = tvtk_base.false_bool_trait(desc=\
        r"""
        
        """
    )

    def _output_selection_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputSelection,
                        self.output_selection_)

    def set_origin_selection(self, *args):
        """
        set_origin_selection(self, s:Selection) -> None
        C++: void set_origin_selection(Selection *s)
        Convenience methods for setting the origin selection input.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetOriginSelection, *my_args)
        return ret

    def set_origin_selection_connection(self, *args):
        """
        set_origin_selection_connection(self, algOutput:AlgorithmOutput)
            -> None
        C++: void set_origin_selection_connection(
            AlgorithmOutput *algOutput)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetOriginSelectionConnection, *my_args)
        return ret

    def set_origin_vertex(self, *args):
        """
        set_origin_vertex(self, index:int) -> None
        C++: void set_origin_vertex(IdType index)
        set_origin_vertex(self, arrayName:str, value:Variant) -> None
        C++: void set_origin_vertex(StdString arrayName,
            Variant value)
        Set the index (into the vertex array) of the breadth first search
        'origin' vertex.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetOriginVertex, *my_args)
        return ret

    def set_origin_vertex_string(self, *args):
        """
        set_origin_vertex_string(self, arrayName:str, value:str) -> None
        C++: void set_origin_vertex_string(char *arrayName, char *value)
        Convenience method for setting the origin vertex given an array
        name and string value. This method is primarily for the benefit
        of the VTK Parallel client/server layer, callers should prefer to
        use set_origin_vertex() whenever possible.
        """
        ret = self._wrap_call(self._vtk_obj.SetOriginVertexString, *args)
        return ret

    def set_output_array_name(self, *args):
        """
        set_output_array_name(self, _arg:str) -> None
        C++: virtual void set_output_array_name(const char *_arg)
        Set the output array name. If no output array name is set then
        the name 'BFS' is used.
        """
        ret = self._wrap_call(self._vtk_obj.SetOutputArrayName, *args)
        return ret

    def set_output_selection_type(self, *args):
        """
        set_output_selection_type(self, _arg:str) -> None
        C++: virtual void set_output_selection_type(const char *_arg)
        Set the output selection type. The default is to use the the
        maximum distance from the starting vertex "MAX_DIST_FROM_ROOT".
        But you can also specify other things like "ROOT","2D_MAX", etc
        """
        ret = self._wrap_call(self._vtk_obj.SetOutputSelectionType, *args)
        return ret

    _updateable_traits_ = \
    (('origin_from_selection', 'GetOriginFromSelection'),
    ('output_selection', 'GetOutputSelection'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'origin_from_selection', 'output_selection', 'release_data_flag',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BoostBreadthFirstSearch, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BoostBreadthFirstSearch properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['origin_from_selection', 'output_selection'], [], []),
            title='Edit BoostBreadthFirstSearch properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BoostBreadthFirstSearch properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

