# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.graph_algorithm import GraphAlgorithm


class BoostBetweennessClustering(GraphAlgorithm):
    r"""
    BoostBetweennessClustering - Implements graph clustering based on
    edge betweenness centrality.
    
    Superclass: GraphAlgorithm
    
    This vtk class uses the Boost centrality clustering generic algorithm
    to compute edge betweenness centrality on the input graph (a
    Graph).
    
    @sa
    Graph BoostGraphAdapter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBoostBetweennessClustering, obj, update, **traits)
    
    edge_weight_array_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _edge_weight_array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetEdgeWeightArrayName,
                        self.edge_weight_array_name)

    threshold = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set the threshold value. Algorithm terminats when the maximum
        edge centrality is below this threshold.
        """
    )

    def _threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetThreshold,
                        self.threshold)

    def invert_edge_weight_array_off(self):
        """
        invert_edge_weight_array_off(self) -> None
        C++: virtual void invert_edge_weight_array_off()"""
        ret = self._vtk_obj.InvertEdgeWeightArrayOff()
        return ret
        

    def invert_edge_weight_array_on(self):
        """
        invert_edge_weight_array_on(self) -> None
        C++: virtual void invert_edge_weight_array_on()"""
        ret = self._vtk_obj.InvertEdgeWeightArrayOn()
        return ret
        

    def set_edge_centrality_array_name(self, *args):
        """
        set_edge_centrality_array_name(self, _arg:str) -> None
        C++: virtual void set_edge_centrality_array_name(const char *_arg)
        Set the edge centrality array name. If no output array name is
        set then the name "edge_centrality" is used.
        """
        ret = self._wrap_call(self._vtk_obj.SetEdgeCentralityArrayName, *args)
        return ret

    def set_invert_edge_weight_array(self, *args):
        """
        set_invert_edge_weight_array(self, _arg:bool) -> None
        C++: virtual void set_invert_edge_weight_array(bool _arg)"""
        ret = self._wrap_call(self._vtk_obj.SetInvertEdgeWeightArray, *args)
        return ret

    def set_use_edge_weight_array(self, *args):
        """
        set_use_edge_weight_array(self, _arg:bool) -> None
        C++: virtual void set_use_edge_weight_array(bool _arg)
        Get/Set the flag that sets the rule whether or not to use the
        edge weight array as set using set_edge_weight_array_name.
        """
        ret = self._wrap_call(self._vtk_obj.SetUseEdgeWeightArray, *args)
        return ret

    def use_edge_weight_array_off(self):
        """
        use_edge_weight_array_off(self) -> None
        C++: virtual void use_edge_weight_array_off()"""
        ret = self._vtk_obj.UseEdgeWeightArrayOff()
        return ret
        

    def use_edge_weight_array_on(self):
        """
        use_edge_weight_array_on(self) -> None
        C++: virtual void use_edge_weight_array_on()"""
        ret = self._vtk_obj.UseEdgeWeightArrayOn()
        return ret
        

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('edge_weight_array_name', 'GetEdgeWeightArrayName'), ('threshold',
    'GetThreshold'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'edge_weight_array_name', 'progress_text',
    'threshold'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BoostBetweennessClustering, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BoostBetweennessClustering properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['edge_weight_array_name', 'threshold']),
            title='Edit BoostBetweennessClustering properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BoostBetweennessClustering properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

