# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class ADIOS2CoreImageReader(DataObjectAlgorithm):
    r"""
    ADIOS2CoreImageReader - Read ADIOS2 bp files.
    
    Superclass: DataObjectAlgorithm
    
    ADIOS2CoreImageReader reads ADIOS2 bp data files so that they can
    be processed or visualized using VTK as ImageDatas. When
    processing data, the assumption is that the all variables share the
    same number of blocks. If the the data has multiple time steps, the
    user can specify the name of the time array then reader will use it
    to calculate the number of time steps. By default we flips the
    dimensions as vtk data array uses column major order whereas adios2
    uses row major order. Check is_column_major flag for more details. This
    reader can be launched either in serial or parallel. // TODO: Expose
    attribute info in PV GUI.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkADIOS2CoreImageReader, obj, update, **traits)
    
    dimension_array_as_cell = tvtk_base.true_bool_trait(desc=\
        r"""
        Enable/Disable the assumption that the dimension array is cell
        data. On by default.
        """
    )

    def _dimension_array_as_cell_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDimensionArrayAsCell,
                        self.dimension_array_as_cell_)

    is_column_major = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable/Disable the assumption that the order of input data is
        column major. Off by default. As VTK's order is column
        major(Fortran order) whereas adios2 uses row major(C order), we
        **flip the dimensions** here to avoid a deep copy.
        """
    )

    def _is_column_major_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetIsColumnMajor,
                        self.is_column_major_)

    def get_array_status(self, *args):
        """
        get_array_status(self, name:str) -> int
        C++: int get_array_status(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetArrayStatus, *args)
        return ret

    def set_array_status(self, *args):
        """
        set_array_status(self, name:str, status:int) -> None
        C++: void set_array_status(const char *name, int status)
        Set the array that should be read in. Based on the dimension
        info, proper adios2 arrays will be read in as point or cell dota.
        """
        ret = self._wrap_call(self._vtk_obj.SetArrayStatus, *args)
        return ret

    dimension_array = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _dimension_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDimensionArray,
                        self.dimension_array)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Get/Set the input filename
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    origin = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.0, 0.0, 0.0), cols=3, desc=\
        r"""
        Get/Set the origin of output ImageData. Default to be the
        origin point.
        """
    )

    def _origin_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOrigin,
                        self.origin)

    spacing = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(1.0, 1.0, 1.0), cols=3, desc=\
        r"""
        Get/Set the spacing of output ImageData Default to be 1.0,
        1.0, 1.0.
        """
    )

    def _spacing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSpacing,
                        self.spacing)

    time_step_array = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set the name of the time step array. Once it's set, vtk will
        try to populate the time step info from this array.
        """
    )

    def _time_step_array_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTimeStepArray,
                        self.time_step_array)

    def _get_all_dimension_arrays(self):
        return wrap_vtk(self._vtk_obj.GetAllDimensionArrays())
    all_dimension_arrays = traits.Property(_get_all_dimension_arrays, desc=\
        r"""
        Get/Set the name of the array to deduce the dimension of
        ImageData. You can toggle the dimension_array_as_cell flag as
        needed.
        """
    )

    def _get_all_time_step_arrays(self):
        return wrap_vtk(self._vtk_obj.GetAllTimeStepArrays())
    all_time_step_arrays = traits.Property(_get_all_time_step_arrays, desc=\
        r"""
        
        """
    )

    def get_array_name(self, *args):
        """
        get_array_name(self, index:int) -> str
        C++: const char *get_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetArrayName, *args)
        return ret

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_number_of_arrays(self):
        return self._vtk_obj.GetNumberOfArrays()
    number_of_arrays = traits.Property(_get_number_of_arrays, desc=\
        r"""
        Get information about arrays. As is typical with readers this is
        only valid after the filename is set and update_information() has
        been called. Since adios2 does not differentiate between cell
        arrays and point arrays, the dimensions info is appended to the
        name so that it can used to kdetermine the type of the array. The
        array name includes its dimension.
        """
    )

    def can_read_file(self, *args):
        """
        can_read_file(self, name:str) -> int
        C++: int can_read_file(const std::string &name)
        Test whether or not a given file should even be attempted for use
        with this reader.
        """
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    def set_controller(self, *args):
        """
        set_controller(self, __a:MultiProcessController) -> None
        C++: void set_controller(MultiProcessController *)
        Set the MPI controller
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetController, *my_args)
        return ret

    _updateable_traits_ = \
    (('dimension_array_as_cell', 'GetDimensionArrayAsCell'),
    ('is_column_major', 'GetIsColumnMajor'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('dimension_array', 'GetDimensionArray'),
    ('file_name', 'GetFileName'), ('origin', 'GetOrigin'), ('spacing',
    'GetSpacing'), ('time_step_array', 'GetTimeStepArray'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'dimension_array_as_cell',
    'global_warning_display', 'is_column_major', 'release_data_flag',
    'dimension_array', 'file_name', 'origin', 'progress_text', 'spacing',
    'time_step_array'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ADIOS2CoreImageReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ADIOS2CoreImageReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['dimension_array_as_cell', 'is_column_major'], [],
            ['dimension_array', 'file_name', 'origin', 'spacing',
            'time_step_array']),
            title='Edit ADIOS2CoreImageReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ADIOS2CoreImageReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

