/*
 -- MAGMA (version 2.6.2) --
 Univ. of Tennessee, Knoxville
 Univ. of California, Berkeley
 Univ. of Colorado, Denver
 @date April 2022

 @generated from sparse/include/magmasparse_z.h, normal z -> c, Wed Apr 20 17:38:08 2022
 @author Hartwig Anzt
*/

#ifndef MAGMASPARSE_C_H
#define MAGMASPARSE_C_H

#include "magma_types.h"
#include "magmasparse_types.h"

#ifdef _OPENMP
#include <omp.h>
#endif

#define PRECISION_c


#ifdef __cplusplus
extern "C" {
#endif


/* ////////////////////////////////////////////////////////////////////////////
 -- For backwards compatability, map old (1.6.1) to new (1.6.2) function names
*/

#define magma_c_mtranspose  magma_cmtranspose
#define magma_c_mtransfer   magma_cmtransfer
#define magma_c_vtransfer   magma_cmtransfer
#define magma_c_mconvert    magma_cmconvert
#define magma_c_vinit       magma_cvinit
#define magma_c_vvisu       magma_cprint_vector
#define magma_c_vread       magma_cvread
#define magma_c_vspread     magma_cvspread
#define magma_c_mvisu       magma_cprint_matrix
#define magma_c_mfree       magma_cmfree
#define magma_c_vfree       magma_cmfree
#define write_c_csr_mtx     magma_cwrite_csr_mtx
#define write_c_csrtomtx    magma_cwrite_csrtomtx
#define print_c_csr         magma_cprint_csr_mtx


/* ////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE Auxiliary functions
*/

magma_int_t
magma_cwrapper(
    magma_copts *zopts,
    magma_c_matrix *A, 
    magma_c_matrix *x, 
    magma_c_matrix *b,
    magma_queue_t queue );

magma_int_t
magma_cparse_opts( 
    int argc, 
    char** argv, 
    magma_copts *opts, 
    int *matrices, 
    magma_queue_t queue );

magma_int_t 
read_c_csr_from_binary( 
    magma_int_t* n_row, 
    magma_int_t* n_col, 
    magma_int_t* nnz, 
    magmaFloatComplex **val, 
    magma_index_t **row, 
    magma_index_t **col,
    const char * filename,
    magma_queue_t queue );

magma_int_t 
read_c_csr_from_mtx( 
    magma_storage_t *type, 
    magma_location_t *location,
    magma_int_t* n_row, 
    magma_int_t* n_col, 
    magma_int_t* nnz, 
    magmaFloatComplex **val, 
    magma_index_t **row, 
    magma_index_t **col, 
    const char *filename,
    magma_queue_t queue );

magma_int_t 
magma_c_csr_mtx( 
    magma_c_matrix *A, 
    const char *filename,
    magma_queue_t queue );

magma_int_t 
magma_ccsrset( 
    magma_int_t m, 
    magma_int_t n, 
    magma_index_t *row, 
    magma_index_t *col, 
    magmaFloatComplex *val,
    magma_c_matrix *A,
    magma_queue_t queue );

magma_int_t 
magma_ccsrget( 
    magma_c_matrix A,
    magma_int_t *m, 
    magma_int_t *n, 
    magma_index_t **row, 
    magma_index_t **col, 
    magmaFloatComplex **val,
    magma_queue_t queue );


magma_int_t 
magma_cvset( 
    magma_int_t m, 
    magma_int_t n, 
    magmaFloatComplex *val,
    magma_c_matrix *v,
    magma_queue_t queue );

magma_int_t 
magma_cvget( 
    magma_c_matrix v,
    magma_int_t *m, 
    magma_int_t *n, 
    magmaFloatComplex **val,
    magma_queue_t queue );

magma_int_t 
magma_cvcopy( 
    magma_c_matrix v,
    magma_int_t *m, 
    magma_int_t *n, 
    magmaFloatComplex *val,
    magma_queue_t queue );

magma_int_t 
magma_cvset_dev( 
    magma_int_t m, 
    magma_int_t n, 
    magmaFloatComplex_ptr val,
    magma_c_matrix *v,
    magma_queue_t queue );

magma_int_t 
magma_cvget_dev( 
    magma_c_matrix v,
    magma_int_t *m, 
    magma_int_t *n, 
    magmaFloatComplex_ptr *val,
    magma_queue_t queue );

magma_int_t 
magma_cvcopy_dev( 
    magma_c_matrix v,
    magma_int_t *m, 
    magma_int_t *n, 
    magmaFloatComplex *val,
    magma_queue_t queue );


magma_int_t 
magma_c_csr_mtxsymm( 
    magma_c_matrix *A, 
    const char *filename,
    magma_queue_t queue );

magma_int_t 
magma_c_csr_compressor( 
    magmaFloatComplex ** val, 
    magma_index_t ** row, 
    magma_index_t ** col, 
    magmaFloatComplex ** valn, 
    magma_index_t ** rown, 
    magma_index_t ** coln, 
    magma_int_t *n,
    magma_queue_t queue );

magma_int_t
magma_cmcsrcompressor( 
    magma_c_matrix *A,
    magma_queue_t queue );

magma_int_t
magma_cmshrink(
    magma_c_matrix A,
    magma_c_matrix *B,
    magma_queue_t queue );

magma_int_t
magma_cmcsrcompressor_gpu( 
    magma_c_matrix *A,
    magma_queue_t queue );

magma_int_t
magma_cvtranspose( 
    magma_c_matrix x,
    magma_c_matrix *y,
    magma_queue_t queue );

magma_int_t 
magma_c_cucsrtranspose( 
    magma_c_matrix A, 
    magma_c_matrix *B,
    magma_queue_t queue );

magma_int_t
    magma_cmtransposeconjugate(
    magma_c_matrix A,
    magma_c_matrix *B,
    magma_queue_t queue );

magma_int_t
magma_cmconjugate(
    magma_c_matrix *A,
    magma_queue_t queue );

magma_int_t 
c_transpose_csr( 
    magma_int_t n_rows, 
    magma_int_t n_cols, 
    magma_int_t nnz,
    magmaFloatComplex *val, 
    magma_index_t *row, 
    magma_index_t *col, 
    magma_int_t *new_n_rows, 
    magma_int_t *new_n_cols, 
    magma_int_t *new_nnz, 
    magmaFloatComplex **new_val, 
    magma_index_t **new_row, 
    magma_index_t **new_col,
    magma_queue_t queue );

magma_int_t
magma_ccsrsplit( 
    magma_int_t offset,
    magma_int_t bsize,
    magma_c_matrix A,
    magma_c_matrix *D,
    magma_c_matrix *R,
    magma_queue_t queue );

magma_int_t
magma_cmscale( 
    magma_c_matrix *A, 
    magma_scale_t scaling,
    magma_queue_t queue );

magma_int_t
magma_cmscale_matrix_rhs(
    magma_c_matrix *A,
    magma_c_matrix *b,
    magma_c_matrix *scaling_factors,
    magma_scale_t scaling,
    magma_queue_t queue );

magma_int_t
magma_cmscale_generate( 
      magma_int_t n, 
      magma_scale_t* scaling, 
      magma_side_t* side, 
      magma_c_matrix* A, 
      magma_c_matrix* scaling_factors,
      magma_queue_t queue  );

magma_int_t
magma_cmscale_apply( 
      magma_int_t n,  
      magma_side_t* side, 
      magma_c_matrix* scaling_factors, 
      magma_c_matrix* A,
    magma_queue_t queue );

magma_int_t
magma_cdimv( 
  magma_c_matrix* vecA, 
  magma_c_matrix* vecB,
  magma_queue_t queue );

magma_int_t
magma_cmslice(
    magma_int_t num_slices,
    magma_int_t slice,
    magma_c_matrix A, 
    magma_c_matrix *B,
    magma_c_matrix *ALOC,
    magma_c_matrix *ANLOC,
    magma_index_t *comm_i,
    magmaFloatComplex *comm_v,
    magma_int_t *start,
    magma_int_t *end,
    magma_queue_t queue );

magma_int_t
magma_cmdiagdom(
    magma_c_matrix M,
    float *min_dd,
    float *max_dd,
    float *avg_dd,
    magma_queue_t queue );

magma_int_t
magma_cmbdiagdom(
    magma_c_matrix M,
    magma_c_matrix blocksizes,
    float *min_dd,
    float *max_dd,
    float *avg_dd,
    magma_queue_t queue );

magma_int_t 
magma_cmdiff( 
    magma_c_matrix A, 
    magma_c_matrix B, 
 real_Double_t *res,
    magma_queue_t queue );

magma_int_t
magma_cmdiagadd( 
    magma_c_matrix *A, 
    magmaFloatComplex add,
    magma_queue_t queue );

magma_int_t 
magma_cmsort(
    magmaFloatComplex *x,
    magma_index_t *col,
    magma_index_t *row,
    magma_int_t first,
    magma_int_t last,
    magma_queue_t queue );

magma_int_t
magma_cindexsort(
    magma_index_t *x, 
    magma_int_t first,
    magma_int_t last,
    magma_queue_t queue );

magma_int_t
magma_csort(
    magmaFloatComplex *x, 
    magma_int_t first,
    magma_int_t last,
    magma_queue_t queue );

magma_int_t
magma_cbitonic_sort(
    magma_int_t start, 
    magma_int_t length, 
    magmaFloatComplex *seq, 
    magma_int_t flag,
    magma_queue_t queue );

magma_int_t
magma_cindexsortval(
    magma_index_t *x,
    magmaFloatComplex *y,
    magma_int_t first,
    magma_int_t last,
    magma_queue_t queue );

magma_int_t
magma_corderstatistics(
    magmaFloatComplex *val,
    magma_int_t length,
    magma_int_t k,
    magma_int_t r,
    magmaFloatComplex *element,
    magma_queue_t queue );

magma_int_t
magma_corderstatistics_inc(
    magmaFloatComplex *val,
    magma_int_t length,
    magma_int_t k,
    magma_int_t inc,
    magma_int_t r,
    magmaFloatComplex *element,
    magma_queue_t queue );

magma_int_t
magma_cmorderstatistics(
    magmaFloatComplex *val,
    magma_index_t *col,
    magma_index_t *row,
    magma_int_t length,
    magma_int_t k,
    magma_int_t r,
    magmaFloatComplex *element,
    magma_queue_t queue );

magma_int_t
magma_cpartition( 
    magmaFloatComplex *a, 
    magma_int_t size, 
    magma_int_t pivot,
    magma_queue_t queue );

magma_int_t
magma_cmedian5( 
    magmaFloatComplex *a, 
    magma_queue_t queue );

magma_int_t
magma_cselect( 
    magmaFloatComplex *a, 
    magma_int_t size, 
    magma_int_t k,
    magma_queue_t queue );

magma_int_t
magma_cselectrandom( 
    magmaFloatComplex *a, 
    magma_int_t size, 
    magma_int_t k,
    magma_queue_t queue );

magma_int_t
magma_cdomainoverlap(
    magma_index_t num_rows,
    magma_int_t *num_indices,
    magma_index_t *rowptr,
    magma_index_t *colidx,
    magma_index_t *x,
    magma_queue_t queue );

magma_int_t
magma_csymbilu( 
    magma_c_matrix *A, 
    magma_int_t levels,
    magma_c_matrix *L,
    magma_c_matrix *U,
    magma_queue_t queue );


magma_int_t 
magma_cwrite_csr_mtx( 
    magma_c_matrix A,
    magma_order_t MajorType,
 const char *filename,
    magma_queue_t queue );

magma_int_t 
magma_cwrite_vector( 
    magma_c_matrix A,
    const char *filename,
    magma_queue_t queue );

magma_int_t 
magma_cwrite_csrtomtx( 
    magma_c_matrix A,
    const char *filename,
    magma_queue_t queue );

magma_int_t 
magma_cprint_csr( 
    magma_int_t n_row, 
    magma_int_t n_col, 
    magma_int_t nnz, 
    magmaFloatComplex **val, 
    magma_index_t **row, 
    magma_index_t **col,
    magma_queue_t queue );

magma_int_t 
magma_cprint_csr_mtx( 
    magma_int_t n_row, 
    magma_int_t n_col, 
    magma_int_t nnz, 
    magmaFloatComplex **val, 
    magma_index_t **row, 
    magma_index_t **col, 
    magma_order_t MajorType,
    magma_queue_t queue );


magma_int_t 
magma_cmtranspose(
    magma_c_matrix A, 
    magma_c_matrix *B,
    magma_queue_t queue );

magma_int_t 
magma_cmtranspose_cpu(
    magma_c_matrix A, 
    magma_c_matrix *B,
    magma_queue_t queue );

magma_int_t 
magma_cmtransposeabs_cpu(
    magma_c_matrix A, 
    magma_c_matrix *B,
    magma_queue_t queue );

magma_int_t 
magma_cmtransposestruct_cpu(
    magma_c_matrix A, 
    magma_c_matrix *B,
    magma_queue_t queue );

magma_int_t 
magma_cmtransposeconj_cpu(
    magma_c_matrix A, 
    magma_c_matrix *B,
    magma_queue_t queue );

magma_int_t 
magma_cmtransfer(
    magma_c_matrix A, 
    magma_c_matrix *B, 
    magma_location_t src, 
    magma_location_t dst,
    magma_queue_t queue );

magma_int_t 
magma_cmconvert(
    magma_c_matrix A, 
    magma_c_matrix *B, 
    magma_storage_t old_format, 
    magma_storage_t new_format,
    magma_queue_t queue );


magma_int_t
magma_cvinit(
    magma_c_matrix *x, 
    magma_location_t memory_location,
    magma_int_t num_rows, 
    magma_int_t num_cols,
    magmaFloatComplex values,
    magma_queue_t queue );

magma_int_t
magma_cvinit_rand(
    magma_c_matrix *x, 
    magma_location_t memory_location,
    magma_int_t num_rows, 
    magma_int_t num_cols,
    magma_queue_t queue );

magma_int_t
magma_cprint_vector(
    magma_c_matrix x, 
    magma_int_t offset, 
    magma_int_t displaylength,
    magma_queue_t queue );

magma_int_t
magma_cvread(
    magma_c_matrix *x, 
    magma_int_t length,
    char * filename,
    magma_queue_t queue );

magma_int_t
magma_cvspread(
    magma_c_matrix *x, 
    const char * filename,
    magma_queue_t queue );

magma_int_t
magma_cprint_matrix(
    magma_c_matrix A,
    magma_queue_t queue );

magma_int_t 
magma_cdiameter(
    magma_c_matrix *A,
    magma_queue_t queue );

magma_int_t 
magma_crowentries(
    magma_c_matrix *A,
    magma_queue_t queue );

magma_int_t
magma_cmfree(
    magma_c_matrix *A,
    magma_queue_t queue );

magma_int_t
magma_cresidual(
    magma_c_matrix A, 
    magma_c_matrix b, 
    magma_c_matrix x, 
    float *res,
    magma_queue_t queue );

magma_int_t
magma_cresidualvec(
    magma_c_matrix A,
    magma_c_matrix b,
    magma_c_matrix x,
    magma_c_matrix *r,
    float *res,
    magma_queue_t queue );

magma_int_t
magma_cresidual_slice(
    magma_int_t start,
    magma_int_t end,
    magma_c_matrix A, 
    magma_c_matrix b, 
    magma_c_matrix x,
    float *res,
    magma_queue_t queue );

magma_int_t
magma_cmgenerator(
    magma_int_t n,
    magma_int_t offdiags,
    magma_index_t *diag_offset,
    magmaFloatComplex *diag_vals,
    magma_c_matrix *A,
    magma_queue_t queue );

magma_int_t
magma_cm_27stencil(
    magma_int_t n,
    magma_c_matrix *A,
    magma_queue_t queue );

magma_int_t
magma_cm_5stencil(
    magma_int_t n,
    magma_c_matrix *A,
    magma_queue_t queue );

magma_int_t
magma_csolverinfo(
    magma_c_solver_par *solver_par, 
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_csolverinfo_init(
    magma_c_solver_par *solver_par, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_ceigensolverinfo_init(
    magma_c_solver_par *solver_par,
    magma_queue_t queue );


magma_int_t
magma_cprecondfree(
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_csolverinfo_free(
    magma_c_solver_par *solver_par, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cKrylov_check( magma_solver_type solver );


/* ////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE parallel incomplete factorizations (ParILU / ParILUT)
*/


magma_int_t
magma_cparilusetup( 
    magma_c_matrix A, 
    magma_c_matrix b,                                 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cparilu_gpu( 
    magma_c_matrix A, 
    magma_c_matrix b,                                 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cparilu_cpu( 
    magma_c_matrix A, 
    magma_c_matrix b,                                 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cparic_gpu( 
    magma_c_matrix A, 
    magma_c_matrix b,                                 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cparic_cpu( 
    magma_c_matrix A, 
    magma_c_matrix b,                                 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cparicsetup( 
    magma_c_matrix A, 
    magma_c_matrix b, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cparicupdate( 
    magma_c_matrix A, 
    magma_c_preconditioner *precond, 
    magma_int_t updates,
    magma_queue_t queue );

magma_int_t
magma_capplyiteric_l( 
    magma_c_matrix b, 
    magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_capplyiteric_r( 
    magma_c_matrix b, 
    magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );


magma_int_t
magma_cparilu_csr( 
    magma_c_matrix A,
    magma_c_matrix L,
    magma_c_matrix U,
    magma_queue_t queue );

magma_int_t
magma_cpariluupdate(
    magma_c_matrix A,
    magma_c_preconditioner *precond,
    magma_int_t updates,
    magma_queue_t queue );

magma_int_t
magma_cparic_csr( 
    magma_c_matrix A,
    magma_c_matrix A_CSR,
    magma_queue_t queue );

magma_int_t 
magma_cfrobenius( 
    magma_c_matrix A, 
    magma_c_matrix B, 
    real_Double_t *res,
    magma_queue_t queue );

magma_int_t
magma_cmfrobenius(
    magma_c_matrix A,
    magma_c_matrix B,
    magma_c_matrix S,
    float *norm,
    magma_queue_t queue );

magma_int_t 
magma_cnonlinres(   
    magma_c_matrix A, 
    magma_c_matrix L,
    magma_c_matrix U, 
    magma_c_matrix *LU, 
    real_Double_t *res,
    magma_queue_t queue );

magma_int_t 
magma_cilures(   
    magma_c_matrix A, 
    magma_c_matrix L,
    magma_c_matrix U, 
    magma_c_matrix *LU, 
    real_Double_t *res,
    real_Double_t *nonlinres,
    magma_queue_t queue );

magma_int_t 
magma_cicres(       
    magma_c_matrix A, 
    magma_c_matrix C,
    magma_c_matrix CT, 
    magma_c_matrix *LU, 
    real_Double_t *res,
    real_Double_t *nonlinres,
    magma_queue_t queue );

magma_int_t 
magma_cinitguess( 
    magma_c_matrix A, 
    magma_c_matrix *L, 
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t 
magma_cinitrecursiveLU( 
    magma_c_matrix A, 
    magma_c_matrix *B,
    magma_queue_t queue );

magma_int_t 
magma_cmLdiagadd( 
    magma_c_matrix *L,
    magma_queue_t queue );


/* ////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE iterative dynamic ILU
*/
// #ifdef _OPENMP

magma_int_t
magma_cmatrix_tril(
    magma_c_matrix A,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cmatrix_triu(
    magma_c_matrix A,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cmatrix_cup(
    magma_c_matrix A,
    magma_c_matrix B,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cmatrix_cup_gpu(
    magma_c_matrix A,
    magma_c_matrix B,
    magma_c_matrix *U,
    magma_queue_t queue);

magma_int_t
magma_cmatrix_cap(
    magma_c_matrix A,
    magma_c_matrix B,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cmatrix_negcap(
    magma_c_matrix A,
    magma_c_matrix B,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cmatrix_tril_negcap(
    magma_c_matrix A,
    magma_c_matrix B,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cmatrix_triu_negcap(
    magma_c_matrix A,
    magma_c_matrix B,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cmatrix_addrowindex(
    magma_c_matrix *A,
    magma_queue_t queue );

magma_int_t
magma_cmatrix_abssum(
    magma_c_matrix A,
    float *sum,
    magma_queue_t queue );

magma_int_t
magma_cparilut_thrsrm(
    magma_int_t order,
    magma_c_matrix *A,
    float *thrs,
    magma_queue_t queue );

magma_int_t
magma_cparilut_thrsrm_semilinked(
    magma_c_matrix *U,
    magma_c_matrix *UT,
    float *thrs,
    magma_queue_t queue );

magma_int_t
magma_cparilut_rmselected(
    magma_c_matrix R,
    magma_c_matrix *A,
    magma_queue_t queue );

magma_int_t
magma_cparilut_selectoneperrow(
    magma_int_t order,
    magma_c_matrix *A,
    magma_c_matrix *oneA,
    magma_queue_t queue );

magma_int_t
magma_cparilut_selecttwoperrow(
    magma_int_t order,
    magma_c_matrix *A,
    magma_c_matrix *oneA,
    magma_queue_t queue );

magma_int_t
magma_cparilut_selectoneperrowthrs_lower(
    magma_c_matrix L,
    magma_c_matrix U,
    magma_c_matrix *A,
    float  rtol,
    magma_c_matrix *oneA,
    magma_queue_t queue );

magma_int_t
magma_cparilut_selectoneperrowthrs_upper(
    magma_c_matrix L,
    magma_c_matrix U,
    magma_c_matrix *A,
    float  rtol,
    magma_c_matrix *oneA,
    magma_queue_t queue );

magma_int_t
magma_cparilut_selectonepercol(
    magma_int_t order,
    magma_c_matrix *A,
    magma_c_matrix *oneA,
    magma_queue_t queue );

magma_int_t
magma_cmatrix_swap(
    magma_c_matrix *A,
    magma_c_matrix *B,
    magma_queue_t queue );

magma_int_t
magma_ccsrcoo_transpose(
    magma_c_matrix A,
    magma_c_matrix *B,
    magma_queue_t queue );

magma_int_t
magma_cparilut_transpose_select_one(
    magma_c_matrix A,
    magma_c_matrix *B,
    magma_queue_t queue );

magma_int_t
magma_cmatrix_createrowptr(
    magma_int_t n,
    magma_index_t *row,
    magma_queue_t queue );

magma_int_t
magma_cparilut_insert_LU(
    magma_int_t num_rm,
    magma_index_t *rm_loc,
    magma_index_t *rm_loc2,
    magma_c_matrix *LU_new,
    magma_c_matrix *L,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cparilut_set_thrs(
    magma_int_t num_rm,
    magma_c_matrix *LU,
    magma_int_t order,
    magmaFloatComplex *thrs,
    magma_queue_t queue );

magma_int_t
magma_cparilut_set_approx_thrs(
    magma_int_t num_rm,
    magma_c_matrix *LU,
    magma_int_t order,
    float *thrs,
    magma_queue_t queue );

magma_int_t
magma_cparilut_set_thrs_randomselect(
    magma_int_t num_rm,
    magma_c_matrix *LU,
    magma_int_t order,
    float *thrs,
    magma_queue_t queue );

magma_int_t
magma_cparilut_set_thrs_randomselect_approx(
    magma_int_t num_rm,
    magma_c_matrix *LU,
    magma_int_t order,
    float *thrs,
    magma_queue_t queue );

magma_int_t
magma_cparilut_set_thrs_randomselect_factors(
    magma_int_t num_rm,
    magma_c_matrix *L,
    magma_c_matrix *U,
    magma_int_t order,
    float *thrs,
    magma_queue_t queue );

magma_int_t
magma_cparilut_set_exact_thrs(
    magma_int_t num_rm,
    magma_c_matrix *LU,
    magma_int_t order,
    magmaFloatComplex *thrs,
    magma_queue_t queue );

magma_int_t
magma_cparilut_set_approx_thrs_inc(
    magma_int_t num_rm,
    magma_c_matrix *LU,
    magma_int_t order,
    magmaFloatComplex *thrs,
    magma_queue_t queue );

magma_int_t
magma_cparilut_LU_approx_thrs(
    magma_int_t num_rm,
    magma_c_matrix *L,
    magma_c_matrix *U,
    magma_int_t order,
    magmaFloatComplex *thrs,
    magma_queue_t queue );

magma_int_t
magma_cparilut_reorder(
    magma_c_matrix *LU,
    magma_queue_t queue );

magma_int_t
magma_cparict_sweep(
    magma_c_matrix *A,
    magma_c_matrix *LU,
    magma_queue_t queue );

magma_int_t
magma_cparilut_zero(
    magma_c_matrix *A,
    magma_queue_t queue );

magma_int_t
magma_cparilu_sweep(
    magma_c_matrix A,
    magma_c_matrix *L,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cparilu_sweep_sync(
    magma_c_matrix A,
    magma_c_matrix *L,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cparic_sweep(
    magma_c_matrix A,
    magma_c_matrix *L,
    magma_queue_t queue );

magma_int_t
magma_cparic_sweep_sync(
    magma_c_matrix A,
    magma_c_matrix *L,
    magma_queue_t queue );

magma_int_t
magma_cparict_sweep_sync(
    magma_c_matrix *A,
    magma_c_matrix *L,
    magma_queue_t queue );

magma_int_t
magma_cparilut_sweep_sync(
    magma_c_matrix *A,
    magma_c_matrix *L,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cparilut_sweep_gpu( 
    magma_c_matrix *A,
    magma_c_matrix *L,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cparilut_residuals_gpu( 
    magma_c_matrix A,
    magma_c_matrix L,
    magma_c_matrix U,
    magma_c_matrix *R,
    magma_queue_t queue );

magma_int_t
magma_cthrsholdrm_gpu(
    magma_int_t order,
    magma_c_matrix* A,
    float* thrs,
    magma_queue_t queue);

magma_int_t
magma_cget_row_ptr(
    const magma_int_t num_rows,
    magma_int_t* nnz,
    const magma_index_t* rowidx,
    magma_index_t* rowptr,
    magma_queue_t queue);

magma_int_t
magma_cvalinit_gpu(
    magma_int_t num_el,
    magmaFloatComplex_ptr dval,
    magma_queue_t queue);

magma_int_t
magma_cindexinit_gpu(
    magma_int_t num_el,
    magmaIndex_ptr dind,
    magma_queue_t queue);

magma_int_t
magma_cparilut_align_residuals(
    magma_c_matrix L,
    magma_c_matrix U,
    magma_c_matrix *Lnew,
    magma_c_matrix *Unew,
    magma_queue_t queue );

magma_int_t
magma_cparilut_preselect_scale(
    magma_c_matrix *L,
    magma_c_matrix *oneL,
    magma_c_matrix *U,
    magma_c_matrix *oneU,
    magma_queue_t queue );

magma_int_t
magma_cparilut_thrsrm_U(
    magma_int_t order,
    magma_c_matrix L,
    magma_c_matrix *A,
    float *thrs,
    magma_queue_t queue );

magma_int_t
magma_cparilut_residuals(
    magma_c_matrix A,
    magma_c_matrix L,
    magma_c_matrix U,
    magma_c_matrix *L_new,
    magma_queue_t queue );

magma_int_t
magma_cparilut_residuals_transpose(
    magma_c_matrix A,
    magma_c_matrix L,
    magma_c_matrix U,
    magma_c_matrix *L_new,
    magma_queue_t queue );

magma_int_t
magma_cparilut_residuals_semilinked(
    magma_c_matrix A,
    magma_c_matrix L,
    magma_c_matrix US,
    magma_c_matrix *L_new,
    magma_queue_t queue );

magma_int_t
magma_cparilut_sweep_semilinked(
    magma_c_matrix *A,
    magma_c_matrix *L,
    magma_c_matrix *US,
    magma_queue_t queue );

magma_int_t
magma_cparilut_sweep_list(
    magma_c_matrix *A,
    magma_c_matrix *L,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cparilut_residuals_list(
    magma_c_matrix A,
    magma_c_matrix L,
    magma_c_matrix U,
    magma_c_matrix *L_new,
    magma_queue_t queue );

magma_int_t
magma_cparilut_sweep_linkedlist(
    magma_c_matrix *A,
    magma_c_matrix *L,
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_cparilut_residuals_linkedlist(
    magma_c_matrix A,
    magma_c_matrix L,
    magma_c_matrix U,
    magma_c_matrix *L_new,
    magma_queue_t queue );

magma_int_t
magma_cparilut_colmajor(
    magma_c_matrix A,
    magma_c_matrix *AC,
    magma_queue_t queue );

magma_int_t
magma_cparilut_colmajorup(
    magma_c_matrix A,
    magma_c_matrix *AC,
    magma_queue_t queue );

magma_int_t
magma_cparict(
    magma_c_matrix A,
    magma_c_matrix b,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cparict_cpu(
    magma_c_matrix A,
    magma_c_matrix b,
    magma_c_preconditioner *precond,
    magma_queue_t queue);

magma_int_t
magma_cparilut(
    magma_c_matrix A,
    magma_c_matrix b,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cparilut_cpu(
    magma_c_matrix A,
    magma_c_matrix b,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cparilut_gpu(
    magma_c_matrix A,
    magma_c_matrix b,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cparilut_gpu_nodp(
    magma_c_matrix A,
    magma_c_matrix b,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cparilut_insert(
    magma_int_t *num_rmL,
    magma_int_t *num_rmU,
    magma_index_t *rm_locL,
    magma_index_t *rm_locU,
    magma_c_matrix *L_new,
    magma_c_matrix *U_new,
    magma_c_matrix *L,
    magma_c_matrix *U,
    magma_c_matrix *UR,
    magma_queue_t queue );

magma_int_t
magma_cparilut_create_collinkedlist(
    magma_c_matrix A,
    magma_c_matrix *B,
    magma_queue_t queue );

magma_int_t
magma_cparilut_candidates(
    magma_c_matrix L0,
    magma_c_matrix U0,
    magma_c_matrix L,
    magma_c_matrix U,
    magma_c_matrix *L_new,
    magma_c_matrix *U_new,
    magma_queue_t queue );

magma_int_t
magma_cparilut_candidates_gpu(
    magma_c_matrix L0,
    magma_c_matrix U0,
    magma_c_matrix L,
    magma_c_matrix U,
    magma_c_matrix *L_new,
    magma_c_matrix *U_new,
    magma_queue_t queue );

magma_int_t
magma_cparict_candidates(
    magma_c_matrix L0,
    magma_c_matrix L,
    magma_c_matrix LT,
    magma_c_matrix *L_new,
    magma_queue_t queue );

magma_int_t
magma_cparilut_candidates_semilinked(
    magma_c_matrix L0,
    magma_c_matrix U0,
    magma_c_matrix L,
    magma_c_matrix U,
    magma_c_matrix UT,
    magma_c_matrix *L_new,
    magma_c_matrix *U_new,
    magma_queue_t queue );

magma_int_t
magma_cparilut_candidates_linkedlist(
    magma_c_matrix L0,
    magma_c_matrix U0,
    magma_c_matrix L,
    magma_c_matrix U,
    magma_c_matrix UR,
    magma_c_matrix *L_new,
    magma_c_matrix *U_new,
    magma_queue_t queue );

magma_int_t
magma_cparilut_rm_thrs(
    float *thrs,
    magma_int_t *num_rm,
    magma_c_matrix *LU,
    magma_c_matrix *LU_new,
    magma_index_t *rm_loc,
    magma_queue_t queue );

magma_int_t
magma_cparilut_count(
    magma_c_matrix L,
    magma_int_t *num,
    magma_queue_t queue );

magma_int_t
magma_cparilut_randlist(
    magma_c_matrix *LU,
    magma_queue_t queue );

magma_int_t
magma_cparilut_select_candidates_L(
    magma_int_t *num_rm,
    magma_index_t *rm_loc,
    magma_c_matrix *L_new,
    magma_queue_t queue );

magma_int_t
magma_cparilut_select_candidates_U(
    magma_int_t *num_rm,
    magma_index_t *rm_loc,
    magma_c_matrix *L_new,
    magma_queue_t queue );

magma_int_t
magma_cparilut_preselect(
    magma_int_t order,
    magma_c_matrix *A,
    magma_c_matrix *oneA,
    magma_queue_t queue );

magma_int_t
magma_cpreselect_gpu(
    magma_int_t order,
    magma_c_matrix *A,
    magma_c_matrix *oneA,
    magma_queue_t queue );

magma_int_t
magma_csampleselect(
    magma_int_t total_size,
    magma_int_t subset_size,
    magmaFloatComplex *val,
    float *thrs,
    magma_ptr *tmp_ptr,
    magma_int_t *tmp_size,
    magma_queue_t queue );

magma_int_t
magma_csampleselect_approx(
    magma_int_t total_size,
    magma_int_t subset_size,
    magmaFloatComplex *val,
    float *thrs,
    magma_ptr *tmp_ptr,
    magma_int_t *tmp_size,
    magma_queue_t queue );


magma_int_t
magma_csampleselect_nodp(
    magma_int_t total_size,
    magma_int_t subset_size,
    magmaFloatComplex *val,
    float *thrs,
    magma_ptr *tmp_ptr,
    magma_int_t *tmp_size,
    magma_queue_t queue );

magma_int_t
magma_csampleselect_approx_nodp(
    magma_int_t total_size,
    magma_int_t subset_size,
    magmaFloatComplex *val,
    float *thrs,
    magma_ptr *tmp_ptr,
    magma_int_t *tmp_size,
    magma_queue_t queue );


// ISAI preconditioner

magma_int_t
magma_cmprepare_batched(
    magma_uplo_t uplotype,
    magma_trans_t transtype,
    magma_diag_t diagtype,
    magma_c_matrix L,
    magma_c_matrix LC,
    magma_index_t *sizes,
    magma_index_t *locations,
    magmaFloatComplex *trisystems,
    magmaFloatComplex *rhs,    
    magma_queue_t queue );

magma_int_t
magma_cmtrisolve_batched(
    magma_uplo_t uplotype,
    magma_trans_t transtype,
    magma_diag_t diagtype,
    magma_c_matrix L,
    magma_c_matrix LC,
    magma_index_t *sizes,
    magma_index_t *locations,
    magmaFloatComplex *trisystems,
    magmaFloatComplex *rhs,    
    magma_queue_t queue );

magma_int_t
magma_cmbackinsert_batched(
    magma_uplo_t uplotype,
    magma_trans_t transtype,
    magma_diag_t diagtype,
    magma_c_matrix *M,
    magma_index_t *sizes,
    magma_index_t *locations,
    magmaFloatComplex *trisystems,
    magmaFloatComplex *rhs,    
    magma_queue_t queue );

magma_int_t
magma_cmprepare_batched_gpu(
    magma_uplo_t uplotype,
    magma_trans_t transtype,
    magma_diag_t diagtype,
    magma_c_matrix L,
    magma_c_matrix LC,
    magma_index_t *sizes,
    magma_index_t *locations,
    magmaFloatComplex *trisystems,
    magmaFloatComplex *rhs,    
    magma_queue_t queue );

magma_int_t
magma_cmtrisolve_batched_gpu(
    magma_uplo_t uplotype,
    magma_trans_t transtype,
    magma_diag_t diagtype,
    magma_c_matrix L,
    magma_c_matrix LC,
    magma_index_t *sizes,
    magma_index_t *locations,
    magmaFloatComplex *trisystems,
    magmaFloatComplex *rhs,    
    magma_queue_t queue );

magma_int_t
magma_cmbackinsert_batched_gpu(
    magma_uplo_t uplotype,
    magma_trans_t transtype,
    magma_diag_t diagtype,
    magma_c_matrix *M,
    magma_index_t *sizes,
    magma_index_t *locations,
    magmaFloatComplex *trisystems,
    magmaFloatComplex *rhs,    
    magma_queue_t queue );

magma_int_t
magma_ciluisaisetup_lower(
    magma_c_matrix L,
    magma_c_matrix S,
    magma_c_matrix *ISAIL,
    magma_queue_t queue );

magma_int_t
magma_ciluisaisetup_upper(
    magma_c_matrix U,
    magma_c_matrix S,
    magma_c_matrix *ISAIU,
    magma_queue_t queue );

magma_int_t
magma_cicisaisetup(
    magma_c_matrix A,
    magma_c_matrix b,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cisai_l(
    magma_c_matrix b,
    magma_c_matrix *x,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cisai_r(
    magma_c_matrix b,
    magma_c_matrix *x,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cisai_l_t(
    magma_c_matrix b,
    magma_c_matrix *x,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cisai_r_t(
    magma_c_matrix b,
    magma_c_matrix *x,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cmiluisai_sizecheck(
    magma_c_matrix A,
    magma_index_t batchsize,
    magma_index_t *maxsize,
    magma_queue_t queue );

magma_int_t
magma_cgeisai_maxblock(
    magma_c_matrix L,
    magma_c_matrix *MT,
    magma_queue_t queue );

magma_int_t
magma_cisai_generator_regs(
    magma_uplo_t uplotype,
    magma_trans_t transtype,
    magma_diag_t diagtype,
    magma_c_matrix L,
    magma_c_matrix *M,
    magma_queue_t queue );

magma_int_t
magma_ccsr_sort(
    magma_c_matrix *A,
    magma_queue_t queue);

magma_int_t
magma_ccsr_sort_gpu(
    magma_c_matrix *A,
    magma_queue_t queue);

// #endif
/* ////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE function definitions / Data on CPU
*/


/* ////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE supernodal and RCM reordering
*/
magma_int_t
magma_cmsupernodal(
    magma_int_t *max_bs,
    magma_c_matrix A,
    magma_c_matrix *S,
    magma_queue_t queue );

magma_int_t
magma_cmvarsizeblockstruct(
    magma_int_t n,
    magma_int_t *bs,
    magma_int_t bsl,
    magma_uplo_t uplotype,
    magma_c_matrix *A,
    magma_queue_t queue );



/* ////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE function definitions / Data on CPU / Multi-GPU
*/

/* ////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE iterative solvers (Data on GPU)
*/

magma_int_t 
magma_ccg(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t 
magma_ccg_res(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t 
magma_ccg_merge(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cpcg_merge(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_ccgs(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_ccgs_merge(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cpcgs(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cpcgs_merge(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cqmr(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cpqmr(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cqmr_merge(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cpqmr_merge(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_ctfqmr(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_ctfqmr_unrolled(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_ctfqmr_merge(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cptfqmr(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cptfqmr_merge(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cbicgstab(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x, 
    magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cbicg(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cbicgstab_merge(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cbicgstab_merge2(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cbicgstab_merge3(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cpcg(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par, 
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cbpcg(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par, 
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cpbicg(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par, 
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cpbicgstab(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par, 
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cpbicgstab_merge(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par, 
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cfgmres(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par, 
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cbfgmres(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par, 
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cidr(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cidr_merge(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cidr_strms(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cpidr(
    magma_c_matrix A, magma_c_matrix b,
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cpidr_merge(
    magma_c_matrix A, magma_c_matrix b,
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cpidr_strms(
    magma_c_matrix A, magma_c_matrix b,
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cbombard(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cbombard_merge(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cjacobi(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cjacobidomainoverlap(
    magma_c_matrix A, 
    magma_c_matrix b, 
    magma_c_matrix *x,  
    magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cbaiter(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cbaiter_overlap(
    magma_c_matrix A, magma_c_matrix b,
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cftjacobicontractions(
    magma_c_matrix xkm2,
    magma_c_matrix xkm1, 
    magma_c_matrix xk, 
    magma_c_matrix *z,
    magma_c_matrix *c,
    magma_queue_t queue );

magma_int_t
magma_cftjacobiupdatecheck(
    float delta,
    magma_c_matrix *xold,
    magma_c_matrix *xnew, 
    magma_c_matrix *zprev, 
    magma_c_matrix c,
    magma_int_t *flag_t,
    magma_int_t *flag_fp,
    magma_queue_t queue );

magma_int_t
magma_citerref(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par, 
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

magma_int_t
magma_cbcsrlu(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );


magma_int_t
magma_cbcsrlutrf(
    magma_c_matrix A, 
    magma_c_matrix *M,
    magma_int_t *ipiv, 
    magma_int_t version,
    magma_queue_t queue );

magma_int_t
magma_cbcsrlusv(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par, 
    magma_int_t *ipiv,
    magma_queue_t queue );



magma_int_t
magma_cilucg(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cilugmres(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue ); 


magma_int_t
magma_clobpcg_shift(
    magma_int_t num_rows,
    magma_int_t num_vecs, 
    magma_int_t shift,
    magmaFloatComplex_ptr x,
    magma_queue_t queue );

magma_int_t
magma_clobpcg_res(
    magma_int_t num_rows,
    magma_int_t num_vecs, 
    float *evalues, 
    magmaFloatComplex_ptr X,
    magmaFloatComplex_ptr R, 
    float *res,
    magma_queue_t queue );

magma_int_t
magma_clobpcg_maxpy(
    magma_int_t num_rows,
    magma_int_t num_vecs, 
    magmaFloatComplex_ptr X,
    magmaFloatComplex_ptr Y,
    magma_queue_t queue );


/*/////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE eigensolvers (Data on GPU)
*/
magma_int_t
magma_clobpcg(
    magma_c_matrix A, 
    magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par, 
    magma_queue_t queue );

/*/////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE LSQR (Data on GPU)
*/
magma_int_t
magma_clsqr(
    magma_c_matrix A, magma_c_matrix b, magma_c_matrix *x,
    magma_c_solver_par *solver_par,
    magma_c_preconditioner *precond_par,
    magma_queue_t queue );

/* ////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE direct solvers (Data on GPU)
*/

magma_int_t 
magma_cpardiso(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_solver_par *solver_par,
    magma_queue_t queue );

/*/////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE preconditioners (Data on GPU)
*/

magma_int_t
magma_cjacobisetup(
    magma_c_matrix A, 
    magma_c_matrix b, 
    magma_c_matrix *M, 
    magma_c_matrix *c,
    magma_queue_t queue );

magma_int_t
magma_cjacobisetup_matrix(
    magma_c_matrix A, 
    magma_c_matrix *M, 
    magma_c_matrix *d,
    magma_queue_t queue );

magma_int_t
magma_cjacobisetup_vector(
    magma_c_matrix b, 
    magma_c_matrix d, 
    magma_c_matrix *c,
    magma_queue_t queue );

magma_int_t
magma_cjacobiiter(
    magma_c_matrix M, 
    magma_c_matrix c, 
    magma_c_matrix *x, 
    magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cjacobiiter_precond( 
    magma_c_matrix M, 
    magma_c_matrix *x, 
    magma_c_solver_par *solver_par, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cjacobiiter_sys(
    magma_c_matrix A, 
    magma_c_matrix b, 
    magma_c_matrix d, 
    magma_c_matrix t, 
    magma_c_matrix *x,  
    magma_c_solver_par *solver_par,
    magma_queue_t queue );

magma_int_t
magma_cftjacobi(
    magma_c_matrix A, 
    magma_c_matrix b, 
    magma_c_matrix *x,  
    magma_c_solver_par *solver_par,
    magma_queue_t queue );

// custom preconditioner
magma_int_t
magma_capplycustomprecond_l(
    magma_c_matrix b, 
    magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_capplycustomprecond_r(
    magma_c_matrix b, 
    magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );


// CUSPARSE preconditioner

magma_int_t
magma_ccuilusetup(
    magma_c_matrix A, magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cilut_saad( 
    magma_c_matrix A,
    magma_c_matrix b,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_cilut_saad_apply( 
    magma_c_matrix b,
    magma_c_matrix *x,
    magma_c_preconditioner *precond,
    magma_queue_t queue );


magma_int_t
magma_ccumilusetup_transpose(
    magma_c_matrix A, magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_capplycuilu_l(
    magma_c_matrix b, magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_capplycuilu_r(
    magma_c_matrix b, magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_ccuiccsetup(
    magma_c_matrix A, magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_capplycuicc_l(
    magma_c_matrix b, magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_capplycuicc_r(
    magma_c_matrix b, magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );


magma_int_t
magma_ccumilusetup(
    magma_c_matrix A, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_ccustomilusetup(
    magma_c_matrix A,
    magma_c_matrix b,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_ccustomicsetup(
    magma_c_matrix A,
    magma_c_matrix b,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_ccumilugeneratesolverinfo(
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_capplycumilu_l(
    magma_c_matrix b, 
    magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_capplycumilu_r(
    magma_c_matrix b, 
    magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_capplycumilu_l_transpose(
    magma_c_matrix b, magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_capplycumilu_r_transpose(
    magma_c_matrix b, magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );



magma_int_t
magma_ccumiccsetup(
    magma_c_matrix A, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_ccumicgeneratesolverinfo(
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_capplycumicc_l(
    magma_c_matrix b, 
    magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_capplycumicc_r(
    magma_c_matrix b, 
    magma_c_matrix *x, 
    magma_c_preconditioner *precond,
    magma_queue_t queue );


// block-asynchronous iteration

magma_int_t
magma_cbajac_csr(
    magma_int_t localiters,
    magma_c_matrix D,
    magma_c_matrix R,
    magma_c_matrix b,
    magma_c_matrix *x,
    magma_queue_t queue );

magma_int_t
magma_cbajac_csr_overlap(
    magma_int_t localiters,
    magma_int_t matrices,
    magma_int_t overlap,
    magma_c_matrix *D,
    magma_c_matrix *R,
    magma_c_matrix b,
    magma_c_matrix *x,
    magma_queue_t queue );

/* ////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE utility function definitions
*/

magma_int_t
magma_c_spmv(
    magmaFloatComplex alpha, 
    magma_c_matrix A, 
    magma_c_matrix x, 
    magmaFloatComplex beta, 
    magma_c_matrix y,
    magma_queue_t queue );

magma_int_t
magma_ccustomspmv(
    magma_int_t m,
    magma_int_t n,
    magmaFloatComplex alpha, 
    magmaFloatComplex beta, 
    magmaFloatComplex_ptr x, 
    magmaFloatComplex_ptr y, 
    magma_queue_t queue );

magma_int_t
magma_c_spmv_shift(
    magmaFloatComplex alpha, 
    magma_c_matrix A, 
    magmaFloatComplex lambda,
    magma_c_matrix x, 
    magmaFloatComplex beta, 
    magma_int_t offset, 
    magma_int_t blocksize,
    magmaIndex_ptr dadd_vecs, 
    magma_c_matrix y,
    magma_queue_t queue );

magma_int_t
magma_ccuspmm(
    magma_c_matrix A, 
    magma_c_matrix B, 
    magma_c_matrix *AB,
    magma_queue_t queue );

magma_int_t
magma_c_spmm(
    magmaFloatComplex alpha, 
    magma_c_matrix A,
    magma_c_matrix B,
    magma_c_matrix *C,
    magma_queue_t queue );

magma_int_t
magma_csymbilu( 
    magma_c_matrix *A, 
    magma_int_t levels, 
    magma_c_matrix *L, 
    magma_c_matrix *U,
    magma_queue_t queue );

magma_int_t
magma_ccuspaxpy(
    magmaFloatComplex_ptr alpha, magma_c_matrix A, 
    magmaFloatComplex_ptr beta, magma_c_matrix B, 
    magma_c_matrix *AB,
    magma_queue_t queue );

magma_int_t
magma_c_precond(
    magma_c_matrix A, 
    magma_c_matrix b, magma_c_matrix *x,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_c_solver(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_copts *zopts,
    magma_queue_t queue );

magma_int_t
magma_c_precondsetup(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_solver_par *solver,
    magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_c_applyprecond(
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_preconditioner *precond,
    magma_queue_t queue );


magma_int_t
magma_c_applyprecond_left(
    magma_trans_t trans,
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_preconditioner *precond,
    magma_queue_t queue );


magma_int_t
magma_c_applyprecond_right(
    magma_trans_t trans,
    magma_c_matrix A, magma_c_matrix b, 
    magma_c_matrix *x, magma_c_preconditioner *precond,
    magma_queue_t queue );

magma_int_t
magma_c_initP2P(
    magma_int_t *bandwidth_benchmark,
    magma_int_t *num_gpus,
    magma_queue_t queue );

magma_int_t
magma_ccompact(
    magma_int_t m, magma_int_t n,
    magmaFloatComplex_ptr dA, magma_int_t ldda,
    float *dnorms, float tol, 
    magma_int_t *activeMask, magma_int_t *cBlockSize,
    magma_queue_t queue );

magma_int_t
magma_ccompactActive(
    magma_int_t m, magma_int_t n,
    magmaFloatComplex_ptr dA, magma_int_t ldda, 
    magma_int_t *active,
    magma_queue_t queue );

magma_int_t
magma_cmlumerge(    
    magma_c_matrix L, 
    magma_c_matrix U,
    magma_c_matrix *A, 
    magma_queue_t queue );

magma_int_t
magma_cdiagcheck(
    magma_c_matrix dA,
    magma_queue_t queue );

magma_int_t
magma_cdiagcheck_cpu(
    magma_c_matrix A,
    magma_queue_t queue );



/*/////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE wrappers to dense MAGMA
*/
magma_int_t
magma_cqr(
    magma_int_t m, 
    magma_int_t n, 
    magma_c_matrix A, 
    magma_int_t lda, 
    magma_c_matrix *Q, 
    magma_c_matrix *R, 
    magma_queue_t queue );


/* ////////////////////////////////////////////////////////////////////////////
 -- MAGMA_SPARSE BLAS function definitions
*/

magma_int_t
magma_cgeaxpy(
    magmaFloatComplex alpha,
    magma_c_matrix X,
    magmaFloatComplex beta,
    magma_c_matrix *Y,
    magma_queue_t queue );

magma_int_t
magma_cgecsrreimsplit(
    magma_c_matrix A,
    magma_c_matrix *ReA,
    magma_c_matrix *ImA,
    magma_queue_t queue );

magma_int_t
magma_cgedensereimsplit(
    magma_c_matrix A,
    magma_c_matrix *ReA,
    magma_c_matrix *ImA,
    magma_queue_t queue );

magma_int_t 
magma_cgecsrmv(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr drowptr,
    magmaIndex_ptr dcolind,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );

magma_int_t 
magma_cgecsrmv_shift(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magmaFloatComplex alpha,
    magmaFloatComplex lambda,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr drowptr,
    magmaIndex_ptr dcolind,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magma_int_t offset,
    magma_int_t blocksize,
    magmaIndex_ptr dadd_rows,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );

magma_int_t 
magma_cmgecsrmv(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magma_int_t num_vecs,
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr drowptr,
    magmaIndex_ptr dcolind,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );

magma_int_t 
magma_cgeellmv(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magma_int_t nnz_per_row,
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr dcolind,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );

magma_int_t 
magma_cgeellmv_shift(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magma_int_t nnz_per_row,
    magmaFloatComplex alpha,
    magmaFloatComplex lambda,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr dcolind,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magma_int_t offset,
    magma_int_t blocksize,
    magmaIndex_ptr dadd_rows,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );


magma_int_t 
magma_cmgeellmv(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magma_int_t num_vecs,
    magma_int_t nnz_per_row,
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr dcolind,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );


magma_int_t 
magma_cgeelltmv(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magma_int_t nnz_per_row,
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr dcolind,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );

magma_int_t 
magma_cgeelltmv_shift(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magma_int_t nnz_per_row,
    magmaFloatComplex alpha,
    magmaFloatComplex lambda,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr dcolind,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magma_int_t offset,
    magma_int_t blocksize,
    magmaIndex_ptr dadd_rows,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );


magma_int_t 
magma_cmgeelltmv(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magma_int_t num_vecs,
    magma_int_t nnz_per_row,
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr dcolind,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );

magma_int_t 
magma_cgeellrtmv(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magma_int_t nnz_per_row,
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr dcolind,
    magmaIndex_ptr drowlength,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magmaFloatComplex_ptr dy,
    magma_int_t num_threads,
    magma_int_t threads_per_row,
    magma_queue_t queue );

magma_int_t 
magma_cgesellcmv(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magma_int_t blocksize,
    magma_int_t slices,
    magma_int_t alignment,
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr dcolind,
    magmaIndex_ptr drowptr,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );

magma_int_t
magma_cgesellpmv(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magma_int_t blocksize,
    magma_int_t slices,
    magma_int_t alignment,
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr dcolind,
    magmaIndex_ptr drowptr,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );

magma_int_t
magma_cmgesellpmv(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magma_int_t num_vecs,
    magma_int_t blocksize,
    magma_int_t slices,
    magma_int_t alignment,
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr dcolind,
    magmaIndex_ptr drowptr,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );

magma_int_t
magma_cmgesellpmv_blocked(
    magma_trans_t transA,
    magma_int_t m, magma_int_t n,
    magma_int_t num_vecs,
    magma_int_t blocksize,
    magma_int_t slices,
    magma_int_t alignment,
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr dval,
    magmaIndex_ptr dcolind,
    magmaIndex_ptr drowptr,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex beta,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );

magma_int_t
magma_cgecsr5mv(
    magma_trans_t           transA,
    magma_int_t             m, 
    magma_int_t             n, 
    magma_int_t             p,
    magmaFloatComplex      alpha,
    magma_int_t             sigma,
    magma_int_t             bit_y_offset,
    magma_int_t             bit_scansum_offset,
    magma_int_t             num_packet,
    magmaUIndex_ptr         dtile_ptr,
    magmaUIndex_ptr         dtile_desc,
    magmaIndex_ptr          dtile_desc_offset_ptr,
    magmaIndex_ptr          dtile_desc_offset,
    magmaFloatComplex_ptr  dcalibrator,
    magma_int_t             tail_tile_start,
    magmaFloatComplex_ptr  dval,
    magmaIndex_ptr          drowptr,
    magmaIndex_ptr          dcolind,
    magmaFloatComplex_ptr  dx,
    magmaFloatComplex      beta,
    magmaFloatComplex_ptr  dy,
    magma_queue_t           queue );

magma_int_t
magma_cgecscsyncfreetrsm_analysis(
    magma_int_t             m, 
    magma_int_t             nnz,
    magmaFloatComplex_ptr  dval,
    magmaIndex_ptr          dcolptr,
    magmaIndex_ptr          drowind, 
    magmaIndex_ptr          dgraphindegree, 
    magmaIndex_ptr          dgraphindegree_bak, 
    magma_queue_t           queue );

magma_int_t
magma_cgecscsyncfreetrsm_solve(
    magma_int_t             m, 
    magma_int_t             nnz,
    magmaFloatComplex_ptr  dval,
    magmaIndex_ptr          dcolptr,
    magmaIndex_ptr          drowind,
    magmaIndex_ptr          dgraphindegree, 
    magmaIndex_ptr          dgraphindegree_bak, 
    magmaFloatComplex_ptr  dx,
    magmaFloatComplex_ptr  db,
    magma_int_t             substitution, 
    magma_int_t             rhs, 
    magma_queue_t           queue );

magma_int_t
magma_cmergedgs(
    magma_int_t n, 
    magma_int_t ldh,
    magma_int_t k, 
    magmaFloatComplex_ptr dv, 
    magmaFloatComplex_ptr dr,
    magmaFloatComplex_ptr dskp,
    magma_queue_t queue );

magma_int_t
magma_ccopyscale(    
    magma_int_t n, 
    magma_int_t k,
    magmaFloatComplex_ptr dr, 
    magmaFloatComplex_ptr dv,
    magmaFloatComplex_ptr dskp,
    magma_queue_t queue );

magma_int_t
magma_scnrm2scale(    
    magma_int_t m, 
    magmaFloatComplex_ptr dr,    
    magma_int_t lddr, 
    magmaFloatComplex *drnorm,
    magma_queue_t queue );


magma_int_t
magma_cjacobisetup_vector_gpu(
    magma_int_t num_rows, 
    magma_c_matrix b, 
    magma_c_matrix d, 
    magma_c_matrix c,
    magma_c_matrix *x,
    magma_queue_t queue );


magma_int_t
magma_cjacobi_diagscal(    
    magma_int_t num_rows, 
    magma_c_matrix d, 
    magma_c_matrix b, 
    magma_c_matrix *c,
    magma_queue_t queue );

magma_int_t
magma_cjacobiupdate(
    magma_c_matrix t, 
    magma_c_matrix b, 
    magma_c_matrix d, 
    magma_c_matrix *x,
    magma_queue_t queue );

magma_int_t
magma_cjacobispmvupdate(
    magma_int_t maxiter,
    magma_c_matrix A, 
    magma_c_matrix t, 
    magma_c_matrix b, 
    magma_c_matrix d, 
    magma_c_matrix *x,
    magma_queue_t queue );

magma_int_t
magma_cjacobispmvupdate_bw(
    magma_int_t maxiter,
    magma_c_matrix A, 
    magma_c_matrix t, 
    magma_c_matrix b, 
    magma_c_matrix d, 
    magma_c_matrix *x,
    magma_queue_t queue );

magma_int_t
magma_cjacobispmvupdateselect(
    magma_int_t maxiter,
    magma_int_t num_updates,
    magma_index_t *indices,
    magma_c_matrix A,
    magma_c_matrix t, 
    magma_c_matrix b, 
    magma_c_matrix d, 
    magma_c_matrix tmp, 
    magma_c_matrix *x,
    magma_queue_t queue );

magma_int_t
magma_cjacobisetup_diagscal(
    magma_c_matrix A, magma_c_matrix *d,
    magma_queue_t queue );


//##################   kernel fusion for Krylov methods

magma_int_t
magma_cmergeblockkrylov(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex_ptr alpha, 
    magmaFloatComplex_ptr p,
    magmaFloatComplex_ptr x,
    magma_queue_t queue );

magma_int_t
magma_cbicgmerge1(    
    magma_int_t n, 
    magmaFloatComplex_ptr dskp,
    magmaFloatComplex_ptr dv, 
    magmaFloatComplex_ptr dr, 
    magmaFloatComplex_ptr dp,
    magma_queue_t queue );


magma_int_t
magma_cbicgmerge2(
    magma_int_t n, 
    magmaFloatComplex_ptr dskp, 
    magmaFloatComplex_ptr dr,
    magmaFloatComplex_ptr dv, 
    magmaFloatComplex_ptr ds,
    magma_queue_t queue );

magma_int_t
magma_cbicgmerge3(
    magma_int_t n, 
    magmaFloatComplex_ptr dskp, 
    magmaFloatComplex_ptr dp,
    magmaFloatComplex_ptr ds,
    magmaFloatComplex_ptr dt,
    magmaFloatComplex_ptr dx, 
    magmaFloatComplex_ptr dr,
    magma_queue_t queue );

magma_int_t
magma_cbicgmerge4(
    magma_int_t type, 
    magmaFloatComplex_ptr dskp,
    magma_queue_t queue );

magma_int_t
magma_cidr_smoothing_1(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex_ptr drs,
    magmaFloatComplex_ptr dr, 
    magmaFloatComplex_ptr dt, 
    magma_queue_t queue );

magma_int_t
magma_cidr_smoothing_2(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex omega,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex_ptr dxs, 
    magma_queue_t queue );

magma_int_t
magma_ccgs_1(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex beta,
    magmaFloatComplex_ptr r,
    magmaFloatComplex_ptr q, 
    magmaFloatComplex_ptr u,
    magmaFloatComplex_ptr p,
    magma_queue_t queue );

magma_int_t
magma_ccgs_2(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex_ptr r,
    magmaFloatComplex_ptr u,
    magmaFloatComplex_ptr p, 
    magma_queue_t queue );

magma_int_t
magma_ccgs_3(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr v_hat,
    magmaFloatComplex_ptr u, 
    magmaFloatComplex_ptr q,
    magmaFloatComplex_ptr t, 
    magma_queue_t queue );

magma_int_t
magma_ccgs_4(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr u_hat,
    magmaFloatComplex_ptr t,
    magmaFloatComplex_ptr x, 
    magmaFloatComplex_ptr r,
    magma_queue_t queue );

magma_int_t
magma_cqmr_1(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex rho,
    magmaFloatComplex psi,
    magmaFloatComplex_ptr y, 
    magmaFloatComplex_ptr z,
    magmaFloatComplex_ptr v,
    magmaFloatComplex_ptr w,
    magma_queue_t queue );

magma_int_t
magma_cqmr_2(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex pde,
    magmaFloatComplex rde,
    magmaFloatComplex_ptr y,
    magmaFloatComplex_ptr z,
    magmaFloatComplex_ptr p, 
    magmaFloatComplex_ptr q, 
    magma_queue_t queue );

magma_int_t
magma_cqmr_3(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex beta,
    magmaFloatComplex_ptr pt,
    magmaFloatComplex_ptr v,
    magmaFloatComplex_ptr y,
    magma_queue_t queue );

magma_int_t
magma_cqmr_4(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex eta,
    magmaFloatComplex_ptr p,
    magmaFloatComplex_ptr pt,
    magmaFloatComplex_ptr d, 
    magmaFloatComplex_ptr s, 
    magmaFloatComplex_ptr x, 
    magmaFloatComplex_ptr r, 
    magma_queue_t queue );

magma_int_t
magma_cqmr_5(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex eta,
    magmaFloatComplex pds,
    magmaFloatComplex_ptr p,
    magmaFloatComplex_ptr pt,
    magmaFloatComplex_ptr d, 
    magmaFloatComplex_ptr s, 
    magmaFloatComplex_ptr x, 
    magmaFloatComplex_ptr r, 
    magma_queue_t queue );

magma_int_t
magma_cqmr_6(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex beta,
    magmaFloatComplex rho,
    magmaFloatComplex psi,
    magmaFloatComplex_ptr y, 
    magmaFloatComplex_ptr z,
    magmaFloatComplex_ptr v,
    magmaFloatComplex_ptr w,
    magmaFloatComplex_ptr wt,
    magma_queue_t queue );

magma_int_t
magma_cqmr_7(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex beta,
    magmaFloatComplex_ptr pt,
    magmaFloatComplex_ptr v,
    magmaFloatComplex_ptr vt,
    magma_queue_t queue );

magma_int_t
magma_cqmr_8(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex rho,
    magmaFloatComplex psi,
    magmaFloatComplex_ptr vt,
    magmaFloatComplex_ptr wt,
    magmaFloatComplex_ptr y, 
    magmaFloatComplex_ptr z,
    magmaFloatComplex_ptr v,
    magmaFloatComplex_ptr w,
    magma_queue_t queue );

magma_int_t
magma_cbicgstab_1(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex beta,
    magmaFloatComplex omega,
    magmaFloatComplex_ptr r, 
    magmaFloatComplex_ptr v,
    magmaFloatComplex_ptr p,
    magma_queue_t queue );

magma_int_t
magma_cbicgstab_2(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex alpha,
    magmaFloatComplex_ptr r,
    magmaFloatComplex_ptr v,
    magmaFloatComplex_ptr s, 
    magma_queue_t queue );

magma_int_t
magma_cbicgstab_3(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex alpha,
    magmaFloatComplex omega,
    magmaFloatComplex_ptr p,
    magmaFloatComplex_ptr s,
    magmaFloatComplex_ptr t,
    magmaFloatComplex_ptr x,
    magmaFloatComplex_ptr r,
    magma_queue_t queue );

magma_int_t
magma_cbicgstab_4(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex alpha,
    magmaFloatComplex omega,
    magmaFloatComplex_ptr y,
    magmaFloatComplex_ptr z,
    magmaFloatComplex_ptr s,
    magmaFloatComplex_ptr t,
    magmaFloatComplex_ptr x,
    magmaFloatComplex_ptr r,
    magma_queue_t queue );

magma_int_t
magma_ctfqmr_1(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex alpha,
    magmaFloatComplex sigma,
    magmaFloatComplex_ptr v, 
    magmaFloatComplex_ptr Au,
    magmaFloatComplex_ptr u_m,
    magmaFloatComplex_ptr pu_m,
    magmaFloatComplex_ptr u_mp1,
    magmaFloatComplex_ptr w, 
    magmaFloatComplex_ptr d,
    magmaFloatComplex_ptr Ad,
    magma_queue_t queue );

magma_int_t
magma_ctfqmr_2(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex eta,
    magmaFloatComplex_ptr d,
    magmaFloatComplex_ptr Ad,
    magmaFloatComplex_ptr x, 
    magmaFloatComplex_ptr r, 
    magma_queue_t queue );

magma_int_t
magma_ctfqmr_3(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex beta,
    magmaFloatComplex_ptr w,
    magmaFloatComplex_ptr u_m,
    magmaFloatComplex_ptr u_mp1, 
    magma_queue_t queue );

magma_int_t
magma_ctfqmr_4(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex beta,
    magmaFloatComplex_ptr Au_new,
    magmaFloatComplex_ptr v,
    magmaFloatComplex_ptr Au, 
    magma_queue_t queue );

magma_int_t
magma_ctfqmr_5(  
    magma_int_t num_rows, 
    magma_int_t num_cols, 
    magmaFloatComplex alpha,
    magmaFloatComplex sigma,
    magmaFloatComplex_ptr v, 
    magmaFloatComplex_ptr Au,
    magmaFloatComplex_ptr u_mp1,
    magmaFloatComplex_ptr w, 
    magmaFloatComplex_ptr d,
    magmaFloatComplex_ptr Ad,
    magma_queue_t queue );

magma_int_t
magma_ccgmerge_spmv1( 
    magma_c_matrix A,
    magmaFloatComplex_ptr d1,
    magmaFloatComplex_ptr d2,
    magmaFloatComplex_ptr dd,
    magmaFloatComplex_ptr dz,
    magmaFloatComplex_ptr dskp,
    magma_queue_t queue );

magma_int_t
magma_ccgmerge_xrbeta( 
    magma_int_t n,
    magmaFloatComplex_ptr d1,
    magmaFloatComplex_ptr d2,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex_ptr dr,
    magmaFloatComplex_ptr dd,
    magmaFloatComplex_ptr dz, 
    magmaFloatComplex_ptr dskp,
    magma_queue_t queue );


magma_int_t
magma_cpcgmerge_xrbeta1(
    magma_int_t n,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex_ptr dr,
    magmaFloatComplex_ptr dd,
    magmaFloatComplex_ptr dz, 
    magmaFloatComplex_ptr skp,
    magma_queue_t queue );

magma_int_t
magma_cpcgmerge_xrbeta2(
    magma_int_t n,
    magmaFloatComplex_ptr d1,
    magmaFloatComplex_ptr d2,
    magmaFloatComplex_ptr dh,
    magmaFloatComplex_ptr dr, 
    magmaFloatComplex_ptr dd, 
    magmaFloatComplex_ptr skp,
    magma_queue_t queue );

magma_int_t
magma_cjcgmerge_xrbeta(
    magma_int_t n,
    magmaFloatComplex_ptr d1,
    magmaFloatComplex_ptr d2,
    magmaFloatComplex_ptr diag,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex_ptr dr,
    magmaFloatComplex_ptr dd,
    magmaFloatComplex_ptr dz,
    magmaFloatComplex_ptr dh, 
    magmaFloatComplex_ptr skp,
    magma_queue_t queue );

magma_int_t
magma_cmdotc_shfl(
    magma_int_t n, 
    magma_int_t k, 
    magmaFloatComplex_ptr dv, 
    magmaFloatComplex_ptr dr,
    magmaFloatComplex_ptr dd1,
    magmaFloatComplex_ptr dd2,
    magmaFloatComplex_ptr dskp,
    magma_queue_t queue );

magma_int_t
magma_cmdotc(
    magma_int_t n, 
    magma_int_t k, 
    magmaFloatComplex_ptr dv, 
    magmaFloatComplex_ptr dr,
    magmaFloatComplex_ptr dd1,
    magmaFloatComplex_ptr dd2,
    magmaFloatComplex_ptr dskp,
    magma_queue_t queue );

magma_int_t
magma_cgemvmdot_shfl(
    magma_int_t n, 
    magma_int_t k, 
    magmaFloatComplex_ptr dv, 
    magmaFloatComplex_ptr dr,
    magmaFloatComplex_ptr dd1,
    magmaFloatComplex_ptr dd2,
    magmaFloatComplex_ptr dskp,
    magma_queue_t queue );


magma_int_t
magma_cgemvmdot(
    magma_int_t n, 
    magma_int_t k, 
    magmaFloatComplex_ptr dv, 
    magmaFloatComplex_ptr dr,
    magmaFloatComplex_ptr dd1,
    magmaFloatComplex_ptr dd2,
    magmaFloatComplex_ptr dskp,
    magma_queue_t queue );


magma_int_t
magma_cmdotc1(
    magma_int_t n,  
    magmaFloatComplex_ptr v0, 
    magmaFloatComplex_ptr w0,
    magmaFloatComplex_ptr d1,
    magmaFloatComplex_ptr d2,
    magmaFloatComplex_ptr skp,
    magma_queue_t queue );

magma_int_t
magma_cmdotc2(
    magma_int_t n,  
    magmaFloatComplex_ptr v0, 
    magmaFloatComplex_ptr w0,
    magmaFloatComplex_ptr v1, 
    magmaFloatComplex_ptr w1,
    magmaFloatComplex_ptr d1,
    magmaFloatComplex_ptr d2,
    magmaFloatComplex_ptr skp,
    magma_queue_t queue );

magma_int_t
magma_cmdotc3(
    magma_int_t n,  
    magmaFloatComplex_ptr v0, 
    magmaFloatComplex_ptr w0,
    magmaFloatComplex_ptr v1, 
    magmaFloatComplex_ptr w1,
    magmaFloatComplex_ptr v2, 
    magmaFloatComplex_ptr w2,
    magmaFloatComplex_ptr d1,
    magmaFloatComplex_ptr d2,
    magmaFloatComplex_ptr skp,
    magma_queue_t queue );

magma_int_t
magma_cmdotc4(
    magma_int_t n,  
    magmaFloatComplex_ptr v0, 
    magmaFloatComplex_ptr w0,
    magmaFloatComplex_ptr v1, 
    magmaFloatComplex_ptr w1,
    magmaFloatComplex_ptr v2, 
    magmaFloatComplex_ptr w2,
    magmaFloatComplex_ptr v3, 
    magmaFloatComplex_ptr w3,
    magmaFloatComplex_ptr d1,
    magmaFloatComplex_ptr d2,
    magmaFloatComplex_ptr skp,
    magma_queue_t queue );

magma_int_t
magma_cbicgmerge_spmv1( 
    magma_c_matrix A,
    magmaFloatComplex_ptr dd1,
    magmaFloatComplex_ptr dd2,
    magmaFloatComplex_ptr dp,
    magmaFloatComplex_ptr dr,
    magmaFloatComplex_ptr dv,
    magmaFloatComplex_ptr dskp,
    magma_queue_t queue );

magma_int_t
magma_cbicgmerge_spmv2( 
    magma_c_matrix A,
    magmaFloatComplex_ptr dd1,
    magmaFloatComplex_ptr dd2,
    magmaFloatComplex_ptr ds,
    magmaFloatComplex_ptr dt,
    magmaFloatComplex_ptr dskp,
    magma_queue_t queue );

magma_int_t
magma_cbicgmerge_xrbeta( 
    magma_int_t n,
    magmaFloatComplex_ptr dd1,
    magmaFloatComplex_ptr dd2,
    magmaFloatComplex_ptr drr,
    magmaFloatComplex_ptr dr,
    magmaFloatComplex_ptr dp,
    magmaFloatComplex_ptr ds,
    magmaFloatComplex_ptr dt,
    magmaFloatComplex_ptr dx, 
    magmaFloatComplex_ptr dskp,
    magma_queue_t queue );

magma_int_t
magma_cbcsrswp(
    magma_int_t n,
    magma_int_t size_b, 
    magma_int_t *ipiv,
    magmaFloatComplex_ptr dx,
    magma_queue_t queue );

magma_int_t
magma_cbcsrtrsv(
    magma_uplo_t uplo,
    magma_int_t r_blocks,
    magma_int_t c_blocks,
    magma_int_t size_b, 
    magmaFloatComplex_ptr dA,
    magma_index_t *blockinfo, 
    magmaFloatComplex_ptr dx,
    magma_queue_t queue );

magma_int_t
magma_cbcsrvalcpy(
    magma_int_t size_b, 
    magma_int_t num_blocks, 
    magma_int_t num_zero_blocks, 
    magmaFloatComplex_ptr *dAval, 
    magmaFloatComplex_ptr *dBval,
    magmaFloatComplex_ptr *dBval2,
    magma_queue_t queue );

magma_int_t
magma_cbcsrluegemm(
    magma_int_t size_b, 
    magma_int_t num_block_rows,
    magma_int_t kblocks,
    magmaFloatComplex_ptr *dA, 
    magmaFloatComplex_ptr *dB, 
    magmaFloatComplex_ptr *dC,
    magma_queue_t queue );

magma_int_t
magma_cbcsrlupivloc(
    magma_int_t size_b, 
    magma_int_t kblocks,
    magmaFloatComplex_ptr *dA, 
    magma_int_t *ipiv,
    magma_queue_t queue );

magma_int_t
magma_cbcsrblockinfo5(
    magma_int_t lustep,
    magma_int_t num_blocks, 
    magma_int_t c_blocks, 
    magma_int_t size_b,
    magma_index_t *blockinfo,
    magmaFloatComplex_ptr dval,
    magmaFloatComplex_ptr *AII,
    magma_queue_t queue );


magma_int_t
magma_ctestasync( 
    magma_c_matrix A,
    magma_queue_t queue );

//##################   stencil operators


magma_int_t
magma_cge3pt(
    magma_int_t m, 
    magma_int_t n,
    magmaFloatComplex alpha,
    magmaFloatComplex beta,
    magmaFloatComplex_ptr dx,
    magmaFloatComplex_ptr dy,
    magma_queue_t queue );

//#############  Big data analytics
magma_int_t
magma_cjaccard_weights(
    magma_c_matrix A,
    magma_c_matrix *J,
    magma_queue_t queue );

magma_int_t
magma_cthrsholdselect(
    magma_int_t sampling,
    magma_int_t total_size,
    magma_int_t subset_size,
    magmaFloatComplex *val,
    float *thrs,
    magma_queue_t queue );
 
#ifdef __cplusplus
}
#endif

#undef PRECISION_c
#endif /* MAGMASPARSE_C_H */
