/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.et.libguestfs;

import com.redhat.et.libguestfs.Application;
import com.redhat.et.libguestfs.Application2;
import com.redhat.et.libguestfs.BTRFSBalance;
import com.redhat.et.libguestfs.BTRFSQgroup;
import com.redhat.et.libguestfs.BTRFSScrub;
import com.redhat.et.libguestfs.BTRFSSubvolume;
import com.redhat.et.libguestfs.Dirent;
import com.redhat.et.libguestfs.EventCallback;
import com.redhat.et.libguestfs.HivexNode;
import com.redhat.et.libguestfs.HivexValue;
import com.redhat.et.libguestfs.INotifyEvent;
import com.redhat.et.libguestfs.ISOInfo;
import com.redhat.et.libguestfs.IntBool;
import com.redhat.et.libguestfs.LV;
import com.redhat.et.libguestfs.LibGuestFSException;
import com.redhat.et.libguestfs.MDStat;
import com.redhat.et.libguestfs.PV;
import com.redhat.et.libguestfs.Partition;
import com.redhat.et.libguestfs.Stat;
import com.redhat.et.libguestfs.StatNS;
import com.redhat.et.libguestfs.StatVFS;
import com.redhat.et.libguestfs.TSKDirent;
import com.redhat.et.libguestfs.UTSName;
import com.redhat.et.libguestfs.VG;
import com.redhat.et.libguestfs.Version;
import com.redhat.et.libguestfs.XAttr;
import com.redhat.et.libguestfs.XFSInfo;
import com.redhat.et.libguestfs.YaraDetection;
import java.util.HashMap;
import java.util.Map;

public class GuestFS {
    long g;
    private static int CREATE_NO_ENVIRONMENT;
    private static int CREATE_NO_CLOSE_ON_EXIT;
    public static final long EVENT_CLOSE = 1L;
    public static final long EVENT_SUBPROCESS_QUIT = 2L;
    public static final long EVENT_LAUNCH_DONE = 4L;
    public static final long EVENT_PROGRESS = 8L;
    public static final long EVENT_APPLIANCE = 16L;
    public static final long EVENT_LIBRARY = 32L;
    public static final long EVENT_TRACE = 64L;
    public static final long EVENT_ENTER = 128L;
    public static final long EVENT_LIBVIRT_AUTH = 256L;
    public static final long EVENT_WARNING = 512L;
    public static final long EVENT_ALL = 1023L;

    public GuestFS(Map<String, Object> map) throws LibGuestFSException {
        int n = 0;
        Object object = null;
        if (map != null) {
            object = map.get("environment");
        }
        if (object != null && !((Boolean)object).booleanValue()) {
            n |= CREATE_NO_ENVIRONMENT;
        }
        if (map != null) {
            object = map.get("close_on_exit");
        }
        if (object != null && !((Boolean)object).booleanValue()) {
            n |= CREATE_NO_CLOSE_ON_EXIT;
        }
        this.g = this._create(n);
    }

    public GuestFS() throws LibGuestFSException {
        this.g = this._create(0);
    }

    private native long _create(int var1) throws LibGuestFSException;

    public void close() throws LibGuestFSException {
        if (this.g != 0L) {
            this._close(this.g);
        }
        this.g = 0L;
    }

    private native void _close(long var1) throws LibGuestFSException;

    public void finalize() throws LibGuestFSException {
        this.close();
    }

    public static String eventToString(long l) {
        return GuestFS._event_to_string(l);
    }

    private static native String _event_to_string(long var0);

    public int set_event_callback(EventCallback eventCallback, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_event_callback: handle is closed");
        }
        return this._set_event_callback(this.g, eventCallback, l);
    }

    private native int _set_event_callback(long var1, EventCallback var3, long var4) throws LibGuestFSException;

    public void delete_event_callback(int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("delete_event_callback: handle is closed");
        }
        this._delete_event_callback(this.g, n);
    }

    private native void _delete_event_callback(long var1, int var3);

    public void acl_delete_def_file(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("acl_delete_def_file: handle is closed");
        }
        this._acl_delete_def_file(this.g, string);
    }

    private native void _acl_delete_def_file(long var1, String var3) throws LibGuestFSException;

    public String acl_get_file(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("acl_get_file: handle is closed");
        }
        return this._acl_get_file(this.g, string, string2);
    }

    private native String _acl_get_file(long var1, String var3, String var4) throws LibGuestFSException;

    public void acl_set_file(String string, String string2, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("acl_set_file: handle is closed");
        }
        this._acl_set_file(this.g, string, string2, string3);
    }

    private native void _acl_set_file(long var1, String var3, String var4, String var5) throws LibGuestFSException;

    @Deprecated
    public void add_cdrom(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("add_cdrom: handle is closed");
        }
        this._add_cdrom(this.g, string);
    }

    private native void _add_cdrom(long var1, String var3) throws LibGuestFSException;

    public int add_domain(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("add_domain: handle is closed");
        }
        long l = 0L;
        String string2 = "";
        Object object = null;
        if (map != null) {
            object = map.get("libvirturi");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 1L;
        }
        boolean bl = false;
        object = null;
        if (map != null) {
            object = map.get("readonly");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 2L;
        }
        String string3 = "";
        object = null;
        if (map != null) {
            object = map.get("iface");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 4L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("live");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 8L;
        }
        boolean bl3 = false;
        object = null;
        if (map != null) {
            object = map.get("allowuuid");
        }
        if (object != null) {
            bl3 = (Boolean)object;
            l |= 0x10L;
        }
        String string4 = "";
        object = null;
        if (map != null) {
            object = map.get("readonlydisk");
        }
        if (object != null) {
            string4 = (String)object;
            l |= 0x20L;
        }
        String string5 = "";
        object = null;
        if (map != null) {
            object = map.get("cachemode");
        }
        if (object != null) {
            string5 = (String)object;
            l |= 0x40L;
        }
        String string6 = "";
        object = null;
        if (map != null) {
            object = map.get("discard");
        }
        if (object != null) {
            string6 = (String)object;
            l |= 0x80L;
        }
        boolean bl4 = false;
        object = null;
        if (map != null) {
            object = map.get("copyonread");
        }
        if (object != null) {
            bl4 = (Boolean)object;
            l |= 0x100L;
        }
        return this._add_domain(this.g, string, l, string2, bl, string3, bl2, bl3, string4, string5, string6, bl4);
    }

    public int add_domain(String string) throws LibGuestFSException {
        return this.add_domain(string, null);
    }

    private native int _add_domain(long var1, String var3, long var4, String var6, boolean var7, String var8, boolean var9, boolean var10, String var11, String var12, String var13, boolean var14) throws LibGuestFSException;

    public void add_drive(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("add_drive: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("readonly");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        String string2 = "";
        object = null;
        if (map != null) {
            object = map.get("format");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 2L;
        }
        String string3 = "";
        object = null;
        if (map != null) {
            object = map.get("iface");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 4L;
        }
        String string4 = "";
        object = null;
        if (map != null) {
            object = map.get("name");
        }
        if (object != null) {
            string4 = (String)object;
            l |= 8L;
        }
        String string5 = "";
        object = null;
        if (map != null) {
            object = map.get("label");
        }
        if (object != null) {
            string5 = (String)object;
            l |= 0x10L;
        }
        String string6 = "";
        object = null;
        if (map != null) {
            object = map.get("protocol");
        }
        if (object != null) {
            string6 = (String)object;
            l |= 0x20L;
        }
        String[] stringArray = new String[]{};
        object = null;
        if (map != null) {
            object = map.get("server");
        }
        if (object != null) {
            stringArray = (String[])object;
            l |= 0x40L;
        }
        String string7 = "";
        object = null;
        if (map != null) {
            object = map.get("username");
        }
        if (object != null) {
            string7 = (String)object;
            l |= 0x80L;
        }
        String string8 = "";
        object = null;
        if (map != null) {
            object = map.get("secret");
        }
        if (object != null) {
            string8 = (String)object;
            l |= 0x100L;
        }
        String string9 = "";
        object = null;
        if (map != null) {
            object = map.get("cachemode");
        }
        if (object != null) {
            string9 = (String)object;
            l |= 0x200L;
        }
        String string10 = "";
        object = null;
        if (map != null) {
            object = map.get("discard");
        }
        if (object != null) {
            string10 = (String)object;
            l |= 0x400L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("copyonread");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 0x800L;
        }
        int n = 0;
        object = null;
        if (map != null) {
            object = map.get("blocksize");
        }
        if (object != null) {
            n = (Integer)object;
            l |= 0x1000L;
        }
        this._add_drive(this.g, string, l, bl, string2, string3, string4, string5, string6, stringArray, string7, string8, string9, string10, bl2, n);
    }

    public void add_drive(String string) throws LibGuestFSException {
        this.add_drive(string, null);
    }

    public void add_drive_opts(String string, Map<String, Object> map) throws LibGuestFSException {
        this.add_drive(string, map);
    }

    public void add_drive_opts(String string) throws LibGuestFSException {
        this.add_drive(string, null);
    }

    private native void _add_drive(long var1, String var3, long var4, boolean var6, String var7, String var8, String var9, String var10, String var11, String[] var12, String var13, String var14, String var15, String var16, boolean var17, int var18) throws LibGuestFSException;

    public void add_drive_ro(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("add_drive_ro: handle is closed");
        }
        this._add_drive_ro(this.g, string);
    }

    private native void _add_drive_ro(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public void add_drive_ro_with_if(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("add_drive_ro_with_if: handle is closed");
        }
        this._add_drive_ro_with_if(this.g, string, string2);
    }

    private native void _add_drive_ro_with_if(long var1, String var3, String var4) throws LibGuestFSException;

    public void add_drive_scratch(long l, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("add_drive_scratch: handle is closed");
        }
        long l2 = 0L;
        String string = "";
        Object object = null;
        if (map != null) {
            object = map.get("name");
        }
        if (object != null) {
            string = (String)object;
            l2 |= 1L;
        }
        String string2 = "";
        object = null;
        if (map != null) {
            object = map.get("label");
        }
        if (object != null) {
            string2 = (String)object;
            l2 |= 2L;
        }
        int n = 0;
        object = null;
        if (map != null) {
            object = map.get("blocksize");
        }
        if (object != null) {
            n = (Integer)object;
            l2 |= 4L;
        }
        this._add_drive_scratch(this.g, l, l2, string, string2, n);
    }

    public void add_drive_scratch(long l) throws LibGuestFSException {
        this.add_drive_scratch(l, null);
    }

    private native void _add_drive_scratch(long var1, long var3, long var5, String var7, String var8, int var9) throws LibGuestFSException;

    @Deprecated
    public void add_drive_with_if(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("add_drive_with_if: handle is closed");
        }
        this._add_drive_with_if(this.g, string, string2);
    }

    private native void _add_drive_with_if(long var1, String var3, String var4) throws LibGuestFSException;

    public int add_libvirt_dom(long l, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("add_libvirt_dom: handle is closed");
        }
        long l2 = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("readonly");
        }
        if (object != null) {
            bl = (Boolean)object;
            l2 |= 1L;
        }
        String string = "";
        object = null;
        if (map != null) {
            object = map.get("iface");
        }
        if (object != null) {
            string = (String)object;
            l2 |= 2L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("live");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l2 |= 4L;
        }
        String string2 = "";
        object = null;
        if (map != null) {
            object = map.get("readonlydisk");
        }
        if (object != null) {
            string2 = (String)object;
            l2 |= 8L;
        }
        String string3 = "";
        object = null;
        if (map != null) {
            object = map.get("cachemode");
        }
        if (object != null) {
            string3 = (String)object;
            l2 |= 0x10L;
        }
        String string4 = "";
        object = null;
        if (map != null) {
            object = map.get("discard");
        }
        if (object != null) {
            string4 = (String)object;
            l2 |= 0x20L;
        }
        boolean bl3 = false;
        object = null;
        if (map != null) {
            object = map.get("copyonread");
        }
        if (object != null) {
            bl3 = (Boolean)object;
            l2 |= 0x40L;
        }
        return this._add_libvirt_dom(this.g, l, l2, bl, string, bl2, string2, string3, string4, bl3);
    }

    public int add_libvirt_dom(long l) throws LibGuestFSException {
        return this.add_libvirt_dom(l, null);
    }

    private native int _add_libvirt_dom(long var1, long var3, long var5, boolean var7, String var8, boolean var9, String var10, String var11, String var12, boolean var13) throws LibGuestFSException;

    public void aug_clear(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_clear: handle is closed");
        }
        this._aug_clear(this.g, string);
    }

    private native void _aug_clear(long var1, String var3) throws LibGuestFSException;

    public void aug_close() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_close: handle is closed");
        }
        this._aug_close(this.g);
    }

    private native void _aug_close(long var1) throws LibGuestFSException;

    public IntBool aug_defnode(String string, String string2, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_defnode: handle is closed");
        }
        return this._aug_defnode(this.g, string, string2, string3);
    }

    private native IntBool _aug_defnode(long var1, String var3, String var4, String var5) throws LibGuestFSException;

    public int aug_defvar(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_defvar: handle is closed");
        }
        return this._aug_defvar(this.g, string, string2);
    }

    private native int _aug_defvar(long var1, String var3, String var4) throws LibGuestFSException;

    public String aug_get(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_get: handle is closed");
        }
        return this._aug_get(this.g, string);
    }

    private native String _aug_get(long var1, String var3) throws LibGuestFSException;

    public void aug_init(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_init: handle is closed");
        }
        this._aug_init(this.g, string, n);
    }

    private native void _aug_init(long var1, String var3, int var4) throws LibGuestFSException;

    public void aug_insert(String string, String string2, boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_insert: handle is closed");
        }
        this._aug_insert(this.g, string, string2, bl);
    }

    private native void _aug_insert(long var1, String var3, String var4, boolean var5) throws LibGuestFSException;

    public String aug_label(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_label: handle is closed");
        }
        return this._aug_label(this.g, string);
    }

    private native String _aug_label(long var1, String var3) throws LibGuestFSException;

    public void aug_load() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_load: handle is closed");
        }
        this._aug_load(this.g);
    }

    private native void _aug_load(long var1) throws LibGuestFSException;

    public String[] aug_ls(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_ls: handle is closed");
        }
        return this._aug_ls(this.g, string);
    }

    private native String[] _aug_ls(long var1, String var3) throws LibGuestFSException;

    public String[] aug_match(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_match: handle is closed");
        }
        return this._aug_match(this.g, string);
    }

    private native String[] _aug_match(long var1, String var3) throws LibGuestFSException;

    public void aug_mv(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_mv: handle is closed");
        }
        this._aug_mv(this.g, string, string2);
    }

    private native void _aug_mv(long var1, String var3, String var4) throws LibGuestFSException;

    public int aug_rm(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_rm: handle is closed");
        }
        return this._aug_rm(this.g, string);
    }

    private native int _aug_rm(long var1, String var3) throws LibGuestFSException;

    public void aug_save() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_save: handle is closed");
        }
        this._aug_save(this.g);
    }

    private native void _aug_save(long var1) throws LibGuestFSException;

    public void aug_set(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_set: handle is closed");
        }
        this._aug_set(this.g, string, string2);
    }

    private native void _aug_set(long var1, String var3, String var4) throws LibGuestFSException;

    public int aug_setm(String string, String string2, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_setm: handle is closed");
        }
        return this._aug_setm(this.g, string, string2, string3);
    }

    private native int _aug_setm(long var1, String var3, String var4, String var5) throws LibGuestFSException;

    public void aug_transform(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("aug_transform: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("remove");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        this._aug_transform(this.g, string, string2, l, bl);
    }

    public void aug_transform(String string, String string2) throws LibGuestFSException {
        this.aug_transform(string, string2, null);
    }

    private native void _aug_transform(long var1, String var3, String var4, long var5, boolean var7) throws LibGuestFSException;

    public void available(String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("available: handle is closed");
        }
        this._available(this.g, stringArray);
    }

    private native void _available(long var1, String[] var3) throws LibGuestFSException;

    public String[] available_all_groups() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("available_all_groups: handle is closed");
        }
        return this._available_all_groups(this.g);
    }

    private native String[] _available_all_groups(long var1) throws LibGuestFSException;

    public void base64_in(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("base64_in: handle is closed");
        }
        this._base64_in(this.g, string, string2);
    }

    private native void _base64_in(long var1, String var3, String var4) throws LibGuestFSException;

    public void base64_out(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("base64_out: handle is closed");
        }
        this._base64_out(this.g, string, string2);
    }

    private native void _base64_out(long var1, String var3, String var4) throws LibGuestFSException;

    public void blkdiscard(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blkdiscard: handle is closed");
        }
        this._blkdiscard(this.g, string);
    }

    private native void _blkdiscard(long var1, String var3) throws LibGuestFSException;

    public boolean blkdiscardzeroes(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blkdiscardzeroes: handle is closed");
        }
        return this._blkdiscardzeroes(this.g, string);
    }

    private native boolean _blkdiscardzeroes(long var1, String var3) throws LibGuestFSException;

    public Map<String, String> blkid(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blkid: handle is closed");
        }
        String[] stringArray = this._blkid(this.g, string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return hashMap;
    }

    private native String[] _blkid(long var1, String var3) throws LibGuestFSException;

    public void blockdev_flushbufs(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blockdev_flushbufs: handle is closed");
        }
        this._blockdev_flushbufs(this.g, string);
    }

    private native void _blockdev_flushbufs(long var1, String var3) throws LibGuestFSException;

    public int blockdev_getbsz(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blockdev_getbsz: handle is closed");
        }
        return this._blockdev_getbsz(this.g, string);
    }

    private native int _blockdev_getbsz(long var1, String var3) throws LibGuestFSException;

    public boolean blockdev_getro(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blockdev_getro: handle is closed");
        }
        return this._blockdev_getro(this.g, string);
    }

    private native boolean _blockdev_getro(long var1, String var3) throws LibGuestFSException;

    public long blockdev_getsize64(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blockdev_getsize64: handle is closed");
        }
        return this._blockdev_getsize64(this.g, string);
    }

    private native long _blockdev_getsize64(long var1, String var3) throws LibGuestFSException;

    public int blockdev_getss(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blockdev_getss: handle is closed");
        }
        return this._blockdev_getss(this.g, string);
    }

    private native int _blockdev_getss(long var1, String var3) throws LibGuestFSException;

    public long blockdev_getsz(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blockdev_getsz: handle is closed");
        }
        return this._blockdev_getsz(this.g, string);
    }

    private native long _blockdev_getsz(long var1, String var3) throws LibGuestFSException;

    public void blockdev_rereadpt(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blockdev_rereadpt: handle is closed");
        }
        this._blockdev_rereadpt(this.g, string);
    }

    private native void _blockdev_rereadpt(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public void blockdev_setbsz(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blockdev_setbsz: handle is closed");
        }
        this._blockdev_setbsz(this.g, string, n);
    }

    private native void _blockdev_setbsz(long var1, String var3, int var4) throws LibGuestFSException;

    public void blockdev_setra(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blockdev_setra: handle is closed");
        }
        this._blockdev_setra(this.g, string, n);
    }

    private native void _blockdev_setra(long var1, String var3, int var4) throws LibGuestFSException;

    public void blockdev_setro(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blockdev_setro: handle is closed");
        }
        this._blockdev_setro(this.g, string);
    }

    private native void _blockdev_setro(long var1, String var3) throws LibGuestFSException;

    public void blockdev_setrw(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("blockdev_setrw: handle is closed");
        }
        this._blockdev_setrw(this.g, string);
    }

    private native void _blockdev_setrw(long var1, String var3) throws LibGuestFSException;

    public void btrfs_balance_cancel(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_balance_cancel: handle is closed");
        }
        this._btrfs_balance_cancel(this.g, string);
    }

    private native void _btrfs_balance_cancel(long var1, String var3) throws LibGuestFSException;

    public void btrfs_balance_pause(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_balance_pause: handle is closed");
        }
        this._btrfs_balance_pause(this.g, string);
    }

    private native void _btrfs_balance_pause(long var1, String var3) throws LibGuestFSException;

    public void btrfs_balance_resume(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_balance_resume: handle is closed");
        }
        this._btrfs_balance_resume(this.g, string);
    }

    private native void _btrfs_balance_resume(long var1, String var3) throws LibGuestFSException;

    public BTRFSBalance btrfs_balance_status(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_balance_status: handle is closed");
        }
        return this._btrfs_balance_status(this.g, string);
    }

    private native BTRFSBalance _btrfs_balance_status(long var1, String var3) throws LibGuestFSException;

    public void btrfs_device_add(String[] stringArray, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_device_add: handle is closed");
        }
        this._btrfs_device_add(this.g, stringArray, string);
    }

    private native void _btrfs_device_add(long var1, String[] var3, String var4) throws LibGuestFSException;

    public void btrfs_device_delete(String[] stringArray, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_device_delete: handle is closed");
        }
        this._btrfs_device_delete(this.g, stringArray, string);
    }

    private native void _btrfs_device_delete(long var1, String[] var3, String var4) throws LibGuestFSException;

    public void btrfs_filesystem_balance(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_filesystem_balance: handle is closed");
        }
        this._btrfs_filesystem_balance(this.g, string);
    }

    private native void _btrfs_filesystem_balance(long var1, String var3) throws LibGuestFSException;

    public void btrfs_filesystem_defragment(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_filesystem_defragment: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("flush");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        String string2 = "";
        object = null;
        if (map != null) {
            object = map.get("compress");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 2L;
        }
        this._btrfs_filesystem_defragment(this.g, string, l, bl, string2);
    }

    public void btrfs_filesystem_defragment(String string) throws LibGuestFSException {
        this.btrfs_filesystem_defragment(string, null);
    }

    private native void _btrfs_filesystem_defragment(long var1, String var3, long var4, boolean var6, String var7) throws LibGuestFSException;

    public void btrfs_filesystem_resize(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_filesystem_resize: handle is closed");
        }
        long l = 0L;
        long l2 = 0L;
        Object object = null;
        if (map != null) {
            object = map.get("size");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 1L;
        }
        this._btrfs_filesystem_resize(this.g, string, l, l2);
    }

    public void btrfs_filesystem_resize(String string) throws LibGuestFSException {
        this.btrfs_filesystem_resize(string, null);
    }

    private native void _btrfs_filesystem_resize(long var1, String var3, long var4, long var6) throws LibGuestFSException;

    public String[] btrfs_filesystem_show(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_filesystem_show: handle is closed");
        }
        return this._btrfs_filesystem_show(this.g, string);
    }

    private native String[] _btrfs_filesystem_show(long var1, String var3) throws LibGuestFSException;

    public void btrfs_filesystem_sync(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_filesystem_sync: handle is closed");
        }
        this._btrfs_filesystem_sync(this.g, string);
    }

    private native void _btrfs_filesystem_sync(long var1, String var3) throws LibGuestFSException;

    public void btrfs_fsck(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_fsck: handle is closed");
        }
        long l = 0L;
        long l2 = 0L;
        Object object = null;
        if (map != null) {
            object = map.get("superblock");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 1L;
        }
        boolean bl = false;
        object = null;
        if (map != null) {
            object = map.get("repair");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 2L;
        }
        this._btrfs_fsck(this.g, string, l, l2, bl);
    }

    public void btrfs_fsck(String string) throws LibGuestFSException {
        this.btrfs_fsck(string, null);
    }

    private native void _btrfs_fsck(long var1, String var3, long var4, long var6, boolean var8) throws LibGuestFSException;

    public void btrfs_image(String[] stringArray, String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_image: handle is closed");
        }
        long l = 0L;
        int n = 0;
        Object object = null;
        if (map != null) {
            object = map.get("compresslevel");
        }
        if (object != null) {
            n = (Integer)object;
            l |= 1L;
        }
        this._btrfs_image(this.g, stringArray, string, l, n);
    }

    public void btrfs_image(String[] stringArray, String string) throws LibGuestFSException {
        this.btrfs_image(stringArray, string, null);
    }

    private native void _btrfs_image(long var1, String[] var3, String var4, long var5, int var7) throws LibGuestFSException;

    public void btrfs_qgroup_assign(String string, String string2, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_qgroup_assign: handle is closed");
        }
        this._btrfs_qgroup_assign(this.g, string, string2, string3);
    }

    private native void _btrfs_qgroup_assign(long var1, String var3, String var4, String var5) throws LibGuestFSException;

    public void btrfs_qgroup_create(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_qgroup_create: handle is closed");
        }
        this._btrfs_qgroup_create(this.g, string, string2);
    }

    private native void _btrfs_qgroup_create(long var1, String var3, String var4) throws LibGuestFSException;

    public void btrfs_qgroup_destroy(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_qgroup_destroy: handle is closed");
        }
        this._btrfs_qgroup_destroy(this.g, string, string2);
    }

    private native void _btrfs_qgroup_destroy(long var1, String var3, String var4) throws LibGuestFSException;

    public void btrfs_qgroup_limit(String string, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_qgroup_limit: handle is closed");
        }
        this._btrfs_qgroup_limit(this.g, string, l);
    }

    private native void _btrfs_qgroup_limit(long var1, String var3, long var4) throws LibGuestFSException;

    public void btrfs_qgroup_remove(String string, String string2, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_qgroup_remove: handle is closed");
        }
        this._btrfs_qgroup_remove(this.g, string, string2, string3);
    }

    private native void _btrfs_qgroup_remove(long var1, String var3, String var4, String var5) throws LibGuestFSException;

    public BTRFSQgroup[] btrfs_qgroup_show(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_qgroup_show: handle is closed");
        }
        return this._btrfs_qgroup_show(this.g, string);
    }

    private native BTRFSQgroup[] _btrfs_qgroup_show(long var1, String var3) throws LibGuestFSException;

    public void btrfs_quota_enable(String string, boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_quota_enable: handle is closed");
        }
        this._btrfs_quota_enable(this.g, string, bl);
    }

    private native void _btrfs_quota_enable(long var1, String var3, boolean var4) throws LibGuestFSException;

    public void btrfs_quota_rescan(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_quota_rescan: handle is closed");
        }
        this._btrfs_quota_rescan(this.g, string);
    }

    private native void _btrfs_quota_rescan(long var1, String var3) throws LibGuestFSException;

    public void btrfs_replace(String string, String string2, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_replace: handle is closed");
        }
        this._btrfs_replace(this.g, string, string2, string3);
    }

    private native void _btrfs_replace(long var1, String var3, String var4, String var5) throws LibGuestFSException;

    public void btrfs_rescue_chunk_recover(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_rescue_chunk_recover: handle is closed");
        }
        this._btrfs_rescue_chunk_recover(this.g, string);
    }

    private native void _btrfs_rescue_chunk_recover(long var1, String var3) throws LibGuestFSException;

    public void btrfs_rescue_super_recover(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_rescue_super_recover: handle is closed");
        }
        this._btrfs_rescue_super_recover(this.g, string);
    }

    private native void _btrfs_rescue_super_recover(long var1, String var3) throws LibGuestFSException;

    public void btrfs_scrub_cancel(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_scrub_cancel: handle is closed");
        }
        this._btrfs_scrub_cancel(this.g, string);
    }

    private native void _btrfs_scrub_cancel(long var1, String var3) throws LibGuestFSException;

    public void btrfs_scrub_resume(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_scrub_resume: handle is closed");
        }
        this._btrfs_scrub_resume(this.g, string);
    }

    private native void _btrfs_scrub_resume(long var1, String var3) throws LibGuestFSException;

    public void btrfs_scrub_start(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_scrub_start: handle is closed");
        }
        this._btrfs_scrub_start(this.g, string);
    }

    private native void _btrfs_scrub_start(long var1, String var3) throws LibGuestFSException;

    public BTRFSScrub btrfs_scrub_status(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_scrub_status: handle is closed");
        }
        return this._btrfs_scrub_status(this.g, string);
    }

    private native BTRFSScrub _btrfs_scrub_status(long var1, String var3) throws LibGuestFSException;

    public void btrfs_set_seeding(String string, boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_set_seeding: handle is closed");
        }
        this._btrfs_set_seeding(this.g, string, bl);
    }

    private native void _btrfs_set_seeding(long var1, String var3, boolean var4) throws LibGuestFSException;

    public void btrfs_subvolume_create(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_subvolume_create: handle is closed");
        }
        long l = 0L;
        String string2 = "";
        Object object = null;
        if (map != null) {
            object = map.get("qgroupid");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 1L;
        }
        this._btrfs_subvolume_create(this.g, string, l, string2);
    }

    public void btrfs_subvolume_create(String string) throws LibGuestFSException {
        this.btrfs_subvolume_create(string, null);
    }

    public void btrfs_subvolume_create_opts(String string, Map<String, Object> map) throws LibGuestFSException {
        this.btrfs_subvolume_create(string, map);
    }

    public void btrfs_subvolume_create_opts(String string) throws LibGuestFSException {
        this.btrfs_subvolume_create(string, null);
    }

    private native void _btrfs_subvolume_create(long var1, String var3, long var4, String var6) throws LibGuestFSException;

    public void btrfs_subvolume_delete(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_subvolume_delete: handle is closed");
        }
        this._btrfs_subvolume_delete(this.g, string);
    }

    private native void _btrfs_subvolume_delete(long var1, String var3) throws LibGuestFSException;

    public long btrfs_subvolume_get_default(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_subvolume_get_default: handle is closed");
        }
        return this._btrfs_subvolume_get_default(this.g, string);
    }

    private native long _btrfs_subvolume_get_default(long var1, String var3) throws LibGuestFSException;

    public BTRFSSubvolume[] btrfs_subvolume_list(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_subvolume_list: handle is closed");
        }
        return this._btrfs_subvolume_list(this.g, string);
    }

    private native BTRFSSubvolume[] _btrfs_subvolume_list(long var1, String var3) throws LibGuestFSException;

    public void btrfs_subvolume_set_default(long l, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_subvolume_set_default: handle is closed");
        }
        this._btrfs_subvolume_set_default(this.g, l, string);
    }

    private native void _btrfs_subvolume_set_default(long var1, long var3, String var5) throws LibGuestFSException;

    public Map<String, String> btrfs_subvolume_show(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_subvolume_show: handle is closed");
        }
        String[] stringArray = this._btrfs_subvolume_show(this.g, string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return hashMap;
    }

    private native String[] _btrfs_subvolume_show(long var1, String var3) throws LibGuestFSException;

    public void btrfs_subvolume_snapshot(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfs_subvolume_snapshot: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("ro");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        String string3 = "";
        object = null;
        if (map != null) {
            object = map.get("qgroupid");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 2L;
        }
        this._btrfs_subvolume_snapshot(this.g, string, string2, l, bl, string3);
    }

    public void btrfs_subvolume_snapshot(String string, String string2) throws LibGuestFSException {
        this.btrfs_subvolume_snapshot(string, string2, null);
    }

    public void btrfs_subvolume_snapshot_opts(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        this.btrfs_subvolume_snapshot(string, string2, map);
    }

    public void btrfs_subvolume_snapshot_opts(String string, String string2) throws LibGuestFSException {
        this.btrfs_subvolume_snapshot(string, string2, null);
    }

    private native void _btrfs_subvolume_snapshot(long var1, String var3, String var4, long var5, boolean var7, String var8) throws LibGuestFSException;

    public void btrfstune_enable_extended_inode_refs(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfstune_enable_extended_inode_refs: handle is closed");
        }
        this._btrfstune_enable_extended_inode_refs(this.g, string);
    }

    private native void _btrfstune_enable_extended_inode_refs(long var1, String var3) throws LibGuestFSException;

    public void btrfstune_enable_skinny_metadata_extent_refs(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfstune_enable_skinny_metadata_extent_refs: handle is closed");
        }
        this._btrfstune_enable_skinny_metadata_extent_refs(this.g, string);
    }

    private native void _btrfstune_enable_skinny_metadata_extent_refs(long var1, String var3) throws LibGuestFSException;

    public void btrfstune_seeding(String string, boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("btrfstune_seeding: handle is closed");
        }
        this._btrfstune_seeding(this.g, string, bl);
    }

    private native void _btrfstune_seeding(long var1, String var3, boolean var4) throws LibGuestFSException;

    public long c_pointer() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("c_pointer: handle is closed");
        }
        return this._c_pointer(this.g);
    }

    private native long _c_pointer(long var1) throws LibGuestFSException;

    public String canonical_device_name(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("canonical_device_name: handle is closed");
        }
        return this._canonical_device_name(this.g, string);
    }

    private native String _canonical_device_name(long var1, String var3) throws LibGuestFSException;

    public String cap_get_file(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("cap_get_file: handle is closed");
        }
        return this._cap_get_file(this.g, string);
    }

    private native String _cap_get_file(long var1, String var3) throws LibGuestFSException;

    public void cap_set_file(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("cap_set_file: handle is closed");
        }
        this._cap_set_file(this.g, string, string2);
    }

    private native void _cap_set_file(long var1, String var3, String var4) throws LibGuestFSException;

    public String case_sensitive_path(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("case_sensitive_path: handle is closed");
        }
        return this._case_sensitive_path(this.g, string);
    }

    private native String _case_sensitive_path(long var1, String var3) throws LibGuestFSException;

    public String cat(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("cat: handle is closed");
        }
        return this._cat(this.g, string);
    }

    private native String _cat(long var1, String var3) throws LibGuestFSException;

    public String checksum(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("checksum: handle is closed");
        }
        return this._checksum(this.g, string, string2);
    }

    private native String _checksum(long var1, String var3, String var4) throws LibGuestFSException;

    public String checksum_device(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("checksum_device: handle is closed");
        }
        return this._checksum_device(this.g, string, string2);
    }

    private native String _checksum_device(long var1, String var3, String var4) throws LibGuestFSException;

    public void checksums_out(String string, String string2, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("checksums_out: handle is closed");
        }
        this._checksums_out(this.g, string, string2, string3);
    }

    private native void _checksums_out(long var1, String var3, String var4, String var5) throws LibGuestFSException;

    public void chmod(int n, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("chmod: handle is closed");
        }
        this._chmod(this.g, n, string);
    }

    private native void _chmod(long var1, int var3, String var4) throws LibGuestFSException;

    public void chown(int n, int n2, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("chown: handle is closed");
        }
        this._chown(this.g, n, n2, string);
    }

    private native void _chown(long var1, int var3, int var4, String var5) throws LibGuestFSException;

    public int clear_backend_setting(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("clear_backend_setting: handle is closed");
        }
        return this._clear_backend_setting(this.g, string);
    }

    private native int _clear_backend_setting(long var1, String var3) throws LibGuestFSException;

    public String command(String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("command: handle is closed");
        }
        return this._command(this.g, stringArray);
    }

    private native String _command(long var1, String[] var3) throws LibGuestFSException;

    public String[] command_lines(String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("command_lines: handle is closed");
        }
        return this._command_lines(this.g, stringArray);
    }

    private native String[] _command_lines(long var1, String[] var3) throws LibGuestFSException;

    public void compress_device_out(String string, String string2, String string3, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("compress_device_out: handle is closed");
        }
        long l = 0L;
        int n = 0;
        Object object = null;
        if (map != null) {
            object = map.get("level");
        }
        if (object != null) {
            n = (Integer)object;
            l |= 1L;
        }
        this._compress_device_out(this.g, string, string2, string3, l, n);
    }

    public void compress_device_out(String string, String string2, String string3) throws LibGuestFSException {
        this.compress_device_out(string, string2, string3, null);
    }

    private native void _compress_device_out(long var1, String var3, String var4, String var5, long var6, int var8) throws LibGuestFSException;

    public void compress_out(String string, String string2, String string3, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("compress_out: handle is closed");
        }
        long l = 0L;
        int n = 0;
        Object object = null;
        if (map != null) {
            object = map.get("level");
        }
        if (object != null) {
            n = (Integer)object;
            l |= 1L;
        }
        this._compress_out(this.g, string, string2, string3, l, n);
    }

    public void compress_out(String string, String string2, String string3) throws LibGuestFSException {
        this.compress_out(string, string2, string3, null);
    }

    private native void _compress_out(long var1, String var3, String var4, String var5, long var6, int var8) throws LibGuestFSException;

    public void config(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("config: handle is closed");
        }
        this._config(this.g, string, string2);
    }

    private native void _config(long var1, String var3, String var4) throws LibGuestFSException;

    public void copy_attributes(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("copy_attributes: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("all");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("mode");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 2L;
        }
        boolean bl3 = false;
        object = null;
        if (map != null) {
            object = map.get("xattributes");
        }
        if (object != null) {
            bl3 = (Boolean)object;
            l |= 4L;
        }
        boolean bl4 = false;
        object = null;
        if (map != null) {
            object = map.get("ownership");
        }
        if (object != null) {
            bl4 = (Boolean)object;
            l |= 8L;
        }
        this._copy_attributes(this.g, string, string2, l, bl, bl2, bl3, bl4);
    }

    public void copy_attributes(String string, String string2) throws LibGuestFSException {
        this.copy_attributes(string, string2, null);
    }

    private native void _copy_attributes(long var1, String var3, String var4, long var5, boolean var7, boolean var8, boolean var9, boolean var10) throws LibGuestFSException;

    public void copy_device_to_device(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("copy_device_to_device: handle is closed");
        }
        long l = 0L;
        long l2 = 0L;
        Object object = null;
        if (map != null) {
            object = map.get("srcoffset");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 1L;
        }
        long l3 = 0L;
        object = null;
        if (map != null) {
            object = map.get("destoffset");
        }
        if (object != null) {
            l3 = (Long)object;
            l |= 2L;
        }
        long l4 = 0L;
        object = null;
        if (map != null) {
            object = map.get("size");
        }
        if (object != null) {
            l4 = (Long)object;
            l |= 4L;
        }
        boolean bl = false;
        object = null;
        if (map != null) {
            object = map.get("sparse");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 8L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("append");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 0x10L;
        }
        this._copy_device_to_device(this.g, string, string2, l, l2, l3, l4, bl, bl2);
    }

    public void copy_device_to_device(String string, String string2) throws LibGuestFSException {
        this.copy_device_to_device(string, string2, null);
    }

    private native void _copy_device_to_device(long var1, String var3, String var4, long var5, long var7, long var9, long var11, boolean var13, boolean var14) throws LibGuestFSException;

    public void copy_device_to_file(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("copy_device_to_file: handle is closed");
        }
        long l = 0L;
        long l2 = 0L;
        Object object = null;
        if (map != null) {
            object = map.get("srcoffset");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 1L;
        }
        long l3 = 0L;
        object = null;
        if (map != null) {
            object = map.get("destoffset");
        }
        if (object != null) {
            l3 = (Long)object;
            l |= 2L;
        }
        long l4 = 0L;
        object = null;
        if (map != null) {
            object = map.get("size");
        }
        if (object != null) {
            l4 = (Long)object;
            l |= 4L;
        }
        boolean bl = false;
        object = null;
        if (map != null) {
            object = map.get("sparse");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 8L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("append");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 0x10L;
        }
        this._copy_device_to_file(this.g, string, string2, l, l2, l3, l4, bl, bl2);
    }

    public void copy_device_to_file(String string, String string2) throws LibGuestFSException {
        this.copy_device_to_file(string, string2, null);
    }

    private native void _copy_device_to_file(long var1, String var3, String var4, long var5, long var7, long var9, long var11, boolean var13, boolean var14) throws LibGuestFSException;

    public void copy_file_to_device(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("copy_file_to_device: handle is closed");
        }
        long l = 0L;
        long l2 = 0L;
        Object object = null;
        if (map != null) {
            object = map.get("srcoffset");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 1L;
        }
        long l3 = 0L;
        object = null;
        if (map != null) {
            object = map.get("destoffset");
        }
        if (object != null) {
            l3 = (Long)object;
            l |= 2L;
        }
        long l4 = 0L;
        object = null;
        if (map != null) {
            object = map.get("size");
        }
        if (object != null) {
            l4 = (Long)object;
            l |= 4L;
        }
        boolean bl = false;
        object = null;
        if (map != null) {
            object = map.get("sparse");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 8L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("append");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 0x10L;
        }
        this._copy_file_to_device(this.g, string, string2, l, l2, l3, l4, bl, bl2);
    }

    public void copy_file_to_device(String string, String string2) throws LibGuestFSException {
        this.copy_file_to_device(string, string2, null);
    }

    private native void _copy_file_to_device(long var1, String var3, String var4, long var5, long var7, long var9, long var11, boolean var13, boolean var14) throws LibGuestFSException;

    public void copy_file_to_file(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("copy_file_to_file: handle is closed");
        }
        long l = 0L;
        long l2 = 0L;
        Object object = null;
        if (map != null) {
            object = map.get("srcoffset");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 1L;
        }
        long l3 = 0L;
        object = null;
        if (map != null) {
            object = map.get("destoffset");
        }
        if (object != null) {
            l3 = (Long)object;
            l |= 2L;
        }
        long l4 = 0L;
        object = null;
        if (map != null) {
            object = map.get("size");
        }
        if (object != null) {
            l4 = (Long)object;
            l |= 4L;
        }
        boolean bl = false;
        object = null;
        if (map != null) {
            object = map.get("sparse");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 8L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("append");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 0x10L;
        }
        this._copy_file_to_file(this.g, string, string2, l, l2, l3, l4, bl, bl2);
    }

    public void copy_file_to_file(String string, String string2) throws LibGuestFSException {
        this.copy_file_to_file(string, string2, null);
    }

    private native void _copy_file_to_file(long var1, String var3, String var4, long var5, long var7, long var9, long var11, boolean var13, boolean var14) throws LibGuestFSException;

    public void copy_in(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("copy_in: handle is closed");
        }
        this._copy_in(this.g, string, string2);
    }

    private native void _copy_in(long var1, String var3, String var4) throws LibGuestFSException;

    public void copy_out(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("copy_out: handle is closed");
        }
        this._copy_out(this.g, string, string2);
    }

    private native void _copy_out(long var1, String var3, String var4) throws LibGuestFSException;

    @Deprecated
    public void copy_size(String string, String string2, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("copy_size: handle is closed");
        }
        this._copy_size(this.g, string, string2, l);
    }

    private native void _copy_size(long var1, String var3, String var4, long var5) throws LibGuestFSException;

    public void cp(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("cp: handle is closed");
        }
        this._cp(this.g, string, string2);
    }

    private native void _cp(long var1, String var3, String var4) throws LibGuestFSException;

    public void cp_a(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("cp_a: handle is closed");
        }
        this._cp_a(this.g, string, string2);
    }

    private native void _cp_a(long var1, String var3, String var4) throws LibGuestFSException;

    public void cp_r(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("cp_r: handle is closed");
        }
        this._cp_r(this.g, string, string2);
    }

    private native void _cp_r(long var1, String var3, String var4) throws LibGuestFSException;

    public void cpio_out(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("cpio_out: handle is closed");
        }
        long l = 0L;
        String string3 = "";
        Object object = null;
        if (map != null) {
            object = map.get("format");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 1L;
        }
        this._cpio_out(this.g, string, string2, l, string3);
    }

    public void cpio_out(String string, String string2) throws LibGuestFSException {
        this.cpio_out(string, string2, null);
    }

    private native void _cpio_out(long var1, String var3, String var4, long var5, String var7) throws LibGuestFSException;

    public void cryptsetup_close(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("cryptsetup_close: handle is closed");
        }
        this._cryptsetup_close(this.g, string);
    }

    private native void _cryptsetup_close(long var1, String var3) throws LibGuestFSException;

    public void cryptsetup_open(String string, String string2, String string3, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("cryptsetup_open: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("readonly");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        String string4 = "";
        object = null;
        if (map != null) {
            object = map.get("crypttype");
        }
        if (object != null) {
            string4 = (String)object;
            l |= 2L;
        }
        this._cryptsetup_open(this.g, string, string2, string3, l, bl, string4);
    }

    public void cryptsetup_open(String string, String string2, String string3) throws LibGuestFSException {
        this.cryptsetup_open(string, string2, string3, null);
    }

    private native void _cryptsetup_open(long var1, String var3, String var4, String var5, long var6, boolean var8, String var9) throws LibGuestFSException;

    @Deprecated
    public void dd(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("dd: handle is closed");
        }
        this._dd(this.g, string, string2);
    }

    private native void _dd(long var1, String var3, String var4) throws LibGuestFSException;

    public String debug(String string, String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("debug: handle is closed");
        }
        return this._debug(this.g, string, stringArray);
    }

    private native String _debug(long var1, String var3, String[] var4) throws LibGuestFSException;

    public String[] debug_drives() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("debug_drives: handle is closed");
        }
        return this._debug_drives(this.g);
    }

    private native String[] _debug_drives(long var1) throws LibGuestFSException;

    public void debug_upload(String string, String string2, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("debug_upload: handle is closed");
        }
        this._debug_upload(this.g, string, string2, n);
    }

    private native void _debug_upload(long var1, String var3, String var4, int var5) throws LibGuestFSException;

    public int device_index(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("device_index: handle is closed");
        }
        return this._device_index(this.g, string);
    }

    private native int _device_index(long var1, String var3) throws LibGuestFSException;

    public String df() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("df: handle is closed");
        }
        return this._df(this.g);
    }

    private native String _df(long var1) throws LibGuestFSException;

    public String df_h() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("df_h: handle is closed");
        }
        return this._df_h(this.g);
    }

    private native String _df_h(long var1) throws LibGuestFSException;

    public void disk_create(String string, String string2, long l, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("disk_create: handle is closed");
        }
        long l2 = 0L;
        String string3 = "";
        Object object = null;
        if (map != null) {
            object = map.get("backingfile");
        }
        if (object != null) {
            string3 = (String)object;
            l2 |= 1L;
        }
        String string4 = "";
        object = null;
        if (map != null) {
            object = map.get("backingformat");
        }
        if (object != null) {
            string4 = (String)object;
            l2 |= 2L;
        }
        String string5 = "";
        object = null;
        if (map != null) {
            object = map.get("preallocation");
        }
        if (object != null) {
            string5 = (String)object;
            l2 |= 4L;
        }
        String string6 = "";
        object = null;
        if (map != null) {
            object = map.get("compat");
        }
        if (object != null) {
            string6 = (String)object;
            l2 |= 8L;
        }
        int n = 0;
        object = null;
        if (map != null) {
            object = map.get("clustersize");
        }
        if (object != null) {
            n = (Integer)object;
            l2 |= 0x10L;
        }
        this._disk_create(this.g, string, string2, l, l2, string3, string4, string5, string6, n);
    }

    public void disk_create(String string, String string2, long l) throws LibGuestFSException {
        this.disk_create(string, string2, l, null);
    }

    private native void _disk_create(long var1, String var3, String var4, long var5, long var7, String var9, String var10, String var11, String var12, int var13) throws LibGuestFSException;

    public String disk_format(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("disk_format: handle is closed");
        }
        return this._disk_format(this.g, string);
    }

    private native String _disk_format(long var1, String var3) throws LibGuestFSException;

    public boolean disk_has_backing_file(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("disk_has_backing_file: handle is closed");
        }
        return this._disk_has_backing_file(this.g, string);
    }

    private native boolean _disk_has_backing_file(long var1, String var3) throws LibGuestFSException;

    public long disk_virtual_size(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("disk_virtual_size: handle is closed");
        }
        return this._disk_virtual_size(this.g, string);
    }

    private native long _disk_virtual_size(long var1, String var3) throws LibGuestFSException;

    public String dmesg() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("dmesg: handle is closed");
        }
        return this._dmesg(this.g);
    }

    private native String _dmesg(long var1) throws LibGuestFSException;

    public void download(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("download: handle is closed");
        }
        this._download(this.g, string, string2);
    }

    private native void _download(long var1, String var3, String var4) throws LibGuestFSException;

    public void download_blocks(String string, long l, long l2, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("download_blocks: handle is closed");
        }
        long l3 = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("unallocated");
        }
        if (object != null) {
            bl = (Boolean)object;
            l3 |= 1L;
        }
        this._download_blocks(this.g, string, l, l2, string2, l3, bl);
    }

    public void download_blocks(String string, long l, long l2, String string2) throws LibGuestFSException {
        this.download_blocks(string, l, l2, string2, null);
    }

    private native void _download_blocks(long var1, String var3, long var4, long var6, String var8, long var9, boolean var11) throws LibGuestFSException;

    public void download_inode(String string, long l, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("download_inode: handle is closed");
        }
        this._download_inode(this.g, string, l, string2);
    }

    private native void _download_inode(long var1, String var3, long var4, String var6) throws LibGuestFSException;

    public void download_offset(String string, String string2, long l, long l2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("download_offset: handle is closed");
        }
        this._download_offset(this.g, string, string2, l, l2);
    }

    private native void _download_offset(long var1, String var3, String var4, long var5, long var7) throws LibGuestFSException;

    public void drop_caches(int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("drop_caches: handle is closed");
        }
        this._drop_caches(this.g, n);
    }

    private native void _drop_caches(long var1, int var3) throws LibGuestFSException;

    public long du(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("du: handle is closed");
        }
        return this._du(this.g, string);
    }

    private native long _du(long var1, String var3) throws LibGuestFSException;

    public void e2fsck(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("e2fsck: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("correct");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("forceall");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 2L;
        }
        this._e2fsck(this.g, string, l, bl, bl2);
    }

    public void e2fsck(String string) throws LibGuestFSException {
        this.e2fsck(string, null);
    }

    private native void _e2fsck(long var1, String var3, long var4, boolean var6, boolean var7) throws LibGuestFSException;

    @Deprecated
    public void e2fsck_f(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("e2fsck_f: handle is closed");
        }
        this._e2fsck_f(this.g, string);
    }

    private native void _e2fsck_f(long var1, String var3) throws LibGuestFSException;

    public String echo_daemon(String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("echo_daemon: handle is closed");
        }
        return this._echo_daemon(this.g, stringArray);
    }

    private native String _echo_daemon(long var1, String[] var3) throws LibGuestFSException;

    @Deprecated
    public String[] egrep(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("egrep: handle is closed");
        }
        return this._egrep(this.g, string, string2);
    }

    private native String[] _egrep(long var1, String var3, String var4) throws LibGuestFSException;

    @Deprecated
    public String[] egrepi(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("egrepi: handle is closed");
        }
        return this._egrepi(this.g, string, string2);
    }

    private native String[] _egrepi(long var1, String var3, String var4) throws LibGuestFSException;

    public boolean equal(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("equal: handle is closed");
        }
        return this._equal(this.g, string, string2);
    }

    private native boolean _equal(long var1, String var3, String var4) throws LibGuestFSException;

    public boolean exists(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("exists: handle is closed");
        }
        return this._exists(this.g, string);
    }

    private native boolean _exists(long var1, String var3) throws LibGuestFSException;

    public void extlinux(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("extlinux: handle is closed");
        }
        this._extlinux(this.g, string);
    }

    private native void _extlinux(long var1, String var3) throws LibGuestFSException;

    public void f2fs_expand(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("f2fs_expand: handle is closed");
        }
        this._f2fs_expand(this.g, string);
    }

    private native void _f2fs_expand(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public void fallocate(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("fallocate: handle is closed");
        }
        this._fallocate(this.g, string, n);
    }

    private native void _fallocate(long var1, String var3, int var4) throws LibGuestFSException;

    public void fallocate64(String string, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("fallocate64: handle is closed");
        }
        this._fallocate64(this.g, string, l);
    }

    private native void _fallocate64(long var1, String var3, long var4) throws LibGuestFSException;

    public boolean feature_available(String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("feature_available: handle is closed");
        }
        return this._feature_available(this.g, stringArray);
    }

    private native boolean _feature_available(long var1, String[] var3) throws LibGuestFSException;

    @Deprecated
    public String[] fgrep(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("fgrep: handle is closed");
        }
        return this._fgrep(this.g, string, string2);
    }

    private native String[] _fgrep(long var1, String var3, String var4) throws LibGuestFSException;

    @Deprecated
    public String[] fgrepi(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("fgrepi: handle is closed");
        }
        return this._fgrepi(this.g, string, string2);
    }

    private native String[] _fgrepi(long var1, String var3, String var4) throws LibGuestFSException;

    public String file(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("file: handle is closed");
        }
        return this._file(this.g, string);
    }

    private native String _file(long var1, String var3) throws LibGuestFSException;

    public String file_architecture(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("file_architecture: handle is closed");
        }
        return this._file_architecture(this.g, string);
    }

    private native String _file_architecture(long var1, String var3) throws LibGuestFSException;

    public long filesize(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("filesize: handle is closed");
        }
        return this._filesize(this.g, string);
    }

    private native long _filesize(long var1, String var3) throws LibGuestFSException;

    public boolean filesystem_available(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("filesystem_available: handle is closed");
        }
        return this._filesystem_available(this.g, string);
    }

    private native boolean _filesystem_available(long var1, String var3) throws LibGuestFSException;

    public TSKDirent[] filesystem_walk(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("filesystem_walk: handle is closed");
        }
        return this._filesystem_walk(this.g, string);
    }

    private native TSKDirent[] _filesystem_walk(long var1, String var3) throws LibGuestFSException;

    public void fill(int n, int n2, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("fill: handle is closed");
        }
        this._fill(this.g, n, n2, string);
    }

    private native void _fill(long var1, int var3, int var4, String var5) throws LibGuestFSException;

    public void fill_dir(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("fill_dir: handle is closed");
        }
        this._fill_dir(this.g, string, n);
    }

    private native void _fill_dir(long var1, String var3, int var4) throws LibGuestFSException;

    public void fill_pattern(String string, int n, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("fill_pattern: handle is closed");
        }
        this._fill_pattern(this.g, string, n, string2);
    }

    private native void _fill_pattern(long var1, String var3, int var4, String var5) throws LibGuestFSException;

    public String[] find(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("find: handle is closed");
        }
        return this._find(this.g, string);
    }

    private native String[] _find(long var1, String var3) throws LibGuestFSException;

    public void find0(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("find0: handle is closed");
        }
        this._find0(this.g, string, string2);
    }

    private native void _find0(long var1, String var3, String var4) throws LibGuestFSException;

    public TSKDirent[] find_inode(String string, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("find_inode: handle is closed");
        }
        return this._find_inode(this.g, string, l);
    }

    private native TSKDirent[] _find_inode(long var1, String var3, long var4) throws LibGuestFSException;

    public String findfs_label(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("findfs_label: handle is closed");
        }
        return this._findfs_label(this.g, string);
    }

    private native String _findfs_label(long var1, String var3) throws LibGuestFSException;

    public String findfs_uuid(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("findfs_uuid: handle is closed");
        }
        return this._findfs_uuid(this.g, string);
    }

    private native String _findfs_uuid(long var1, String var3) throws LibGuestFSException;

    public int fsck(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("fsck: handle is closed");
        }
        return this._fsck(this.g, string, string2);
    }

    private native int _fsck(long var1, String var3, String var4) throws LibGuestFSException;

    public void fstrim(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("fstrim: handle is closed");
        }
        long l = 0L;
        long l2 = 0L;
        Object object = null;
        if (map != null) {
            object = map.get("offset");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 1L;
        }
        long l3 = 0L;
        object = null;
        if (map != null) {
            object = map.get("length");
        }
        if (object != null) {
            l3 = (Long)object;
            l |= 2L;
        }
        long l4 = 0L;
        object = null;
        if (map != null) {
            object = map.get("minimumfreeextent");
        }
        if (object != null) {
            l4 = (Long)object;
            l |= 4L;
        }
        this._fstrim(this.g, string, l, l2, l3, l4);
    }

    public void fstrim(String string) throws LibGuestFSException {
        this.fstrim(string, null);
    }

    private native void _fstrim(long var1, String var3, long var4, long var6, long var8, long var10) throws LibGuestFSException;

    public String get_append() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_append: handle is closed");
        }
        return this._get_append(this.g);
    }

    private native String _get_append(long var1) throws LibGuestFSException;

    @Deprecated
    public String get_attach_method() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_attach_method: handle is closed");
        }
        return this._get_attach_method(this.g);
    }

    private native String _get_attach_method(long var1) throws LibGuestFSException;

    public boolean get_autosync() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_autosync: handle is closed");
        }
        return this._get_autosync(this.g);
    }

    private native boolean _get_autosync(long var1) throws LibGuestFSException;

    public String get_backend() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_backend: handle is closed");
        }
        return this._get_backend(this.g);
    }

    private native String _get_backend(long var1) throws LibGuestFSException;

    public String get_backend_setting(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_backend_setting: handle is closed");
        }
        return this._get_backend_setting(this.g, string);
    }

    private native String _get_backend_setting(long var1, String var3) throws LibGuestFSException;

    public String[] get_backend_settings() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_backend_settings: handle is closed");
        }
        return this._get_backend_settings(this.g);
    }

    private native String[] _get_backend_settings(long var1) throws LibGuestFSException;

    public String get_cachedir() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_cachedir: handle is closed");
        }
        return this._get_cachedir(this.g);
    }

    private native String _get_cachedir(long var1) throws LibGuestFSException;

    @Deprecated
    public boolean get_direct() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_direct: handle is closed");
        }
        return this._get_direct(this.g);
    }

    private native boolean _get_direct(long var1) throws LibGuestFSException;

    public String get_e2attrs(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_e2attrs: handle is closed");
        }
        return this._get_e2attrs(this.g, string);
    }

    private native String _get_e2attrs(long var1, String var3) throws LibGuestFSException;

    public long get_e2generation(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_e2generation: handle is closed");
        }
        return this._get_e2generation(this.g, string);
    }

    private native long _get_e2generation(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public String get_e2label(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_e2label: handle is closed");
        }
        return this._get_e2label(this.g, string);
    }

    private native String _get_e2label(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public String get_e2uuid(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_e2uuid: handle is closed");
        }
        return this._get_e2uuid(this.g, string);
    }

    private native String _get_e2uuid(long var1, String var3) throws LibGuestFSException;

    public String get_hv() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_hv: handle is closed");
        }
        return this._get_hv(this.g);
    }

    private native String _get_hv(long var1) throws LibGuestFSException;

    public String get_identifier() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_identifier: handle is closed");
        }
        return this._get_identifier(this.g);
    }

    private native String _get_identifier(long var1) throws LibGuestFSException;

    public String get_libvirt_requested_credential_challenge(int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_libvirt_requested_credential_challenge: handle is closed");
        }
        return this._get_libvirt_requested_credential_challenge(this.g, n);
    }

    private native String _get_libvirt_requested_credential_challenge(long var1, int var3) throws LibGuestFSException;

    public String get_libvirt_requested_credential_defresult(int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_libvirt_requested_credential_defresult: handle is closed");
        }
        return this._get_libvirt_requested_credential_defresult(this.g, n);
    }

    private native String _get_libvirt_requested_credential_defresult(long var1, int var3) throws LibGuestFSException;

    public String get_libvirt_requested_credential_prompt(int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_libvirt_requested_credential_prompt: handle is closed");
        }
        return this._get_libvirt_requested_credential_prompt(this.g, n);
    }

    private native String _get_libvirt_requested_credential_prompt(long var1, int var3) throws LibGuestFSException;

    public String[] get_libvirt_requested_credentials() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_libvirt_requested_credentials: handle is closed");
        }
        return this._get_libvirt_requested_credentials(this.g);
    }

    private native String[] _get_libvirt_requested_credentials(long var1) throws LibGuestFSException;

    public int get_memsize() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_memsize: handle is closed");
        }
        return this._get_memsize(this.g);
    }

    private native int _get_memsize(long var1) throws LibGuestFSException;

    public boolean get_network() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_network: handle is closed");
        }
        return this._get_network(this.g);
    }

    private native boolean _get_network(long var1) throws LibGuestFSException;

    public String get_path() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_path: handle is closed");
        }
        return this._get_path(this.g);
    }

    private native String _get_path(long var1) throws LibGuestFSException;

    public boolean get_pgroup() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_pgroup: handle is closed");
        }
        return this._get_pgroup(this.g);
    }

    private native boolean _get_pgroup(long var1) throws LibGuestFSException;

    public int get_pid() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_pid: handle is closed");
        }
        return this._get_pid(this.g);
    }

    private native int _get_pid(long var1) throws LibGuestFSException;

    public String get_program() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_program: handle is closed");
        }
        return this._get_program(this.g);
    }

    private native String _get_program(long var1) throws LibGuestFSException;

    @Deprecated
    public String get_qemu() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_qemu: handle is closed");
        }
        return this._get_qemu(this.g);
    }

    private native String _get_qemu(long var1) throws LibGuestFSException;

    public boolean get_recovery_proc() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_recovery_proc: handle is closed");
        }
        return this._get_recovery_proc(this.g);
    }

    private native boolean _get_recovery_proc(long var1) throws LibGuestFSException;

    @Deprecated
    public boolean get_selinux() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_selinux: handle is closed");
        }
        return this._get_selinux(this.g);
    }

    private native boolean _get_selinux(long var1) throws LibGuestFSException;

    public int get_smp() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_smp: handle is closed");
        }
        return this._get_smp(this.g);
    }

    private native int _get_smp(long var1) throws LibGuestFSException;

    public String get_sockdir() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_sockdir: handle is closed");
        }
        return this._get_sockdir(this.g);
    }

    private native String _get_sockdir(long var1) throws LibGuestFSException;

    public int get_state() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_state: handle is closed");
        }
        return this._get_state(this.g);
    }

    private native int _get_state(long var1) throws LibGuestFSException;

    public String get_tmpdir() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_tmpdir: handle is closed");
        }
        return this._get_tmpdir(this.g);
    }

    private native String _get_tmpdir(long var1) throws LibGuestFSException;

    public boolean get_trace() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_trace: handle is closed");
        }
        return this._get_trace(this.g);
    }

    private native boolean _get_trace(long var1) throws LibGuestFSException;

    public int get_umask() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_umask: handle is closed");
        }
        return this._get_umask(this.g);
    }

    private native int _get_umask(long var1) throws LibGuestFSException;

    public boolean get_verbose() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("get_verbose: handle is closed");
        }
        return this._get_verbose(this.g);
    }

    private native boolean _get_verbose(long var1) throws LibGuestFSException;

    @Deprecated
    public String getcon() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("getcon: handle is closed");
        }
        return this._getcon(this.g);
    }

    private native String _getcon(long var1) throws LibGuestFSException;

    public String getxattr(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("getxattr: handle is closed");
        }
        return this._getxattr(this.g, string, string2);
    }

    private native String _getxattr(long var1, String var3, String var4) throws LibGuestFSException;

    public XAttr[] getxattrs(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("getxattrs: handle is closed");
        }
        return this._getxattrs(this.g, string);
    }

    private native XAttr[] _getxattrs(long var1, String var3) throws LibGuestFSException;

    public String[] glob_expand(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("glob_expand: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("directoryslash");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        return this._glob_expand(this.g, string, l, bl);
    }

    public String[] glob_expand(String string) throws LibGuestFSException {
        return this.glob_expand(string, null);
    }

    public String[] glob_expand_opts(String string, Map<String, Object> map) throws LibGuestFSException {
        return this.glob_expand(string, map);
    }

    public String[] glob_expand_opts(String string) throws LibGuestFSException {
        return this.glob_expand(string, null);
    }

    private native String[] _glob_expand(long var1, String var3, long var4, boolean var6) throws LibGuestFSException;

    public String[] grep(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("grep: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("extended");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("fixed");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 2L;
        }
        boolean bl3 = false;
        object = null;
        if (map != null) {
            object = map.get("insensitive");
        }
        if (object != null) {
            bl3 = (Boolean)object;
            l |= 4L;
        }
        boolean bl4 = false;
        object = null;
        if (map != null) {
            object = map.get("compressed");
        }
        if (object != null) {
            bl4 = (Boolean)object;
            l |= 8L;
        }
        return this._grep(this.g, string, string2, l, bl, bl2, bl3, bl4);
    }

    public String[] grep(String string, String string2) throws LibGuestFSException {
        return this.grep(string, string2, null);
    }

    public String[] grep_opts(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        return this.grep(string, string2, map);
    }

    public String[] grep_opts(String string, String string2) throws LibGuestFSException {
        return this.grep(string, string2, null);
    }

    private native String[] _grep(long var1, String var3, String var4, long var5, boolean var7, boolean var8, boolean var9, boolean var10) throws LibGuestFSException;

    @Deprecated
    public String[] grepi(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("grepi: handle is closed");
        }
        return this._grepi(this.g, string, string2);
    }

    private native String[] _grepi(long var1, String var3, String var4) throws LibGuestFSException;

    public void grub_install(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("grub_install: handle is closed");
        }
        this._grub_install(this.g, string, string2);
    }

    private native void _grub_install(long var1, String var3, String var4) throws LibGuestFSException;

    public String[] head(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("head: handle is closed");
        }
        return this._head(this.g, string);
    }

    private native String[] _head(long var1, String var3) throws LibGuestFSException;

    public String[] head_n(int n, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("head_n: handle is closed");
        }
        return this._head_n(this.g, n, string);
    }

    private native String[] _head_n(long var1, int var3, String var4) throws LibGuestFSException;

    public String hexdump(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hexdump: handle is closed");
        }
        return this._hexdump(this.g, string);
    }

    private native String _hexdump(long var1, String var3) throws LibGuestFSException;

    public void hivex_close() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_close: handle is closed");
        }
        this._hivex_close(this.g);
    }

    private native void _hivex_close(long var1) throws LibGuestFSException;

    public void hivex_commit(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_commit: handle is closed");
        }
        this._hivex_commit(this.g, string);
    }

    private native void _hivex_commit(long var1, String var3) throws LibGuestFSException;

    public long hivex_node_add_child(long l, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_node_add_child: handle is closed");
        }
        return this._hivex_node_add_child(this.g, l, string);
    }

    private native long _hivex_node_add_child(long var1, long var3, String var5) throws LibGuestFSException;

    public HivexNode[] hivex_node_children(long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_node_children: handle is closed");
        }
        return this._hivex_node_children(this.g, l);
    }

    private native HivexNode[] _hivex_node_children(long var1, long var3) throws LibGuestFSException;

    public void hivex_node_delete_child(long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_node_delete_child: handle is closed");
        }
        this._hivex_node_delete_child(this.g, l);
    }

    private native void _hivex_node_delete_child(long var1, long var3) throws LibGuestFSException;

    public long hivex_node_get_child(long l, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_node_get_child: handle is closed");
        }
        return this._hivex_node_get_child(this.g, l, string);
    }

    private native long _hivex_node_get_child(long var1, long var3, String var5) throws LibGuestFSException;

    public long hivex_node_get_value(long l, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_node_get_value: handle is closed");
        }
        return this._hivex_node_get_value(this.g, l, string);
    }

    private native long _hivex_node_get_value(long var1, long var3, String var5) throws LibGuestFSException;

    public String hivex_node_name(long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_node_name: handle is closed");
        }
        return this._hivex_node_name(this.g, l);
    }

    private native String _hivex_node_name(long var1, long var3) throws LibGuestFSException;

    public long hivex_node_parent(long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_node_parent: handle is closed");
        }
        return this._hivex_node_parent(this.g, l);
    }

    private native long _hivex_node_parent(long var1, long var3) throws LibGuestFSException;

    public void hivex_node_set_value(long l, String string, long l2, byte[] byArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_node_set_value: handle is closed");
        }
        this._hivex_node_set_value(this.g, l, string, l2, byArray);
    }

    private native void _hivex_node_set_value(long var1, long var3, String var5, long var6, byte[] var8) throws LibGuestFSException;

    public HivexValue[] hivex_node_values(long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_node_values: handle is closed");
        }
        return this._hivex_node_values(this.g, l);
    }

    private native HivexValue[] _hivex_node_values(long var1, long var3) throws LibGuestFSException;

    public void hivex_open(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_open: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("verbose");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("debug");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 2L;
        }
        boolean bl3 = false;
        object = null;
        if (map != null) {
            object = map.get("write");
        }
        if (object != null) {
            bl3 = (Boolean)object;
            l |= 4L;
        }
        boolean bl4 = false;
        object = null;
        if (map != null) {
            object = map.get("unsafe");
        }
        if (object != null) {
            bl4 = (Boolean)object;
            l |= 8L;
        }
        this._hivex_open(this.g, string, l, bl, bl2, bl3, bl4);
    }

    public void hivex_open(String string) throws LibGuestFSException {
        this.hivex_open(string, null);
    }

    private native void _hivex_open(long var1, String var3, long var4, boolean var6, boolean var7, boolean var8, boolean var9) throws LibGuestFSException;

    public long hivex_root() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_root: handle is closed");
        }
        return this._hivex_root(this.g);
    }

    private native long _hivex_root(long var1) throws LibGuestFSException;

    public String hivex_value_key(long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_value_key: handle is closed");
        }
        return this._hivex_value_key(this.g, l);
    }

    private native String _hivex_value_key(long var1, long var3) throws LibGuestFSException;

    public String hivex_value_string(long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_value_string: handle is closed");
        }
        return this._hivex_value_string(this.g, l);
    }

    private native String _hivex_value_string(long var1, long var3) throws LibGuestFSException;

    public long hivex_value_type(long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_value_type: handle is closed");
        }
        return this._hivex_value_type(this.g, l);
    }

    private native long _hivex_value_type(long var1, long var3) throws LibGuestFSException;

    @Deprecated
    public String hivex_value_utf8(long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_value_utf8: handle is closed");
        }
        return this._hivex_value_utf8(this.g, l);
    }

    private native String _hivex_value_utf8(long var1, long var3) throws LibGuestFSException;

    public String hivex_value_value(long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("hivex_value_value: handle is closed");
        }
        return this._hivex_value_value(this.g, l);
    }

    private native String _hivex_value_value(long var1, long var3) throws LibGuestFSException;

    public String initrd_cat(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("initrd_cat: handle is closed");
        }
        return this._initrd_cat(this.g, string, string2);
    }

    private native String _initrd_cat(long var1, String var3, String var4) throws LibGuestFSException;

    public String[] initrd_list(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("initrd_list: handle is closed");
        }
        return this._initrd_list(this.g, string);
    }

    private native String[] _initrd_list(long var1, String var3) throws LibGuestFSException;

    public long inotify_add_watch(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inotify_add_watch: handle is closed");
        }
        return this._inotify_add_watch(this.g, string, n);
    }

    private native long _inotify_add_watch(long var1, String var3, int var4) throws LibGuestFSException;

    public void inotify_close() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inotify_close: handle is closed");
        }
        this._inotify_close(this.g);
    }

    private native void _inotify_close(long var1) throws LibGuestFSException;

    public String[] inotify_files() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inotify_files: handle is closed");
        }
        return this._inotify_files(this.g);
    }

    private native String[] _inotify_files(long var1) throws LibGuestFSException;

    public void inotify_init(int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inotify_init: handle is closed");
        }
        this._inotify_init(this.g, n);
    }

    private native void _inotify_init(long var1, int var3) throws LibGuestFSException;

    public INotifyEvent[] inotify_read() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inotify_read: handle is closed");
        }
        return this._inotify_read(this.g);
    }

    private native INotifyEvent[] _inotify_read(long var1) throws LibGuestFSException;

    public void inotify_rm_watch(int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inotify_rm_watch: handle is closed");
        }
        this._inotify_rm_watch(this.g, n);
    }

    private native void _inotify_rm_watch(long var1, int var3) throws LibGuestFSException;

    public String inspect_get_arch(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_arch: handle is closed");
        }
        return this._inspect_get_arch(this.g, string);
    }

    private native String _inspect_get_arch(long var1, String var3) throws LibGuestFSException;

    public String inspect_get_distro(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_distro: handle is closed");
        }
        return this._inspect_get_distro(this.g, string);
    }

    private native String _inspect_get_distro(long var1, String var3) throws LibGuestFSException;

    public Map<String, String> inspect_get_drive_mappings(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_drive_mappings: handle is closed");
        }
        String[] stringArray = this._inspect_get_drive_mappings(this.g, string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return hashMap;
    }

    private native String[] _inspect_get_drive_mappings(long var1, String var3) throws LibGuestFSException;

    public String[] inspect_get_filesystems(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_filesystems: handle is closed");
        }
        return this._inspect_get_filesystems(this.g, string);
    }

    private native String[] _inspect_get_filesystems(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public String inspect_get_format(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_format: handle is closed");
        }
        return this._inspect_get_format(this.g, string);
    }

    private native String _inspect_get_format(long var1, String var3) throws LibGuestFSException;

    public String inspect_get_hostname(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_hostname: handle is closed");
        }
        return this._inspect_get_hostname(this.g, string);
    }

    private native String _inspect_get_hostname(long var1, String var3) throws LibGuestFSException;

    public String inspect_get_icon(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_icon: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("favicon");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("highquality");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 2L;
        }
        return this._inspect_get_icon(this.g, string, l, bl, bl2);
    }

    public String inspect_get_icon(String string) throws LibGuestFSException {
        return this.inspect_get_icon(string, null);
    }

    private native String _inspect_get_icon(long var1, String var3, long var4, boolean var6, boolean var7) throws LibGuestFSException;

    public int inspect_get_major_version(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_major_version: handle is closed");
        }
        return this._inspect_get_major_version(this.g, string);
    }

    private native int _inspect_get_major_version(long var1, String var3) throws LibGuestFSException;

    public int inspect_get_minor_version(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_minor_version: handle is closed");
        }
        return this._inspect_get_minor_version(this.g, string);
    }

    private native int _inspect_get_minor_version(long var1, String var3) throws LibGuestFSException;

    public Map<String, String> inspect_get_mountpoints(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_mountpoints: handle is closed");
        }
        String[] stringArray = this._inspect_get_mountpoints(this.g, string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return hashMap;
    }

    private native String[] _inspect_get_mountpoints(long var1, String var3) throws LibGuestFSException;

    public String inspect_get_osinfo(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_osinfo: handle is closed");
        }
        return this._inspect_get_osinfo(this.g, string);
    }

    private native String _inspect_get_osinfo(long var1, String var3) throws LibGuestFSException;

    public String inspect_get_package_format(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_package_format: handle is closed");
        }
        return this._inspect_get_package_format(this.g, string);
    }

    private native String _inspect_get_package_format(long var1, String var3) throws LibGuestFSException;

    public String inspect_get_package_management(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_package_management: handle is closed");
        }
        return this._inspect_get_package_management(this.g, string);
    }

    private native String _inspect_get_package_management(long var1, String var3) throws LibGuestFSException;

    public String inspect_get_product_name(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_product_name: handle is closed");
        }
        return this._inspect_get_product_name(this.g, string);
    }

    private native String _inspect_get_product_name(long var1, String var3) throws LibGuestFSException;

    public String inspect_get_product_variant(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_product_variant: handle is closed");
        }
        return this._inspect_get_product_variant(this.g, string);
    }

    private native String _inspect_get_product_variant(long var1, String var3) throws LibGuestFSException;

    public String[] inspect_get_roots() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_roots: handle is closed");
        }
        return this._inspect_get_roots(this.g);
    }

    private native String[] _inspect_get_roots(long var1) throws LibGuestFSException;

    public String inspect_get_type(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_type: handle is closed");
        }
        return this._inspect_get_type(this.g, string);
    }

    private native String _inspect_get_type(long var1, String var3) throws LibGuestFSException;

    public String inspect_get_windows_current_control_set(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_windows_current_control_set: handle is closed");
        }
        return this._inspect_get_windows_current_control_set(this.g, string);
    }

    private native String _inspect_get_windows_current_control_set(long var1, String var3) throws LibGuestFSException;

    public String inspect_get_windows_software_hive(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_windows_software_hive: handle is closed");
        }
        return this._inspect_get_windows_software_hive(this.g, string);
    }

    private native String _inspect_get_windows_software_hive(long var1, String var3) throws LibGuestFSException;

    public String inspect_get_windows_system_hive(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_windows_system_hive: handle is closed");
        }
        return this._inspect_get_windows_system_hive(this.g, string);
    }

    private native String _inspect_get_windows_system_hive(long var1, String var3) throws LibGuestFSException;

    public String inspect_get_windows_systemroot(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_get_windows_systemroot: handle is closed");
        }
        return this._inspect_get_windows_systemroot(this.g, string);
    }

    private native String _inspect_get_windows_systemroot(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public boolean inspect_is_live(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_is_live: handle is closed");
        }
        return this._inspect_is_live(this.g, string);
    }

    private native boolean _inspect_is_live(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public boolean inspect_is_multipart(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_is_multipart: handle is closed");
        }
        return this._inspect_is_multipart(this.g, string);
    }

    private native boolean _inspect_is_multipart(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public boolean inspect_is_netinst(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_is_netinst: handle is closed");
        }
        return this._inspect_is_netinst(this.g, string);
    }

    private native boolean _inspect_is_netinst(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public Application[] inspect_list_applications(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_list_applications: handle is closed");
        }
        return this._inspect_list_applications(this.g, string);
    }

    private native Application[] _inspect_list_applications(long var1, String var3) throws LibGuestFSException;

    public Application2[] inspect_list_applications2(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_list_applications2: handle is closed");
        }
        return this._inspect_list_applications2(this.g, string);
    }

    private native Application2[] _inspect_list_applications2(long var1, String var3) throws LibGuestFSException;

    public String[] inspect_os() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("inspect_os: handle is closed");
        }
        return this._inspect_os(this.g);
    }

    private native String[] _inspect_os(long var1) throws LibGuestFSException;

    public void internal_exit() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_exit: handle is closed");
        }
        this._internal_exit(this.g);
    }

    private native void _internal_exit(long var1) throws LibGuestFSException;

    public void internal_test(String string, String string2, String[] stringArray, boolean bl, int n, long l, String string3, String string4, byte[] byArray, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test: handle is closed");
        }
        long l2 = 0L;
        boolean bl2 = false;
        Object object = null;
        if (map != null) {
            object = map.get("obool");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l2 |= 1L;
        }
        int n2 = 0;
        object = null;
        if (map != null) {
            object = map.get("oint");
        }
        if (object != null) {
            n2 = (Integer)object;
            l2 |= 2L;
        }
        long l3 = 0L;
        object = null;
        if (map != null) {
            object = map.get("oint64");
        }
        if (object != null) {
            l3 = (Long)object;
            l2 |= 4L;
        }
        String string5 = "";
        object = null;
        if (map != null) {
            object = map.get("ostring");
        }
        if (object != null) {
            string5 = (String)object;
            l2 |= 8L;
        }
        String[] stringArray2 = new String[]{};
        object = null;
        if (map != null) {
            object = map.get("ostringlist");
        }
        if (object != null) {
            stringArray2 = (String[])object;
            l2 |= 0x10L;
        }
        this._internal_test(this.g, string, string2, stringArray, bl, n, l, string3, string4, byArray, l2, bl2, n2, l3, string5, stringArray2);
    }

    public void internal_test(String string, String string2, String[] stringArray, boolean bl, int n, long l, String string3, String string4, byte[] byArray) throws LibGuestFSException {
        this.internal_test(string, string2, stringArray, bl, n, l, string3, string4, byArray, null);
    }

    private native void _internal_test(long var1, String var3, String var4, String[] var5, boolean var6, int var7, long var8, String var10, String var11, byte[] var12, long var13, boolean var15, int var16, long var17, String var19, String[] var20) throws LibGuestFSException;

    public void internal_test_63_optargs(Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_63_optargs: handle is closed");
        }
        long l = 0L;
        int n = 0;
        Object object = null;
        if (map != null) {
            object = map.get("opt1");
        }
        if (object != null) {
            n = (Integer)object;
            l |= 1L;
        }
        int n2 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt2");
        }
        if (object != null) {
            n2 = (Integer)object;
            l |= 2L;
        }
        int n3 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt3");
        }
        if (object != null) {
            n3 = (Integer)object;
            l |= 4L;
        }
        int n4 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt4");
        }
        if (object != null) {
            n4 = (Integer)object;
            l |= 8L;
        }
        int n5 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt5");
        }
        if (object != null) {
            n5 = (Integer)object;
            l |= 0x10L;
        }
        int n6 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt6");
        }
        if (object != null) {
            n6 = (Integer)object;
            l |= 0x20L;
        }
        int n7 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt7");
        }
        if (object != null) {
            n7 = (Integer)object;
            l |= 0x40L;
        }
        int n8 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt8");
        }
        if (object != null) {
            n8 = (Integer)object;
            l |= 0x80L;
        }
        int n9 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt9");
        }
        if (object != null) {
            n9 = (Integer)object;
            l |= 0x100L;
        }
        int n10 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt10");
        }
        if (object != null) {
            n10 = (Integer)object;
            l |= 0x200L;
        }
        int n11 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt11");
        }
        if (object != null) {
            n11 = (Integer)object;
            l |= 0x400L;
        }
        int n12 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt12");
        }
        if (object != null) {
            n12 = (Integer)object;
            l |= 0x800L;
        }
        int n13 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt13");
        }
        if (object != null) {
            n13 = (Integer)object;
            l |= 0x1000L;
        }
        int n14 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt14");
        }
        if (object != null) {
            n14 = (Integer)object;
            l |= 0x2000L;
        }
        int n15 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt15");
        }
        if (object != null) {
            n15 = (Integer)object;
            l |= 0x4000L;
        }
        int n16 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt16");
        }
        if (object != null) {
            n16 = (Integer)object;
            l |= 0x8000L;
        }
        int n17 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt17");
        }
        if (object != null) {
            n17 = (Integer)object;
            l |= 0x10000L;
        }
        int n18 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt18");
        }
        if (object != null) {
            n18 = (Integer)object;
            l |= 0x20000L;
        }
        int n19 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt19");
        }
        if (object != null) {
            n19 = (Integer)object;
            l |= 0x40000L;
        }
        int n20 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt20");
        }
        if (object != null) {
            n20 = (Integer)object;
            l |= 0x80000L;
        }
        int n21 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt21");
        }
        if (object != null) {
            n21 = (Integer)object;
            l |= 0x100000L;
        }
        int n22 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt22");
        }
        if (object != null) {
            n22 = (Integer)object;
            l |= 0x200000L;
        }
        int n23 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt23");
        }
        if (object != null) {
            n23 = (Integer)object;
            l |= 0x400000L;
        }
        int n24 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt24");
        }
        if (object != null) {
            n24 = (Integer)object;
            l |= 0x800000L;
        }
        int n25 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt25");
        }
        if (object != null) {
            n25 = (Integer)object;
            l |= 0x1000000L;
        }
        int n26 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt26");
        }
        if (object != null) {
            n26 = (Integer)object;
            l |= 0x2000000L;
        }
        int n27 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt27");
        }
        if (object != null) {
            n27 = (Integer)object;
            l |= 0x4000000L;
        }
        int n28 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt28");
        }
        if (object != null) {
            n28 = (Integer)object;
            l |= 0x8000000L;
        }
        int n29 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt29");
        }
        if (object != null) {
            n29 = (Integer)object;
            l |= 0x10000000L;
        }
        int n30 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt30");
        }
        if (object != null) {
            n30 = (Integer)object;
            l |= 0x20000000L;
        }
        int n31 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt31");
        }
        if (object != null) {
            n31 = (Integer)object;
            l |= 0x40000000L;
        }
        int n32 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt32");
        }
        if (object != null) {
            n32 = (Integer)object;
            l |= 0x80000000L;
        }
        int n33 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt33");
        }
        if (object != null) {
            n33 = (Integer)object;
            l |= 0x100000000L;
        }
        int n34 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt34");
        }
        if (object != null) {
            n34 = (Integer)object;
            l |= 0x200000000L;
        }
        int n35 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt35");
        }
        if (object != null) {
            n35 = (Integer)object;
            l |= 0x400000000L;
        }
        int n36 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt36");
        }
        if (object != null) {
            n36 = (Integer)object;
            l |= 0x800000000L;
        }
        int n37 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt37");
        }
        if (object != null) {
            n37 = (Integer)object;
            l |= 0x1000000000L;
        }
        int n38 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt38");
        }
        if (object != null) {
            n38 = (Integer)object;
            l |= 0x2000000000L;
        }
        int n39 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt39");
        }
        if (object != null) {
            n39 = (Integer)object;
            l |= 0x4000000000L;
        }
        int n40 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt40");
        }
        if (object != null) {
            n40 = (Integer)object;
            l |= 0x8000000000L;
        }
        int n41 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt41");
        }
        if (object != null) {
            n41 = (Integer)object;
            l |= 0x10000000000L;
        }
        int n42 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt42");
        }
        if (object != null) {
            n42 = (Integer)object;
            l |= 0x20000000000L;
        }
        int n43 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt43");
        }
        if (object != null) {
            n43 = (Integer)object;
            l |= 0x40000000000L;
        }
        int n44 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt44");
        }
        if (object != null) {
            n44 = (Integer)object;
            l |= 0x80000000000L;
        }
        int n45 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt45");
        }
        if (object != null) {
            n45 = (Integer)object;
            l |= 0x100000000000L;
        }
        int n46 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt46");
        }
        if (object != null) {
            n46 = (Integer)object;
            l |= 0x200000000000L;
        }
        int n47 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt47");
        }
        if (object != null) {
            n47 = (Integer)object;
            l |= 0x400000000000L;
        }
        int n48 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt48");
        }
        if (object != null) {
            n48 = (Integer)object;
            l |= 0x800000000000L;
        }
        int n49 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt49");
        }
        if (object != null) {
            n49 = (Integer)object;
            l |= 0x1000000000000L;
        }
        int n50 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt50");
        }
        if (object != null) {
            n50 = (Integer)object;
            l |= 0x2000000000000L;
        }
        int n51 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt51");
        }
        if (object != null) {
            n51 = (Integer)object;
            l |= 0x4000000000000L;
        }
        int n52 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt52");
        }
        if (object != null) {
            n52 = (Integer)object;
            l |= 0x8000000000000L;
        }
        int n53 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt53");
        }
        if (object != null) {
            n53 = (Integer)object;
            l |= 0x10000000000000L;
        }
        int n54 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt54");
        }
        if (object != null) {
            n54 = (Integer)object;
            l |= 0x20000000000000L;
        }
        int n55 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt55");
        }
        if (object != null) {
            n55 = (Integer)object;
            l |= 0x40000000000000L;
        }
        int n56 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt56");
        }
        if (object != null) {
            n56 = (Integer)object;
            l |= 0x80000000000000L;
        }
        int n57 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt57");
        }
        if (object != null) {
            n57 = (Integer)object;
            l |= 0x100000000000000L;
        }
        int n58 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt58");
        }
        if (object != null) {
            n58 = (Integer)object;
            l |= 0x200000000000000L;
        }
        int n59 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt59");
        }
        if (object != null) {
            n59 = (Integer)object;
            l |= 0x400000000000000L;
        }
        int n60 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt60");
        }
        if (object != null) {
            n60 = (Integer)object;
            l |= 0x800000000000000L;
        }
        int n61 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt61");
        }
        if (object != null) {
            n61 = (Integer)object;
            l |= 0x1000000000000000L;
        }
        int n62 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt62");
        }
        if (object != null) {
            n62 = (Integer)object;
            l |= 0x2000000000000000L;
        }
        int n63 = 0;
        object = null;
        if (map != null) {
            object = map.get("opt63");
        }
        if (object != null) {
            n63 = (Integer)object;
            l |= 0x4000000000000000L;
        }
        this._internal_test_63_optargs(this.g, l, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19, n20, n21, n22, n23, n24, n25, n26, n27, n28, n29, n30, n31, n32, n33, n34, n35, n36, n37, n38, n39, n40, n41, n42, n43, n44, n45, n46, n47, n48, n49, n50, n51, n52, n53, n54, n55, n56, n57, n58, n59, n60, n61, n62, n63);
    }

    public void internal_test_63_optargs() throws LibGuestFSException {
        this.internal_test_63_optargs(null);
    }

    private native void _internal_test_63_optargs(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, int var19, int var20, int var21, int var22, int var23, int var24, int var25, int var26, int var27, int var28, int var29, int var30, int var31, int var32, int var33, int var34, int var35, int var36, int var37, int var38, int var39, int var40, int var41, int var42, int var43, int var44, int var45, int var46, int var47, int var48, int var49, int var50, int var51, int var52, int var53, int var54, int var55, int var56, int var57, int var58, int var59, int var60, int var61, int var62, int var63, int var64, int var65, int var66, int var67) throws LibGuestFSException;

    public void internal_test_close_output() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_close_output: handle is closed");
        }
        this._internal_test_close_output(this.g);
    }

    private native void _internal_test_close_output(long var1) throws LibGuestFSException;

    public void internal_test_only_optargs(Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_only_optargs: handle is closed");
        }
        long l = 0L;
        int n = 0;
        Object object = null;
        if (map != null) {
            object = map.get("test");
        }
        if (object != null) {
            n = (Integer)object;
            l |= 1L;
        }
        this._internal_test_only_optargs(this.g, l, n);
    }

    public void internal_test_only_optargs() throws LibGuestFSException {
        this.internal_test_only_optargs(null);
    }

    private native void _internal_test_only_optargs(long var1, long var3, int var5) throws LibGuestFSException;

    public boolean internal_test_rbool(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rbool: handle is closed");
        }
        return this._internal_test_rbool(this.g, string);
    }

    private native boolean _internal_test_rbool(long var1, String var3) throws LibGuestFSException;

    public boolean internal_test_rboolerr() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rboolerr: handle is closed");
        }
        return this._internal_test_rboolerr(this.g);
    }

    private native boolean _internal_test_rboolerr(long var1) throws LibGuestFSException;

    public String internal_test_rbufferout(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rbufferout: handle is closed");
        }
        return this._internal_test_rbufferout(this.g, string);
    }

    private native String _internal_test_rbufferout(long var1, String var3) throws LibGuestFSException;

    public String internal_test_rbufferouterr() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rbufferouterr: handle is closed");
        }
        return this._internal_test_rbufferouterr(this.g);
    }

    private native String _internal_test_rbufferouterr(long var1) throws LibGuestFSException;

    public String internal_test_rconstoptstring(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rconstoptstring: handle is closed");
        }
        return this._internal_test_rconstoptstring(this.g, string);
    }

    private native String _internal_test_rconstoptstring(long var1, String var3) throws LibGuestFSException;

    public String internal_test_rconstoptstringerr() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rconstoptstringerr: handle is closed");
        }
        return this._internal_test_rconstoptstringerr(this.g);
    }

    private native String _internal_test_rconstoptstringerr(long var1) throws LibGuestFSException;

    public String internal_test_rconststring(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rconststring: handle is closed");
        }
        return this._internal_test_rconststring(this.g, string);
    }

    private native String _internal_test_rconststring(long var1, String var3) throws LibGuestFSException;

    public String internal_test_rconststringerr() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rconststringerr: handle is closed");
        }
        return this._internal_test_rconststringerr(this.g);
    }

    private native String _internal_test_rconststringerr(long var1) throws LibGuestFSException;

    public Map<String, String> internal_test_rhashtable(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rhashtable: handle is closed");
        }
        String[] stringArray = this._internal_test_rhashtable(this.g, string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return hashMap;
    }

    private native String[] _internal_test_rhashtable(long var1, String var3) throws LibGuestFSException;

    public Map<String, String> internal_test_rhashtableerr() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rhashtableerr: handle is closed");
        }
        String[] stringArray = this._internal_test_rhashtableerr(this.g);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return hashMap;
    }

    private native String[] _internal_test_rhashtableerr(long var1) throws LibGuestFSException;

    public int internal_test_rint(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rint: handle is closed");
        }
        return this._internal_test_rint(this.g, string);
    }

    private native int _internal_test_rint(long var1, String var3) throws LibGuestFSException;

    public long internal_test_rint64(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rint64: handle is closed");
        }
        return this._internal_test_rint64(this.g, string);
    }

    private native long _internal_test_rint64(long var1, String var3) throws LibGuestFSException;

    public long internal_test_rint64err() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rint64err: handle is closed");
        }
        return this._internal_test_rint64err(this.g);
    }

    private native long _internal_test_rint64err(long var1) throws LibGuestFSException;

    public int internal_test_rinterr() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rinterr: handle is closed");
        }
        return this._internal_test_rinterr(this.g);
    }

    private native int _internal_test_rinterr(long var1) throws LibGuestFSException;

    public String internal_test_rstring(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rstring: handle is closed");
        }
        return this._internal_test_rstring(this.g, string);
    }

    private native String _internal_test_rstring(long var1, String var3) throws LibGuestFSException;

    public String internal_test_rstringerr() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rstringerr: handle is closed");
        }
        return this._internal_test_rstringerr(this.g);
    }

    private native String _internal_test_rstringerr(long var1) throws LibGuestFSException;

    public String[] internal_test_rstringlist(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rstringlist: handle is closed");
        }
        return this._internal_test_rstringlist(this.g, string);
    }

    private native String[] _internal_test_rstringlist(long var1, String var3) throws LibGuestFSException;

    public String[] internal_test_rstringlisterr() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rstringlisterr: handle is closed");
        }
        return this._internal_test_rstringlisterr(this.g);
    }

    private native String[] _internal_test_rstringlisterr(long var1) throws LibGuestFSException;

    public PV internal_test_rstruct(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rstruct: handle is closed");
        }
        return this._internal_test_rstruct(this.g, string);
    }

    private native PV _internal_test_rstruct(long var1, String var3) throws LibGuestFSException;

    public PV internal_test_rstructerr() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rstructerr: handle is closed");
        }
        return this._internal_test_rstructerr(this.g);
    }

    private native PV _internal_test_rstructerr(long var1) throws LibGuestFSException;

    public PV[] internal_test_rstructlist(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rstructlist: handle is closed");
        }
        return this._internal_test_rstructlist(this.g, string);
    }

    private native PV[] _internal_test_rstructlist(long var1, String var3) throws LibGuestFSException;

    public PV[] internal_test_rstructlisterr() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_rstructlisterr: handle is closed");
        }
        return this._internal_test_rstructlisterr(this.g);
    }

    private native PV[] _internal_test_rstructlisterr(long var1) throws LibGuestFSException;

    public void internal_test_set_output(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("internal_test_set_output: handle is closed");
        }
        this._internal_test_set_output(this.g, string);
    }

    private native void _internal_test_set_output(long var1, String var3) throws LibGuestFSException;

    public boolean is_blockdev(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_blockdev: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("followsymlinks");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        return this._is_blockdev(this.g, string, l, bl);
    }

    public boolean is_blockdev(String string) throws LibGuestFSException {
        return this.is_blockdev(string, null);
    }

    public boolean is_blockdev_opts(String string, Map<String, Object> map) throws LibGuestFSException {
        return this.is_blockdev(string, map);
    }

    public boolean is_blockdev_opts(String string) throws LibGuestFSException {
        return this.is_blockdev(string, null);
    }

    private native boolean _is_blockdev(long var1, String var3, long var4, boolean var6) throws LibGuestFSException;

    public boolean is_busy() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_busy: handle is closed");
        }
        return this._is_busy(this.g);
    }

    private native boolean _is_busy(long var1) throws LibGuestFSException;

    public boolean is_chardev(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_chardev: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("followsymlinks");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        return this._is_chardev(this.g, string, l, bl);
    }

    public boolean is_chardev(String string) throws LibGuestFSException {
        return this.is_chardev(string, null);
    }

    public boolean is_chardev_opts(String string, Map<String, Object> map) throws LibGuestFSException {
        return this.is_chardev(string, map);
    }

    public boolean is_chardev_opts(String string) throws LibGuestFSException {
        return this.is_chardev(string, null);
    }

    private native boolean _is_chardev(long var1, String var3, long var4, boolean var6) throws LibGuestFSException;

    public boolean is_config() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_config: handle is closed");
        }
        return this._is_config(this.g);
    }

    private native boolean _is_config(long var1) throws LibGuestFSException;

    public boolean is_dir(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_dir: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("followsymlinks");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        return this._is_dir(this.g, string, l, bl);
    }

    public boolean is_dir(String string) throws LibGuestFSException {
        return this.is_dir(string, null);
    }

    public boolean is_dir_opts(String string, Map<String, Object> map) throws LibGuestFSException {
        return this.is_dir(string, map);
    }

    public boolean is_dir_opts(String string) throws LibGuestFSException {
        return this.is_dir(string, null);
    }

    private native boolean _is_dir(long var1, String var3, long var4, boolean var6) throws LibGuestFSException;

    public boolean is_fifo(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_fifo: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("followsymlinks");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        return this._is_fifo(this.g, string, l, bl);
    }

    public boolean is_fifo(String string) throws LibGuestFSException {
        return this.is_fifo(string, null);
    }

    public boolean is_fifo_opts(String string, Map<String, Object> map) throws LibGuestFSException {
        return this.is_fifo(string, map);
    }

    public boolean is_fifo_opts(String string) throws LibGuestFSException {
        return this.is_fifo(string, null);
    }

    private native boolean _is_fifo(long var1, String var3, long var4, boolean var6) throws LibGuestFSException;

    public boolean is_file(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_file: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("followsymlinks");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        return this._is_file(this.g, string, l, bl);
    }

    public boolean is_file(String string) throws LibGuestFSException {
        return this.is_file(string, null);
    }

    public boolean is_file_opts(String string, Map<String, Object> map) throws LibGuestFSException {
        return this.is_file(string, map);
    }

    public boolean is_file_opts(String string) throws LibGuestFSException {
        return this.is_file(string, null);
    }

    private native boolean _is_file(long var1, String var3, long var4, boolean var6) throws LibGuestFSException;

    public boolean is_launching() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_launching: handle is closed");
        }
        return this._is_launching(this.g);
    }

    private native boolean _is_launching(long var1) throws LibGuestFSException;

    public boolean is_lv(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_lv: handle is closed");
        }
        return this._is_lv(this.g, string);
    }

    private native boolean _is_lv(long var1, String var3) throws LibGuestFSException;

    public boolean is_ready() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_ready: handle is closed");
        }
        return this._is_ready(this.g);
    }

    private native boolean _is_ready(long var1) throws LibGuestFSException;

    public boolean is_socket(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_socket: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("followsymlinks");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        return this._is_socket(this.g, string, l, bl);
    }

    public boolean is_socket(String string) throws LibGuestFSException {
        return this.is_socket(string, null);
    }

    public boolean is_socket_opts(String string, Map<String, Object> map) throws LibGuestFSException {
        return this.is_socket(string, map);
    }

    public boolean is_socket_opts(String string) throws LibGuestFSException {
        return this.is_socket(string, null);
    }

    private native boolean _is_socket(long var1, String var3, long var4, boolean var6) throws LibGuestFSException;

    public boolean is_symlink(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_symlink: handle is closed");
        }
        return this._is_symlink(this.g, string);
    }

    private native boolean _is_symlink(long var1, String var3) throws LibGuestFSException;

    public boolean is_whole_device(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_whole_device: handle is closed");
        }
        return this._is_whole_device(this.g, string);
    }

    private native boolean _is_whole_device(long var1, String var3) throws LibGuestFSException;

    public boolean is_zero(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_zero: handle is closed");
        }
        return this._is_zero(this.g, string);
    }

    private native boolean _is_zero(long var1, String var3) throws LibGuestFSException;

    public boolean is_zero_device(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("is_zero_device: handle is closed");
        }
        return this._is_zero_device(this.g, string);
    }

    private native boolean _is_zero_device(long var1, String var3) throws LibGuestFSException;

    public ISOInfo isoinfo(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("isoinfo: handle is closed");
        }
        return this._isoinfo(this.g, string);
    }

    private native ISOInfo _isoinfo(long var1, String var3) throws LibGuestFSException;

    public ISOInfo isoinfo_device(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("isoinfo_device: handle is closed");
        }
        return this._isoinfo_device(this.g, string);
    }

    private native ISOInfo _isoinfo_device(long var1, String var3) throws LibGuestFSException;

    public void journal_close() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("journal_close: handle is closed");
        }
        this._journal_close(this.g);
    }

    private native void _journal_close(long var1) throws LibGuestFSException;

    public XAttr[] journal_get() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("journal_get: handle is closed");
        }
        return this._journal_get(this.g);
    }

    private native XAttr[] _journal_get(long var1) throws LibGuestFSException;

    public long journal_get_data_threshold() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("journal_get_data_threshold: handle is closed");
        }
        return this._journal_get_data_threshold(this.g);
    }

    private native long _journal_get_data_threshold(long var1) throws LibGuestFSException;

    public long journal_get_realtime_usec() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("journal_get_realtime_usec: handle is closed");
        }
        return this._journal_get_realtime_usec(this.g);
    }

    private native long _journal_get_realtime_usec(long var1) throws LibGuestFSException;

    public boolean journal_next() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("journal_next: handle is closed");
        }
        return this._journal_next(this.g);
    }

    private native boolean _journal_next(long var1) throws LibGuestFSException;

    public void journal_open(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("journal_open: handle is closed");
        }
        this._journal_open(this.g, string);
    }

    private native void _journal_open(long var1, String var3) throws LibGuestFSException;

    public void journal_set_data_threshold(long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("journal_set_data_threshold: handle is closed");
        }
        this._journal_set_data_threshold(this.g, l);
    }

    private native void _journal_set_data_threshold(long var1, long var3) throws LibGuestFSException;

    public long journal_skip(long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("journal_skip: handle is closed");
        }
        return this._journal_skip(this.g, l);
    }

    private native long _journal_skip(long var1, long var3) throws LibGuestFSException;

    @Deprecated
    public void kill_subprocess() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("kill_subprocess: handle is closed");
        }
        this._kill_subprocess(this.g);
    }

    private native void _kill_subprocess(long var1) throws LibGuestFSException;

    public void launch() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("launch: handle is closed");
        }
        this._launch(this.g);
    }

    private native void _launch(long var1) throws LibGuestFSException;

    public void lchown(int n, int n2, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lchown: handle is closed");
        }
        this._lchown(this.g, n, n2, string);
    }

    private native void _lchown(long var1, int var3, int var4, String var5) throws LibGuestFSException;

    public void ldmtool_create_all() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ldmtool_create_all: handle is closed");
        }
        this._ldmtool_create_all(this.g);
    }

    private native void _ldmtool_create_all(long var1) throws LibGuestFSException;

    public String[] ldmtool_diskgroup_disks(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ldmtool_diskgroup_disks: handle is closed");
        }
        return this._ldmtool_diskgroup_disks(this.g, string);
    }

    private native String[] _ldmtool_diskgroup_disks(long var1, String var3) throws LibGuestFSException;

    public String ldmtool_diskgroup_name(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ldmtool_diskgroup_name: handle is closed");
        }
        return this._ldmtool_diskgroup_name(this.g, string);
    }

    private native String _ldmtool_diskgroup_name(long var1, String var3) throws LibGuestFSException;

    public String[] ldmtool_diskgroup_volumes(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ldmtool_diskgroup_volumes: handle is closed");
        }
        return this._ldmtool_diskgroup_volumes(this.g, string);
    }

    private native String[] _ldmtool_diskgroup_volumes(long var1, String var3) throws LibGuestFSException;

    public void ldmtool_remove_all() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ldmtool_remove_all: handle is closed");
        }
        this._ldmtool_remove_all(this.g);
    }

    private native void _ldmtool_remove_all(long var1) throws LibGuestFSException;

    public String[] ldmtool_scan() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ldmtool_scan: handle is closed");
        }
        return this._ldmtool_scan(this.g);
    }

    private native String[] _ldmtool_scan(long var1) throws LibGuestFSException;

    public String[] ldmtool_scan_devices(String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ldmtool_scan_devices: handle is closed");
        }
        return this._ldmtool_scan_devices(this.g, stringArray);
    }

    private native String[] _ldmtool_scan_devices(long var1, String[] var3) throws LibGuestFSException;

    public String ldmtool_volume_hint(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ldmtool_volume_hint: handle is closed");
        }
        return this._ldmtool_volume_hint(this.g, string, string2);
    }

    private native String _ldmtool_volume_hint(long var1, String var3, String var4) throws LibGuestFSException;

    public String[] ldmtool_volume_partitions(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ldmtool_volume_partitions: handle is closed");
        }
        return this._ldmtool_volume_partitions(this.g, string, string2);
    }

    private native String[] _ldmtool_volume_partitions(long var1, String var3, String var4) throws LibGuestFSException;

    public String ldmtool_volume_type(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ldmtool_volume_type: handle is closed");
        }
        return this._ldmtool_volume_type(this.g, string, string2);
    }

    private native String _ldmtool_volume_type(long var1, String var3, String var4) throws LibGuestFSException;

    public String lgetxattr(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lgetxattr: handle is closed");
        }
        return this._lgetxattr(this.g, string, string2);
    }

    private native String _lgetxattr(long var1, String var3, String var4) throws LibGuestFSException;

    public XAttr[] lgetxattrs(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lgetxattrs: handle is closed");
        }
        return this._lgetxattrs(this.g, string);
    }

    private native XAttr[] _lgetxattrs(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public String[] list_9p() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("list_9p: handle is closed");
        }
        return this._list_9p(this.g);
    }

    private native String[] _list_9p(long var1) throws LibGuestFSException;

    public String[] list_devices() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("list_devices: handle is closed");
        }
        return this._list_devices(this.g);
    }

    private native String[] _list_devices(long var1) throws LibGuestFSException;

    public Map<String, String> list_disk_labels() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("list_disk_labels: handle is closed");
        }
        String[] stringArray = this._list_disk_labels(this.g);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return hashMap;
    }

    private native String[] _list_disk_labels(long var1) throws LibGuestFSException;

    public String[] list_dm_devices() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("list_dm_devices: handle is closed");
        }
        return this._list_dm_devices(this.g);
    }

    private native String[] _list_dm_devices(long var1) throws LibGuestFSException;

    public Map<String, String> list_filesystems() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("list_filesystems: handle is closed");
        }
        String[] stringArray = this._list_filesystems(this.g);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return hashMap;
    }

    private native String[] _list_filesystems(long var1) throws LibGuestFSException;

    public String[] list_ldm_partitions() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("list_ldm_partitions: handle is closed");
        }
        return this._list_ldm_partitions(this.g);
    }

    private native String[] _list_ldm_partitions(long var1) throws LibGuestFSException;

    public String[] list_ldm_volumes() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("list_ldm_volumes: handle is closed");
        }
        return this._list_ldm_volumes(this.g);
    }

    private native String[] _list_ldm_volumes(long var1) throws LibGuestFSException;

    public String[] list_md_devices() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("list_md_devices: handle is closed");
        }
        return this._list_md_devices(this.g);
    }

    private native String[] _list_md_devices(long var1) throws LibGuestFSException;

    public String[] list_partitions() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("list_partitions: handle is closed");
        }
        return this._list_partitions(this.g);
    }

    private native String[] _list_partitions(long var1) throws LibGuestFSException;

    public String ll(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ll: handle is closed");
        }
        return this._ll(this.g, string);
    }

    private native String _ll(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public String llz(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("llz: handle is closed");
        }
        return this._llz(this.g, string);
    }

    private native String _llz(long var1, String var3) throws LibGuestFSException;

    public void ln(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ln: handle is closed");
        }
        this._ln(this.g, string, string2);
    }

    private native void _ln(long var1, String var3, String var4) throws LibGuestFSException;

    public void ln_f(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ln_f: handle is closed");
        }
        this._ln_f(this.g, string, string2);
    }

    private native void _ln_f(long var1, String var3, String var4) throws LibGuestFSException;

    public void ln_s(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ln_s: handle is closed");
        }
        this._ln_s(this.g, string, string2);
    }

    private native void _ln_s(long var1, String var3, String var4) throws LibGuestFSException;

    public void ln_sf(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ln_sf: handle is closed");
        }
        this._ln_sf(this.g, string, string2);
    }

    private native void _ln_sf(long var1, String var3, String var4) throws LibGuestFSException;

    public void lremovexattr(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lremovexattr: handle is closed");
        }
        this._lremovexattr(this.g, string, string2);
    }

    private native void _lremovexattr(long var1, String var3, String var4) throws LibGuestFSException;

    public String[] ls(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ls: handle is closed");
        }
        return this._ls(this.g, string);
    }

    private native String[] _ls(long var1, String var3) throws LibGuestFSException;

    public void ls0(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ls0: handle is closed");
        }
        this._ls0(this.g, string, string2);
    }

    private native void _ls0(long var1, String var3, String var4) throws LibGuestFSException;

    public void lsetxattr(String string, String string2, int n, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lsetxattr: handle is closed");
        }
        this._lsetxattr(this.g, string, string2, n, string3);
    }

    private native void _lsetxattr(long var1, String var3, String var4, int var5, String var6) throws LibGuestFSException;

    @Deprecated
    public Stat lstat(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lstat: handle is closed");
        }
        return this._lstat(this.g, string);
    }

    private native Stat _lstat(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public Stat[] lstatlist(String string, String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lstatlist: handle is closed");
        }
        return this._lstatlist(this.g, string, stringArray);
    }

    private native Stat[] _lstatlist(long var1, String var3, String[] var4) throws LibGuestFSException;

    public StatNS lstatns(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lstatns: handle is closed");
        }
        return this._lstatns(this.g, string);
    }

    private native StatNS _lstatns(long var1, String var3) throws LibGuestFSException;

    public StatNS[] lstatnslist(String string, String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lstatnslist: handle is closed");
        }
        return this._lstatnslist(this.g, string, stringArray);
    }

    private native StatNS[] _lstatnslist(long var1, String var3, String[] var4) throws LibGuestFSException;

    public void luks_add_key(String string, String string2, String string3, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("luks_add_key: handle is closed");
        }
        this._luks_add_key(this.g, string, string2, string3, n);
    }

    private native void _luks_add_key(long var1, String var3, String var4, String var5, int var6) throws LibGuestFSException;

    @Deprecated
    public void luks_close(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("luks_close: handle is closed");
        }
        this._luks_close(this.g, string);
    }

    private native void _luks_close(long var1, String var3) throws LibGuestFSException;

    public void luks_format(String string, String string2, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("luks_format: handle is closed");
        }
        this._luks_format(this.g, string, string2, n);
    }

    private native void _luks_format(long var1, String var3, String var4, int var5) throws LibGuestFSException;

    public void luks_format_cipher(String string, String string2, int n, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("luks_format_cipher: handle is closed");
        }
        this._luks_format_cipher(this.g, string, string2, n, string3);
    }

    private native void _luks_format_cipher(long var1, String var3, String var4, int var5, String var6) throws LibGuestFSException;

    public void luks_kill_slot(String string, String string2, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("luks_kill_slot: handle is closed");
        }
        this._luks_kill_slot(this.g, string, string2, n);
    }

    private native void _luks_kill_slot(long var1, String var3, String var4, int var5) throws LibGuestFSException;

    @Deprecated
    public void luks_open(String string, String string2, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("luks_open: handle is closed");
        }
        this._luks_open(this.g, string, string2, string3);
    }

    private native void _luks_open(long var1, String var3, String var4, String var5) throws LibGuestFSException;

    @Deprecated
    public void luks_open_ro(String string, String string2, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("luks_open_ro: handle is closed");
        }
        this._luks_open_ro(this.g, string, string2, string3);
    }

    private native void _luks_open_ro(long var1, String var3, String var4, String var5) throws LibGuestFSException;

    public String luks_uuid(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("luks_uuid: handle is closed");
        }
        return this._luks_uuid(this.g, string);
    }

    private native String _luks_uuid(long var1, String var3) throws LibGuestFSException;

    public void lvcreate(String string, String string2, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvcreate: handle is closed");
        }
        this._lvcreate(this.g, string, string2, n);
    }

    private native void _lvcreate(long var1, String var3, String var4, int var5) throws LibGuestFSException;

    public void lvcreate_free(String string, String string2, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvcreate_free: handle is closed");
        }
        this._lvcreate_free(this.g, string, string2, n);
    }

    private native void _lvcreate_free(long var1, String var3, String var4, int var5) throws LibGuestFSException;

    public String lvm_canonical_lv_name(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvm_canonical_lv_name: handle is closed");
        }
        return this._lvm_canonical_lv_name(this.g, string);
    }

    private native String _lvm_canonical_lv_name(long var1, String var3) throws LibGuestFSException;

    public void lvm_clear_filter() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvm_clear_filter: handle is closed");
        }
        this._lvm_clear_filter(this.g);
    }

    private native void _lvm_clear_filter(long var1) throws LibGuestFSException;

    public void lvm_remove_all() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvm_remove_all: handle is closed");
        }
        this._lvm_remove_all(this.g);
    }

    private native void _lvm_remove_all(long var1) throws LibGuestFSException;

    public void lvm_scan(boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvm_scan: handle is closed");
        }
        this._lvm_scan(this.g, bl);
    }

    private native void _lvm_scan(long var1, boolean var3) throws LibGuestFSException;

    public void lvm_set_filter(String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvm_set_filter: handle is closed");
        }
        this._lvm_set_filter(this.g, stringArray);
    }

    private native void _lvm_set_filter(long var1, String[] var3) throws LibGuestFSException;

    public void lvremove(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvremove: handle is closed");
        }
        this._lvremove(this.g, string);
    }

    private native void _lvremove(long var1, String var3) throws LibGuestFSException;

    public void lvrename(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvrename: handle is closed");
        }
        this._lvrename(this.g, string, string2);
    }

    private native void _lvrename(long var1, String var3, String var4) throws LibGuestFSException;

    public void lvresize(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvresize: handle is closed");
        }
        this._lvresize(this.g, string, n);
    }

    private native void _lvresize(long var1, String var3, int var4) throws LibGuestFSException;

    public void lvresize_free(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvresize_free: handle is closed");
        }
        this._lvresize_free(this.g, string, n);
    }

    private native void _lvresize_free(long var1, String var3, int var4) throws LibGuestFSException;

    public String[] lvs() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvs: handle is closed");
        }
        return this._lvs(this.g);
    }

    private native String[] _lvs(long var1) throws LibGuestFSException;

    public LV[] lvs_full() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvs_full: handle is closed");
        }
        return this._lvs_full(this.g);
    }

    private native LV[] _lvs_full(long var1) throws LibGuestFSException;

    public String lvuuid(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lvuuid: handle is closed");
        }
        return this._lvuuid(this.g, string);
    }

    private native String _lvuuid(long var1, String var3) throws LibGuestFSException;

    public XAttr[] lxattrlist(String string, String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("lxattrlist: handle is closed");
        }
        return this._lxattrlist(this.g, string, stringArray);
    }

    private native XAttr[] _lxattrlist(long var1, String var3, String[] var4) throws LibGuestFSException;

    public int max_disks() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("max_disks: handle is closed");
        }
        return this._max_disks(this.g);
    }

    private native int _max_disks(long var1) throws LibGuestFSException;

    public void md_create(String string, String[] stringArray, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("md_create: handle is closed");
        }
        long l = 0L;
        long l2 = 0L;
        Object object = null;
        if (map != null) {
            object = map.get("missingbitmap");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 1L;
        }
        int n = 0;
        object = null;
        if (map != null) {
            object = map.get("nrdevices");
        }
        if (object != null) {
            n = (Integer)object;
            l |= 2L;
        }
        int n2 = 0;
        object = null;
        if (map != null) {
            object = map.get("spare");
        }
        if (object != null) {
            n2 = (Integer)object;
            l |= 4L;
        }
        long l3 = 0L;
        object = null;
        if (map != null) {
            object = map.get("chunk");
        }
        if (object != null) {
            l3 = (Long)object;
            l |= 8L;
        }
        String string2 = "";
        object = null;
        if (map != null) {
            object = map.get("level");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 0x10L;
        }
        this._md_create(this.g, string, stringArray, l, l2, n, n2, l3, string2);
    }

    public void md_create(String string, String[] stringArray) throws LibGuestFSException {
        this.md_create(string, stringArray, null);
    }

    private native void _md_create(long var1, String var3, String[] var4, long var5, long var7, int var9, int var10, long var11, String var13) throws LibGuestFSException;

    public Map<String, String> md_detail(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("md_detail: handle is closed");
        }
        String[] stringArray = this._md_detail(this.g, string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return hashMap;
    }

    private native String[] _md_detail(long var1, String var3) throws LibGuestFSException;

    public MDStat[] md_stat(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("md_stat: handle is closed");
        }
        return this._md_stat(this.g, string);
    }

    private native MDStat[] _md_stat(long var1, String var3) throws LibGuestFSException;

    public void md_stop(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("md_stop: handle is closed");
        }
        this._md_stop(this.g, string);
    }

    private native void _md_stop(long var1, String var3) throws LibGuestFSException;

    public void mkdir(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mkdir: handle is closed");
        }
        this._mkdir(this.g, string);
    }

    private native void _mkdir(long var1, String var3) throws LibGuestFSException;

    public void mkdir_mode(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mkdir_mode: handle is closed");
        }
        this._mkdir_mode(this.g, string, n);
    }

    private native void _mkdir_mode(long var1, String var3, int var4) throws LibGuestFSException;

    public void mkdir_p(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mkdir_p: handle is closed");
        }
        this._mkdir_p(this.g, string);
    }

    private native void _mkdir_p(long var1, String var3) throws LibGuestFSException;

    public String mkdtemp(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mkdtemp: handle is closed");
        }
        return this._mkdtemp(this.g, string);
    }

    private native String _mkdtemp(long var1, String var3) throws LibGuestFSException;

    public void mke2fs(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mke2fs: handle is closed");
        }
        long l = 0L;
        long l2 = 0L;
        Object object = null;
        if (map != null) {
            object = map.get("blockscount");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 1L;
        }
        long l3 = 0L;
        object = null;
        if (map != null) {
            object = map.get("blocksize");
        }
        if (object != null) {
            l3 = (Long)object;
            l |= 2L;
        }
        long l4 = 0L;
        object = null;
        if (map != null) {
            object = map.get("fragsize");
        }
        if (object != null) {
            l4 = (Long)object;
            l |= 4L;
        }
        long l5 = 0L;
        object = null;
        if (map != null) {
            object = map.get("blockspergroup");
        }
        if (object != null) {
            l5 = (Long)object;
            l |= 8L;
        }
        long l6 = 0L;
        object = null;
        if (map != null) {
            object = map.get("numberofgroups");
        }
        if (object != null) {
            l6 = (Long)object;
            l |= 0x10L;
        }
        long l7 = 0L;
        object = null;
        if (map != null) {
            object = map.get("bytesperinode");
        }
        if (object != null) {
            l7 = (Long)object;
            l |= 0x20L;
        }
        long l8 = 0L;
        object = null;
        if (map != null) {
            object = map.get("inodesize");
        }
        if (object != null) {
            l8 = (Long)object;
            l |= 0x40L;
        }
        long l9 = 0L;
        object = null;
        if (map != null) {
            object = map.get("journalsize");
        }
        if (object != null) {
            l9 = (Long)object;
            l |= 0x80L;
        }
        long l10 = 0L;
        object = null;
        if (map != null) {
            object = map.get("numberofinodes");
        }
        if (object != null) {
            l10 = (Long)object;
            l |= 0x100L;
        }
        long l11 = 0L;
        object = null;
        if (map != null) {
            object = map.get("stridesize");
        }
        if (object != null) {
            l11 = (Long)object;
            l |= 0x200L;
        }
        long l12 = 0L;
        object = null;
        if (map != null) {
            object = map.get("stripewidth");
        }
        if (object != null) {
            l12 = (Long)object;
            l |= 0x400L;
        }
        long l13 = 0L;
        object = null;
        if (map != null) {
            object = map.get("maxonlineresize");
        }
        if (object != null) {
            l13 = (Long)object;
            l |= 0x800L;
        }
        int n = 0;
        object = null;
        if (map != null) {
            object = map.get("reservedblockspercentage");
        }
        if (object != null) {
            n = (Integer)object;
            l |= 0x1000L;
        }
        int n2 = 0;
        object = null;
        if (map != null) {
            object = map.get("mmpupdateinterval");
        }
        if (object != null) {
            n2 = (Integer)object;
            l |= 0x2000L;
        }
        String string2 = "";
        object = null;
        if (map != null) {
            object = map.get("journaldevice");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 0x4000L;
        }
        String string3 = "";
        object = null;
        if (map != null) {
            object = map.get("label");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 0x8000L;
        }
        String string4 = "";
        object = null;
        if (map != null) {
            object = map.get("lastmounteddir");
        }
        if (object != null) {
            string4 = (String)object;
            l |= 0x10000L;
        }
        String string5 = "";
        object = null;
        if (map != null) {
            object = map.get("creatoros");
        }
        if (object != null) {
            string5 = (String)object;
            l |= 0x20000L;
        }
        String string6 = "";
        object = null;
        if (map != null) {
            object = map.get("fstype");
        }
        if (object != null) {
            string6 = (String)object;
            l |= 0x40000L;
        }
        String string7 = "";
        object = null;
        if (map != null) {
            object = map.get("usagetype");
        }
        if (object != null) {
            string7 = (String)object;
            l |= 0x80000L;
        }
        String string8 = "";
        object = null;
        if (map != null) {
            object = map.get("uuid");
        }
        if (object != null) {
            string8 = (String)object;
            l |= 0x100000L;
        }
        boolean bl = false;
        object = null;
        if (map != null) {
            object = map.get("forcecreate");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 0x200000L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("writesbandgrouponly");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 0x400000L;
        }
        boolean bl3 = false;
        object = null;
        if (map != null) {
            object = map.get("lazyitableinit");
        }
        if (object != null) {
            bl3 = (Boolean)object;
            l |= 0x800000L;
        }
        boolean bl4 = false;
        object = null;
        if (map != null) {
            object = map.get("lazyjournalinit");
        }
        if (object != null) {
            bl4 = (Boolean)object;
            l |= 0x1000000L;
        }
        boolean bl5 = false;
        object = null;
        if (map != null) {
            object = map.get("testfs");
        }
        if (object != null) {
            bl5 = (Boolean)object;
            l |= 0x2000000L;
        }
        boolean bl6 = false;
        object = null;
        if (map != null) {
            object = map.get("discard");
        }
        if (object != null) {
            bl6 = (Boolean)object;
            l |= 0x4000000L;
        }
        boolean bl7 = false;
        object = null;
        if (map != null) {
            object = map.get("quotatype");
        }
        if (object != null) {
            bl7 = (Boolean)object;
            l |= 0x8000000L;
        }
        boolean bl8 = false;
        object = null;
        if (map != null) {
            object = map.get("extent");
        }
        if (object != null) {
            bl8 = (Boolean)object;
            l |= 0x10000000L;
        }
        boolean bl9 = false;
        object = null;
        if (map != null) {
            object = map.get("filetype");
        }
        if (object != null) {
            bl9 = (Boolean)object;
            l |= 0x20000000L;
        }
        boolean bl10 = false;
        object = null;
        if (map != null) {
            object = map.get("flexbg");
        }
        if (object != null) {
            bl10 = (Boolean)object;
            l |= 0x40000000L;
        }
        boolean bl11 = false;
        object = null;
        if (map != null) {
            object = map.get("hasjournal");
        }
        if (object != null) {
            bl11 = (Boolean)object;
            l |= 0x80000000L;
        }
        boolean bl12 = false;
        object = null;
        if (map != null) {
            object = map.get("journaldev");
        }
        if (object != null) {
            bl12 = (Boolean)object;
            l |= 0x100000000L;
        }
        boolean bl13 = false;
        object = null;
        if (map != null) {
            object = map.get("largefile");
        }
        if (object != null) {
            bl13 = (Boolean)object;
            l |= 0x200000000L;
        }
        boolean bl14 = false;
        object = null;
        if (map != null) {
            object = map.get("quota");
        }
        if (object != null) {
            bl14 = (Boolean)object;
            l |= 0x400000000L;
        }
        boolean bl15 = false;
        object = null;
        if (map != null) {
            object = map.get("resizeinode");
        }
        if (object != null) {
            bl15 = (Boolean)object;
            l |= 0x800000000L;
        }
        boolean bl16 = false;
        object = null;
        if (map != null) {
            object = map.get("sparsesuper");
        }
        if (object != null) {
            bl16 = (Boolean)object;
            l |= 0x1000000000L;
        }
        boolean bl17 = false;
        object = null;
        if (map != null) {
            object = map.get("uninitbg");
        }
        if (object != null) {
            bl17 = (Boolean)object;
            l |= 0x2000000000L;
        }
        this._mke2fs(this.g, string, l, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12, l13, n, n2, string2, string3, string4, string5, string6, string7, string8, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, bl11, bl12, bl13, bl14, bl15, bl16, bl17);
    }

    public void mke2fs(String string) throws LibGuestFSException {
        this.mke2fs(string, null);
    }

    private native void _mke2fs(long var1, String var3, long var4, long var6, long var8, long var10, long var12, long var14, long var16, long var18, long var20, long var22, long var24, long var26, long var28, int var30, int var31, String var32, String var33, String var34, String var35, String var36, String var37, String var38, boolean var39, boolean var40, boolean var41, boolean var42, boolean var43, boolean var44, boolean var45, boolean var46, boolean var47, boolean var48, boolean var49, boolean var50, boolean var51, boolean var52, boolean var53, boolean var54, boolean var55) throws LibGuestFSException;

    @Deprecated
    public void mke2fs_J(String string, int n, String string2, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mke2fs_J: handle is closed");
        }
        this._mke2fs_J(this.g, string, n, string2, string3);
    }

    private native void _mke2fs_J(long var1, String var3, int var4, String var5, String var6) throws LibGuestFSException;

    @Deprecated
    public void mke2fs_JL(String string, int n, String string2, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mke2fs_JL: handle is closed");
        }
        this._mke2fs_JL(this.g, string, n, string2, string3);
    }

    private native void _mke2fs_JL(long var1, String var3, int var4, String var5, String var6) throws LibGuestFSException;

    @Deprecated
    public void mke2fs_JU(String string, int n, String string2, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mke2fs_JU: handle is closed");
        }
        this._mke2fs_JU(this.g, string, n, string2, string3);
    }

    private native void _mke2fs_JU(long var1, String var3, int var4, String var5, String var6) throws LibGuestFSException;

    @Deprecated
    public void mke2journal(int n, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mke2journal: handle is closed");
        }
        this._mke2journal(this.g, n, string);
    }

    private native void _mke2journal(long var1, int var3, String var4) throws LibGuestFSException;

    @Deprecated
    public void mke2journal_L(int n, String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mke2journal_L: handle is closed");
        }
        this._mke2journal_L(this.g, n, string, string2);
    }

    private native void _mke2journal_L(long var1, int var3, String var4, String var5) throws LibGuestFSException;

    @Deprecated
    public void mke2journal_U(int n, String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mke2journal_U: handle is closed");
        }
        this._mke2journal_U(this.g, n, string, string2);
    }

    private native void _mke2journal_U(long var1, int var3, String var4, String var5) throws LibGuestFSException;

    public void mkfifo(int n, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mkfifo: handle is closed");
        }
        this._mkfifo(this.g, n, string);
    }

    private native void _mkfifo(long var1, int var3, String var4) throws LibGuestFSException;

    public void mkfs(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mkfs: handle is closed");
        }
        long l = 0L;
        int n = 0;
        Object object = null;
        if (map != null) {
            object = map.get("blocksize");
        }
        if (object != null) {
            n = (Integer)object;
            l |= 1L;
        }
        String string3 = "";
        object = null;
        if (map != null) {
            object = map.get("features");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 2L;
        }
        int n2 = 0;
        object = null;
        if (map != null) {
            object = map.get("inode");
        }
        if (object != null) {
            n2 = (Integer)object;
            l |= 4L;
        }
        int n3 = 0;
        object = null;
        if (map != null) {
            object = map.get("sectorsize");
        }
        if (object != null) {
            n3 = (Integer)object;
            l |= 8L;
        }
        String string4 = "";
        object = null;
        if (map != null) {
            object = map.get("label");
        }
        if (object != null) {
            string4 = (String)object;
            l |= 0x10L;
        }
        this._mkfs(this.g, string, string2, l, n, string3, n2, n3, string4);
    }

    public void mkfs(String string, String string2) throws LibGuestFSException {
        this.mkfs(string, string2, null);
    }

    public void mkfs_opts(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        this.mkfs(string, string2, map);
    }

    public void mkfs_opts(String string, String string2) throws LibGuestFSException {
        this.mkfs(string, string2, null);
    }

    private native void _mkfs(long var1, String var3, String var4, long var5, int var7, String var8, int var9, int var10, String var11) throws LibGuestFSException;

    @Deprecated
    public void mkfs_b(String string, int n, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mkfs_b: handle is closed");
        }
        this._mkfs_b(this.g, string, n, string2);
    }

    private native void _mkfs_b(long var1, String var3, int var4, String var5) throws LibGuestFSException;

    public void mkfs_btrfs(String[] stringArray, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mkfs_btrfs: handle is closed");
        }
        long l = 0L;
        long l2 = 0L;
        Object object = null;
        if (map != null) {
            object = map.get("allocstart");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 1L;
        }
        long l3 = 0L;
        object = null;
        if (map != null) {
            object = map.get("bytecount");
        }
        if (object != null) {
            l3 = (Long)object;
            l |= 2L;
        }
        String string = "";
        object = null;
        if (map != null) {
            object = map.get("datatype");
        }
        if (object != null) {
            string = (String)object;
            l |= 4L;
        }
        int n = 0;
        object = null;
        if (map != null) {
            object = map.get("leafsize");
        }
        if (object != null) {
            n = (Integer)object;
            l |= 8L;
        }
        String string2 = "";
        object = null;
        if (map != null) {
            object = map.get("label");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 0x10L;
        }
        String string3 = "";
        object = null;
        if (map != null) {
            object = map.get("metadata");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 0x20L;
        }
        int n2 = 0;
        object = null;
        if (map != null) {
            object = map.get("nodesize");
        }
        if (object != null) {
            n2 = (Integer)object;
            l |= 0x40L;
        }
        int n3 = 0;
        object = null;
        if (map != null) {
            object = map.get("sectorsize");
        }
        if (object != null) {
            n3 = (Integer)object;
            l |= 0x80L;
        }
        this._mkfs_btrfs(this.g, stringArray, l, l2, l3, string, n, string2, string3, n2, n3);
    }

    public void mkfs_btrfs(String[] stringArray) throws LibGuestFSException {
        this.mkfs_btrfs(stringArray, null);
    }

    private native void _mkfs_btrfs(long var1, String[] var3, long var4, long var6, long var8, String var10, int var11, String var12, String var13, int var14, int var15) throws LibGuestFSException;

    public void mklost_and_found(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mklost_and_found: handle is closed");
        }
        this._mklost_and_found(this.g, string);
    }

    private native void _mklost_and_found(long var1, String var3) throws LibGuestFSException;

    public void mkmountpoint(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mkmountpoint: handle is closed");
        }
        this._mkmountpoint(this.g, string);
    }

    private native void _mkmountpoint(long var1, String var3) throws LibGuestFSException;

    public void mknod(int n, int n2, int n3, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mknod: handle is closed");
        }
        this._mknod(this.g, n, n2, n3, string);
    }

    private native void _mknod(long var1, int var3, int var4, int var5, String var6) throws LibGuestFSException;

    public void mknod_b(int n, int n2, int n3, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mknod_b: handle is closed");
        }
        this._mknod_b(this.g, n, n2, n3, string);
    }

    private native void _mknod_b(long var1, int var3, int var4, int var5, String var6) throws LibGuestFSException;

    public void mknod_c(int n, int n2, int n3, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mknod_c: handle is closed");
        }
        this._mknod_c(this.g, n, n2, n3, string);
    }

    private native void _mknod_c(long var1, int var3, int var4, int var5, String var6) throws LibGuestFSException;

    public void mksquashfs(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mksquashfs: handle is closed");
        }
        long l = 0L;
        String string3 = "";
        Object object = null;
        if (map != null) {
            object = map.get("compress");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 1L;
        }
        String[] stringArray = new String[]{};
        object = null;
        if (map != null) {
            object = map.get("excludes");
        }
        if (object != null) {
            stringArray = (String[])object;
            l |= 2L;
        }
        this._mksquashfs(this.g, string, string2, l, string3, stringArray);
    }

    public void mksquashfs(String string, String string2) throws LibGuestFSException {
        this.mksquashfs(string, string2, null);
    }

    private native void _mksquashfs(long var1, String var3, String var4, long var5, String var7, String[] var8) throws LibGuestFSException;

    public void mkswap(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mkswap: handle is closed");
        }
        long l = 0L;
        String string2 = "";
        Object object = null;
        if (map != null) {
            object = map.get("label");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 1L;
        }
        String string3 = "";
        object = null;
        if (map != null) {
            object = map.get("uuid");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 2L;
        }
        this._mkswap(this.g, string, l, string2, string3);
    }

    public void mkswap(String string) throws LibGuestFSException {
        this.mkswap(string, null);
    }

    public void mkswap_opts(String string, Map<String, Object> map) throws LibGuestFSException {
        this.mkswap(string, map);
    }

    public void mkswap_opts(String string) throws LibGuestFSException {
        this.mkswap(string, null);
    }

    private native void _mkswap(long var1, String var3, long var4, String var6, String var7) throws LibGuestFSException;

    @Deprecated
    public void mkswap_L(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mkswap_L: handle is closed");
        }
        this._mkswap_L(this.g, string, string2);
    }

    private native void _mkswap_L(long var1, String var3, String var4) throws LibGuestFSException;

    @Deprecated
    public void mkswap_U(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mkswap_U: handle is closed");
        }
        this._mkswap_U(this.g, string, string2);
    }

    private native void _mkswap_U(long var1, String var3, String var4) throws LibGuestFSException;

    public void mkswap_file(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mkswap_file: handle is closed");
        }
        this._mkswap_file(this.g, string);
    }

    private native void _mkswap_file(long var1, String var3) throws LibGuestFSException;

    public String mktemp(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mktemp: handle is closed");
        }
        long l = 0L;
        String string2 = "";
        Object object = null;
        if (map != null) {
            object = map.get("suffix");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 1L;
        }
        return this._mktemp(this.g, string, l, string2);
    }

    public String mktemp(String string) throws LibGuestFSException {
        return this.mktemp(string, null);
    }

    private native String _mktemp(long var1, String var3, long var4, String var6) throws LibGuestFSException;

    public void modprobe(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("modprobe: handle is closed");
        }
        this._modprobe(this.g, string);
    }

    private native void _modprobe(long var1, String var3) throws LibGuestFSException;

    public void mount(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mount: handle is closed");
        }
        this._mount(this.g, string, string2);
    }

    private native void _mount(long var1, String var3, String var4) throws LibGuestFSException;

    @Deprecated
    public void mount_9p(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mount_9p: handle is closed");
        }
        long l = 0L;
        String string3 = "";
        Object object = null;
        if (map != null) {
            object = map.get("options");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 1L;
        }
        this._mount_9p(this.g, string, string2, l, string3);
    }

    public void mount_9p(String string, String string2) throws LibGuestFSException {
        this.mount_9p(string, string2, null);
    }

    private native void _mount_9p(long var1, String var3, String var4, long var5, String var7) throws LibGuestFSException;

    public void mount_local(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mount_local: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("readonly");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        String string2 = "";
        object = null;
        if (map != null) {
            object = map.get("options");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 2L;
        }
        int n = 0;
        object = null;
        if (map != null) {
            object = map.get("cachetimeout");
        }
        if (object != null) {
            n = (Integer)object;
            l |= 4L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("debugcalls");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 8L;
        }
        this._mount_local(this.g, string, l, bl, string2, n, bl2);
    }

    public void mount_local(String string) throws LibGuestFSException {
        this.mount_local(string, null);
    }

    private native void _mount_local(long var1, String var3, long var4, boolean var6, String var7, int var8, boolean var9) throws LibGuestFSException;

    public void mount_local_run() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mount_local_run: handle is closed");
        }
        this._mount_local_run(this.g);
    }

    private native void _mount_local_run(long var1) throws LibGuestFSException;

    public void mount_loop(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mount_loop: handle is closed");
        }
        this._mount_loop(this.g, string, string2);
    }

    private native void _mount_loop(long var1, String var3, String var4) throws LibGuestFSException;

    public void mount_options(String string, String string2, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mount_options: handle is closed");
        }
        this._mount_options(this.g, string, string2, string3);
    }

    private native void _mount_options(long var1, String var3, String var4, String var5) throws LibGuestFSException;

    public void mount_ro(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mount_ro: handle is closed");
        }
        this._mount_ro(this.g, string, string2);
    }

    private native void _mount_ro(long var1, String var3, String var4) throws LibGuestFSException;

    public void mount_vfs(String string, String string2, String string3, String string4) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mount_vfs: handle is closed");
        }
        this._mount_vfs(this.g, string, string2, string3, string4);
    }

    private native void _mount_vfs(long var1, String var3, String var4, String var5, String var6) throws LibGuestFSException;

    public String mountable_device(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mountable_device: handle is closed");
        }
        return this._mountable_device(this.g, string);
    }

    private native String _mountable_device(long var1, String var3) throws LibGuestFSException;

    public String mountable_subvolume(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mountable_subvolume: handle is closed");
        }
        return this._mountable_subvolume(this.g, string);
    }

    private native String _mountable_subvolume(long var1, String var3) throws LibGuestFSException;

    public Map<String, String> mountpoints() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mountpoints: handle is closed");
        }
        String[] stringArray = this._mountpoints(this.g);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return hashMap;
    }

    private native String[] _mountpoints(long var1) throws LibGuestFSException;

    public String[] mounts() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mounts: handle is closed");
        }
        return this._mounts(this.g);
    }

    private native String[] _mounts(long var1) throws LibGuestFSException;

    public void mv(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("mv: handle is closed");
        }
        this._mv(this.g, string, string2);
    }

    private native void _mv(long var1, String var3, String var4) throws LibGuestFSException;

    public int nr_devices() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("nr_devices: handle is closed");
        }
        return this._nr_devices(this.g);
    }

    private native int _nr_devices(long var1) throws LibGuestFSException;

    public int ntfs_3g_probe(boolean bl, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ntfs_3g_probe: handle is closed");
        }
        return this._ntfs_3g_probe(this.g, bl, string);
    }

    private native int _ntfs_3g_probe(long var1, boolean var3, String var4) throws LibGuestFSException;

    public void ntfscat_i(String string, long l, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ntfscat_i: handle is closed");
        }
        this._ntfscat_i(this.g, string, l, string2);
    }

    private native void _ntfscat_i(long var1, String var3, long var4, String var6) throws LibGuestFSException;

    public void ntfsclone_in(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ntfsclone_in: handle is closed");
        }
        this._ntfsclone_in(this.g, string, string2);
    }

    private native void _ntfsclone_in(long var1, String var3, String var4) throws LibGuestFSException;

    public void ntfsclone_out(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ntfsclone_out: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("metadataonly");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("rescue");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 2L;
        }
        boolean bl3 = false;
        object = null;
        if (map != null) {
            object = map.get("ignorefscheck");
        }
        if (object != null) {
            bl3 = (Boolean)object;
            l |= 4L;
        }
        boolean bl4 = false;
        object = null;
        if (map != null) {
            object = map.get("preservetimestamps");
        }
        if (object != null) {
            bl4 = (Boolean)object;
            l |= 8L;
        }
        boolean bl5 = false;
        object = null;
        if (map != null) {
            object = map.get("force");
        }
        if (object != null) {
            bl5 = (Boolean)object;
            l |= 0x10L;
        }
        this._ntfsclone_out(this.g, string, string2, l, bl, bl2, bl3, bl4, bl5);
    }

    public void ntfsclone_out(String string, String string2) throws LibGuestFSException {
        this.ntfsclone_out(string, string2, null);
    }

    private native void _ntfsclone_out(long var1, String var3, String var4, long var5, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11) throws LibGuestFSException;

    public void ntfsfix(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ntfsfix: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("clearbadsectors");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        this._ntfsfix(this.g, string, l, bl);
    }

    public void ntfsfix(String string) throws LibGuestFSException {
        this.ntfsfix(string, null);
    }

    private native void _ntfsfix(long var1, String var3, long var4, boolean var6) throws LibGuestFSException;

    public void ntfsresize(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ntfsresize: handle is closed");
        }
        long l = 0L;
        long l2 = 0L;
        Object object = null;
        if (map != null) {
            object = map.get("size");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 1L;
        }
        boolean bl = false;
        object = null;
        if (map != null) {
            object = map.get("force");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 2L;
        }
        this._ntfsresize(this.g, string, l, l2, bl);
    }

    public void ntfsresize(String string) throws LibGuestFSException {
        this.ntfsresize(string, null);
    }

    public void ntfsresize_opts(String string, Map<String, Object> map) throws LibGuestFSException {
        this.ntfsresize(string, map);
    }

    public void ntfsresize_opts(String string) throws LibGuestFSException {
        this.ntfsresize(string, null);
    }

    private native void _ntfsresize(long var1, String var3, long var4, long var6, boolean var8) throws LibGuestFSException;

    @Deprecated
    public void ntfsresize_size(String string, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ntfsresize_size: handle is closed");
        }
        this._ntfsresize_size(this.g, string, l);
    }

    private native void _ntfsresize_size(long var1, String var3, long var4) throws LibGuestFSException;

    public void parse_environment() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("parse_environment: handle is closed");
        }
        this._parse_environment(this.g);
    }

    private native void _parse_environment(long var1) throws LibGuestFSException;

    public void parse_environment_list(String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("parse_environment_list: handle is closed");
        }
        this._parse_environment_list(this.g, stringArray);
    }

    private native void _parse_environment_list(long var1, String[] var3) throws LibGuestFSException;

    public void part_add(String string, String string2, long l, long l2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_add: handle is closed");
        }
        this._part_add(this.g, string, string2, l, l2);
    }

    private native void _part_add(long var1, String var3, String var4, long var5, long var7) throws LibGuestFSException;

    public void part_del(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_del: handle is closed");
        }
        this._part_del(this.g, string, n);
    }

    private native void _part_del(long var1, String var3, int var4) throws LibGuestFSException;

    public void part_disk(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_disk: handle is closed");
        }
        this._part_disk(this.g, string, string2);
    }

    private native void _part_disk(long var1, String var3, String var4) throws LibGuestFSException;

    public void part_expand_gpt(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_expand_gpt: handle is closed");
        }
        this._part_expand_gpt(this.g, string);
    }

    private native void _part_expand_gpt(long var1, String var3) throws LibGuestFSException;

    public boolean part_get_bootable(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_get_bootable: handle is closed");
        }
        return this._part_get_bootable(this.g, string, n);
    }

    private native boolean _part_get_bootable(long var1, String var3, int var4) throws LibGuestFSException;

    public String part_get_disk_guid(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_get_disk_guid: handle is closed");
        }
        return this._part_get_disk_guid(this.g, string);
    }

    private native String _part_get_disk_guid(long var1, String var3) throws LibGuestFSException;

    public long part_get_gpt_attributes(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_get_gpt_attributes: handle is closed");
        }
        return this._part_get_gpt_attributes(this.g, string, n);
    }

    private native long _part_get_gpt_attributes(long var1, String var3, int var4) throws LibGuestFSException;

    public String part_get_gpt_guid(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_get_gpt_guid: handle is closed");
        }
        return this._part_get_gpt_guid(this.g, string, n);
    }

    private native String _part_get_gpt_guid(long var1, String var3, int var4) throws LibGuestFSException;

    public String part_get_gpt_type(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_get_gpt_type: handle is closed");
        }
        return this._part_get_gpt_type(this.g, string, n);
    }

    private native String _part_get_gpt_type(long var1, String var3, int var4) throws LibGuestFSException;

    public int part_get_mbr_id(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_get_mbr_id: handle is closed");
        }
        return this._part_get_mbr_id(this.g, string, n);
    }

    private native int _part_get_mbr_id(long var1, String var3, int var4) throws LibGuestFSException;

    public String part_get_mbr_part_type(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_get_mbr_part_type: handle is closed");
        }
        return this._part_get_mbr_part_type(this.g, string, n);
    }

    private native String _part_get_mbr_part_type(long var1, String var3, int var4) throws LibGuestFSException;

    public String part_get_name(String string, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_get_name: handle is closed");
        }
        return this._part_get_name(this.g, string, n);
    }

    private native String _part_get_name(long var1, String var3, int var4) throws LibGuestFSException;

    public String part_get_parttype(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_get_parttype: handle is closed");
        }
        return this._part_get_parttype(this.g, string);
    }

    private native String _part_get_parttype(long var1, String var3) throws LibGuestFSException;

    public void part_init(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_init: handle is closed");
        }
        this._part_init(this.g, string, string2);
    }

    private native void _part_init(long var1, String var3, String var4) throws LibGuestFSException;

    public Partition[] part_list(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_list: handle is closed");
        }
        return this._part_list(this.g, string);
    }

    private native Partition[] _part_list(long var1, String var3) throws LibGuestFSException;

    public void part_resize(String string, int n, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_resize: handle is closed");
        }
        this._part_resize(this.g, string, n, l);
    }

    private native void _part_resize(long var1, String var3, int var4, long var5) throws LibGuestFSException;

    public void part_set_bootable(String string, int n, boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_set_bootable: handle is closed");
        }
        this._part_set_bootable(this.g, string, n, bl);
    }

    private native void _part_set_bootable(long var1, String var3, int var4, boolean var5) throws LibGuestFSException;

    public void part_set_disk_guid(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_set_disk_guid: handle is closed");
        }
        this._part_set_disk_guid(this.g, string, string2);
    }

    private native void _part_set_disk_guid(long var1, String var3, String var4) throws LibGuestFSException;

    public void part_set_disk_guid_random(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_set_disk_guid_random: handle is closed");
        }
        this._part_set_disk_guid_random(this.g, string);
    }

    private native void _part_set_disk_guid_random(long var1, String var3) throws LibGuestFSException;

    public void part_set_gpt_attributes(String string, int n, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_set_gpt_attributes: handle is closed");
        }
        this._part_set_gpt_attributes(this.g, string, n, l);
    }

    private native void _part_set_gpt_attributes(long var1, String var3, int var4, long var5) throws LibGuestFSException;

    public void part_set_gpt_guid(String string, int n, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_set_gpt_guid: handle is closed");
        }
        this._part_set_gpt_guid(this.g, string, n, string2);
    }

    private native void _part_set_gpt_guid(long var1, String var3, int var4, String var5) throws LibGuestFSException;

    public void part_set_gpt_type(String string, int n, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_set_gpt_type: handle is closed");
        }
        this._part_set_gpt_type(this.g, string, n, string2);
    }

    private native void _part_set_gpt_type(long var1, String var3, int var4, String var5) throws LibGuestFSException;

    public void part_set_mbr_id(String string, int n, int n2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_set_mbr_id: handle is closed");
        }
        this._part_set_mbr_id(this.g, string, n, n2);
    }

    private native void _part_set_mbr_id(long var1, String var3, int var4, int var5) throws LibGuestFSException;

    public void part_set_name(String string, int n, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_set_name: handle is closed");
        }
        this._part_set_name(this.g, string, n, string2);
    }

    private native void _part_set_name(long var1, String var3, int var4, String var5) throws LibGuestFSException;

    public String part_to_dev(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_to_dev: handle is closed");
        }
        return this._part_to_dev(this.g, string);
    }

    private native String _part_to_dev(long var1, String var3) throws LibGuestFSException;

    public int part_to_partnum(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("part_to_partnum: handle is closed");
        }
        return this._part_to_partnum(this.g, string);
    }

    private native int _part_to_partnum(long var1, String var3) throws LibGuestFSException;

    public void ping_daemon() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("ping_daemon: handle is closed");
        }
        this._ping_daemon(this.g);
    }

    private native void _ping_daemon(long var1) throws LibGuestFSException;

    public String pread(String string, int n, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("pread: handle is closed");
        }
        return this._pread(this.g, string, n, l);
    }

    private native String _pread(long var1, String var3, int var4, long var5) throws LibGuestFSException;

    public String pread_device(String string, int n, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("pread_device: handle is closed");
        }
        return this._pread_device(this.g, string, n, l);
    }

    private native String _pread_device(long var1, String var3, int var4, long var5) throws LibGuestFSException;

    public void pvchange_uuid(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("pvchange_uuid: handle is closed");
        }
        this._pvchange_uuid(this.g, string);
    }

    private native void _pvchange_uuid(long var1, String var3) throws LibGuestFSException;

    public void pvchange_uuid_all() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("pvchange_uuid_all: handle is closed");
        }
        this._pvchange_uuid_all(this.g);
    }

    private native void _pvchange_uuid_all(long var1) throws LibGuestFSException;

    public void pvcreate(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("pvcreate: handle is closed");
        }
        this._pvcreate(this.g, string);
    }

    private native void _pvcreate(long var1, String var3) throws LibGuestFSException;

    public void pvremove(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("pvremove: handle is closed");
        }
        this._pvremove(this.g, string);
    }

    private native void _pvremove(long var1, String var3) throws LibGuestFSException;

    public void pvresize(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("pvresize: handle is closed");
        }
        this._pvresize(this.g, string);
    }

    private native void _pvresize(long var1, String var3) throws LibGuestFSException;

    public void pvresize_size(String string, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("pvresize_size: handle is closed");
        }
        this._pvresize_size(this.g, string, l);
    }

    private native void _pvresize_size(long var1, String var3, long var4) throws LibGuestFSException;

    public String[] pvs() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("pvs: handle is closed");
        }
        return this._pvs(this.g);
    }

    private native String[] _pvs(long var1) throws LibGuestFSException;

    public PV[] pvs_full() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("pvs_full: handle is closed");
        }
        return this._pvs_full(this.g);
    }

    private native PV[] _pvs_full(long var1) throws LibGuestFSException;

    public String pvuuid(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("pvuuid: handle is closed");
        }
        return this._pvuuid(this.g, string);
    }

    private native String _pvuuid(long var1, String var3) throws LibGuestFSException;

    public int pwrite(String string, byte[] byArray, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("pwrite: handle is closed");
        }
        return this._pwrite(this.g, string, byArray, l);
    }

    private native int _pwrite(long var1, String var3, byte[] var4, long var5) throws LibGuestFSException;

    public int pwrite_device(String string, byte[] byArray, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("pwrite_device: handle is closed");
        }
        return this._pwrite_device(this.g, string, byArray, l);
    }

    private native int _pwrite_device(long var1, String var3, byte[] var4, long var5) throws LibGuestFSException;

    public String read_file(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("read_file: handle is closed");
        }
        return this._read_file(this.g, string);
    }

    private native String _read_file(long var1, String var3) throws LibGuestFSException;

    public String[] read_lines(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("read_lines: handle is closed");
        }
        return this._read_lines(this.g, string);
    }

    private native String[] _read_lines(long var1, String var3) throws LibGuestFSException;

    public Dirent[] readdir(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("readdir: handle is closed");
        }
        return this._readdir(this.g, string);
    }

    private native Dirent[] _readdir(long var1, String var3) throws LibGuestFSException;

    public String readlink(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("readlink: handle is closed");
        }
        return this._readlink(this.g, string);
    }

    private native String _readlink(long var1, String var3) throws LibGuestFSException;

    public String[] readlinklist(String string, String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("readlinklist: handle is closed");
        }
        return this._readlinklist(this.g, string, stringArray);
    }

    private native String[] _readlinklist(long var1, String var3, String[] var4) throws LibGuestFSException;

    public String realpath(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("realpath: handle is closed");
        }
        return this._realpath(this.g, string);
    }

    private native String _realpath(long var1, String var3) throws LibGuestFSException;

    public void remount(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("remount: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("rw");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        this._remount(this.g, string, l, bl);
    }

    public void remount(String string) throws LibGuestFSException {
        this.remount(string, null);
    }

    private native void _remount(long var1, String var3, long var4, boolean var6) throws LibGuestFSException;

    @Deprecated
    public void remove_drive(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("remove_drive: handle is closed");
        }
        this._remove_drive(this.g, string);
    }

    private native void _remove_drive(long var1, String var3) throws LibGuestFSException;

    public void removexattr(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("removexattr: handle is closed");
        }
        this._removexattr(this.g, string, string2);
    }

    private native void _removexattr(long var1, String var3, String var4) throws LibGuestFSException;

    public void rename(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("rename: handle is closed");
        }
        this._rename(this.g, string, string2);
    }

    private native void _rename(long var1, String var3, String var4) throws LibGuestFSException;

    public void resize2fs(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("resize2fs: handle is closed");
        }
        this._resize2fs(this.g, string);
    }

    private native void _resize2fs(long var1, String var3) throws LibGuestFSException;

    public void resize2fs_M(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("resize2fs_M: handle is closed");
        }
        this._resize2fs_M(this.g, string);
    }

    private native void _resize2fs_M(long var1, String var3) throws LibGuestFSException;

    public void resize2fs_size(String string, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("resize2fs_size: handle is closed");
        }
        this._resize2fs_size(this.g, string, l);
    }

    private native void _resize2fs_size(long var1, String var3, long var4) throws LibGuestFSException;

    public void rm(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("rm: handle is closed");
        }
        this._rm(this.g, string);
    }

    private native void _rm(long var1, String var3) throws LibGuestFSException;

    public void rm_f(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("rm_f: handle is closed");
        }
        this._rm_f(this.g, string);
    }

    private native void _rm_f(long var1, String var3) throws LibGuestFSException;

    public void rm_rf(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("rm_rf: handle is closed");
        }
        this._rm_rf(this.g, string);
    }

    private native void _rm_rf(long var1, String var3) throws LibGuestFSException;

    public void rmdir(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("rmdir: handle is closed");
        }
        this._rmdir(this.g, string);
    }

    private native void _rmdir(long var1, String var3) throws LibGuestFSException;

    public void rmmountpoint(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("rmmountpoint: handle is closed");
        }
        this._rmmountpoint(this.g, string);
    }

    private native void _rmmountpoint(long var1, String var3) throws LibGuestFSException;

    public void rsync(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("rsync: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("archive");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("deletedest");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 2L;
        }
        this._rsync(this.g, string, string2, l, bl, bl2);
    }

    public void rsync(String string, String string2) throws LibGuestFSException {
        this.rsync(string, string2, null);
    }

    private native void _rsync(long var1, String var3, String var4, long var5, boolean var7, boolean var8) throws LibGuestFSException;

    public void rsync_in(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("rsync_in: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("archive");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("deletedest");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 2L;
        }
        this._rsync_in(this.g, string, string2, l, bl, bl2);
    }

    public void rsync_in(String string, String string2) throws LibGuestFSException {
        this.rsync_in(string, string2, null);
    }

    private native void _rsync_in(long var1, String var3, String var4, long var5, boolean var7, boolean var8) throws LibGuestFSException;

    public void rsync_out(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("rsync_out: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("archive");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("deletedest");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 2L;
        }
        this._rsync_out(this.g, string, string2, l, bl, bl2);
    }

    public void rsync_out(String string, String string2) throws LibGuestFSException {
        this.rsync_out(string, string2, null);
    }

    private native void _rsync_out(long var1, String var3, String var4, long var5, boolean var7, boolean var8) throws LibGuestFSException;

    public void scrub_device(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("scrub_device: handle is closed");
        }
        this._scrub_device(this.g, string);
    }

    private native void _scrub_device(long var1, String var3) throws LibGuestFSException;

    public void scrub_file(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("scrub_file: handle is closed");
        }
        this._scrub_file(this.g, string);
    }

    private native void _scrub_file(long var1, String var3) throws LibGuestFSException;

    public void scrub_freespace(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("scrub_freespace: handle is closed");
        }
        this._scrub_freespace(this.g, string);
    }

    private native void _scrub_freespace(long var1, String var3) throws LibGuestFSException;

    public void selinux_relabel(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("selinux_relabel: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("force");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        this._selinux_relabel(this.g, string, string2, l, bl);
    }

    public void selinux_relabel(String string, String string2) throws LibGuestFSException {
        this.selinux_relabel(string, string2, null);
    }

    private native void _selinux_relabel(long var1, String var3, String var4, long var5, boolean var7) throws LibGuestFSException;

    public void set_append(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_append: handle is closed");
        }
        this._set_append(this.g, string);
    }

    private native void _set_append(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public void set_attach_method(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_attach_method: handle is closed");
        }
        this._set_attach_method(this.g, string);
    }

    private native void _set_attach_method(long var1, String var3) throws LibGuestFSException;

    public void set_autosync(boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_autosync: handle is closed");
        }
        this._set_autosync(this.g, bl);
    }

    private native void _set_autosync(long var1, boolean var3) throws LibGuestFSException;

    public void set_backend(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_backend: handle is closed");
        }
        this._set_backend(this.g, string);
    }

    private native void _set_backend(long var1, String var3) throws LibGuestFSException;

    public void set_backend_setting(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_backend_setting: handle is closed");
        }
        this._set_backend_setting(this.g, string, string2);
    }

    private native void _set_backend_setting(long var1, String var3, String var4) throws LibGuestFSException;

    public void set_backend_settings(String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_backend_settings: handle is closed");
        }
        this._set_backend_settings(this.g, stringArray);
    }

    private native void _set_backend_settings(long var1, String[] var3) throws LibGuestFSException;

    public void set_cachedir(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_cachedir: handle is closed");
        }
        this._set_cachedir(this.g, string);
    }

    private native void _set_cachedir(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public void set_direct(boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_direct: handle is closed");
        }
        this._set_direct(this.g, bl);
    }

    private native void _set_direct(long var1, boolean var3) throws LibGuestFSException;

    public void set_e2attrs(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_e2attrs: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("clear");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        this._set_e2attrs(this.g, string, string2, l, bl);
    }

    public void set_e2attrs(String string, String string2) throws LibGuestFSException {
        this.set_e2attrs(string, string2, null);
    }

    private native void _set_e2attrs(long var1, String var3, String var4, long var5, boolean var7) throws LibGuestFSException;

    public void set_e2generation(String string, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_e2generation: handle is closed");
        }
        this._set_e2generation(this.g, string, l);
    }

    private native void _set_e2generation(long var1, String var3, long var4) throws LibGuestFSException;

    @Deprecated
    public void set_e2label(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_e2label: handle is closed");
        }
        this._set_e2label(this.g, string, string2);
    }

    private native void _set_e2label(long var1, String var3, String var4) throws LibGuestFSException;

    @Deprecated
    public void set_e2uuid(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_e2uuid: handle is closed");
        }
        this._set_e2uuid(this.g, string, string2);
    }

    private native void _set_e2uuid(long var1, String var3, String var4) throws LibGuestFSException;

    public void set_hv(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_hv: handle is closed");
        }
        this._set_hv(this.g, string);
    }

    private native void _set_hv(long var1, String var3) throws LibGuestFSException;

    public void set_identifier(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_identifier: handle is closed");
        }
        this._set_identifier(this.g, string);
    }

    private native void _set_identifier(long var1, String var3) throws LibGuestFSException;

    public void set_label(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_label: handle is closed");
        }
        this._set_label(this.g, string, string2);
    }

    private native void _set_label(long var1, String var3, String var4) throws LibGuestFSException;

    public void set_libvirt_requested_credential(int n, byte[] byArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_libvirt_requested_credential: handle is closed");
        }
        this._set_libvirt_requested_credential(this.g, n, byArray);
    }

    private native void _set_libvirt_requested_credential(long var1, int var3, byte[] var4) throws LibGuestFSException;

    public void set_libvirt_supported_credentials(String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_libvirt_supported_credentials: handle is closed");
        }
        this._set_libvirt_supported_credentials(this.g, stringArray);
    }

    private native void _set_libvirt_supported_credentials(long var1, String[] var3) throws LibGuestFSException;

    public void set_memsize(int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_memsize: handle is closed");
        }
        this._set_memsize(this.g, n);
    }

    private native void _set_memsize(long var1, int var3) throws LibGuestFSException;

    public void set_network(boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_network: handle is closed");
        }
        this._set_network(this.g, bl);
    }

    private native void _set_network(long var1, boolean var3) throws LibGuestFSException;

    public void set_path(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_path: handle is closed");
        }
        this._set_path(this.g, string);
    }

    private native void _set_path(long var1, String var3) throws LibGuestFSException;

    public void set_pgroup(boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_pgroup: handle is closed");
        }
        this._set_pgroup(this.g, bl);
    }

    private native void _set_pgroup(long var1, boolean var3) throws LibGuestFSException;

    public void set_program(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_program: handle is closed");
        }
        this._set_program(this.g, string);
    }

    private native void _set_program(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public void set_qemu(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_qemu: handle is closed");
        }
        this._set_qemu(this.g, string);
    }

    private native void _set_qemu(long var1, String var3) throws LibGuestFSException;

    public void set_recovery_proc(boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_recovery_proc: handle is closed");
        }
        this._set_recovery_proc(this.g, bl);
    }

    private native void _set_recovery_proc(long var1, boolean var3) throws LibGuestFSException;

    @Deprecated
    public void set_selinux(boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_selinux: handle is closed");
        }
        this._set_selinux(this.g, bl);
    }

    private native void _set_selinux(long var1, boolean var3) throws LibGuestFSException;

    public void set_smp(int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_smp: handle is closed");
        }
        this._set_smp(this.g, n);
    }

    private native void _set_smp(long var1, int var3) throws LibGuestFSException;

    public void set_tmpdir(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_tmpdir: handle is closed");
        }
        this._set_tmpdir(this.g, string);
    }

    private native void _set_tmpdir(long var1, String var3) throws LibGuestFSException;

    public void set_trace(boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_trace: handle is closed");
        }
        this._set_trace(this.g, bl);
    }

    private native void _set_trace(long var1, boolean var3) throws LibGuestFSException;

    public void set_uuid(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_uuid: handle is closed");
        }
        this._set_uuid(this.g, string, string2);
    }

    private native void _set_uuid(long var1, String var3, String var4) throws LibGuestFSException;

    public void set_uuid_random(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_uuid_random: handle is closed");
        }
        this._set_uuid_random(this.g, string);
    }

    private native void _set_uuid_random(long var1, String var3) throws LibGuestFSException;

    public void set_verbose(boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("set_verbose: handle is closed");
        }
        this._set_verbose(this.g, bl);
    }

    private native void _set_verbose(long var1, boolean var3) throws LibGuestFSException;

    @Deprecated
    public void setcon(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("setcon: handle is closed");
        }
        this._setcon(this.g, string);
    }

    private native void _setcon(long var1, String var3) throws LibGuestFSException;

    public void setxattr(String string, String string2, int n, String string3) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("setxattr: handle is closed");
        }
        this._setxattr(this.g, string, string2, n, string3);
    }

    private native void _setxattr(long var1, String var3, String var4, int var5, String var6) throws LibGuestFSException;

    @Deprecated
    public void sfdisk(String string, int n, int n2, int n3, String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("sfdisk: handle is closed");
        }
        this._sfdisk(this.g, string, n, n2, n3, stringArray);
    }

    private native void _sfdisk(long var1, String var3, int var4, int var5, int var6, String[] var7) throws LibGuestFSException;

    @Deprecated
    public void sfdiskM(String string, String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("sfdiskM: handle is closed");
        }
        this._sfdiskM(this.g, string, stringArray);
    }

    private native void _sfdiskM(long var1, String var3, String[] var4) throws LibGuestFSException;

    @Deprecated
    public void sfdisk_N(String string, int n, int n2, int n3, int n4, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("sfdisk_N: handle is closed");
        }
        this._sfdisk_N(this.g, string, n, n2, n3, n4, string2);
    }

    private native void _sfdisk_N(long var1, String var3, int var4, int var5, int var6, int var7, String var8) throws LibGuestFSException;

    public String sfdisk_disk_geometry(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("sfdisk_disk_geometry: handle is closed");
        }
        return this._sfdisk_disk_geometry(this.g, string);
    }

    private native String _sfdisk_disk_geometry(long var1, String var3) throws LibGuestFSException;

    public String sfdisk_kernel_geometry(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("sfdisk_kernel_geometry: handle is closed");
        }
        return this._sfdisk_kernel_geometry(this.g, string);
    }

    private native String _sfdisk_kernel_geometry(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public String sfdisk_l(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("sfdisk_l: handle is closed");
        }
        return this._sfdisk_l(this.g, string);
    }

    private native String _sfdisk_l(long var1, String var3) throws LibGuestFSException;

    public String sh(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("sh: handle is closed");
        }
        return this._sh(this.g, string);
    }

    private native String _sh(long var1, String var3) throws LibGuestFSException;

    public String[] sh_lines(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("sh_lines: handle is closed");
        }
        return this._sh_lines(this.g, string);
    }

    private native String[] _sh_lines(long var1, String var3) throws LibGuestFSException;

    public void shutdown() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("shutdown: handle is closed");
        }
        this._shutdown(this.g);
    }

    private native void _shutdown(long var1) throws LibGuestFSException;

    public void sleep(int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("sleep: handle is closed");
        }
        this._sleep(this.g, n);
    }

    private native void _sleep(long var1, int var3) throws LibGuestFSException;

    @Deprecated
    public Stat stat(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("stat: handle is closed");
        }
        return this._stat(this.g, string);
    }

    private native Stat _stat(long var1, String var3) throws LibGuestFSException;

    public StatNS statns(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("statns: handle is closed");
        }
        return this._statns(this.g, string);
    }

    private native StatNS _statns(long var1, String var3) throws LibGuestFSException;

    public StatVFS statvfs(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("statvfs: handle is closed");
        }
        return this._statvfs(this.g, string);
    }

    private native StatVFS _statvfs(long var1, String var3) throws LibGuestFSException;

    public String[] strings(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("strings: handle is closed");
        }
        return this._strings(this.g, string);
    }

    private native String[] _strings(long var1, String var3) throws LibGuestFSException;

    public String[] strings_e(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("strings_e: handle is closed");
        }
        return this._strings_e(this.g, string, string2);
    }

    private native String[] _strings_e(long var1, String var3, String var4) throws LibGuestFSException;

    public void swapoff_device(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("swapoff_device: handle is closed");
        }
        this._swapoff_device(this.g, string);
    }

    private native void _swapoff_device(long var1, String var3) throws LibGuestFSException;

    public void swapoff_file(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("swapoff_file: handle is closed");
        }
        this._swapoff_file(this.g, string);
    }

    private native void _swapoff_file(long var1, String var3) throws LibGuestFSException;

    public void swapoff_label(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("swapoff_label: handle is closed");
        }
        this._swapoff_label(this.g, string);
    }

    private native void _swapoff_label(long var1, String var3) throws LibGuestFSException;

    public void swapoff_uuid(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("swapoff_uuid: handle is closed");
        }
        this._swapoff_uuid(this.g, string);
    }

    private native void _swapoff_uuid(long var1, String var3) throws LibGuestFSException;

    public void swapon_device(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("swapon_device: handle is closed");
        }
        this._swapon_device(this.g, string);
    }

    private native void _swapon_device(long var1, String var3) throws LibGuestFSException;

    public void swapon_file(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("swapon_file: handle is closed");
        }
        this._swapon_file(this.g, string);
    }

    private native void _swapon_file(long var1, String var3) throws LibGuestFSException;

    public void swapon_label(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("swapon_label: handle is closed");
        }
        this._swapon_label(this.g, string);
    }

    private native void _swapon_label(long var1, String var3) throws LibGuestFSException;

    public void swapon_uuid(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("swapon_uuid: handle is closed");
        }
        this._swapon_uuid(this.g, string);
    }

    private native void _swapon_uuid(long var1, String var3) throws LibGuestFSException;

    public void sync() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("sync: handle is closed");
        }
        this._sync(this.g);
    }

    private native void _sync(long var1) throws LibGuestFSException;

    public void syslinux(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("syslinux: handle is closed");
        }
        long l = 0L;
        String string2 = "";
        Object object = null;
        if (map != null) {
            object = map.get("directory");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 1L;
        }
        this._syslinux(this.g, string, l, string2);
    }

    public void syslinux(String string) throws LibGuestFSException {
        this.syslinux(string, null);
    }

    private native void _syslinux(long var1, String var3, long var4, String var6) throws LibGuestFSException;

    public String[] tail(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("tail: handle is closed");
        }
        return this._tail(this.g, string);
    }

    private native String[] _tail(long var1, String var3) throws LibGuestFSException;

    public String[] tail_n(int n, String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("tail_n: handle is closed");
        }
        return this._tail_n(this.g, n, string);
    }

    private native String[] _tail_n(long var1, int var3, String var4) throws LibGuestFSException;

    public void tar_in(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("tar_in: handle is closed");
        }
        long l = 0L;
        String string3 = "";
        Object object = null;
        if (map != null) {
            object = map.get("compress");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 1L;
        }
        boolean bl = false;
        object = null;
        if (map != null) {
            object = map.get("xattrs");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 2L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("selinux");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 4L;
        }
        boolean bl3 = false;
        object = null;
        if (map != null) {
            object = map.get("acls");
        }
        if (object != null) {
            bl3 = (Boolean)object;
            l |= 8L;
        }
        this._tar_in(this.g, string, string2, l, string3, bl, bl2, bl3);
    }

    public void tar_in(String string, String string2) throws LibGuestFSException {
        this.tar_in(string, string2, null);
    }

    public void tar_in_opts(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        this.tar_in(string, string2, map);
    }

    public void tar_in_opts(String string, String string2) throws LibGuestFSException {
        this.tar_in(string, string2, null);
    }

    private native void _tar_in(long var1, String var3, String var4, long var5, String var7, boolean var8, boolean var9, boolean var10) throws LibGuestFSException;

    public void tar_out(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("tar_out: handle is closed");
        }
        long l = 0L;
        String string3 = "";
        Object object = null;
        if (map != null) {
            object = map.get("compress");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 1L;
        }
        boolean bl = false;
        object = null;
        if (map != null) {
            object = map.get("numericowner");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 2L;
        }
        String[] stringArray = new String[]{};
        object = null;
        if (map != null) {
            object = map.get("excludes");
        }
        if (object != null) {
            stringArray = (String[])object;
            l |= 4L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("xattrs");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 8L;
        }
        boolean bl3 = false;
        object = null;
        if (map != null) {
            object = map.get("selinux");
        }
        if (object != null) {
            bl3 = (Boolean)object;
            l |= 0x10L;
        }
        boolean bl4 = false;
        object = null;
        if (map != null) {
            object = map.get("acls");
        }
        if (object != null) {
            bl4 = (Boolean)object;
            l |= 0x20L;
        }
        this._tar_out(this.g, string, string2, l, string3, bl, stringArray, bl2, bl3, bl4);
    }

    public void tar_out(String string, String string2) throws LibGuestFSException {
        this.tar_out(string, string2, null);
    }

    public void tar_out_opts(String string, String string2, Map<String, Object> map) throws LibGuestFSException {
        this.tar_out(string, string2, map);
    }

    public void tar_out_opts(String string, String string2) throws LibGuestFSException {
        this.tar_out(string, string2, null);
    }

    private native void _tar_out(long var1, String var3, String var4, long var5, String var7, boolean var8, String[] var9, boolean var10, boolean var11, boolean var12) throws LibGuestFSException;

    @Deprecated
    public void tgz_in(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("tgz_in: handle is closed");
        }
        this._tgz_in(this.g, string, string2);
    }

    private native void _tgz_in(long var1, String var3, String var4) throws LibGuestFSException;

    @Deprecated
    public void tgz_out(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("tgz_out: handle is closed");
        }
        this._tgz_out(this.g, string, string2);
    }

    private native void _tgz_out(long var1, String var3, String var4) throws LibGuestFSException;

    public void touch(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("touch: handle is closed");
        }
        this._touch(this.g, string);
    }

    private native void _touch(long var1, String var3) throws LibGuestFSException;

    public void truncate(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("truncate: handle is closed");
        }
        this._truncate(this.g, string);
    }

    private native void _truncate(long var1, String var3) throws LibGuestFSException;

    public void truncate_size(String string, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("truncate_size: handle is closed");
        }
        this._truncate_size(this.g, string, l);
    }

    private native void _truncate_size(long var1, String var3, long var4) throws LibGuestFSException;

    public void tune2fs(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("tune2fs: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("force");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        int n = 0;
        object = null;
        if (map != null) {
            object = map.get("maxmountcount");
        }
        if (object != null) {
            n = (Integer)object;
            l |= 2L;
        }
        int n2 = 0;
        object = null;
        if (map != null) {
            object = map.get("mountcount");
        }
        if (object != null) {
            n2 = (Integer)object;
            l |= 4L;
        }
        String string2 = "";
        object = null;
        if (map != null) {
            object = map.get("errorbehavior");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 8L;
        }
        long l2 = 0L;
        object = null;
        if (map != null) {
            object = map.get("group");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 0x10L;
        }
        int n3 = 0;
        object = null;
        if (map != null) {
            object = map.get("intervalbetweenchecks");
        }
        if (object != null) {
            n3 = (Integer)object;
            l |= 0x20L;
        }
        int n4 = 0;
        object = null;
        if (map != null) {
            object = map.get("reservedblockspercentage");
        }
        if (object != null) {
            n4 = (Integer)object;
            l |= 0x40L;
        }
        String string3 = "";
        object = null;
        if (map != null) {
            object = map.get("lastmounteddirectory");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 0x80L;
        }
        long l3 = 0L;
        object = null;
        if (map != null) {
            object = map.get("reservedblockscount");
        }
        if (object != null) {
            l3 = (Long)object;
            l |= 0x100L;
        }
        long l4 = 0L;
        object = null;
        if (map != null) {
            object = map.get("user");
        }
        if (object != null) {
            l4 = (Long)object;
            l |= 0x200L;
        }
        this._tune2fs(this.g, string, l, bl, n, n2, string2, l2, n3, n4, string3, l3, l4);
    }

    public void tune2fs(String string) throws LibGuestFSException {
        this.tune2fs(string, null);
    }

    private native void _tune2fs(long var1, String var3, long var4, boolean var6, int var7, int var8, String var9, long var10, int var12, int var13, String var14, long var15, long var17) throws LibGuestFSException;

    public Map<String, String> tune2fs_l(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("tune2fs_l: handle is closed");
        }
        String[] stringArray = this._tune2fs_l(this.g, string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return hashMap;
    }

    private native String[] _tune2fs_l(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public void txz_in(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("txz_in: handle is closed");
        }
        this._txz_in(this.g, string, string2);
    }

    private native void _txz_in(long var1, String var3, String var4) throws LibGuestFSException;

    @Deprecated
    public void txz_out(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("txz_out: handle is closed");
        }
        this._txz_out(this.g, string, string2);
    }

    private native void _txz_out(long var1, String var3, String var4) throws LibGuestFSException;

    public int umask(int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("umask: handle is closed");
        }
        return this._umask(this.g, n);
    }

    private native int _umask(long var1, int var3) throws LibGuestFSException;

    public void umount(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("umount: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("force");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("lazyunmount");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 2L;
        }
        this._umount(this.g, string, l, bl, bl2);
    }

    public void umount(String string) throws LibGuestFSException {
        this.umount(string, null);
    }

    public void umount_opts(String string, Map<String, Object> map) throws LibGuestFSException {
        this.umount(string, map);
    }

    public void umount_opts(String string) throws LibGuestFSException {
        this.umount(string, null);
    }

    private native void _umount(long var1, String var3, long var4, boolean var6, boolean var7) throws LibGuestFSException;

    public void umount_all() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("umount_all: handle is closed");
        }
        this._umount_all(this.g);
    }

    private native void _umount_all(long var1) throws LibGuestFSException;

    public void umount_local(Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("umount_local: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("retry");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        this._umount_local(this.g, l, bl);
    }

    public void umount_local() throws LibGuestFSException {
        this.umount_local(null);
    }

    private native void _umount_local(long var1, long var3, boolean var5) throws LibGuestFSException;

    public void upload(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("upload: handle is closed");
        }
        this._upload(this.g, string, string2);
    }

    private native void _upload(long var1, String var3, String var4) throws LibGuestFSException;

    public void upload_offset(String string, String string2, long l) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("upload_offset: handle is closed");
        }
        this._upload_offset(this.g, string, string2, l);
    }

    private native void _upload_offset(long var1, String var3, String var4, long var5) throws LibGuestFSException;

    public void user_cancel() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("user_cancel: handle is closed");
        }
        this._user_cancel(this.g);
    }

    private native void _user_cancel(long var1) throws LibGuestFSException;

    public void utimens(String string, long l, long l2, long l3, long l4) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("utimens: handle is closed");
        }
        this._utimens(this.g, string, l, l2, l3, l4);
    }

    private native void _utimens(long var1, String var3, long var4, long var6, long var8, long var10) throws LibGuestFSException;

    public UTSName utsname() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("utsname: handle is closed");
        }
        return this._utsname(this.g);
    }

    private native UTSName _utsname(long var1) throws LibGuestFSException;

    public Version version() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("version: handle is closed");
        }
        return this._version(this.g);
    }

    private native Version _version(long var1) throws LibGuestFSException;

    public String vfs_label(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vfs_label: handle is closed");
        }
        return this._vfs_label(this.g, string);
    }

    private native String _vfs_label(long var1, String var3) throws LibGuestFSException;

    public long vfs_minimum_size(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vfs_minimum_size: handle is closed");
        }
        return this._vfs_minimum_size(this.g, string);
    }

    private native long _vfs_minimum_size(long var1, String var3) throws LibGuestFSException;

    public String vfs_type(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vfs_type: handle is closed");
        }
        return this._vfs_type(this.g, string);
    }

    private native String _vfs_type(long var1, String var3) throws LibGuestFSException;

    public String vfs_uuid(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vfs_uuid: handle is closed");
        }
        return this._vfs_uuid(this.g, string);
    }

    private native String _vfs_uuid(long var1, String var3) throws LibGuestFSException;

    public void vg_activate(boolean bl, String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vg_activate: handle is closed");
        }
        this._vg_activate(this.g, bl, stringArray);
    }

    private native void _vg_activate(long var1, boolean var3, String[] var4) throws LibGuestFSException;

    public void vg_activate_all(boolean bl) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vg_activate_all: handle is closed");
        }
        this._vg_activate_all(this.g, bl);
    }

    private native void _vg_activate_all(long var1, boolean var3) throws LibGuestFSException;

    public void vgchange_uuid(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vgchange_uuid: handle is closed");
        }
        this._vgchange_uuid(this.g, string);
    }

    private native void _vgchange_uuid(long var1, String var3) throws LibGuestFSException;

    public void vgchange_uuid_all() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vgchange_uuid_all: handle is closed");
        }
        this._vgchange_uuid_all(this.g);
    }

    private native void _vgchange_uuid_all(long var1) throws LibGuestFSException;

    public void vgcreate(String string, String[] stringArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vgcreate: handle is closed");
        }
        this._vgcreate(this.g, string, stringArray);
    }

    private native void _vgcreate(long var1, String var3, String[] var4) throws LibGuestFSException;

    public String[] vglvuuids(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vglvuuids: handle is closed");
        }
        return this._vglvuuids(this.g, string);
    }

    private native String[] _vglvuuids(long var1, String var3) throws LibGuestFSException;

    public String vgmeta(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vgmeta: handle is closed");
        }
        return this._vgmeta(this.g, string);
    }

    private native String _vgmeta(long var1, String var3) throws LibGuestFSException;

    public String[] vgpvuuids(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vgpvuuids: handle is closed");
        }
        return this._vgpvuuids(this.g, string);
    }

    private native String[] _vgpvuuids(long var1, String var3) throws LibGuestFSException;

    public void vgremove(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vgremove: handle is closed");
        }
        this._vgremove(this.g, string);
    }

    private native void _vgremove(long var1, String var3) throws LibGuestFSException;

    public void vgrename(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vgrename: handle is closed");
        }
        this._vgrename(this.g, string, string2);
    }

    private native void _vgrename(long var1, String var3, String var4) throws LibGuestFSException;

    public String[] vgs() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vgs: handle is closed");
        }
        return this._vgs(this.g);
    }

    private native String[] _vgs(long var1) throws LibGuestFSException;

    public VG[] vgs_full() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vgs_full: handle is closed");
        }
        return this._vgs_full(this.g);
    }

    private native VG[] _vgs_full(long var1) throws LibGuestFSException;

    @Deprecated
    public void vgscan() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vgscan: handle is closed");
        }
        this._vgscan(this.g);
    }

    private native void _vgscan(long var1) throws LibGuestFSException;

    public String vguuid(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("vguuid: handle is closed");
        }
        return this._vguuid(this.g, string);
    }

    private native String _vguuid(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public void wait_ready() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("wait_ready: handle is closed");
        }
        this._wait_ready(this.g);
    }

    private native void _wait_ready(long var1) throws LibGuestFSException;

    public int wc_c(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("wc_c: handle is closed");
        }
        return this._wc_c(this.g, string);
    }

    private native int _wc_c(long var1, String var3) throws LibGuestFSException;

    public int wc_l(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("wc_l: handle is closed");
        }
        return this._wc_l(this.g, string);
    }

    private native int _wc_l(long var1, String var3) throws LibGuestFSException;

    public int wc_w(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("wc_w: handle is closed");
        }
        return this._wc_w(this.g, string);
    }

    private native int _wc_w(long var1, String var3) throws LibGuestFSException;

    public void wipefs(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("wipefs: handle is closed");
        }
        this._wipefs(this.g, string);
    }

    private native void _wipefs(long var1, String var3) throws LibGuestFSException;

    public void write(String string, byte[] byArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("write: handle is closed");
        }
        this._write(this.g, string, byArray);
    }

    private native void _write(long var1, String var3, byte[] var4) throws LibGuestFSException;

    public void write_append(String string, byte[] byArray) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("write_append: handle is closed");
        }
        this._write_append(this.g, string, byArray);
    }

    private native void _write_append(long var1, String var3, byte[] var4) throws LibGuestFSException;

    @Deprecated
    public void write_file(String string, String string2, int n) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("write_file: handle is closed");
        }
        this._write_file(this.g, string, string2, n);
    }

    private native void _write_file(long var1, String var3, String var4, int var5) throws LibGuestFSException;

    public void xfs_admin(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("xfs_admin: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("extunwritten");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("imgfile");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 2L;
        }
        boolean bl3 = false;
        object = null;
        if (map != null) {
            object = map.get("v2log");
        }
        if (object != null) {
            bl3 = (Boolean)object;
            l |= 4L;
        }
        boolean bl4 = false;
        object = null;
        if (map != null) {
            object = map.get("projid32bit");
        }
        if (object != null) {
            bl4 = (Boolean)object;
            l |= 8L;
        }
        boolean bl5 = false;
        object = null;
        if (map != null) {
            object = map.get("lazycounter");
        }
        if (object != null) {
            bl5 = (Boolean)object;
            l |= 0x10L;
        }
        String string2 = "";
        object = null;
        if (map != null) {
            object = map.get("label");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 0x20L;
        }
        String string3 = "";
        object = null;
        if (map != null) {
            object = map.get("uuid");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 0x40L;
        }
        this._xfs_admin(this.g, string, l, bl, bl2, bl3, bl4, bl5, string2, string3);
    }

    public void xfs_admin(String string) throws LibGuestFSException {
        this.xfs_admin(string, null);
    }

    private native void _xfs_admin(long var1, String var3, long var4, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, String var11, String var12) throws LibGuestFSException;

    public void xfs_growfs(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("xfs_growfs: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("datasec");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("logsec");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 2L;
        }
        boolean bl3 = false;
        object = null;
        if (map != null) {
            object = map.get("rtsec");
        }
        if (object != null) {
            bl3 = (Boolean)object;
            l |= 4L;
        }
        long l2 = 0L;
        object = null;
        if (map != null) {
            object = map.get("datasize");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 8L;
        }
        long l3 = 0L;
        object = null;
        if (map != null) {
            object = map.get("logsize");
        }
        if (object != null) {
            l3 = (Long)object;
            l |= 0x10L;
        }
        long l4 = 0L;
        object = null;
        if (map != null) {
            object = map.get("rtsize");
        }
        if (object != null) {
            l4 = (Long)object;
            l |= 0x20L;
        }
        long l5 = 0L;
        object = null;
        if (map != null) {
            object = map.get("rtextsize");
        }
        if (object != null) {
            l5 = (Long)object;
            l |= 0x40L;
        }
        int n = 0;
        object = null;
        if (map != null) {
            object = map.get("maxpct");
        }
        if (object != null) {
            n = (Integer)object;
            l |= 0x80L;
        }
        this._xfs_growfs(this.g, string, l, bl, bl2, bl3, l2, l3, l4, l5, n);
    }

    public void xfs_growfs(String string) throws LibGuestFSException {
        this.xfs_growfs(string, null);
    }

    private native void _xfs_growfs(long var1, String var3, long var4, boolean var6, boolean var7, boolean var8, long var9, long var11, long var13, long var15, int var17) throws LibGuestFSException;

    public XFSInfo xfs_info(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("xfs_info: handle is closed");
        }
        return this._xfs_info(this.g, string);
    }

    private native XFSInfo _xfs_info(long var1, String var3) throws LibGuestFSException;

    public int xfs_repair(String string, Map<String, Object> map) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("xfs_repair: handle is closed");
        }
        long l = 0L;
        boolean bl = false;
        Object object = null;
        if (map != null) {
            object = map.get("forcelogzero");
        }
        if (object != null) {
            bl = (Boolean)object;
            l |= 1L;
        }
        boolean bl2 = false;
        object = null;
        if (map != null) {
            object = map.get("nomodify");
        }
        if (object != null) {
            bl2 = (Boolean)object;
            l |= 2L;
        }
        boolean bl3 = false;
        object = null;
        if (map != null) {
            object = map.get("noprefetch");
        }
        if (object != null) {
            bl3 = (Boolean)object;
            l |= 4L;
        }
        boolean bl4 = false;
        object = null;
        if (map != null) {
            object = map.get("forcegeometry");
        }
        if (object != null) {
            bl4 = (Boolean)object;
            l |= 8L;
        }
        long l2 = 0L;
        object = null;
        if (map != null) {
            object = map.get("maxmem");
        }
        if (object != null) {
            l2 = (Long)object;
            l |= 0x10L;
        }
        long l3 = 0L;
        object = null;
        if (map != null) {
            object = map.get("ihashsize");
        }
        if (object != null) {
            l3 = (Long)object;
            l |= 0x20L;
        }
        long l4 = 0L;
        object = null;
        if (map != null) {
            object = map.get("bhashsize");
        }
        if (object != null) {
            l4 = (Long)object;
            l |= 0x40L;
        }
        long l5 = 0L;
        object = null;
        if (map != null) {
            object = map.get("agstride");
        }
        if (object != null) {
            l5 = (Long)object;
            l |= 0x80L;
        }
        String string2 = "";
        object = null;
        if (map != null) {
            object = map.get("logdev");
        }
        if (object != null) {
            string2 = (String)object;
            l |= 0x100L;
        }
        String string3 = "";
        object = null;
        if (map != null) {
            object = map.get("rtdev");
        }
        if (object != null) {
            string3 = (String)object;
            l |= 0x200L;
        }
        return this._xfs_repair(this.g, string, l, bl, bl2, bl3, bl4, l2, l3, l4, l5, string2, string3);
    }

    public int xfs_repair(String string) throws LibGuestFSException {
        return this.xfs_repair(string, null);
    }

    private native int _xfs_repair(long var1, String var3, long var4, boolean var6, boolean var7, boolean var8, boolean var9, long var10, long var12, long var14, long var16, String var18, String var19) throws LibGuestFSException;

    public void yara_destroy() throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("yara_destroy: handle is closed");
        }
        this._yara_destroy(this.g);
    }

    private native void _yara_destroy(long var1) throws LibGuestFSException;

    public void yara_load(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("yara_load: handle is closed");
        }
        this._yara_load(this.g, string);
    }

    private native void _yara_load(long var1, String var3) throws LibGuestFSException;

    public YaraDetection[] yara_scan(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("yara_scan: handle is closed");
        }
        return this._yara_scan(this.g, string);
    }

    private native YaraDetection[] _yara_scan(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public String[] zegrep(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("zegrep: handle is closed");
        }
        return this._zegrep(this.g, string, string2);
    }

    private native String[] _zegrep(long var1, String var3, String var4) throws LibGuestFSException;

    @Deprecated
    public String[] zegrepi(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("zegrepi: handle is closed");
        }
        return this._zegrepi(this.g, string, string2);
    }

    private native String[] _zegrepi(long var1, String var3, String var4) throws LibGuestFSException;

    public void zero(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("zero: handle is closed");
        }
        this._zero(this.g, string);
    }

    private native void _zero(long var1, String var3) throws LibGuestFSException;

    public void zero_device(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("zero_device: handle is closed");
        }
        this._zero_device(this.g, string);
    }

    private native void _zero_device(long var1, String var3) throws LibGuestFSException;

    public void zero_free_space(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("zero_free_space: handle is closed");
        }
        this._zero_free_space(this.g, string);
    }

    private native void _zero_free_space(long var1, String var3) throws LibGuestFSException;

    public void zerofree(String string) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("zerofree: handle is closed");
        }
        this._zerofree(this.g, string);
    }

    private native void _zerofree(long var1, String var3) throws LibGuestFSException;

    @Deprecated
    public String[] zfgrep(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("zfgrep: handle is closed");
        }
        return this._zfgrep(this.g, string, string2);
    }

    private native String[] _zfgrep(long var1, String var3, String var4) throws LibGuestFSException;

    @Deprecated
    public String[] zfgrepi(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("zfgrepi: handle is closed");
        }
        return this._zfgrepi(this.g, string, string2);
    }

    private native String[] _zfgrepi(long var1, String var3, String var4) throws LibGuestFSException;

    @Deprecated
    public String zfile(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("zfile: handle is closed");
        }
        return this._zfile(this.g, string, string2);
    }

    private native String _zfile(long var1, String var3, String var4) throws LibGuestFSException;

    @Deprecated
    public String[] zgrep(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("zgrep: handle is closed");
        }
        return this._zgrep(this.g, string, string2);
    }

    private native String[] _zgrep(long var1, String var3, String var4) throws LibGuestFSException;

    @Deprecated
    public String[] zgrepi(String string, String string2) throws LibGuestFSException {
        if (this.g == 0L) {
            throw new LibGuestFSException("zgrepi: handle is closed");
        }
        return this._zgrepi(this.g, string, string2);
    }

    private native String[] _zgrepi(long var1, String var3, String var4) throws LibGuestFSException;

    static {
        System.loadLibrary("guestfs_jni");
        CREATE_NO_ENVIRONMENT = 1;
        CREATE_NO_CLOSE_ON_EXIT = 2;
    }
}

