/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0015B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0017\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\r\u0010\u0012\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0013\u0010\u0013\u001a\r\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000f0\u0014H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtArrayAccessReference;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleReference;", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "Lcom/intellij/psi/MultiRangeReference;", "expression", "(Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;)V", "resolvesByNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getResolvesByNames", "()Ljava/util/Collection;", "canRename", "", "getBracketRange", "Lcom/intellij/openapi/util/TextRange;", "Lorg/jetbrains/annotations/NotNull;", "bracketToken", "Lorg/jetbrains/kotlin/lexer/KtToken;", "getRangeInElement", "getRanges", "", "Companion", "kt-references"})
public abstract class KtArrayAccessReference
extends KtSimpleReference<KtArrayAccessExpression>
implements MultiRangeReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Name> NAMES;

    public KtArrayAccessReference(@NotNull KtArrayAccessExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super((KtReferenceExpression)expression2);
    }

    @Override
    @NotNull
    public Collection<Name> getResolvesByNames() {
        return NAMES;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = ((KtArrayAccessExpression)this.getElement()).getTextRange().shiftRight(-((KtArrayAccessExpression)this.getElement()).getTextOffset());
        Intrinsics.checkNotNullExpressionValue(textRange, "element.textRange.shiftRight(-element.textOffset)");
        return textRange;
    }

    private final TextRange getBracketRange(KtToken bracketToken) {
        Object object = ((KtArrayAccessExpression)this.getExpression()).getIndicesNode().getNode().findChildByType(bracketToken);
        return object != null && (object = object.getTextRange()) != null ? ((TextRange)object).shiftRight(-((KtArrayAccessExpression)this.getExpression()).getTextOffset()) : null;
    }

    @Override
    @NotNull
    public List<TextRange> getRanges() {
        TextRange[] textRangeArray = new TextRange[2];
        KtSingleValueToken ktSingleValueToken = KtTokens.LBRACKET;
        Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "LBRACKET");
        textRangeArray[0] = this.getBracketRange(ktSingleValueToken);
        KtSingleValueToken ktSingleValueToken2 = KtTokens.RBRACKET;
        Intrinsics.checkNotNullExpressionValue(ktSingleValueToken2, "RBRACKET");
        textRangeArray[1] = this.getBracketRange(ktSingleValueToken2);
        return CollectionsKt.listOfNotNull(textRangeArray);
    }

    @Override
    public boolean canRename() {
        return true;
    }

    static {
        Name[] nameArray = new Name[]{OperatorNameConventions.GET, OperatorNameConventions.SET};
        NAMES = CollectionsKt.listOf(nameArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtArrayAccessReference$Companion;", "", "()V", "NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "kt-references"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

