/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.substitution;

import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0016R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutorByMap;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "substitution", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Ljava/util/Map;Lorg/jetbrains/kotlin/fir/FirSession;)V", "hashCode", "", "getHashCode", "()I", "hashCode$delegate", "Lkotlin/Lazy;", "getSubstitution", "()Ljava/util/Map;", "equals", "", "other", "", "substituteType", "type", "providers"})
public final class ConeSubstitutorByMap
extends AbstractConeSubstitutor {
    @NotNull
    private final Map<FirTypeParameterSymbol, ConeKotlinType> substitution;
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final Lazy hashCode$delegate;

    public ConeSubstitutorByMap(@NotNull Map<FirTypeParameterSymbol, ? extends ConeKotlinType> substitution, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter(substitution, "substitution");
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        super(TypeComponentsKt.getTypeContext(useSiteSession));
        this.substitution = substitution;
        this.useSiteSession = useSiteSession;
        this.hashCode$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, (Function0)new Function0<Integer>(this){
            final /* synthetic */ ConeSubstitutorByMap this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return ((Object)this.this$0.getSubstitution()).hashCode();
            }
        });
    }

    @NotNull
    public final Map<FirTypeParameterSymbol, ConeKotlinType> getSubstitution() {
        return this.substitution;
    }

    private final int getHashCode() {
        Lazy lazy = this.hashCode$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    @Nullable
    public ConeKotlinType substituteType(@NotNull ConeKotlinType type2) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter(type2, "type");
        if (!(type2 instanceof ConeTypeParameterType)) {
            return null;
        }
        ConeKotlinType coneKotlinType2 = this.updateNullabilityIfNeeded(this.substitution.get(((ConeTypeParameterType)type2).getLookupTag().getSymbol()), type2);
        if (coneKotlinType2 == null || (coneKotlinType = LookupTagUtilsKt.withCombinedAttributesFrom(coneKotlinType2, type2)) == null) {
            return null;
        }
        ConeKotlinType result2 = coneKotlinType;
        if (TypeUtilsKt.isUnsafeVarianceType(type2, this.useSiteSession)) {
            ConeKotlinType coneKotlinType3 = TypeComponentsKt.getTypeApproximator(this.useSiteSession).approximateToSuperType(result2, (TypeApproximatorConfiguration)TypeApproximatorConfiguration.FinalApproximationAfterResolutionAndInference.INSTANCE);
            if (coneKotlinType3 == null) {
                coneKotlinType3 = result2;
            }
            return coneKotlinType3;
        }
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConeSubstitutorByMap)) {
            return false;
        }
        if (this.getHashCode() != ((ConeSubstitutorByMap)other).getHashCode()) {
            return false;
        }
        if (!Intrinsics.areEqual(this.substitution, ((ConeSubstitutorByMap)other).substitution)) {
            return false;
        }
        return Intrinsics.areEqual(this.useSiteSession, ((ConeSubstitutorByMap)other).useSiteSession);
    }

    public int hashCode() {
        return this.getHashCode();
    }
}

