/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi.text;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtDecompiledFile;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.ByDescriptorIndexer;
import org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledTextIndexer;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltInsSignatures;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0016J\f\u0010\u0012\u001a\u00020\u0002*\u00020\u000bH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/ByDescriptorIndexer;", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledTextIndexer;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "descriptorRendererForKeys", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "getBuiltinsDescriptorKey", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getDeclarationForDescriptor", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "file", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/file/KtDecompiledFile;", "indexDescriptor", "", "toStringKey", "decompiler-to-psi"})
public final class ByDescriptorIndexer
implements DecompiledTextIndexer<String> {
    @NotNull
    public static final ByDescriptorIndexer INSTANCE = new ByDescriptorIndexer();
    @NotNull
    private static final DescriptorRenderer descriptorRendererForKeys = DescriptorRenderer.Companion.withOptions(descriptorRendererForKeys.1.INSTANCE);
    @NotNull
    private static final Logger LOG;

    private ByDescriptorIndexer() {
    }

    @Override
    @NotNull
    public Collection<String> indexDescriptor(@NotNull DeclarationDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return CollectionsKt.listOf(this.toStringKey(descriptor2));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final KtDeclaration getDeclarationForDescriptor(@NotNull DeclarationDescriptor descriptor, @NotNull KtDecompiledFile file) {
        block22: {
            Intrinsics.checkNotNullParameter(descriptor, "descriptor");
            Intrinsics.checkNotNullParameter(file, "file");
            v0 = descriptor.getOriginal();
            Intrinsics.checkNotNullExpressionValue(v0, "descriptor.original");
            original = v0;
            if (original instanceof TypeAliasConstructorDescriptor) {
                return this.getDeclarationForDescriptor(((TypeAliasConstructorDescriptor)original).getTypeAliasDescriptor(), file);
            }
            if (original instanceof ValueParameterDescriptor) {
                callable = ((ValueParameterDescriptor)original).getContainingDeclaration();
                var7_7 = this.getDeclarationForDescriptor(callable, file);
                v1 = var7_7 instanceof KtCallableDeclaration != false ? (KtCallableDeclaration)var7_7 : null;
                if (v1 == null) {
                    return null;
                }
                callableDeclaration = v1;
                if (((ValueParameterDescriptor)original).getIndex() >= callableDeclaration.getValueParameters().size()) {
                    v2 = callableDeclaration.getValueParameterList();
                    ByDescriptorIndexer.LOG.error("Parameter count mismatch for " + DescriptorRenderer.DEBUG_TEXT.render(callable) + '[' + ((ValueParameterDescriptor)original).getIndex() + "] vs " + (v2 != null ? v2.getText() : null));
                    return null;
                }
                return callableDeclaration.getValueParameters().get(((ValueParameterDescriptor)original).getIndex());
            }
            if (original instanceof ConstructorDescriptor && ((ConstructorDescriptor)original).isPrimary()) {
                v3 = ((ConstructorDescriptor)original).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(v3, "original.containingDeclaration");
                callableDeclaration = this.getDeclarationForDescriptor(v3, file);
                classOrObject = callableDeclaration instanceof KtClassOrObject != false ? (KtClassOrObject)callableDeclaration : null;
                v4 /* !! */  = classOrObject;
                return v4 /* !! */  != null && (v4 /* !! */  = v4 /* !! */ .getPrimaryConstructor()) != null ? (KtDeclaration)v4 /* !! */  : (KtDeclaration)classOrObject;
            }
            descriptorKey = this.toStringKey(original);
            if (file.isContentsLoaded() || !(original instanceof MemberDescriptor)) break block22;
            if (file.hasDeclarationWithKey(this, descriptorKey)) ** GOTO lbl-1000
            v5 = this.getBuiltinsDescriptorKey(descriptor);
            if (v5 != null) {
                it = v5;
                $i$a$-let-ByDescriptorIndexer$getDeclarationForDescriptor$hasDeclarationByKey$1 = false;
                v6 = file.hasDeclarationWithKey(this, it);
            } else {
                v6 = false;
            }
            if (v6) lbl-1000:
            // 2 sources

            {
                v7 = true;
            } else {
                v7 = hasDeclarationByKey = false;
            }
            if (hasDeclarationByKey) {
                if (DescriptorUtils.isTopLevelDeclaration(original)) {
                    v8 = file;
                } else if (((MemberDescriptor)original).getContainingDeclaration() instanceof ClassDescriptor) {
                    v9 = ((MemberDescriptor)original).getContainingDeclaration();
                    Intrinsics.checkNotNull(v9, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                    var7_8 = this.getDeclarationForDescriptor((ClassDescriptor)v9, file);
                    v8 = var7_8 instanceof KtClassOrObject != false ? (KtClassOrObject)var7_8 : null;
                } else {
                    v8 = declarationContainer = null;
                }
                if (declarationContainer != null) {
                    block21: {
                        v10 = ((MemberDescriptor)original).getName().asString();
                        Intrinsics.checkNotNullExpressionValue(v10, "original.name.asString()");
                        descriptorName = v10;
                        v11 = declarationContainer.getDeclarations();
                        Intrinsics.checkNotNullExpressionValue(v11, "declarationContainer.declarations");
                        $this$singleOrNull$iv = v11;
                        $i$f$singleOrNull = false;
                        single$iv = null;
                        found$iv = false;
                        for (T element$iv : $this$singleOrNull$iv) {
                            it = (KtDeclaration)element$iv;
                            $i$a$-singleOrNull-ByDescriptorIndexer$getDeclarationForDescriptor$singleOrNull$1 = false;
                            if (!Intrinsics.areEqual(it.getName(), descriptorName)) continue;
                            if (found$iv) {
                                v12 = null;
                                break block21;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v12 = found$iv == false ? null : single$iv;
                    }
                    singleOrNull = v12;
                    if (singleOrNull != null) {
                        return singleOrNull;
                    }
                }
            }
        }
        v13 = file.getDeclaration(this, descriptorKey);
        if (v13 == null) {
            $this$getDeclarationForDescriptor_u24lambda_u243 = this;
            $i$a$-run-ByDescriptorIndexer$getDeclarationForDescriptor$1 = false;
            v14 = $this$getDeclarationForDescriptor_u24lambda_u243.getBuiltinsDescriptorKey(descriptor);
            if (v14 != null) {
                it = v14;
                $i$a$-let-ByDescriptorIndexer$getDeclarationForDescriptor$1$1 = false;
                v15 = file.getDeclaration($this$getDeclarationForDescriptor_u24lambda_u243, it);
            } else {
                v15 = null;
            }
            return v15;
        }
        return v13;
    }

    @Nullable
    public final String getBuiltinsDescriptorKey(@NotNull DeclarationDescriptor descriptor2) {
        ClassDescriptor builtInDescriptor;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return null;
        }
        FqNameUnsafe classFqName = DescriptorUtilsKt.getFqNameUnsafe(descriptor2);
        if (!JvmBuiltInsSignatures.INSTANCE.isSerializableInJava(classFqName)) {
            return null;
        }
        ModuleDescriptorImpl moduleDescriptorImpl = DefaultBuiltIns.Companion.getInstance().getBuiltInsModule();
        Intrinsics.checkNotNullExpressionValue(moduleDescriptorImpl, "DefaultBuiltIns.Instance.builtInsModule");
        ModuleDescriptor moduleDescriptor = moduleDescriptorImpl;
        FqName fqName2 = classFqName.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName2, "classFqName.toSafe()");
        ClassDescriptor classDescriptor = builtInDescriptor = DescriptorUtilsKt.resolveTopLevelClass(moduleDescriptor, fqName2, NoLookupLocation.FROM_IDE);
        return classDescriptor != null ? this.toStringKey(classDescriptor) : null;
    }

    private final String toStringKey(DeclarationDescriptor $this$toStringKey) {
        return descriptorRendererForKeys.render($this$toStringKey);
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(this::class.java)");
        LOG = logger;
    }
}

