/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.singleUseObject;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.singleUseObject.MapSingleUseObjectEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodPair;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;
import org.keycloak.models.map.storage.hotRod.singleUseObject.HotRodSingleUseObjectEntity;

public class HotRodSingleUseObjectEntityDelegate
extends HotRodSingleUseObjectEntity.AbstractHotRodSingleUseObjectEntityDelegate
implements MapSingleUseObjectEntity {
    private final HotRodSingleUseObjectEntity hotRodEntity;

    public HotRodSingleUseObjectEntityDelegate() {
        this.hotRodEntity = new HotRodSingleUseObjectEntity();
    }

    public HotRodSingleUseObjectEntityDelegate(HotRodSingleUseObjectEntity hotRodEntity) {
        Objects.requireNonNull(hotRodEntity);
        this.hotRodEntity = hotRodEntity;
    }

    public HotRodSingleUseObjectEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodSingleUseObjectEntity();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodSingleUseObjectEntityDelegate)) {
            return false;
        }
        HotRodSingleUseObjectEntityDelegate other = (HotRodSingleUseObjectEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getExpiration(), other.getExpiration()) && Objects.equals(this.getNotes(), other.getNotes()) && Objects.equals(this.getObjectKey(), other.getObjectKey());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodSingleUseObjectEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodSingleUseObjectEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodSingleUseObjectEntity e1 = (HotRodSingleUseObjectEntity)o1;
        HotRodSingleUseObjectEntity e2 = (HotRodSingleUseObjectEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.entityVersion, e2.entityVersion) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.objectKey, e2.objectKey) && Objects.equals(e1.expiration, e2.expiration) && Objects.equals(e1.notes, e2.notes);
    }

    public static int entityHashCode(HotRodSingleUseObjectEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public void setExpiration(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.expiration, migrated);
        this.hotRodEntity.expiration = migrated;
    }

    public Long getExpiration() {
        return this.hotRodEntity.expiration == null ? null : this.hotRodEntity.expiration;
    }

    public void setNotes(Map<String, String> p0) {
        HashMap hashMap = p0 = p0 == null ? null : new HashMap(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodPair> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodPairFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.notes, migrated);
        this.hotRodEntity.notes = migrated;
    }

    public String getNote(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.notes, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public Map<String, String> getNotes() {
        return this.hotRodEntity.notes == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.notes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setNote(String p0, String p1) {
        boolean valueUndefined = UndefinedValuesUtils.isUndefined((Object)p1);
        if (this.hotRodEntity.notes == null && !valueUndefined) {
            this.hotRodEntity.notes = new HashSet<HotRodPair<String, String>>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.notes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.notes.add(new HotRodPair<String, String>(p0, p1)));
    }

    public String getObjectKey() {
        return this.hotRodEntity.objectKey == null ? null : this.hotRodEntity.objectKey;
    }

    public void setObjectKey(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.objectKey, migrated);
        this.hotRodEntity.objectKey = migrated;
    }

    @Override
    public HotRodSingleUseObjectEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

