/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.storage.hotRod.client.HotRodClientEntity;
import org.keycloak.models.map.storage.hotRod.client.HotRodProtocolMapperEntity;
import org.keycloak.models.map.storage.hotRod.client.HotRodProtocolMapperEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodAttributeEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodEntityDelegate;
import org.keycloak.models.map.storage.hotRod.common.HotRodPair;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;

public class HotRodClientEntityDelegate
extends HotRodClientEntity.AbstractHotRodClientEntityDelegate
implements MapClientEntity {
    private final HotRodClientEntity hotRodEntity;
    private final DeepCloner cloner;

    public HotRodClientEntityDelegate() {
        this.cloner = DeepCloner.DUMB_CLONER;
        this.hotRodEntity = new HotRodClientEntity();
    }

    public HotRodClientEntityDelegate(HotRodClientEntity hotRodEntity) {
        Objects.requireNonNull(hotRodEntity);
        this.hotRodEntity = hotRodEntity;
        this.cloner = DeepCloner.DUMB_CLONER;
    }

    public HotRodClientEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodClientEntity();
        this.cloner = cloner;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodClientEntityDelegate)) {
            return false;
        }
        HotRodClientEntityDelegate other = (HotRodClientEntityDelegate)o;
        return Objects.equals(this.getId(), other.getId()) && Objects.equals(this.getAttributes(), other.getAttributes()) && Objects.equals(this.getAuthenticationFlowBindingOverrides(), other.getAuthenticationFlowBindingOverrides()) && Objects.equals(this.getBaseUrl(), other.getBaseUrl()) && Objects.equals(this.getClientAuthenticatorType(), other.getClientAuthenticatorType()) && Objects.equals(this.getClientId(), other.getClientId()) && Objects.equals(this.getClientScopes(), other.getClientScopes()) && Objects.equals(this.getDescription(), other.getDescription()) && Objects.equals(this.getManagementUrl(), other.getManagementUrl()) && Objects.equals(this.getName(), other.getName()) && Objects.equals(this.getNodeReRegistrationTimeout(), other.getNodeReRegistrationTimeout()) && Objects.equals(this.getNotBefore(), other.getNotBefore()) && Objects.equals(this.getProtocol(), other.getProtocol()) && Objects.equals(this.getProtocolMappers(), other.getProtocolMappers()) && Objects.equals(this.getRealmId(), other.getRealmId()) && Objects.equals(this.getRedirectUris(), other.getRedirectUris()) && Objects.equals(this.getRegistrationToken(), other.getRegistrationToken()) && Objects.equals(this.getRootUrl(), other.getRootUrl()) && Objects.equals(this.getScope(), other.getScope()) && Objects.equals(this.getScopeMappings(), other.getScopeMappings()) && Objects.equals(this.getSecret(), other.getSecret()) && Objects.equals(this.getWebOrigins(), other.getWebOrigins()) && Objects.equals(this.isAlwaysDisplayInConsole(), other.isAlwaysDisplayInConsole()) && Objects.equals(this.isBearerOnly(), other.isBearerOnly()) && Objects.equals(this.isConsentRequired(), other.isConsentRequired()) && Objects.equals(this.isDirectAccessGrantsEnabled(), other.isDirectAccessGrantsEnabled()) && Objects.equals(this.isEnabled(), other.isEnabled()) && Objects.equals(this.isFrontchannelLogout(), other.isFrontchannelLogout()) && Objects.equals(this.isFullScopeAllowed(), other.isFullScopeAllowed()) && Objects.equals(this.isImplicitFlowEnabled(), other.isImplicitFlowEnabled()) && Objects.equals(this.isPublicClient(), other.isPublicClient()) && Objects.equals(this.isServiceAccountsEnabled(), other.isServiceAccountsEnabled()) && Objects.equals(this.isStandardFlowEnabled(), other.isStandardFlowEnabled()) && Objects.equals(this.isSurrogateAuthRequired(), other.isSurrogateAuthRequired());
    }

    public int hashCode() {
        return this.getId() == null ? super.hashCode() : this.getId().hashCode();
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodClientEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodClientEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodClientEntity e1 = (HotRodClientEntity)o1;
        HotRodClientEntity e2 = (HotRodClientEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.entityVersion, e2.entityVersion) && Objects.equals(e1.id, e2.id) && Objects.equals(e1.realmId, e2.realmId) && Objects.equals(e1.clientId, e2.clientId) && Objects.equals(e1.clientIdLowercase, e2.clientIdLowercase) && Objects.equals(e1.name, e2.name) && Objects.equals(e1.description, e2.description) && Objects.equals(e1.redirectUris, e2.redirectUris) && Objects.equals(e1.enabled, e2.enabled) && Objects.equals(e1.alwaysDisplayInConsole, e2.alwaysDisplayInConsole) && Objects.equals(e1.clientAuthenticatorType, e2.clientAuthenticatorType) && Objects.equals(e1.secret, e2.secret) && Objects.equals(e1.registrationToken, e2.registrationToken) && Objects.equals(e1.protocol, e2.protocol) && Objects.equals(e1.attributes, e2.attributes) && Objects.equals(e1.authenticationFlowBindingOverrides, e2.authenticationFlowBindingOverrides) && Objects.equals(e1.publicClient, e2.publicClient) && Objects.equals(e1.fullScopeAllowed, e2.fullScopeAllowed) && Objects.equals(e1.frontchannelLogout, e2.frontchannelLogout) && Objects.equals(e1.notBefore, e2.notBefore) && Objects.equals(e1.scope, e2.scope) && Objects.equals(e1.webOrigins, e2.webOrigins) && Objects.equals(e1.protocolMappers, e2.protocolMappers) && Objects.equals(e1.clientScopes, e2.clientScopes) && Objects.equals(e1.scopeMappings, e2.scopeMappings) && Objects.equals(e1.surrogateAuthRequired, e2.surrogateAuthRequired) && Objects.equals(e1.managementUrl, e2.managementUrl) && Objects.equals(e1.baseUrl, e2.baseUrl) && Objects.equals(e1.bearerOnly, e2.bearerOnly) && Objects.equals(e1.consentRequired, e2.consentRequired) && Objects.equals(e1.rootUrl, e2.rootUrl) && Objects.equals(e1.standardFlowEnabled, e2.standardFlowEnabled) && Objects.equals(e1.implicitFlowEnabled, e2.implicitFlowEnabled) && Objects.equals(e1.directAccessGrantsEnabled, e2.directAccessGrantsEnabled) && Objects.equals(e1.serviceAccountsEnabled, e2.serviceAccountsEnabled) && Objects.equals(e1.nodeReRegistrationTimeout, e2.nodeReRegistrationTimeout);
    }

    public static int entityHashCode(HotRodClientEntity e) {
        return e.id == null ? Objects.hash(e) : e.id.hashCode();
    }

    public <V> V deepClone(V obj) {
        return (V)this.cloner.from(obj);
    }

    public Boolean isAlwaysDisplayInConsole() {
        return this.hotRodEntity.alwaysDisplayInConsole == null ? null : this.hotRodEntity.alwaysDisplayInConsole;
    }

    public void setAlwaysDisplayInConsole(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.alwaysDisplayInConsole, migrated);
        this.hotRodEntity.alwaysDisplayInConsole = migrated;
    }

    public void removeAttribute(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
    }

    public void setAttributes(Map<String, List<String>> p0) {
        Map<String, List<String>> map = p0 = p0 == null ? null : (Map<String, List<String>>)p0.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue() == null ? null : new LinkedList((Collection)entry.getValue()), (o1, o2) -> o1, HashMap::new));
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodAttributeEntity> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodAttributeEntityFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.attributes, migrated);
        this.hotRodEntity.attributes = migrated;
    }

    public void setAttribute(String p0, List<String> p1) {
        LinkedList<String> linkedList = p1 = p1 == null ? null : new LinkedList<String>(p1);
        if (p1 != null) {
            p1.removeIf(UndefinedValuesUtils::isUndefined);
        }
        boolean valueUndefined = UndefinedValuesUtils.isUndefined(p1);
        if (this.hotRodEntity.attributes == null && !valueUndefined) {
            this.hotRodEntity.attributes = new HashSet<HotRodAttributeEntity>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.attributes.add(new HotRodAttributeEntity(p0, p1)));
    }

    public Map<String, List<String>> getAttributes() {
        return this.hotRodEntity.attributes == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.attributes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public List<String> getAttribute(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.attributes, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public String getAuthenticationFlowBindingOverride(String p0) {
        return HotRodTypesUtils.getMapValueFromSet(this.hotRodEntity.authenticationFlowBindingOverrides, p0, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public Map<String, String> getAuthenticationFlowBindingOverrides() {
        return this.hotRodEntity.authenticationFlowBindingOverrides == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.authenticationFlowBindingOverrides, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void removeAuthenticationFlowBindingOverride(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.authenticationFlowBindingOverrides, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
    }

    public void setAuthenticationFlowBindingOverride(String p0, String p1) {
        boolean valueUndefined = UndefinedValuesUtils.isUndefined((Object)p1);
        if (this.hotRodEntity.authenticationFlowBindingOverrides == null && !valueUndefined) {
            this.hotRodEntity.authenticationFlowBindingOverrides = new HashSet<HotRodPair<String, String>>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.authenticationFlowBindingOverrides, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.authenticationFlowBindingOverrides.add(new HotRodPair<String, String>(p0, p1)));
    }

    public String getBaseUrl() {
        return this.hotRodEntity.baseUrl == null ? null : this.hotRodEntity.baseUrl;
    }

    public void setBaseUrl(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.baseUrl, migrated);
        this.hotRodEntity.baseUrl = migrated;
    }

    public Boolean isBearerOnly() {
        return this.hotRodEntity.bearerOnly == null ? null : this.hotRodEntity.bearerOnly;
    }

    public void setBearerOnly(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.bearerOnly, migrated);
        this.hotRodEntity.bearerOnly = migrated;
    }

    public void setClientAuthenticatorType(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.clientAuthenticatorType, migrated);
        this.hotRodEntity.clientAuthenticatorType = migrated;
    }

    public String getClientAuthenticatorType() {
        return this.hotRodEntity.clientAuthenticatorType == null ? null : this.hotRodEntity.clientAuthenticatorType;
    }

    public String getClientId() {
        return this.hotRodEntity.clientId == null ? null : this.hotRodEntity.clientId;
    }

    public void setClientScope(String p0, Boolean p1) {
        boolean valueUndefined = UndefinedValuesUtils.isUndefined((Object)p1);
        if (this.hotRodEntity.clientScopes == null && !valueUndefined) {
            this.hotRodEntity.clientScopes = new HashSet<HotRodPair<String, Boolean>>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.clientScopes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.clientScopes.add(new HotRodPair<String, Boolean>(p0, p1)));
    }

    public Map<String, Boolean> getClientScopes() {
        return this.hotRodEntity.clientScopes == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.clientScopes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void removeClientScope(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.clientScopes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
    }

    public Boolean isConsentRequired() {
        return this.hotRodEntity.consentRequired == null ? null : this.hotRodEntity.consentRequired;
    }

    public void setConsentRequired(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.consentRequired, migrated);
        this.hotRodEntity.consentRequired = migrated;
    }

    public String getDescription() {
        return this.hotRodEntity.description == null ? null : this.hotRodEntity.description;
    }

    public void setDescription(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.description, migrated);
        this.hotRodEntity.description = migrated;
    }

    public Boolean isDirectAccessGrantsEnabled() {
        return this.hotRodEntity.directAccessGrantsEnabled == null ? null : this.hotRodEntity.directAccessGrantsEnabled;
    }

    public void setDirectAccessGrantsEnabled(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.directAccessGrantsEnabled, migrated);
        this.hotRodEntity.directAccessGrantsEnabled = migrated;
    }

    public void setEnabled(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.enabled, migrated);
        this.hotRodEntity.enabled = migrated;
    }

    public Boolean isEnabled() {
        return this.hotRodEntity.enabled == null ? null : this.hotRodEntity.enabled;
    }

    public Boolean isFrontchannelLogout() {
        return this.hotRodEntity.frontchannelLogout == null ? null : this.hotRodEntity.frontchannelLogout;
    }

    public void setFrontchannelLogout(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.frontchannelLogout, migrated);
        this.hotRodEntity.frontchannelLogout = migrated;
    }

    public Boolean isFullScopeAllowed() {
        return this.hotRodEntity.fullScopeAllowed == null ? null : this.hotRodEntity.fullScopeAllowed;
    }

    public void setFullScopeAllowed(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.fullScopeAllowed, migrated);
        this.hotRodEntity.fullScopeAllowed = migrated;
    }

    public Boolean isImplicitFlowEnabled() {
        return this.hotRodEntity.implicitFlowEnabled == null ? null : this.hotRodEntity.implicitFlowEnabled;
    }

    public void setImplicitFlowEnabled(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.implicitFlowEnabled, migrated);
        this.hotRodEntity.implicitFlowEnabled = migrated;
    }

    public String getManagementUrl() {
        return this.hotRodEntity.managementUrl == null ? null : this.hotRodEntity.managementUrl;
    }

    public void setManagementUrl(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.managementUrl, migrated);
        this.hotRodEntity.managementUrl = migrated;
    }

    public String getName() {
        return this.hotRodEntity.name == null ? null : this.hotRodEntity.name;
    }

    public void setName(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.name, migrated);
        this.hotRodEntity.name = migrated;
    }

    public Integer getNodeReRegistrationTimeout() {
        return this.hotRodEntity.nodeReRegistrationTimeout == null ? null : this.hotRodEntity.nodeReRegistrationTimeout;
    }

    public void setNodeReRegistrationTimeout(Integer p0) {
        Integer migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.nodeReRegistrationTimeout, migrated);
        this.hotRodEntity.nodeReRegistrationTimeout = migrated;
    }

    public Long getNotBefore() {
        return this.hotRodEntity.notBefore == null ? null : this.hotRodEntity.notBefore;
    }

    public void setNotBefore(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.notBefore, migrated);
        this.hotRodEntity.notBefore = migrated;
    }

    public void setProtocol(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.protocol, migrated);
        this.hotRodEntity.protocol = migrated;
    }

    public String getProtocol() {
        return this.hotRodEntity.protocol == null ? null : this.hotRodEntity.protocol;
    }

    public Set<MapProtocolMapperEntity> getProtocolMappers() {
        return this.hotRodEntity.protocolMappers == null ? null : HotRodTypesUtils.migrateSet(this.hotRodEntity.protocolMappers, collectionItem -> new HotRodProtocolMapperEntityDelegate((HotRodProtocolMapperEntity)collectionItem));
    }

    public void addProtocolMapper(MapProtocolMapperEntity p0) {
        if (UndefinedValuesUtils.isUndefined((Object)(p0 = this.deepClone(p0)))) {
            return;
        }
        if (this.hotRodEntity.protocolMappers == null) {
            this.hotRodEntity.protocolMappers = new HashSet<HotRodProtocolMapperEntity>();
        }
        HotRodProtocolMapperEntity migrated = (HotRodProtocolMapperEntity)((HotRodEntityDelegate)p0).getHotRodEntity();
        this.hotRodEntity.updated |= this.hotRodEntity.protocolMappers.add(migrated);
    }

    public Boolean isPublicClient() {
        return this.hotRodEntity.publicClient == null ? null : this.hotRodEntity.publicClient;
    }

    public void setPublicClient(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.publicClient, migrated);
        this.hotRodEntity.publicClient = migrated;
    }

    public String getRealmId() {
        return this.hotRodEntity.realmId == null ? null : this.hotRodEntity.realmId;
    }

    public void setRealmId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.realmId, migrated);
        this.hotRodEntity.realmId = migrated;
    }

    public void removeRedirectUri(String p0) {
        if (this.hotRodEntity.redirectUris == null) {
            return;
        }
        boolean removed = this.hotRodEntity.redirectUris.remove(p0);
        this.hotRodEntity.updated |= removed;
    }

    public void setRedirectUris(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.redirectUris, migrated);
        this.hotRodEntity.redirectUris = migrated;
    }

    public void addRedirectUri(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.redirectUris == null) {
            this.hotRodEntity.redirectUris = new HashSet<String>();
        }
        String migrated = p0;
        this.hotRodEntity.updated |= this.hotRodEntity.redirectUris.add(migrated);
    }

    public Set<String> getRedirectUris() {
        return this.hotRodEntity.redirectUris == null ? null : this.hotRodEntity.redirectUris;
    }

    public String getRegistrationToken() {
        return this.hotRodEntity.registrationToken == null ? null : this.hotRodEntity.registrationToken;
    }

    public void setRegistrationToken(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.registrationToken, migrated);
        this.hotRodEntity.registrationToken = migrated;
    }

    public void setRootUrl(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.rootUrl, migrated);
        this.hotRodEntity.rootUrl = migrated;
    }

    public String getRootUrl() {
        return this.hotRodEntity.rootUrl == null ? null : this.hotRodEntity.rootUrl;
    }

    public void setScope(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.scope, migrated);
        this.hotRodEntity.scope = migrated;
    }

    public Set<String> getScope() {
        return this.hotRodEntity.scope == null ? null : this.hotRodEntity.scope;
    }

    public void addScopeMapping(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.scopeMappings == null) {
            this.hotRodEntity.scopeMappings = new LinkedList<String>();
        }
        String migrated = p0;
        this.hotRodEntity.scopeMappings.add(migrated);
        this.hotRodEntity.updated = true;
    }

    public void removeScopeMapping(String p0) {
        if (this.hotRodEntity.scopeMappings == null) {
            return;
        }
        boolean removed = this.hotRodEntity.scopeMappings.remove(p0);
        this.hotRodEntity.updated |= removed;
    }

    public Collection<String> getScopeMappings() {
        return this.hotRodEntity.scopeMappings == null ? null : this.hotRodEntity.scopeMappings;
    }

    public void setSecret(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.secret, migrated);
        this.hotRodEntity.secret = migrated;
    }

    public String getSecret() {
        return this.hotRodEntity.secret == null ? null : this.hotRodEntity.secret;
    }

    public Boolean isServiceAccountsEnabled() {
        return this.hotRodEntity.serviceAccountsEnabled == null ? null : this.hotRodEntity.serviceAccountsEnabled;
    }

    public void setServiceAccountsEnabled(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.serviceAccountsEnabled, migrated);
        this.hotRodEntity.serviceAccountsEnabled = migrated;
    }

    public Boolean isStandardFlowEnabled() {
        return this.hotRodEntity.standardFlowEnabled == null ? null : this.hotRodEntity.standardFlowEnabled;
    }

    public void setStandardFlowEnabled(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.standardFlowEnabled, migrated);
        this.hotRodEntity.standardFlowEnabled = migrated;
    }

    public void setSurrogateAuthRequired(Boolean p0) {
        Boolean migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.surrogateAuthRequired, migrated);
        this.hotRodEntity.surrogateAuthRequired = migrated;
    }

    public Boolean isSurrogateAuthRequired() {
        return this.hotRodEntity.surrogateAuthRequired == null ? null : this.hotRodEntity.surrogateAuthRequired;
    }

    public void setWebOrigins(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.webOrigins, migrated);
        this.hotRodEntity.webOrigins = migrated;
    }

    public void addWebOrigin(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.webOrigins == null) {
            this.hotRodEntity.webOrigins = new HashSet<String>();
        }
        String migrated = p0;
        this.hotRodEntity.updated |= this.hotRodEntity.webOrigins.add(migrated);
    }

    public void removeWebOrigin(String p0) {
        if (this.hotRodEntity.webOrigins == null) {
            return;
        }
        boolean removed = this.hotRodEntity.webOrigins.remove(p0);
        this.hotRodEntity.updated |= removed;
    }

    public Set<String> getWebOrigins() {
        return this.hotRodEntity.webOrigins == null ? null : this.hotRodEntity.webOrigins;
    }

    @Override
    public HotRodClientEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

