/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.authSession;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UndefinedValuesUtils;
import org.keycloak.models.map.storage.hotRod.authSession.HotRodAuthenticationSessionEntity;
import org.keycloak.models.map.storage.hotRod.common.HotRodPair;
import org.keycloak.models.map.storage.hotRod.common.HotRodTypesUtils;

public class HotRodAuthenticationSessionEntityDelegate
extends HotRodAuthenticationSessionEntity.AbstractHotRodAuthenticationSessionEntityDelegate
implements MapAuthenticationSessionEntity {
    private final HotRodAuthenticationSessionEntity hotRodEntity;

    public HotRodAuthenticationSessionEntityDelegate() {
        this.hotRodEntity = new HotRodAuthenticationSessionEntity();
    }

    public HotRodAuthenticationSessionEntityDelegate(HotRodAuthenticationSessionEntity hotRodEntity) {
        Objects.requireNonNull(hotRodEntity);
        this.hotRodEntity = hotRodEntity;
    }

    public HotRodAuthenticationSessionEntityDelegate(DeepCloner cloner) {
        this.hotRodEntity = new HotRodAuthenticationSessionEntity();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HotRodAuthenticationSessionEntityDelegate)) {
            return false;
        }
        HotRodAuthenticationSessionEntityDelegate other = (HotRodAuthenticationSessionEntityDelegate)o;
        return Objects.equals(this.getAction(), other.getAction()) && Objects.equals(this.getAuthNotes(), other.getAuthNotes()) && Objects.equals(this.getAuthUserId(), other.getAuthUserId()) && Objects.equals(this.getClientNotes(), other.getClientNotes()) && Objects.equals(this.getClientScopes(), other.getClientScopes()) && Objects.equals(this.getClientUUID(), other.getClientUUID()) && Objects.equals(this.getExecutionStatuses(), other.getExecutionStatuses()) && Objects.equals(this.getProtocol(), other.getProtocol()) && Objects.equals(this.getRedirectUri(), other.getRedirectUri()) && Objects.equals(this.getRequiredActions(), other.getRequiredActions()) && Objects.equals(this.getTabId(), other.getTabId()) && Objects.equals(this.getTimestamp(), other.getTimestamp()) && Objects.equals(this.getUserSessionNotes(), other.getUserSessionNotes());
    }

    public int hashCode() {
        return Objects.hash(this.getAction(), this.getAuthUserId(), this.getClientUUID(), this.getProtocol(), this.getRedirectUri(), this.getTabId(), this.getTimestamp());
    }

    public String toString() {
        return String.format("%s@%08x", "HotRodAuthenticationSessionEntityDelegate", System.identityHashCode(this));
    }

    public static boolean entityEquals(Object o1, Object o2) {
        if (!(o1 instanceof HotRodAuthenticationSessionEntity)) {
            return false;
        }
        if (!(o2 instanceof HotRodAuthenticationSessionEntity)) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        HotRodAuthenticationSessionEntity e1 = (HotRodAuthenticationSessionEntity)o1;
        HotRodAuthenticationSessionEntity e2 = (HotRodAuthenticationSessionEntity)o2;
        return Objects.equals(e1.updated, e2.updated) && Objects.equals(e1.tabId, e2.tabId) && Objects.equals(e1.clientUUID, e2.clientUUID) && Objects.equals(e1.authUserId, e2.authUserId) && Objects.equals(e1.timestamp, e2.timestamp) && Objects.equals(e1.redirectUri, e2.redirectUri) && Objects.equals(e1.action, e2.action) && Objects.equals(e1.clientScopes, e2.clientScopes) && Objects.equals(e1.executionStatuses, e2.executionStatuses) && Objects.equals(e1.protocol, e2.protocol) && Objects.equals(e1.clientNotes, e2.clientNotes) && Objects.equals(e1.authNotes, e2.authNotes) && Objects.equals(e1.requiredActions, e2.requiredActions) && Objects.equals(e1.userSessionNotes, e2.userSessionNotes);
    }

    public static int entityHashCode(HotRodAuthenticationSessionEntity e) {
        return Objects.hash(e.updated, e.tabId, e.clientUUID, e.authUserId, e.timestamp, e.redirectUri, e.action, e.clientScopes, e.executionStatuses, e.protocol, e.clientNotes, e.authNotes, e.requiredActions, e.userSessionNotes);
    }

    public void setAction(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.action, migrated);
        this.hotRodEntity.action = migrated;
    }

    public String getAction() {
        return this.hotRodEntity.action == null ? null : this.hotRodEntity.action;
    }

    public void setAuthNotes(Map<String, String> p0) {
        HashMap hashMap = p0 = p0 == null ? null : new HashMap(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodPair> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodPairFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.authNotes, migrated);
        this.hotRodEntity.authNotes = migrated;
    }

    public void removeAuthNote(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.authNotes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
    }

    public void setAuthNote(String p0, String p1) {
        boolean valueUndefined = UndefinedValuesUtils.isUndefined((Object)p1);
        if (this.hotRodEntity.authNotes == null && !valueUndefined) {
            this.hotRodEntity.authNotes = new HashSet<HotRodPair<String, String>>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.authNotes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.authNotes.add(new HotRodPair<String, String>(p0, p1)));
    }

    public Map<String, String> getAuthNotes() {
        return this.hotRodEntity.authNotes == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.authNotes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public String getAuthUserId() {
        return this.hotRodEntity.authUserId == null ? null : this.hotRodEntity.authUserId;
    }

    public void setAuthUserId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.authUserId, migrated);
        this.hotRodEntity.authUserId = migrated;
    }

    public void setClientNotes(Map<String, String> p0) {
        HashMap hashMap = p0 = p0 == null ? null : new HashMap(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodPair> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodPairFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.clientNotes, migrated);
        this.hotRodEntity.clientNotes = migrated;
    }

    public Map<String, String> getClientNotes() {
        return this.hotRodEntity.clientNotes == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.clientNotes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void removeClientNote(String p0) {
        boolean removed = HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.clientNotes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated |= removed;
    }

    public void setClientNote(String p0, String p1) {
        boolean valueUndefined = UndefinedValuesUtils.isUndefined((Object)p1);
        if (this.hotRodEntity.clientNotes == null && !valueUndefined) {
            this.hotRodEntity.clientNotes = new HashSet<HotRodPair<String, String>>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.clientNotes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.clientNotes.add(new HotRodPair<String, String>(p0, p1)));
    }

    public Set<String> getClientScopes() {
        return this.hotRodEntity.clientScopes == null ? null : this.hotRodEntity.clientScopes;
    }

    public void setClientScopes(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.clientScopes, migrated);
        this.hotRodEntity.clientScopes = migrated;
    }

    public String getClientUUID() {
        return this.hotRodEntity.clientUUID == null ? null : this.hotRodEntity.clientUUID;
    }

    public void setClientUUID(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.clientUUID, migrated);
        this.hotRodEntity.clientUUID = migrated;
    }

    public String getProtocol() {
        return this.hotRodEntity.protocol == null ? null : this.hotRodEntity.protocol;
    }

    public void setProtocol(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.protocol, migrated);
        this.hotRodEntity.protocol = migrated;
    }

    public void setRedirectUri(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.redirectUri, migrated);
        this.hotRodEntity.redirectUri = migrated;
    }

    public String getRedirectUri() {
        return this.hotRodEntity.redirectUri == null ? null : this.hotRodEntity.redirectUri;
    }

    public Set<String> getRequiredActions() {
        return this.hotRodEntity.requiredActions == null ? null : this.hotRodEntity.requiredActions;
    }

    public void addRequiredAction(String p0) {
        if (UndefinedValuesUtils.isUndefined((Object)p0)) {
            return;
        }
        if (this.hotRodEntity.requiredActions == null) {
            this.hotRodEntity.requiredActions = new HashSet<String>();
        }
        String migrated = p0;
        this.hotRodEntity.updated |= this.hotRodEntity.requiredActions.add(migrated);
    }

    public void removeRequiredAction(String p0) {
        if (this.hotRodEntity.requiredActions == null) {
            return;
        }
        boolean removed = this.hotRodEntity.requiredActions.remove(p0);
        this.hotRodEntity.updated |= removed;
    }

    public void setRequiredActions(Set<String> p0) {
        HashSet<String> hashSet = p0 = p0 == null ? null : new HashSet<String>(p0);
        if (p0 != null) {
            p0.removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        HashSet<String> migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.requiredActions, migrated);
        this.hotRodEntity.requiredActions = migrated;
    }

    public String getTabId() {
        return this.hotRodEntity.tabId == null ? null : this.hotRodEntity.tabId;
    }

    public void setTabId(String p0) {
        String migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.tabId, migrated);
        this.hotRodEntity.tabId = migrated;
    }

    public Long getTimestamp() {
        return this.hotRodEntity.timestamp == null ? null : this.hotRodEntity.timestamp;
    }

    public void setTimestamp(Long p0) {
        Long migrated = p0 == null ? null : p0;
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.timestamp, migrated);
        this.hotRodEntity.timestamp = migrated;
    }

    public Map<String, String> getUserSessionNotes() {
        return this.hotRodEntity.userSessionNotes == null ? null : HotRodTypesUtils.migrateSetToMap(this.hotRodEntity.userSessionNotes, HotRodTypesUtils::getKey, HotRodTypesUtils::getValue);
    }

    public void setUserSessionNotes(Map<String, String> p0) {
        HashMap hashMap = p0 = p0 == null ? null : new HashMap(p0);
        if (p0 != null) {
            p0.values().removeIf(UndefinedValuesUtils::isUndefined);
            if (UndefinedValuesUtils.isUndefined(p0)) {
                p0 = null;
            }
        }
        Set<HotRodPair> migrated = p0 == null ? null : HotRodTypesUtils.migrateMapToSet(p0, HotRodTypesUtils::createHotRodPairFromMapEntry);
        this.hotRodEntity.updated = this.hotRodEntity.updated | !Objects.equals(this.hotRodEntity.userSessionNotes, migrated);
        this.hotRodEntity.userSessionNotes = migrated;
    }

    public void setUserSessionNote(String p0, String p1) {
        boolean valueUndefined = UndefinedValuesUtils.isUndefined((Object)p1);
        if (this.hotRodEntity.userSessionNotes == null && !valueUndefined) {
            this.hotRodEntity.userSessionNotes = new HashSet<HotRodPair<String, String>>();
        }
        this.hotRodEntity.updated |= HotRodTypesUtils.removeFromSetByMapKey(this.hotRodEntity.userSessionNotes, p0, HotRodTypesUtils::getKey);
        this.hotRodEntity.updated = this.hotRodEntity.updated | (!valueUndefined && this.hotRodEntity.userSessionNotes.add(new HotRodPair<String, String>(p0, p1)));
    }

    @Override
    public HotRodAuthenticationSessionEntity getHotRodEntity() {
        return this.hotRodEntity;
    }
}

